/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.DB;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConnection
extends TestCase {
    static /* synthetic */ Class class$com$hp$hpl$jena$db$test$TestConnection;

    public TestConnection(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$db$test$TestConnection == null ? (class$com$hp$hpl$jena$db$test$TestConnection = TestConnection.class$("com.hp.hpl.jena.db.test.TestConnection")) : class$com$hp$hpl$jena$db$test$TestConnection);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testNoClass() throws Exception {
    }

    public void testNoConnection() throws Exception {
    }

    private static void loadClass() {
        try {
            Class.forName(TestPackage.M_DBDRIVER_CLASS);
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public static IDBConnection makeTestConnection() {
        TestConnection.loadClass();
        return new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, TestPackage.M_DB);
    }

    public static IDBConnection makeAndCleanTestConnection() {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            iDBConnection.cleanDB();
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
        return iDBConnection;
    }

    public void testDBConnect() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        iDBConnection.close();
    }

    public void testConstructDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testReconstructDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testReconstructNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenNamedParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testOpenNamedNonExistentModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            ModelRDB modelRDB = ModelRDB.open(iDBConnection, "myName");
            modelRDB.remove();
            iDBConnection.close();
            TestConnection.assertTrue((String)"Successfully opened non-existent model", (boolean)false);
        }
        catch (RDFRDBException rDFRDBException) {
            iDBConnection.close();
        }
    }

    public void testOpenUnnamedNonExistentModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            iDBConnection.cleanDB();
            ModelRDB modelRDB = ModelRDB.open(iDBConnection);
            modelRDB.remove();
            iDBConnection.close();
            TestConnection.assertTrue((String)"Successfully opened unnamed non-existent model", (boolean)false);
        }
        catch (RDFRDBException rDFRDBException) {
            iDBConnection.close();
        }
    }

    public void testCreateExistingModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        try {
            ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
            modelRDB.remove();
            modelRDB2.remove();
            iDBConnection.close();
            TestConnection.assertTrue((String)"Successfully created pre-existing model", (boolean)false);
        }
        catch (RDFRDBException rDFRDBException) {
            modelRDB.remove();
            iDBConnection.close();
        }
    }

    public void addToDBGraphProp(Model model, Property property, String string) {
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, DB.graphName, (RDFNode)null));
        TestConnection.assertTrue((boolean)stmtIterator.hasNext());
        Statement statement = stmtIterator.nextStatement();
        TestConnection.assertTrue((!stmtIterator.hasNext() ? 1 : 0) != 0);
        Resource resource = statement.getSubject();
        Literal literal = model.createLiteral(string);
        Statement statement2 = model.createStatement(resource, property, literal);
        model.add(statement2);
        TestConnection.assertTrue((boolean)model.contains(statement2));
    }

    public void testConstructDefSchemaModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        Model model = ModelRDB.getDefaultModelProperties(iDBConnection);
        this.addToDBGraphProp(model, DB.graphDBSchema, "DEFAULT");
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, model);
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructBadSchemaModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        Model model = ModelRDB.getDefaultModelProperties(iDBConnection);
        this.addToDBGraphProp(model, DB.graphDBSchema, "SCHEMA_DOES_NOT_EXIST");
        try {
            ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, model);
            modelRDB.remove();
            TestConnection.assertFalse((String)"Created model with non-existent schema", (boolean)true);
        }
        catch (RDFRDBException rDFRDBException) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        Model model = ModelRDB.getDefaultModelProperties(iDBConnection);
        this.addToDBGraphProp(model, DB.graphDBSchema, "DEFAULT");
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", model);
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema1() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, ModelRDB.getDefaultModelProperties(iDBConnection));
        Model model = ModelRDB.getDefaultModelProperties(iDBConnection);
        this.addToDBGraphProp(model, DB.graphDBSchema, "DEFAULT");
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName", model);
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelSchema() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "model1", ModelRDB.getDefaultModelProperties(iDBConnection));
        Model model = ModelRDB.getDefaultModelProperties(iDBConnection);
        this.addToDBGraphProp(model, DB.graphDBSchema, "model1");
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "model2", model);
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

