/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DBPropLSet;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.PSet_ReifStore_RDB;
import com.hp.hpl.jena.db.impl.ResultSetReifIterator;
import com.hp.hpl.jena.db.impl.ResultSetTripleIterator;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraphBase;
import com.hp.hpl.jena.db.impl.SpecializedGraphReifier;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.JenaAddDeniedException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpecializedGraphReifier_RDB
extends SpecializedGraphBase
implements SpecializedGraphReifier {
    public PSet_ReifStore_RDB m_pset;
    public DBPropLSet m_dbPropLSet;
    public IDBID my_GID = null;
    private String m_lsetName;
    private String m_className;
    private ReifCacheMap m_reifCache;
    public PSet_ReifStore_RDB m_reif;

    SpecializedGraphReifier_RDB(DBPropLSet dBPropLSet, IPSet iPSet, Integer n) {
        this.m_pset = (PSet_ReifStore_RDB)iPSet;
        this.m_dbPropLSet = dBPropLSet;
        this.my_GID = new DBIDInt(n);
        this.m_reifCache = new ReifCacheMap(1);
        this.m_reif = this.m_pset;
    }

    public SpecializedGraphReifier_RDB(IPSet iPSet, Integer n) {
        this.m_pset = (PSet_ReifStore_RDB)iPSet;
        this.my_GID = new DBIDInt(n);
        this.m_reifCache = new ReifCacheMap(1);
        this.m_reif = this.m_pset;
    }

    public void add(Node node, Triple triple, SpecializedGraph.CompletionFlag completionFlag) throws Reifier.CannotReifyException {
        StmtMask stmtMask = new StmtMask();
        StmtMask stmtMask2 = new StmtMask();
        ReifCache reifCache = this.m_reifCache.load(node, triple, stmtMask, stmtMask2);
        if (reifCache == null) {
            this.m_reif.storeReifStmt(node, triple, this.my_GID);
        } else if (stmtMask2.hasNada()) {
            Triple triple2;
            boolean bl = false;
            if (!stmtMask.hasSubj()) {
                triple2 = new Triple(node, Reifier.subject, triple.getSubject());
                this.m_reif.updateFrag(node, triple2, new StmtMask(triple2), this.my_GID);
                bl = true;
            }
            if (!stmtMask.hasPred()) {
                triple2 = new Triple(node, Reifier.predicate, triple.getPredicate());
                this.m_reif.updateFrag(node, triple2, new StmtMask(triple2), this.my_GID);
                bl = true;
            }
            if (!stmtMask.hasObj()) {
                triple2 = new Triple(node, Reifier.object, triple.getObject());
                this.m_reif.updateFrag(node, triple2, new StmtMask(triple2), this.my_GID);
                bl = true;
            }
            if (!reifCache.mask.hasType()) {
                triple2 = new Triple(node, Reifier.type, Reifier.Statement);
                this.m_reif.updateFrag(node, triple2, new StmtMask(triple2), this.my_GID);
                bl = true;
            }
            if (bl) {
                this.fragCompact(node);
            }
            this.m_reifCache.flushAll();
        } else {
            if (reifCache.mask.isStmt()) {
                throw new Reifier.AlreadyReifiedException(node);
            }
            throw new Reifier.CannotReifyException(node);
        }
        completionFlag.setDone();
    }

    public void delete(Node node, Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        this.m_reifCache.flushAll();
        this.m_reif.deleteReifStmt(node, triple, this.my_GID);
        completionFlag.setDone();
    }

    public boolean contains(Node node, Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        throw new JenaException("SpecializedGraphReifier.contains called");
    }

    public ExtendedIterator findReifiedNodes(Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        completionFlag.setDone();
        return this.m_reif.findReifStmtURIByTriple(triple, this.my_GID);
    }

    public Triple findReifiedTriple(Node node, SpecializedGraph.CompletionFlag completionFlag) {
        ResultSetReifIterator resultSetReifIterator = this.m_reif.findReifStmt(node, true, this.my_GID, false);
        Triple triple = null;
        if (resultSetReifIterator.hasNext()) {
            triple = (Triple)resultSetReifIterator.next();
        }
        completionFlag.setDone();
        return triple;
    }

    public ExtendedIterator findReifiedTriples(Node node, SpecializedGraph.CompletionFlag completionFlag) {
        completionFlag.setDone();
        return this.m_reif.findReifStmt(node, false, this.my_GID, true);
    }

    public void add(Graph graph, SpecializedGraph.CompletionFlag completionFlag) {
        throw new JenaAddDeniedException("sorry, not implemented");
    }

    public void add(Triple triple, SpecializedGraph.CompletionFlag completionFlag) throws Reifier.AlreadyReifiedException {
        StmtMask stmtMask = new StmtMask(triple);
        if (stmtMask.hasNada()) {
            return;
        }
        boolean bl = stmtMask.hasType();
        Node node = triple.getSubject();
        ReifCache reifCache = this.m_reifCache.load(node);
        if (reifCache == null) {
            this.m_reif.storeFrag(node, triple, stmtMask, this.my_GID);
            completionFlag.setDone();
        } else {
            StmtMask stmtMask2 = reifCache.getStmtMask();
            if (stmtMask2.hasIntersect(stmtMask)) {
                ResultSetTripleIterator resultSetTripleIterator;
                boolean bl2;
                boolean bl3 = bl2 = bl && stmtMask2.hasType();
                if (!bl2 && !(bl2 = (resultSetTripleIterator = this.m_reif.findFrag(node, triple, stmtMask, this.my_GID)).hasNext())) {
                    if (stmtMask2.isStmt()) {
                        throw new Reifier.AlreadyReifiedException(triple.getSubject());
                    }
                    this.m_reif.storeFrag(node, triple, stmtMask, this.my_GID);
                    this.m_reifCache.flush(reifCache);
                }
            } else if (reifCache.canMerge(stmtMask)) {
                if (reifCache.canUpdate(stmtMask)) {
                    this.m_reif.updateFrag(node, triple, stmtMask, this.my_GID);
                    reifCache.update(stmtMask);
                } else {
                    this.fragCompact(node);
                }
            } else {
                this.m_reif.storeFrag(node, triple, stmtMask, this.my_GID);
            }
        }
        completionFlag.setDone();
    }

    public void delete(Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        StmtMask stmtMask = new StmtMask(triple);
        if (stmtMask.hasNada()) {
            return;
        }
        boolean bl = stmtMask.hasType();
        Node node = triple.getSubject();
        ResultSetTripleIterator resultSetTripleIterator = this.m_reif.findFrag(node, triple, stmtMask, this.my_GID);
        if (resultSetTripleIterator.hasNext()) {
            resultSetTripleIterator.next();
            Triple triple2 = resultSetTripleIterator.m_triple;
            StmtMask stmtMask2 = new StmtMask(triple2);
            if (stmtMask2.equals(stmtMask)) {
                resultSetTripleIterator.deleteRow();
                resultSetTripleIterator.close();
            } else {
                this.m_reif.nullifyFrag(node, stmtMask, this.my_GID);
                resultSetTripleIterator.close();
                this.fragCompact(node);
            }
            ReifCache reifCache = this.m_reifCache.lookup(node);
            if (reifCache != null) {
                this.m_reifCache.flush(reifCache);
            }
        }
        completionFlag.setDone();
    }

    protected void fragCompact(Node node) {
        ResultSetReifIterator resultSetReifIterator = this.m_reif.findReifStmt(node, true, this.my_GID, false);
        if (resultSetReifIterator.hasNext()) {
            Triple triple = (Triple)resultSetReifIterator.next();
            if (resultSetReifIterator.hasNext()) {
                throw new JenaException("Multiple HasType fragments for URI");
            }
            StmtMask stmtMask = new StmtMask(triple);
            resultSetReifIterator.close();
            ResultSetReifIterator resultSetReifIterator2 = this.m_reif.findReifStmt(node, false, this.my_GID, false);
            StmtMask stmtMask2 = new StmtMask();
            while (resultSetReifIterator2.hasNext()) {
                triple = (Triple)resultSetReifIterator2.next();
                if (resultSetReifIterator2.getHasType()) continue;
                StmtMask stmtMask3 = new StmtMask(this.rowToFrag(node, triple));
                if (stmtMask.hasIntersect(stmtMask3)) break;
                this.m_reif.updateFrag(node, triple, stmtMask3, this.my_GID);
                stmtMask.setMerge(stmtMask3);
                resultSetReifIterator2.deleteRow();
            }
        }
    }

    protected Triple rowToFrag(Node node, Triple triple) {
        Node node2 = null;
        Node node3 = null;
        int n = 0;
        if (triple.getSubject() != null) {
            node3 = triple.getSubject();
            node2 = Reifier.subject;
            ++n;
        }
        if (triple.getPredicate() != null) {
            node3 = triple.getPredicate();
            node2 = Reifier.predicate;
            ++n;
        }
        if (triple.getObject() != null) {
            node3 = triple.getObject();
            node2 = Reifier.object;
            ++n;
        }
        if (n != 1) {
            throw new JenaException("Partially reified row must have exactly one value");
        }
        return new Triple(node, node2, node3);
    }

    public void add(List list, SpecializedGraph.CompletionFlag completionFlag) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            SpecializedGraph.CompletionFlag completionFlag2 = this.newComplete();
            this.add((Triple)list.get(i), completionFlag2);
            if (completionFlag2.isDone()) continue;
            arrayList.add(list.get(i));
        }
        list.clear();
        if (arrayList.isEmpty()) {
            completionFlag.setDone();
        } else {
            list.addAll(arrayList);
        }
    }

    public void delete(List list, SpecializedGraph.CompletionFlag completionFlag) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SpecializedGraph.CompletionFlag completionFlag2 = this.newComplete();
            this.delete((Triple)iterator.next(), completionFlag2);
            bl = bl && completionFlag2.isDone();
        }
        if (bl) {
            completionFlag.setDone();
        }
    }

    public int tripleCount() {
        ExtendedIterator extendedIterator = this.find(null, null, null, this.newComplete());
        int n = 0;
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        extendedIterator.close();
        return n;
    }

    public ExtendedIterator find(TripleMatch tripleMatch, SpecializedGraph.CompletionFlag completionFlag) {
        ResultSetReifIterator resultSetReifIterator = this.m_reif.findReifTripleMatch(tripleMatch, this.my_GID);
        return resultSetReifIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Triple triple, SpecializedGraph.CompletionFlag completionFlag) {
        ExtendedIterator extendedIterator = this.find(triple, completionFlag);
        try {
            boolean bl = extendedIterator.hasNext();
            return bl;
        }
        finally {
            extendedIterator.close();
        }
    }

    public String getLSetName() {
        return this.m_lsetName;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void close() {
        this.m_reif.close();
    }

    public void clear() {
        this.m_reif.removeStatementsFromDB(this.my_GID);
    }

    static boolean isReifProp(Node_URI node_URI) {
        return node_URI.equals(Reifier.subject) || node_URI.equals(Reifier.predicate) || node_URI.equals(Reifier.object) || node_URI.equals(Reifier.type);
    }

    class StmtMask {
        protected int mask = 0;
        public static final int HasSubj = 1;
        public static final int HasPred = 2;
        public static final int HasObj = 4;
        public static final int HasType = 8;
        public static final int HasSPOT = 15;
        public static final int IsStmt = 16;
        public static final int HasNada = 0;

        public boolean hasSubj() {
            return (this.mask & 1) == 1;
        }

        public boolean hasPred() {
            return (this.mask & 2) == 2;
        }

        public boolean hasObj() {
            return (this.mask & 4) == 4;
        }

        public boolean hasType() {
            return (this.mask & 8) == 8;
        }

        public boolean hasSPOT() {
            return (this.mask & 0xF) == 15;
        }

        public boolean isStmt() {
            return (this.mask & 0x10) == 16;
        }

        public boolean hasNada() {
            return this.mask == 0;
        }

        public boolean hasOneBit() {
            return this.mask == 1 || this.mask == 2 || this.mask == 4 || this.mask == 8;
        }

        StmtMask(Triple triple) {
            Node_URI node_URI = (Node_URI)triple.getPredicate();
            if (node_URI != null) {
                Node node;
                if (node_URI.equals(Reifier.subject)) {
                    this.mask = 1;
                } else if (node_URI.equals(Reifier.predicate)) {
                    this.mask = 2;
                } else if (node_URI.equals(Reifier.object)) {
                    this.mask = 4;
                } else if (node_URI.equals(Reifier.type) && (node = triple.getObject()).equals(Reifier.Statement)) {
                    this.mask = 8;
                }
            }
        }

        StmtMask() {
        }

        public void setMerge(StmtMask stmtMask) {
            this.mask |= stmtMask.mask;
        }

        public void setHasType() {
            this.mask |= 8;
        }

        public void setMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            if (bl) {
                this.mask |= 1;
            }
            if (bl2) {
                this.mask |= 2;
            }
            if (bl3) {
                this.mask |= 4;
            }
            if (bl4) {
                this.mask |= 8;
            }
        }

        public void setHasSubj() {
            this.mask |= 1;
        }

        public void setHasPred() {
            this.mask |= 2;
        }

        public void setHasObj() {
            this.mask |= 4;
        }

        public void setIsStmt() {
            this.mask |= 0x10;
        }

        public boolean hasIntersect(StmtMask stmtMask) {
            return (this.mask & stmtMask.mask) != 0;
        }

        public boolean equals(StmtMask stmtMask) {
            return this.mask == stmtMask.mask;
        }
    }

    class ReifCache {
        protected Node stmtURI;
        protected StmtMask mask;
        protected int tripleCnt;

        ReifCache(Node node, StmtMask stmtMask, int n) {
            this.stmtURI = node;
            this.mask = stmtMask;
            this.tripleCnt = n;
        }

        public StmtMask getStmtMask() {
            return this.mask;
        }

        public int getCnt() {
            return this.tripleCnt;
        }

        public Node getStmtURI() {
            return this.stmtURI;
        }

        public void setMask(StmtMask stmtMask) {
            this.mask = stmtMask;
        }

        public void setCnt(int n) {
            this.tripleCnt = n;
        }

        public void incCnt(int n) {
            ++this.tripleCnt;
        }

        public void decCnt(int n) {
            --this.tripleCnt;
        }

        public boolean canMerge(StmtMask stmtMask) {
            return !this.mask.hasIntersect(stmtMask);
        }

        public boolean canUpdate(StmtMask stmtMask) {
            return this.canMerge(stmtMask) && this.tripleCnt == 1;
        }

        public void update(StmtMask stmtMask) {
            this.mask.setMerge(stmtMask);
            if (this.isStmt()) {
                this.mask.setIsStmt();
            }
        }

        private boolean isStmt() {
            return this.mask.hasSPOT() && this.tripleCnt == 1;
        }
    }

    public class ReifCacheMap {
        protected int cacheSize = 1;
        protected ReifCache[] cache;
        protected boolean[] inUse;

        ReifCacheMap(int n) {
            this.inUse = new boolean[n];
            this.cache = new ReifCache[n];
            for (int i = 0; i < n; ++i) {
                this.inUse[i] = false;
            }
        }

        ReifCache lookup(Node node) {
            for (int i = 0; i < this.cache.length; ++i) {
                if (!this.inUse[i] || !this.cache[i].getStmtURI().equals(node)) continue;
                return this.cache[i];
            }
            return null;
        }

        public void flushAll() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.inUse[i] = false;
            }
        }

        public void flush(ReifCache reifCache) {
            this.flushAll();
        }

        public ReifCache load(Node node) {
            ReifCache reifCache = this.lookup(node);
            if (reifCache != null) {
                return reifCache;
            }
            return this.load(node, null, null, null);
        }

        public ReifCache load(Node node, Triple triple, StmtMask stmtMask, StmtMask stmtMask2) {
            this.flushAll();
            StmtMask stmtMask3 = new StmtMask();
            boolean bl = stmtMask != null;
            int n = 0;
            ResultSetReifIterator resultSetReifIterator = SpecializedGraphReifier_RDB.this.m_reif.findReifStmt(node, false, SpecializedGraphReifier_RDB.this.my_GID, false);
            while (resultSetReifIterator.hasNext()) {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                ++n;
                Triple triple2 = (Triple)resultSetReifIterator.next();
                StmtMask stmtMask4 = new StmtMask();
                boolean bl5 = bl4 = !triple2.getSubject().equals(Node.ANY);
                if (bl4 && bl) {
                    if (triple2.getSubject().equals(triple.getSubject())) {
                        stmtMask.setHasSubj();
                    } else {
                        stmtMask2.setHasSubj();
                    }
                }
                boolean bl6 = bl3 = !triple2.getPredicate().equals(Node.ANY);
                if (bl3 && bl) {
                    if (triple2.getPredicate().equals(triple.getPredicate())) {
                        stmtMask.setHasPred();
                    } else {
                        stmtMask2.setHasPred();
                    }
                }
                boolean bl7 = bl2 = !triple2.getObject().equals(Node.ANY);
                if (bl2 && bl) {
                    if (triple2.getObject().equals(triple.getObject())) {
                        stmtMask.setHasObj();
                    } else {
                        stmtMask2.setHasObj();
                    }
                }
                boolean bl8 = resultSetReifIterator.getHasType();
                stmtMask4.setMask(bl4, bl3, bl2, bl8);
                if (stmtMask4.hasNada()) {
                    throw new JenaException("Fragment has no data");
                }
                stmtMask3.setMerge(stmtMask4);
            }
            if (n == 0) {
                return null;
            }
            if (stmtMask3.hasSPOT() && n == 1) {
                stmtMask3.setIsStmt();
            }
            this.inUse[0] = true;
            this.cache[0] = new ReifCache(node, stmtMask3, n);
            return this.cache[0];
        }

        protected Triple fragToTriple(Triple triple, StmtMask stmtMask) {
            Node_URI node_URI = (Node_URI)triple.getSubject();
            if (stmtMask.hasPred()) {
                return new Triple(node_URI, triple.getPredicate(), Node.ANY);
            }
            if (stmtMask.hasObj()) {
                return new Triple(node_URI, Node.ANY, triple.getObject());
            }
            return new Triple(node_URI, Node.ANY, Node.ANY);
        }
    }
}

