/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Properties;

public class Driver_Oracle
extends DriverRDB {
    public Driver_Oracle() {
        String string = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "Oracle";
        this.DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
        this.EMPTY_LITERAL_MARKER = "EmptyLiteral";
        this.ID_SQL_TYPE = "INTEGER";
        this.INSERT_BY_PROCEDURE = false;
        this.INDEX_KEY_LENGTH = 4000;
        this.LONG_OBJECT_LENGTH = 250;
        this.HAS_XACTS = true;
        this.PRE_ALLOCATE_ID = true;
        this.SKIP_DUPLICATE_CHECK = false;
        this.EMPTY_LITERAL_MARKER = "EmptyLiteral";
        this.SQL_FILE = "etc/oracle.sql";
        this.m_psetClassName = string + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = string + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = string + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = string + ".SpecializedGraphReifier_RDB";
        this.QUOTE_CHAR = (char)39;
        this.DB_NAMES_TO_UPPER = true;
    }

    public void setConnection(IDBConnection iDBConnection) {
        this.m_dbcon = iDBConnection;
        try {
            Properties properties = SQLCache.loadSQLFile(this.DEFAULT_SQL_FILE, null, this.ID_SQL_TYPE);
            this.m_sql = new SQLCache(this.SQL_FILE, properties, iDBConnection, this.ID_SQL_TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            logger.error((Object)"Unable to set connection for Driver:", (Throwable)exception);
        }
    }

    public int graphIdAlloc(String string) {
        Object var2_2 = null;
        int n = 0;
        try {
            String string2 = "insertGraph";
            n = this.getInsertID("jena_graph");
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to get last inserted ID: " + sQLException);
        }
        return n;
    }

    public void graphIdDealloc(int n) {
        Object var2_2 = null;
        try {
            String string = "deleteGraph";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to delete graph ID: " + sQLException);
        }
    }

    public int getInsertID(String string) {
        DBIDInt dBIDInt = null;
        try {
            String string2 = "getInsertID";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new RDFRDBException("No insert ID");
            }
            dBIDInt = this.wrapDBID(resultSet.getObject(1));
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to insert ID: " + sQLException);
        }
        return dBIDInt.getIntID();
    }

    protected void getTblParams(String[] stringArray) {
        String string;
        if (this.LONG_OBJECT_LENGTH > 4000) {
            throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        String string2 = "VARCHAR2(" + this.LONG_OBJECT_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        stringArray[0] = string2;
        stringArray[1] = string = "VARCHAR2(" + this.INDEX_KEY_LENGTH + ")";
    }

    protected String[] getCreateTableParams(int n, boolean bl) {
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        this.getTblParams(stringArray);
        int n2 = this.getTableCount(n);
        String string = "jena_g" + Integer.toString(n) + "t" + Integer.toString(n2) + (bl ? "_reif" : "_stmt");
        stringArray2[0] = string = this.stringToDBname(string);
        stringArray2[1] = stringArray[0];
        return stringArray2;
    }

    protected String[] getDbInitTablesParams() {
        String[] stringArray = new String[2];
        this.getTblParams(stringArray);
        this.EOS_LEN = this.EOS.length();
        return stringArray;
    }

    public DBIDInt addRDBLongObject(DriverRDB.RDBLongObject rDBLongObject, String string) throws RDFRDBException {
        DBIDInt dBIDInt = null;
        try {
            int n = 1;
            boolean bl = this.m_dbcon.getConnection().getAutoCommit();
            String string2 = rDBLongObject.tail.length() > 0 ? "insertLongObjectEmptyTail" : "insertLongObject";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            int n2 = 0;
            if (this.PRE_ALLOCATE_ID) {
                n2 = this.getInsertID(string);
                preparedStatement.setInt(n++, n2);
                dBIDInt = this.wrapDBID(new Integer(n2));
            }
            preparedStatement.setString(n++, rDBLongObject.head);
            if (rDBLongObject.tail.length() > 0) {
                preparedStatement.setLong(n++, rDBLongObject.hash);
            } else {
                preparedStatement.setNull(n++, -5);
            }
            preparedStatement.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
            if (rDBLongObject.tail.length() > 0) {
                if (!this.inTransaction) {
                    this.m_dbcon.getConnection().setAutoCommit(false);
                }
                string2 = "getEmptyBLOB";
                String string3 = this.m_sql.getSQLStatement(string2, string, dBIDInt.getID().toString());
                Statement statement = this.m_sql.getConnection().createStatement();
                ResultSet resultSet = statement.executeQuery(string3);
                resultSet.next();
                BLOB bLOB = ((OracleResultSet)resultSet).getBLOB(1);
                OutputStream outputStream = bLOB.getBinaryOutputStream();
                int n4 = bLOB.getBufferSize();
                int n5 = -1;
                StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(rDBLongObject.tail);
                byte[] byArray = new byte[n4];
                while ((n5 = stringBufferInputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n5);
                }
                if (bLOB.isOpen()) {
                    bLOB.close();
                }
                stringBufferInputStream.close();
                outputStream.close();
                statement.close();
                if (!this.inTransaction) {
                    this.m_dbcon.getConnection().setAutoCommit(bl);
                }
            }
            if (!this.PRE_ALLOCATE_ID) {
                n2 = this.getInsertID(string);
                dBIDInt = this.wrapDBID(new Integer(n2));
            }
        }
        catch (Exception exception) {
            System.out.println("Problem on long object (l=" + rDBLongObject.head + ") " + exception);
            throw new RDFRDBException("Failed to add long object ", exception);
        }
        return dBIDInt;
    }

    protected DriverRDB.RDBLongObject IDtoLongObject(int n, String string) {
        DriverRDB.RDBLongObject rDBLongObject = null;
        try {
            String string2 = "getLongObject";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            preparedStatement.setInt(1, n);
            OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
            if (oracleResultSet.next()) {
                rDBLongObject = new DriverRDB.RDBLongObject();
                rDBLongObject.head = oracleResultSet.getString(1);
                BLOB bLOB = oracleResultSet.getBLOB(2);
                if (bLOB != null) {
                    Object var8_10 = null;
                    int n2 = (int)bLOB.length();
                    byte[] byArray = bLOB.getBytes(1L, n2);
                    rDBLongObject.tail = new String(byArray, "UTF-8");
                } else {
                    rDBLongObject.tail = "";
                }
            }
            oracleResultSet.close();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to retrieve long object (SQL Exception): ", sQLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RDFRDBException("Failed to retrieve long object (UnsupportedEncoding): ", unsupportedEncodingException);
        }
        return rDBLongObject;
    }

    public void clearSequences() {
        Iterator iterator = this.getSequences().iterator();
        while (iterator.hasNext()) {
            this.removeSequence((String)iterator.next());
        }
    }

    private static interface OracleResultSet
    extends ResultSet {
        public BLOB getBLOB(int var1);
    }

    public static interface BLOB
    extends Blob {
        public OutputStream getBinaryOutputStream();

        public int getBufferSize();

        public boolean isOpen();

        public void close();
    }
}

