/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DBBulkUpdateHandler
implements BulkUpdateHandler {
    private GraphRDB graph;
    private GraphEventManager manager;
    protected static int CHUNK_SIZE = 50;

    public DBBulkUpdateHandler(GraphRDB graphRDB) {
        this.graph = graphRDB;
        this.manager = graphRDB.getEventManager();
    }

    public void add(Triple[] tripleArray) {
        this.add(Arrays.asList(tripleArray), false);
        this.manager.notifyAddArray(tripleArray);
    }

    public void add(List list) {
        this.add(list, true);
    }

    protected void add(List list, boolean bl) {
        this.graph.add(list);
        if (bl) {
            this.manager.notifyAddList(list);
        }
    }

    public void add(Iterator iterator) {
        if (this.manager.listening()) {
            List list = GraphUtil.iteratorToList(iterator);
            this.add(list, false);
            this.manager.notifyAddIterator(list);
        } else {
            this.addIterator(iterator);
        }
    }

    protected void addIterator(Iterator iterator) {
        ArrayList arrayList = new ArrayList(CHUNK_SIZE);
        while (iterator.hasNext()) {
            while (iterator.hasNext() && arrayList.size() < CHUNK_SIZE) {
                arrayList.add(iterator.next());
            }
            this.graph.add(arrayList);
            arrayList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        try {
            this.addIterator(extendedIterator);
        }
        finally {
            extendedIterator.close();
        }
        SimpleBulkUpdateHandler.addReifications(this.graph, graph);
        this.manager.notifyAddGraph(graph);
    }

    public void delete(Triple[] tripleArray) {
        this.delete(Arrays.asList(tripleArray), false);
        this.manager.notifyDeleteArray(tripleArray);
    }

    public void delete(List list) {
        this.delete(list, true);
    }

    protected void delete(List list, boolean bl) {
        this.graph.delete(list);
        if (bl) {
            this.manager.notifyDeleteList(list);
        }
    }

    public void delete(Iterator iterator) {
        if (this.manager.listening()) {
            List list = GraphUtil.iteratorToList(iterator);
            this.delete(list, false);
            this.manager.notifyDeleteIterator(list);
        } else {
            this.deleteIterator(iterator);
        }
    }

    protected void deleteIterator(Iterator iterator) {
        ArrayList arrayList = new ArrayList(CHUNK_SIZE);
        while (iterator.hasNext()) {
            while (iterator.hasNext() && arrayList.size() < CHUNK_SIZE) {
                arrayList.add(iterator.next());
            }
            this.graph.delete(arrayList);
            arrayList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Graph graph) {
        ExtendedIterator extendedIterator = GraphUtil.findAll(graph);
        try {
            this.deleteIterator(extendedIterator);
        }
        finally {
            extendedIterator.close();
        }
        SimpleBulkUpdateHandler.deleteReifications(this.graph, graph);
        this.manager.notifyDeleteGraph(graph);
    }
}

