/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import java.util.HashMap;
import java.util.Iterator;

public class TypeMapper {
    private static TypeMapper theTypeMap = new TypeMapper();
    private HashMap uriToDT = new HashMap();
    private HashMap classToDT = new HashMap();

    public static TypeMapper getInstance() {
        return theTypeMap;
    }

    public RDFDatatype getSafeTypeByName(String string) {
        RDFDatatype rDFDatatype = (RDFDatatype)this.uriToDT.get(string);
        if (rDFDatatype == null) {
            if (string == null) {
                return null;
            }
            rDFDatatype = new BaseDatatype(string);
            this.registerDatatype(rDFDatatype);
        }
        return rDFDatatype;
    }

    public RDFDatatype getTypeByName(String string) {
        return (RDFDatatype)this.uriToDT.get(string);
    }

    public RDFDatatype getTypeByValue(Object object) {
        return (RDFDatatype)this.classToDT.get(object.getClass());
    }

    public Iterator listTypes() {
        return this.uriToDT.values().iterator();
    }

    public void registerDatatype(RDFDatatype rDFDatatype) {
        this.uriToDT.put(rDFDatatype.getURI(), rDFDatatype);
        Class clazz = rDFDatatype.getJavaClass();
        if (clazz != null) {
            this.classToDT.put(clazz, rDFDatatype);
        }
    }

    public static void main(String[] stringArray) {
        Iterator iterator = theTypeMap.listTypes();
        while (iterator.hasNext()) {
            RDFDatatype rDFDatatype = (RDFDatatype)iterator.next();
            System.out.println(" - " + rDFDatatype);
        }
    }

    static {
        theTypeMap.registerDatatype(XMLLiteralType.theXMLLiteralType);
        XSDDatatype.loadXSDSimpleTypes(theTypeMap);
    }
}

