/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz.applet;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.IsaViz.applet.IsvBrowser;

public class TextViewer
extends JFrame
implements ActionListener,
KeyListener,
Runnable {
    Thread runView;
    JButton okBt;
    StringBuffer text;
    int oldSize;
    int period;
    JTextArea ar;

    public TextViewer(StringBuffer stringBuffer, String string, int n) {
        this.text = stringBuffer;
        this.oldSize = this.text.length();
        this.period = n;
        this.ar = new JTextArea(this.text.toString());
        this.ar.setFont(IsvBrowser.swingFont);
        this.ar.setEditable(false);
        this.ar.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.ar);
        jScrollPane.setVerticalScrollBarPolicy(22);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        container.setLayout(gridBagLayout);
        this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 98);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        container.add(jScrollPane);
        this.okBt = new JButton("OK");
        this.okBt.addActionListener(this);
        this.okBt.addKeyListener(this);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 100, 2);
        gridBagLayout.setConstraints(this.okBt, gridBagConstraints);
        container.add(this.okBt);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TextViewer.this.stop();
                TextViewer.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle(string);
        this.pack();
        this.setLocation(0, 0);
        this.setSize(700, 300);
        this.setVisible(true);
        this.okBt.requestFocus();
        if (this.period > 0) {
            this.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if (TextViewer.this.isShowing()) {
                        TextViewer.this.start();
                    } else {
                        TextViewer.this.stop();
                    }
                }
            });
            this.start();
        }
    }

    public void start() {
        this.runView = new Thread(this);
        this.runView.setPriority(1);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.runView == thread) {
            if (this.text.length() != this.oldSize) {
                this.ar.setText(this.text.toString());
            }
            this.oldSize = this.text.length();
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okBt) {
            this.stop();
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() == this.okBt) {
            this.stop();
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

