/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class XMLManager {
    Editor application;

    XMLManager(Editor editor) {
        this.application = editor;
    }

    Document parse(File file, boolean bl) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(bl));
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            return document;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.application.errorMessages.append("XMLManager.parse(" + file.getAbsolutePath() + "): " + factoryConfigurationError + "\n");
            JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + file);
            this.application.reportError = true;
            factoryConfigurationError.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.application.errorMessages.append("XMLManager.parse(" + file.getAbsolutePath() + "): " + parserConfigurationException + "\n");
            JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + file);
            this.application.reportError = true;
            parserConfigurationException.printStackTrace();
            return null;
        }
        catch (SAXException sAXException) {
            this.application.errorMessages.append("XMLManager.parse(" + file.getAbsolutePath() + "): " + sAXException + "\n");
            JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + file);
            this.application.reportError = true;
            return null;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("XMLManager.parse(" + file.getAbsolutePath() + "): " + iOException + "\n");
            JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + file);
            this.application.reportError = true;
            return null;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("XMLManager.parse(" + file.getAbsolutePath() + "): " + exception + "\n");
            JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + file);
            this.application.reportError = true;
            return null;
        }
    }

    void serialize(Document document, File file) {
        if (file != null && document != null) {
            OutputFormat outputFormat = new OutputFormat(document, "UTF-8", true);
            outputFormat.setLineSeparator("\n");
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ConfigManager.ENCODING);
                DOMSerializer dOMSerializer = new XMLSerializer((Writer)outputStreamWriter, outputFormat).asDOMSerializer();
                dOMSerializer.serialize(document);
            }
            catch (IOException iOException) {
                this.application.errorMessages.append("XMLManager.serialize(" + file.getAbsolutePath() + "): " + iOException + "\n");
                JOptionPane.showMessageDialog(Editor.cmp, "An error occured while trying to serialize XML file " + file.getAbsolutePath());
                this.application.reportError = true;
                iOException.printStackTrace();
            }
        }
    }
}

