/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GSSManager;
import org.w3c.IsaViz.GSSTableModel;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.NSTableModel;
import org.w3c.IsaViz.PRTableModel;
import org.w3c.IsaViz.ProgressPanel;
import org.w3c.IsaViz.RDFLoader;
import org.w3c.IsaViz.URLPanel;
import org.w3c.IsaViz.Utils;

class TablePanel
extends JFrame
implements ActionListener,
KeyListener,
MouseListener,
ChangeListener {
    static boolean SHOW_ISOLATED_NODES = true;
    static String _rx = "   RDF/XML...";
    static String _n3 = "   Notation 3...";
    static String _nt = "   N-Triples...";
    static String[] ldStyleFileFormats = new String[]{"Load from File...", _rx, _n3, _nt};
    static String[] ldStyleURLFormats = new String[]{"Load from URL...", _rx, _n3, _nt};
    Editor application;
    JTabbedPane tabbedPane;
    JScrollPane sp1;
    JScrollPane sp2;
    JScrollPane sp4;
    JTable nsTable;
    DefaultTableModel nsTableModel;
    JButton addNSBt;
    JButton remNSBt;
    JTextField nsPrefTf;
    JTextField nsURITf;
    JTable prTable;
    JButton addPRBt;
    JButton remPRBt;
    JButton loadPRBt;
    JTextField nsPrpTf;
    JTextField lnPrpTf;
    JPanel rsPane;
    JPanel outerRsPane;
    JLabel resourceLb;
    JLabel bckBt;
    IResource[] browserList = new IResource[Editor.MAX_BRW_LIST_SIZE];
    int brwIndex = 0;
    JTable gssTable;
    DefaultTableModel gssTableModel;
    JComboBox ldStyleFromFileCb;
    JComboBox ldStyleFromURLCb;
    JButton editStyleBt;
    JButton removeStyleBt;
    JButton applyStyleBt;
    JButton promoteSelStyleBt;
    JButton demoteSelStyleBt;
    JCheckBox shIsolRsCb;
    JCheckBox debugGssCb;
    ProgressPanel stpb;
    JTextArea rdfInputArea;
    JButton loadQIBt;
    JButton mergeQIBt;
    JButton clearQIBt;
    JComboBox qiFormatList;
    TableModelListener l1 = new TableModelListener(){

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() != -1) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                TablePanel.this.application.updateNamespaceBinding(n, n2, (String)TablePanel.this.nsTableModel.getValueAt(n, 0), (String)TablePanel.this.nsTableModel.getValueAt(n, 1), (Boolean)TablePanel.this.nsTableModel.getValueAt(n, 2), tableModelEvent.getType());
            }
        }
    };
    TableModelListener l2 = new TableModelListener(){

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() != -1) {
                // empty if block
            }
        }
    };
    static /* synthetic */ Class class$java$lang$Boolean;

    TablePanel(Editor editor, int n, int n2, int n3, int n4) {
        this.application = editor;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.nsTableModel = new NSTableModel(0, 3);
        this.nsTableModel.addTableModelListener(this.l1);
        this.nsTable = new JTable(this.nsTableModel);
        this.nsTable.setSelectionMode(0);
        TableColumn tableColumn = this.nsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(n3 / 100 * 20);
        tableColumn.setHeaderValue("Prefix");
        tableColumn = this.nsTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(n3 / 100 * 70);
        tableColumn.setHeaderValue("URI");
        tableColumn = this.nsTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(n3 / 100 * 10);
        tableColumn.setHeaderValue("Display Prefix");
        TableCellRenderer tableCellRenderer = this.nsTable.getDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TablePanel.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        tableColumn.setCellRenderer(tableCellRenderer);
        TableCellEditor tableCellEditor = this.nsTable.getDefaultEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TablePanel.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        tableColumn.setCellEditor(tableCellEditor);
        this.sp1 = new JScrollPane(this.nsTable);
        this.sp1.setVerticalScrollBarPolicy(22);
        this.sp1.setHorizontalScrollBarPolicy(30);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.buildConstraints(gridBagConstraints, 0, 0, 5, 1, 100, 99);
        gridBagLayout.setConstraints(this.sp1, gridBagConstraints);
        jPanel.add(this.sp1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.nsPrefTf = new JTextField();
        this.nsPrefTf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 25, 1);
        gridBagLayout.setConstraints(this.nsPrefTf, gridBagConstraints);
        jPanel.add(this.nsPrefTf);
        this.nsURITf = new JTextField();
        this.nsURITf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 75, 0);
        gridBagLayout.setConstraints(this.nsURITf, gridBagConstraints);
        jPanel.add(this.nsURITf);
        gridBagConstraints.fill = 0;
        this.addNSBt = new JButton("Add NS Binding");
        this.addNSBt.setFont(Editor.tinyFont);
        this.addNSBt.addActionListener(this);
        this.addNSBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 7, 0);
        gridBagLayout.setConstraints(this.addNSBt, gridBagConstraints);
        jPanel.add(this.addNSBt);
        gridBagConstraints.anchor = 10;
        this.remNSBt = new JButton("Remove Selected");
        this.remNSBt.setFont(Editor.tinyFont);
        this.remNSBt.addActionListener(this);
        this.remNSBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 6, 0);
        gridBagLayout.setConstraints(this.remNSBt, gridBagConstraints);
        jPanel.add(this.remNSBt);
        this.tabbedPane.addTab("Namespaces", jPanel);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout2);
        PRTableModel pRTableModel = new PRTableModel(0, 3);
        pRTableModel.addTableModelListener(this.l2);
        this.prTable = new JTable(pRTableModel);
        this.prTable.setSelectionMode(0);
        TableColumn tableColumn2 = this.prTable.getColumnModel().getColumn(0);
        tableColumn2.setPreferredWidth(n3 / 100 * 50);
        tableColumn2.setHeaderValue("Namespace");
        tableColumn2 = this.prTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(n3 / 100 * 15);
        tableColumn2.setHeaderValue("Prefix");
        tableColumn2 = this.prTable.getColumnModel().getColumn(2);
        tableColumn2.setPreferredWidth(n3 / 100 * 35);
        tableColumn2.setHeaderValue("Property name");
        this.sp2 = new JScrollPane(this.prTable);
        this.sp2.setVerticalScrollBarPolicy(22);
        this.sp2.setHorizontalScrollBarPolicy(30);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        this.buildConstraints(gridBagConstraints2, 0, 0, 5, 1, 100, 99);
        gridBagLayout2.setConstraints(this.sp2, gridBagConstraints2);
        jPanel2.add(this.sp2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        this.nsPrpTf = new JTextField();
        this.nsPrpTf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 0, 1, 1, 1, 40, 1);
        gridBagLayout2.setConstraints(this.nsPrpTf, gridBagConstraints2);
        jPanel2.add(this.nsPrpTf);
        this.lnPrpTf = new JTextField();
        this.lnPrpTf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 1, 1, 1, 1, 40, 0);
        gridBagLayout2.setConstraints(this.lnPrpTf, gridBagConstraints2);
        jPanel2.add(this.lnPrpTf);
        gridBagConstraints2.fill = 0;
        this.addPRBt = new JButton("Add Property");
        this.addPRBt.setFont(Editor.tinyFont);
        this.addPRBt.addActionListener(this);
        this.addPRBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 2, 1, 1, 1, 20, 0);
        gridBagLayout2.setConstraints(this.addPRBt, gridBagConstraints2);
        jPanel2.add(this.addPRBt);
        gridBagConstraints2.anchor = 17;
        this.remPRBt = new JButton("Remove Selected");
        this.remPRBt.setFont(Editor.tinyFont);
        this.remPRBt.addActionListener(this);
        this.remPRBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 3, 1, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.remPRBt, gridBagConstraints2);
        jPanel2.add(this.remPRBt);
        gridBagConstraints2.anchor = 13;
        this.loadPRBt = new JButton("Load Properties...");
        this.loadPRBt.setFont(Editor.tinyFont);
        this.loadPRBt.addActionListener(this);
        this.loadPRBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 4, 1, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.loadPRBt, gridBagConstraints2);
        jPanel2.add(this.loadPRBt);
        this.tabbedPane.addTab("Property Types", jPanel2);
        ListSelectionModel listSelectionModel = this.prTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    TablePanel.this.application.setSelectedPropertyConstructor((String)TablePanel.this.prTable.getModel().getValueAt(n, 0), (String)TablePanel.this.prTable.getModel().getValueAt(n, 2));
                }
            }
        });
        this.outerRsPane = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.outerRsPane.setLayout(gridBagLayout3);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        this.resourceLb = new JLabel();
        this.resourceLb.setFont(Editor.swingFont);
        this.buildConstraints(gridBagConstraints3, 0, 0, 1, 1, 50, 1);
        gridBagLayout3.setConstraints(this.resourceLb, gridBagConstraints3);
        this.outerRsPane.add(this.resourceLb);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.anchor = 13;
        this.bckBt = new JLabel("Back");
        this.buildConstraints(gridBagConstraints3, 1, 0, 1, 1, 50, 1);
        gridBagLayout3.setConstraints(this.bckBt, gridBagConstraints3);
        this.bckBt.addMouseListener(this);
        this.outerRsPane.add(this.bckBt);
        this.rsPane = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.rsPane);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 10;
        this.buildConstraints(gridBagConstraints3, 0, 1, 2, 1, 100, 99);
        gridBagLayout3.setConstraints(jScrollPane, gridBagConstraints3);
        this.outerRsPane.add(jScrollPane);
        this.tabbedPane.addTab("Property Browser", this.outerRsPane);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout4);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder());
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        jPanel4.setLayout(gridBagLayout5);
        this.promoteSelStyleBt = new JButton(new ImageIcon(this.getClass().getResource("/images/down24.gif")));
        this.demoteSelStyleBt = new JButton(new ImageIcon(this.getClass().getResource("/images/up24.gif")));
        this.promoteSelStyleBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/images/down24b.gif")));
        this.demoteSelStyleBt.setRolloverIcon(new ImageIcon(this.getClass().getResource("/images/up24b.gif")));
        this.promoteSelStyleBt.setBorder(BorderFactory.createEmptyBorder());
        this.demoteSelStyleBt.setBorder(BorderFactory.createEmptyBorder());
        this.promoteSelStyleBt.addActionListener(this);
        this.demoteSelStyleBt.addActionListener(this);
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.anchor = 15;
        this.buildConstraints(gridBagConstraints5, 0, 0, 1, 1, 100, 50);
        gridBagLayout5.setConstraints(this.demoteSelStyleBt, gridBagConstraints5);
        jPanel4.add(this.demoteSelStyleBt);
        gridBagConstraints5.anchor = 11;
        this.buildConstraints(gridBagConstraints5, 0, 1, 1, 1, 100, 50);
        gridBagLayout5.setConstraints(this.promoteSelStyleBt, gridBagConstraints5);
        jPanel4.add(this.promoteSelStyleBt);
        this.buildConstraints(gridBagConstraints4, 0, 0, 1, 1, 1, 99);
        gridBagLayout4.setConstraints(jPanel4, gridBagConstraints4);
        jPanel3.add(jPanel4);
        this.gssTableModel = new GSSTableModel(0, 1);
        this.gssTable = new JTable(this.gssTableModel);
        this.gssTable.setSelectionMode(0);
        tableColumn = this.gssTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(n3);
        tableColumn.setHeaderValue("Location");
        this.sp4 = new JScrollPane(this.gssTable);
        this.sp4.setVerticalScrollBarPolicy(22);
        this.sp4.setHorizontalScrollBarPolicy(30);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 10;
        this.buildConstraints(gridBagConstraints4, 1, 0, 1, 1, 99, 0);
        gridBagLayout4.setConstraints(this.sp4, gridBagConstraints4);
        jPanel3.add(this.sp4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder());
        jPanel5.setLayout(new GridLayout(1, 8));
        this.ldStyleFromFileCb = new JComboBox<String>(ldStyleFileFormats);
        this.ldStyleFromURLCb = new JComboBox<String>(ldStyleURLFormats);
        this.removeStyleBt = new JButton("Remove");
        this.editStyleBt = new JButton("Edit Stylesheet...");
        this.shIsolRsCb = new JCheckBox("Show Isolated Resources", SHOW_ISOLATED_NODES);
        this.applyStyleBt = new JButton("Apply Stylesheets");
        this.debugGssCb = new JCheckBox("Debug", GraphStylesheet.DEBUG_GSS);
        this.stpb = new ProgressPanel();
        this.stpb.setForegroundColor(ConfigManager.pastelBlue);
        this.ldStyleFromFileCb.addActionListener(this);
        this.ldStyleFromURLCb.addActionListener(this);
        this.editStyleBt.addActionListener(this);
        this.removeStyleBt.addActionListener(this);
        this.applyStyleBt.addActionListener(this);
        this.shIsolRsCb.addActionListener(this);
        this.debugGssCb.addActionListener(this);
        jPanel5.add(this.ldStyleFromFileCb);
        jPanel5.add(this.ldStyleFromURLCb);
        jPanel5.add(this.removeStyleBt);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout6 = new GridBagLayout();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        jPanel6.setLayout(gridBagLayout6);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.anchor = 10;
        this.buildConstraints(gridBagConstraints6, 0, 0, 1, 1, 100, 100);
        gridBagLayout6.setConstraints(this.stpb, gridBagConstraints6);
        jPanel6.add(this.stpb);
        jPanel5.add(jPanel6);
        jPanel5.add(this.editStyleBt);
        jPanel5.add(this.applyStyleBt);
        jPanel5.add(this.shIsolRsCb);
        jPanel5.add(this.debugGssCb);
        this.buildConstraints(gridBagConstraints4, 0, 1, 2, 1, 100, 1);
        gridBagLayout4.setConstraints(jPanel5, gridBagConstraints4);
        jPanel3.add(jPanel5);
        this.tabbedPane.addTab("Stylesheets", jPanel3);
        JPanel jPanel7 = new JPanel();
        GridBagLayout gridBagLayout7 = new GridBagLayout();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        jPanel7.setLayout(gridBagLayout7);
        this.rdfInputArea = new JTextArea();
        JScrollPane jScrollPane2 = new JScrollPane(this.rdfInputArea);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.anchor = 10;
        this.buildConstraints(gridBagConstraints7, 0, 0, 5, 1, 100, 99);
        gridBagLayout7.setConstraints(jScrollPane2, gridBagConstraints7);
        jPanel7.add(jScrollPane2);
        this.qiFormatList = new JComboBox(RDFLoader.formatList);
        this.qiFormatList.setBorder(BorderFactory.createEmptyBorder());
        this.buildConstraints(gridBagConstraints7, 0, 1, 1, 1, 20, 1);
        gridBagLayout7.setConstraints(this.qiFormatList, gridBagConstraints7);
        this.qiFormatList.addActionListener(this);
        jPanel7.add(this.qiFormatList);
        this.loadQIBt = new JButton("Replace");
        this.loadQIBt.setBorder(BorderFactory.createEtchedBorder());
        this.buildConstraints(gridBagConstraints7, 1, 1, 1, 1, 20, 0);
        gridBagLayout7.setConstraints(this.loadQIBt, gridBagConstraints7);
        this.loadQIBt.addActionListener(this);
        jPanel7.add(this.loadQIBt);
        this.mergeQIBt = new JButton("Merge");
        this.mergeQIBt.setBorder(BorderFactory.createEtchedBorder());
        this.buildConstraints(gridBagConstraints7, 2, 1, 1, 1, 20, 0);
        gridBagLayout7.setConstraints(this.mergeQIBt, gridBagConstraints7);
        this.mergeQIBt.addActionListener(this);
        jPanel7.add(this.mergeQIBt);
        this.clearQIBt = new JButton("Clear");
        this.clearQIBt.setBorder(BorderFactory.createEtchedBorder());
        this.buildConstraints(gridBagConstraints7, 4, 1, 1, 1, 20, 0);
        gridBagLayout7.setConstraints(this.clearQIBt, gridBagConstraints7);
        this.clearQIBt.addActionListener(this);
        jPanel7.add(this.clearQIBt);
        this.tabbedPane.addTab("Quick Input", jPanel7);
        Container container = this.getContentPane();
        container.add(this.tabbedPane);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Editor.cmp.showTablesMn.setSelected(false);
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle("Definitions");
        this.pack();
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    void updatePropertyBrowser(INode iNode, boolean bl) {
        this.rsPane.removeAll();
        if (iNode != null && iNode instanceof IResource) {
            IResource iResource = (IResource)iNode;
            if (bl) {
                int n = Utils.getFirstEmptyIndex(this.browserList);
                if (n == -1) {
                    Utils.eraseFirstAddNewElem(this.browserList, iResource);
                    this.brwIndex = this.browserList.length - 1;
                } else {
                    this.browserList[n] = iResource;
                    this.brwIndex = n;
                }
            }
            String string = iResource.getIdentity();
            if (iResource.getLabel() != null) {
                string = string + " (" + iResource.getLabel() + ")";
            }
            this.resourceLb.setText(string);
            this.resourceLb.setForeground(ConfigManager.darkerPastelBlue);
            Vector vector = iResource.getOutgoingPredicates();
            if (vector != null) {
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                this.rsPane.setLayout(gridBagLayout);
                int n = 0;
                int n2 = 0;
                int n3 = 1;
                int n4 = 1;
                int n5 = 50;
                int n6 = 100 / vector.size();
                int n7 = 0;
                while (n7 < vector.size()) {
                    IProperty iProperty = (IProperty)vector.elementAt(n7);
                    String string2 = Editor.getNSBinding(iProperty.getNamespace());
                    JLabel jLabel = new JLabel(string2 != null ? string2 + ":" + iProperty.getLocalname() : iProperty.getIdent());
                    jLabel.setFont(Editor.swingFont);
                    this.buildConstraints(gridBagConstraints, n, n2, n3, n4, n5, 1);
                    gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                    this.rsPane.add(jLabel);
                    Component component = this.getSwingRepresentation(iProperty.object);
                    component.setFont(Editor.swingFont);
                    this.buildConstraints(gridBagConstraints, ++n, n2, n3, n4, n5, 0);
                    gridBagLayout.setConstraints(component, gridBagConstraints);
                    this.rsPane.add(component);
                    n = 0;
                    ++n2;
                    ++n7;
                }
                JLabel jLabel = new JLabel();
                this.buildConstraints(gridBagConstraints, n, n2, 2, 1, 100, 99);
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.rsPane.add(jLabel);
            } else {
                this.rsPane.add(new JLabel("No property is associated to this resource."));
            }
        } else {
            this.resourceLb.setText("");
        }
        this.outerRsPane.paintAll(this.outerRsPane.getGraphics());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addNSBt) {
            this.checkAndAddNS(this.nsPrefTf.getText(), this.nsURITf.getText());
        } else if (object == this.addPRBt) {
            this.checkAndAddProperty(this.nsPrpTf.getText(), this.lnPrpTf.getText());
        } else if (object == this.remNSBt) {
            int n = this.nsTable.getSelectedRow();
            if (n != -1) {
                this.application.removeNamespaceBinding(n);
            }
        } else if (object == this.remPRBt) {
            int n = this.prTable.getSelectedRow();
            if (n != -1) {
                this.application.removePropertyConstructor(n);
            }
        } else if (object == this.loadPRBt) {
            JFileChooser jFileChooser = new JFileChooser(Editor.lastImportRDFDir != null ? Editor.lastImportRDFDir : Editor.rdfDir);
            jFileChooser.setDialogTitle("Load Properties from RDF/XML File");
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.application.loadPropertyTypes(jFileChooser.getSelectedFile());
            }
        } else if (object == this.ldStyleFromFileCb) {
            JFileChooser jFileChooser = new JFileChooser(GSSManager.lastStyleDir != null ? GSSManager.lastStyleDir : Editor.rdfDir);
            String string = (String)this.ldStyleFromFileCb.getSelectedItem();
            if (string.equals(_rx)) {
                jFileChooser.setDialogTitle("Load GSS Stylesheet (RDF/XML)");
                int n = jFileChooser.showOpenDialog(this);
                if (n == 0) {
                    Editor.gssMngr.loadStylesheet(jFileChooser.getSelectedFile(), RDFLoader.RDF_XML_READER);
                    this.ldStyleFromFileCb.setSelectedIndex(0);
                }
            } else if (string.equals(_n3)) {
                jFileChooser.setDialogTitle("Load GSS Stylesheet (Notation 3)");
                int n = jFileChooser.showOpenDialog(this);
                if (n == 0) {
                    Editor.gssMngr.loadStylesheet(jFileChooser.getSelectedFile(), RDFLoader.N3_READER);
                    this.ldStyleFromFileCb.setSelectedIndex(0);
                }
            } else if (string.equals(_nt)) {
                jFileChooser.setDialogTitle("Load GSS Stylesheet (N-Triples)");
                int n = jFileChooser.showOpenDialog(this);
                if (n == 0) {
                    Editor.gssMngr.loadStylesheet(jFileChooser.getSelectedFile(), RDFLoader.NTRIPLE_READER);
                    this.ldStyleFromFileCb.setSelectedIndex(0);
                }
            }
        } else if (object == this.ldStyleFromURLCb) {
            String string = (String)this.ldStyleFromURLCb.getSelectedItem();
            if (string.equals(_rx)) {
                new URLPanel(this.application, "Specify Graph Stylesheet URL (RDF/XML):", RDFLoader.RDF_XML_READER, false, true);
                this.ldStyleFromURLCb.setSelectedIndex(0);
            } else if (string.equals(_n3)) {
                new URLPanel(this.application, "Specify Graph Stylesheet URL (Notation 3):", RDFLoader.N3_READER, false, true);
                this.ldStyleFromURLCb.setSelectedIndex(0);
            } else if (string.equals(_nt)) {
                new URLPanel(this.application, "Specify Graph Stylesheet URL (N-Triples):", RDFLoader.NTRIPLE_READER, false, true);
                this.ldStyleFromURLCb.setSelectedIndex(0);
            }
        } else if (object == this.removeStyleBt) {
            Editor.gssMngr.removeSelectedStylesheet();
        } else if (object == this.editStyleBt) {
            int n = this.gssTable.getSelectedRow();
            if (n > -1) {
                Editor.gssMngr.editSelectedStylesheet(this.gssTable.getValueAt(n, 0));
            }
        } else if (object == this.applyStyleBt) {
            Editor.gssMngr.applyStylesheets();
        } else if (object == this.promoteSelStyleBt) {
            this.promoteSelectedStyle();
        } else if (object == this.demoteSelStyleBt) {
            this.demoteSelectedStyle();
        } else if (object == this.shIsolRsCb) {
            this.setShowIsolatedNodes(this.shIsolRsCb.isSelected());
        } else if (object == this.debugGssCb) {
            GraphStylesheet.DEBUG_GSS = this.debugGssCb.isSelected();
        } else if (object == this.loadQIBt) {
            this.loadRDFFromInputArea();
        } else if (object == this.mergeQIBt) {
            this.mergeRDFFromInputArea();
        } else if (object == this.clearQIBt) {
            this.clearRDFInputArea();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            int n;
            Object object = keyEvent.getSource();
            if (object == this.addNSBt || object == this.nsPrefTf || object == this.nsURITf) {
                this.checkAndAddNS(this.nsPrefTf.getText(), this.nsURITf.getText());
            } else if (object == this.addPRBt || object == this.nsPrpTf || object == this.lnPrpTf) {
                this.checkAndAddProperty(this.nsPrpTf.getText(), this.lnPrpTf.getText());
            } else if (object == this.remNSBt) {
                int n2 = this.nsTable.getSelectedRow();
                if (n2 != -1) {
                    this.application.removeNamespaceBinding(n2);
                }
            } else if (object == this.remPRBt && (n = this.prTable.getSelectedRow()) != -1) {
                this.application.removePropertyConstructor(n);
            }
        }
    }

    public Component getSwingRepresentation(INode iNode) {
        if (iNode instanceof IResource) {
            String string;
            final IResource iResource = (IResource)iNode;
            if (iResource.isAnon()) {
                string = "(AR) ";
                if (ConfigManager.SHOW_ANON_ID) {
                    string = string + iResource.getIdentity();
                }
            } else {
                string = "(R) " + iResource.getIdentity();
            }
            final JLabel jLabel = new JLabel(string);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 0x10) == 16) {
                        TablePanel.this.updatePropertyBrowser(iResource, true);
                    } else if ((n & 4) == 4) {
                        Editor.vsm.centerOnGlyph(iResource.getGlyph(), Editor.vsm.getActiveCamera(), 500);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setForeground(ConfigManager.darkerPastelBlue);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.black);
                }
            };
            jLabel.addMouseListener(mouseAdapter);
            return jLabel;
        }
        if (iNode instanceof ILiteral) {
            final ILiteral iLiteral = (ILiteral)iNode;
            final JLabel jLabel = new JLabel("(L) " + iLiteral.getValue());
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 4) == 4) {
                        Editor.vsm.centerOnGlyph(iLiteral.getGlyph(), Editor.vsm.getActiveCamera(), 500);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setForeground(ConfigManager.darkerPastelBlue);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.black);
                }
            };
            jLabel.addMouseListener(mouseAdapter);
            return jLabel;
        }
        return new JLabel("Unknown kind of object - unable to display " + iNode.toString());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getSource() == this.bckBt && (n & 0x10) == 16 && this.brwIndex > 0) {
            this.browserList[this.brwIndex] = null;
            --this.brwIndex;
            this.updatePropertyBrowser(this.browserList[this.brwIndex], false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setForeground(ConfigManager.darkerPastelBlue);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setForeground(Color.black);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.tabbedPane.getSelectedIndex() == 2) {
            this.updatePropertyBrowser(Editor.lastSelectedItem, true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void resetNamespaceTable() {
        int n = this.nsTableModel.getRowCount() - 1;
        while (n >= 0) {
            this.nsTableModel.removeRow(n);
            --n;
        }
    }

    void resetPropertyTable() {
        int n = ((DefaultTableModel)this.prTable.getModel()).getRowCount() - 1;
        while (n >= 0) {
            ((DefaultTableModel)this.prTable.getModel()).removeRow(n);
            --n;
        }
    }

    void resetBrowser() {
        Utils.resetArray(this.browserList);
        this.updatePropertyBrowser(null, false);
    }

    void resetStylesheets() {
        int n = this.gssTableModel.getRowCount() - 1;
        while (n >= 0) {
            this.gssTableModel.removeRow(n);
            --n;
        }
    }

    void checkAndAddNS(String string, String string2) {
        if (string2.length() > 0) {
            boolean bl;
            String string3 = "";
            if (string.length() > 0) {
                String string4 = string3 = string.endsWith(":") ? string.substring(0, string.length() - 1) : string;
            }
            if (bl = this.application.addNamespaceBinding(string3, string2, new Boolean(false), false, false)) {
                this.nsPrefTf.setText("");
                this.nsURITf.setText("");
                this.nsPrefTf.requestFocus();
            }
        }
    }

    void checkAndAddProperty(String string, String string2) {
        if (this.application.addPropertyType(string, string2, false)) {
            this.nsPrpTf.setText("");
            this.lnPrpTf.setText("");
            this.nsPrpTf.requestFocus();
        }
    }

    void addStylesheet(Object object) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(object);
        this.gssTableModel.addRow(vector);
    }

    Object removeSelectedStylesheet() {
        Object object = null;
        int n = this.gssTable.getSelectedRow();
        if (n != -1) {
            object = this.gssTable.getValueAt(n, 0);
            this.gssTableModel.removeRow(n);
            if (this.gssTable.getRowCount() > n) {
                this.gssTable.setRowSelectionInterval(n, n);
            } else if (this.gssTable.getRowCount() > 0) {
                int n2 = this.gssTable.getRowCount() - 1;
                this.gssTable.setRowSelectionInterval(n2, n2);
            }
        }
        return object;
    }

    Vector getStylesheetList() {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.gssTableModel.getRowCount()) {
            vector.addElement(this.gssTableModel.getValueAt(n, 0));
            ++n;
        }
        return vector;
    }

    void promoteSelectedStyle() {
        int n = this.gssTable.getSelectedRow();
        if (n != -1 && n < this.gssTableModel.getRowCount() - 1) {
            this.gssTableModel.moveRow(n, n, n + 1);
            this.gssTable.setRowSelectionInterval(n + 1, n + 1);
        }
    }

    void demoteSelectedStyle() {
        int n = this.gssTable.getSelectedRow();
        if (n > 0) {
            this.gssTableModel.moveRow(n, n, n - 1);
            this.gssTable.setRowSelectionInterval(n - 1, n - 1);
        }
    }

    void setShowIsolatedNodes(boolean bl) {
        SHOW_ISOLATED_NODES = bl;
    }

    void loadRDFFromInputArea() {
        String string = this.rdfInputArea.getText();
        if (string != null && string.length() > 0) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                String string2 = (String)this.qiFormatList.getSelectedItem();
                if (string2.equals(RDFLoader.formatRDFXML)) {
                    this.application.loadRDF(byteArrayInputStream, RDFLoader.RDF_XML_READER);
                } else if (string2.equals(RDFLoader.formatNTRIPLES)) {
                    this.application.loadRDF(byteArrayInputStream, RDFLoader.NTRIPLE_READER);
                } else if (string2.equals(RDFLoader.formatN3)) {
                    this.application.loadRDF(byteArrayInputStream, RDFLoader.N3_READER);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("TablePanel.loadRDFFromInputArea:Error " + unsupportedEncodingException);
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    void mergeRDFFromInputArea() {
        String string = this.rdfInputArea.getText();
        if (string != null && string.length() > 0) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
                String string2 = (String)this.qiFormatList.getSelectedItem();
                if (string2.equals(RDFLoader.formatRDFXML)) {
                    this.application.mergeRDF(byteArrayInputStream, RDFLoader.RDF_XML_READER);
                } else if (string2.equals(RDFLoader.formatNTRIPLES)) {
                    this.application.mergeRDF(byteArrayInputStream, RDFLoader.NTRIPLE_READER);
                } else if (string2.equals(RDFLoader.formatN3)) {
                    this.application.mergeRDF(byteArrayInputStream, RDFLoader.N3_READER);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("TablePanel.loadRDFFromInputArea:Error " + unsupportedEncodingException);
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    void clearRDFInputArea() {
        this.rdfInputArea.setText(null);
    }

    void updateSwingFont() {
        this.resourceLb.setFont(Editor.swingFont);
        this.rdfInputArea.setFont(Editor.swingFont);
    }

    void setSTPBValue(int n) {
        this.stpb.setPBValue(n);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

