/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Color;
import java.net.URL;
import org.w3c.IsaViz.CustomPolygon;
import org.w3c.IsaViz.CustomShape;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.StyleInfo;

class StyleInfoR
extends StyleInfo {
    Integer shape;
    float[] vertices;
    Float orientation;
    URL icon;
    Integer text_align;
    Object ordering;

    StyleInfoR() {
    }

    void applyStyle(Style style) {
        if (style != null) {
            if (this.fill == null && style.getFill() != null) {
                this.fill = style.getFill();
            }
            if (this.stroke == null && style.getStroke() != null) {
                this.stroke = style.getStroke();
            }
            if (this.strokeWidth == null && style.getStrokeWidth() != null) {
                this.strokeWidth = style.getStrokeWidth();
            }
            if (this.fontFamily == null && style.getFontFamily() != null) {
                this.fontFamily = style.getFontFamily();
            }
            if (this.fontSize == null && style.getFontSize() != null) {
                this.fontSize = style.getFontSize();
            }
            if (this.fontWeight == null && style.getFontWeight() != null) {
                this.fontWeight = style.getFontWeight();
            }
            if (this.fontStyle == null && style.getFontStyle() != null) {
                this.fontStyle = style.getFontStyle();
            }
            if (this.shape == null && style.getShape() != null) {
                this.shape = style.getShape();
                if (this.shape.equals(Style.CUSTOM_SHAPE)) {
                    this.vertices = style.getVertexList();
                    this.orientation = style.getShapeOrient();
                } else if (this.shape.equals(Style.CUSTOM_POLYGON)) {
                    this.vertices = style.getVertexList();
                }
            }
            if (this.icon == null && style.getIcon() != null) {
                this.icon = style.getIcon();
            }
            if (this.text_align == null && style.getTextAlignment() != null) {
                this.text_align = style.getTextAlignment();
            }
            if (this.strokeDashArray == null && style.getStrokeDashArray() != null) {
                this.strokeDashArray = style.getStrokeDashArray();
            }
        }
    }

    void applyLayout(Integer n) {
        if (this.layout == null && n != null && (n.equals(GraphStylesheet.TABLE_FORM) || n.equals(GraphStylesheet.NODE_EDGE))) {
            this.layout = n;
        }
    }

    void applyVisibility(Integer n) {
        if (this.visibility == null && n != null && (n.equals(GraphStylesheet.DISPLAY_NONE) || n.equals(GraphStylesheet.VISIBILITY_HIDDEN) || n.equals(GraphStylesheet.VISIBILITY_VISIBLE))) {
            this.visibility = n;
        }
    }

    void setPropertyOrdering(Object object) {
        if (this.ordering == null) {
            this.ordering = object;
        }
    }

    boolean isFullySpecified() {
        return this.fontFamily != null && this.fontSize != null && this.fontWeight != null && this.fontStyle != null && (this.shape != null || this.icon != null) && this.visibility != null && this.layout != null && this.strokeWidth != null && this.stroke != null && this.fill != null && this.text_align != null && this.ordering != null && this.strokeDashArray != null;
    }

    boolean isDisplayNone() {
        return this.visibility != null && this.visibility.equals(GraphStylesheet.DISPLAY_NONE);
    }

    boolean isVisibilityHiddenAndShapeSpecified() {
        return this.visibility != null && this.visibility.equals(GraphStylesheet.VISIBILITY_HIDDEN) && (this.shape != null || this.icon != null);
    }

    Color getFillColor() {
        if (this.fill == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_FILL;
        }
        return this.fill;
    }

    Color getStrokeColor() {
        if (this.stroke == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_STROKE;
        }
        return this.stroke;
    }

    Float getStrokeWidth() {
        if (this.strokeWidth == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_STROKE_WIDTH;
        }
        return this.strokeWidth;
    }

    String getFontFamily() {
        if (this.fontFamily == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_FONT_FAMILY;
        }
        return this.fontFamily;
    }

    Integer getFontSize() {
        if (this.fontSize == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_FONT_SIZE;
        }
        return this.fontSize;
    }

    Short getFontWeight() {
        if (this.fontWeight == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_FONT_WEIGHT;
        }
        return this.fontWeight;
    }

    Short getFontStyle() {
        if (this.fontStyle == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_FONT_STYLE;
        }
        return this.fontStyle;
    }

    Integer getVisibility() {
        if (this.visibility == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_VISIBILITY;
        }
        return this.visibility;
    }

    Integer getLayout() {
        if (this.layout == null) {
            return GraphStylesheet.DEFAULT_RESOURCE_LAYOUT;
        }
        return this.layout;
    }

    Object getShape() {
        if (this.shape == null) {
            return null;
        }
        if (this.shape.equals(Style.CUSTOM_SHAPE)) {
            return new CustomShape(this.vertices, this.orientation);
        }
        if (this.shape.equals(Style.CUSTOM_POLYGON)) {
            return new CustomPolygon(this.vertices);
        }
        return this.shape;
    }

    URL getIcon() {
        return this.icon;
    }

    Integer getTextAlignment() {
        if (this.text_align == null) {
            return GraphStylesheet.DEFAULT_LITERAL_TEXT_ALIGN;
        }
        return this.text_align;
    }

    Object getPropertyOrdering() {
        return this.ordering;
    }
}

