/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VPolygon;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangle;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.CustomPolygon;
import org.w3c.IsaViz.CustomShape;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GSSManager;
import org.w3c.IsaViz.GeometryManager;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ISVJenaStatement;
import org.w3c.IsaViz.ProgPanel;
import org.w3c.IsaViz.SerializeErrorHandler;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.StyleInfoL;
import org.w3c.IsaViz.StyleInfoP;
import org.w3c.IsaViz.StyleInfoR;
import org.w3c.IsaViz.TablePanel;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

class RDFLoader
implements RDFErrorHandler {
    private static final String DOT_TITLE = "dotfile";
    static int RDF_XML_READER = 0;
    static int NTRIPLE_READER = 1;
    static int N3_READER = 2;
    static String RDFXML = "RDF/XML";
    static String RDFXMLAB = "RDF/XML-ABBREV";
    static String NTRIPLE = "N-TRIPLE";
    static String N3 = "N3";
    static Vector formatList;
    static String formatRDFXML;
    static String formatNTRIPLES;
    static String formatN3;
    static String errorModePropertyName;
    static String errorModePropertyValue;
    Editor application;
    RDFReader parser;
    File rdfF;
    URL rdfU;
    File dotF;
    File svgF;
    boolean dltOnExit;
    private static String RESOURCE_MAPID_PREFIX;
    private static String LITERAL_MAPID_PREFIX;
    private static String PROPERTY_MAPID_PREFIX;
    private static String TF_PROPERTY_MAPID_PREFIX;
    private static String STRUCT_MAPID_PREFIX;
    private static String STRUCT_PREFIX;
    StringBuffer nextNodeID;
    StringBuffer nextEdgeID;
    StringBuffer nextStructID;
    StringBuffer nextTFEdgeID;
    Integer literalLbNum;
    Hashtable tfMapID2pvPairs;
    private static String hackReplacementText;

    RDFLoader(Editor editor) {
        this.application = editor;
        this.nextNodeID = new StringBuffer("0");
        this.nextEdgeID = new StringBuffer("0");
        this.nextTFEdgeID = new StringBuffer("0");
        this.nextStructID = new StringBuffer("0");
    }

    void reset() {
        this.rdfF = null;
        this.rdfU = null;
        this.dotF = null;
        this.svgF = null;
        this.nextNodeID = new StringBuffer("0");
        this.nextEdgeID = new StringBuffer("0");
        this.nextTFEdgeID = new StringBuffer("0");
        this.nextStructID = new StringBuffer("0");
    }

    void initParser(int n, Model model) {
        try {
            errorModePropertyValue = ConfigManager.PARSING_MODE == ConfigManager.STRICT_PARSING ? "strict" : (ConfigManager.PARSING_MODE == ConfigManager.LAX_PARSING ? "lax" : "default");
            if (n == RDF_XML_READER) {
                this.parser = model.getReader(RDFXMLAB);
                this.parser.setErrorHandler((RDFErrorHandler)this);
                this.parser.setProperty(errorModePropertyName, (Object)errorModePropertyValue);
            } else if (n == NTRIPLE_READER) {
                this.parser = model.getReader(NTRIPLE);
                this.parser.setErrorHandler((RDFErrorHandler)this);
            } else if (n == N3_READER) {
                this.parser = model.getReader(N3);
                this.parser.setErrorHandler((RDFErrorHandler)this);
                this.parser.setProperty(errorModePropertyName, (Object)errorModePropertyValue);
            }
        }
        catch (RDFException rDFException) {
            System.err.println("Error: RDFLoader.initParser(): ");
            rDFException.printStackTrace();
        }
    }

    void load(Object object, int n) {
        ProgPanel progPanel = new ProgPanel("Resetting...", "Loading RDF");
        PrintWriter printWriter = null;
        try {
            Object object2;
            progPanel.setPBValue(5);
            this.application.rdfModel = new ModelMem();
            if (object instanceof File) {
                this.rdfF = (File)object;
                object2 = new FileInputStream(this.rdfF);
                progPanel.setLabel("Loading local file " + this.rdfF.toString() + " ...");
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n, this.application.rdfModel);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                Editor.BASE_URI = this.rdfF.toURL().toString();
                this.parser.read(this.application.rdfModel, (InputStream)object2, Editor.BASE_URI);
            } else if (object instanceof URL) {
                this.rdfU = (URL)object;
                progPanel.setLabel("Loading remote file " + this.rdfU.toString() + " ...");
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n, this.application.rdfModel);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                Editor.BASE_URI = this.rdfU.toString();
                this.parser.read(this.application.rdfModel, this.rdfU.toString());
            } else if (object instanceof InputStream) {
                progPanel.setLabel("Reading stream ...");
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n, this.application.rdfModel);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                this.parser.read(this.application.rdfModel, (InputStream)object, Editor.BASE_URI);
            }
            this.application.declareNSBindings(this.application.rdfModel.getNsPrefixMap(), this.application.rdfModel.listNameSpaces());
            object2 = new SH(printWriter, this.application);
            StmtIterator stmtIterator = this.application.rdfModel.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (statement.getObject() instanceof Resource) {
                    ((SH)object2).statement(statement.getSubject(), statement.getPredicate(), (Resource)statement.getObject());
                    continue;
                }
                if (statement.getObject() instanceof Literal) {
                    ((SH)object2).statement(statement.getSubject(), statement.getPredicate(), (Literal)statement.getObject());
                    continue;
                }
                System.err.println("Error: RDFLoader.load(): unknown kind of object: " + statement.getObject());
            }
            stmtIterator.close();
            progPanel.setPBValue(50);
            progPanel.setLabel("Creating temporary SVG file ...");
            this.svgF = Utils.createTempFile(Editor.m_TmpDir.toString(), "isv", ".svg");
            progPanel.setPBValue(60);
            progPanel.setLabel("Calling GraphViz (this can take several minutes) ...");
            this.callDOT(printWriter);
            progPanel.setPBValue(80);
            progPanel.setLabel("Parsing SVG ...");
            this.displaySVG(this.application.xmlMngr.parse(this.svgF, false));
            this.cleanMapIDs();
            this.application.cfgMngr.assignColorsToGraph();
            this.application.showAnonIds(ConfigManager.SHOW_ANON_ID);
            this.application.showResourceLabels(Editor.DISP_AS_LABEL);
            progPanel.setPBValue(100);
            progPanel.setLabel("Deleting temporary files ...");
            if (Editor.dltOnExit) {
                this.deleteFiles();
            }
            Editor.vsm.getGlobalView(Editor.vsm.getVirtualSpace("rdfSpace").getCamera(0), ConfigManager.ANIM_DURATION);
            this.application.centerRadarView();
            this.application.rdfModel = null;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("RDFLoader.load() " + iOException + "\n");
            this.application.reportError = true;
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDFLoader.load() " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("RDFLoader.load() " + exception + "\nPlease verify your directory preferences (GraphViz/DOT might not be configured properly), your default namespace and anonymous node prefix declarations");
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        progPanel.destroy();
    }

    Model merge(Object object, int n) {
        ModelMem modelMem = new ModelMem();
        if (object instanceof File) {
            try {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                this.initParser(n, this.application.rdfModel);
                this.parser.read((Model)modelMem, (InputStream)fileInputStream, ((File)object).toURL().toString());
            }
            catch (IOException iOException) {
                this.application.errorMessages.append("RDFLoader.merge() (File) " + iOException + "\n");
                this.application.reportError = true;
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("RDFLoader.merge() (File) " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        } else if (object instanceof URL) {
            URL uRL = (URL)object;
            try {
                this.initParser(n, this.application.rdfModel);
                this.parser.read((Model)modelMem, uRL.toString());
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("RDFLoader.merge() (URL) " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        } else if (object instanceof InputStream) {
            try {
                this.initParser(n, this.application.rdfModel);
                this.parser.read((Model)modelMem, (InputStream)object, Editor.BASE_URI);
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("RDFLoader.merge() (InputStream) " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        }
        return modelMem;
    }

    void loadProperties(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ModelMem modelMem = new ModelMem();
            this.initParser(RDF_XML_READER, (Model)modelMem);
            this.parser.read((Model)modelMem, (InputStream)fileInputStream, file.toURL().toString());
            this.application.declareNSBindings(modelMem.getNsPrefixMap(), modelMem.listNameSpaces());
            StmtIterator stmtIterator = modelMem.listStatements();
            while (stmtIterator.hasNext()) {
                Property property = stmtIterator.nextStatement().getPredicate();
                this.application.addPropertyType(property.getNameSpace(), property.getLocalName(), true);
            }
            modelMem = null;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("RDFLoader.loadProperties() " + iOException + "\n");
            this.application.reportError = true;
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDFLoader.loadProperties() " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("RDFLoader.loadProperties() " + exception + "\n");
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    void deleteFiles() {
        if (this.dotF != null) {
            this.dotF.delete();
        }
        if (this.svgF != null) {
            this.svgF.delete();
        }
    }

    PrintWriter createDOTFile() {
        this.dotF = this.initGraphFile();
        PrintWriter printWriter = null;
        if (this.dotF == null) {
            return null;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.dotF), ConfigManager.ENCODING);
            if (outputStreamWriter != null) {
                printWriter = new PrintWriter(outputStreamWriter);
            }
            if (printWriter != null) {
                this.processDOTParameters(printWriter);
            }
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("RDFLoader.createDOTFile() " + iOException + "\n");
            this.application.reportError = true;
        }
        return printWriter;
    }

    File initGraphFile() {
        try {
            if (Editor.m_TmpDir == null || Editor.m_GraphVizPath == null) {
                this.application.errorMessages.append("Temporary DOT file initialization failed\n");
                this.application.errorMessages.append("TMP_DIR = " + Editor.m_TmpDir + "\n");
                this.application.errorMessages.append("GRAPH_VIZ_PATH = " + Editor.m_GraphVizPath + "\n");
                this.application.reportError = true;
                return null;
            }
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Unable to create a temporary graph file. A graph cannot be generated.\n");
            this.application.reportError = true;
            return null;
        }
        File file = null;
        file = Utils.createTempFile(Editor.m_TmpDir.toString(), "isv", ".dot");
        if (file == null) {
            this.application.errorMessages.append("Failed to create a temporary graph file. A graph cannot be generated.\n");
            this.application.reportError = true;
            return null;
        }
        return file;
    }

    void processDOTParameters(PrintWriter printWriter) {
        printWriter.println("digraph dotfile {");
        String string = "black";
        String string2 = "black";
        String string3 = "white";
        String string4 = "black";
        String string5 = "black";
        String string6 = Editor.GRAPH_ORIENTATION;
        printWriter.println("node [fontname=\"" + Editor.vtmFontName + "\",fontsize=" + Editor.vtmFontSize + ",color=" + string + ",fillcolor=" + string3 + ",fontcolor=" + string2 + "];");
        printWriter.println("edge [fontname=\"" + Editor.vtmFontName + "\",fontsize=" + Editor.vtmFontSize + ",color=" + string4 + ",fontcolor=" + string5 + "];");
        printWriter.println("rankdir=" + string6 + ";");
    }

    private void callDOT(PrintWriter printWriter) {
        try {
            printWriter.println("}");
            printWriter.close();
            if (!this.generateSVGFile(this.dotF.getAbsolutePath(), this.svgF.getAbsolutePath())) {
                this.application.errorMessages.append("An attempt to create a graph failed.\n");
                this.deleteFiles();
                return;
            }
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Exception generating graph: " + exception.getMessage() + "\n");
            this.application.reportError = true;
        }
    }

    private boolean generateSVGFile(String string, String string2) {
        String[] stringArray = new String[]{Editor.m_GraphVizPath.toString(), "-Tsvg", "-o", string2, string};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(stringArray);
            process.waitFor();
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Error: generating OutputFile.\n");
            this.application.reportError = true;
            return false;
        }
        return true;
    }

    void displaySVG(Document document) {
        Object object;
        Element element = document.getDocumentElement();
        if (element.hasAttribute("width") && element.hasAttribute("height")) {
            object = element.getAttribute("width");
            String string = element.getAttribute("height");
            try {
                long l = -new Long(((String)object).substring(0, ((String)object).length() - 2)).longValue() / 2L;
                long l2 = -new Long(string.substring(0, string.length() - 2)).longValue() / 2L;
                SVGReader.setPositionOffset((long)l, (long)l2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        object = element.getElementsByTagName("g").item(0).getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeType() == 1) {
                this.processSVGNode((Element)node, false, null);
            }
            ++n;
        }
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            this.application.geomMngr.correctResourceTextAndShape((IResource)enumeration.nextElement());
        }
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            this.application.geomMngr.correctLiteralTextAndShape((ILiteral)enumeration2.nextElement());
        }
        SVGReader.setPositionOffset((long)0L, (long)0L);
    }

    void processSVGNode(Element element, boolean bl, ProgPanel progPanel) {
        if (element.getAttribute("class").equals("node")) {
            NodeList nodeList = element.getElementsByTagName("a");
            if (nodeList.getLength() > 0) {
                Element element2 = (Element)nodeList.item(0);
                String string = element2.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                if (string.startsWith(RESOURCE_MAPID_PREFIX)) {
                    IResource iResource = this.getResourceByMapID(string);
                    Glyph glyph = this.getResourceShape(iResource, element2, bl, progPanel);
                    glyph.setFill(true);
                    Editor.vsm.addGlyph(glyph, "rdfSpace");
                    iResource.setGlyph(glyph);
                    Element element3 = (Element)element2.getElementsByTagName("text").item(0);
                    VText vText = element3 != null ? SVGReader.createText((Element)element3, (VirtualSpaceManager)Editor.vsm) : new VText("");
                    if (vText.getText().equals(hackReplacementText)) {
                        vText.setText(iResource.getGraphLabel());
                        vText.setTextAnchor(VText.TEXT_ANCHOR_START);
                    } else {
                        vText.setTextAnchor(VText.TEXT_ANCHOR_START);
                    }
                    Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                    iResource.setGlyphText(vText);
                } else if (string.startsWith(LITERAL_MAPID_PREFIX)) {
                    ILiteral iLiteral = this.getLiteralByMapID(string);
                    if (iLiteral != null) {
                        Glyph glyph = this.getLiteralShape(iLiteral, element2, bl, progPanel);
                        glyph.setFill(true);
                        if (glyph != null) {
                            Editor.vsm.addGlyph(glyph, "rdfSpace");
                            iLiteral.setGlyph(glyph);
                        }
                        Element element4 = (Element)element2.getElementsByTagName("text").item(0);
                        VText vText = null;
                        if (element4 != null) {
                            vText = SVGReader.createText((Element)element4, (VirtualSpaceManager)Editor.vsm);
                            vText.setTextAnchor(VText.TEXT_ANCHOR_START);
                            Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                        }
                        if (vText != null) {
                            iLiteral.setGlyphText(vText);
                        }
                    }
                } else if (string.startsWith(STRUCT_MAPID_PREFIX)) {
                    this.generateTableForm(element2, string);
                } else {
                    System.err.println("Error: processSVGNode: unable to identify node mapID " + string);
                }
            } else {
                System.err.println("Error: processSVGNode: unknown tag in " + element + " (expected <a href=\"...\">)");
            }
        } else if (element.getAttribute("class").equals("edge")) {
            Element element5 = (Element)element.getElementsByTagName("a").item(0);
            String string = ((Element)element5.getElementsByTagName("path").item(0)).getAttribute("d");
            Element element6 = (Element)element5.getElementsByTagName("polygon").item(0);
            Vector vector = new Vector();
            SVGReader.translateSVGPolygon((String)element6.getAttribute("points"), vector);
            LongPoint longPoint = (LongPoint)vector.firstElement();
            long l = longPoint.x;
            long l2 = longPoint.x;
            long l3 = longPoint.y;
            long l4 = longPoint.y;
            int n = 1;
            while (n < vector.size()) {
                longPoint = (LongPoint)vector.elementAt(n);
                if (longPoint.x < l) {
                    l = longPoint.x;
                }
                if (longPoint.x > l2) {
                    l2 = longPoint.x;
                }
                if (longPoint.y < l3) {
                    l3 = longPoint.y;
                }
                if (longPoint.y > l4) {
                    l4 = longPoint.y;
                }
                ++n;
            }
            VPath vPath = SVGReader.createPath((String)string, (VPath)new VPath());
            vPath = GeometryManager.invertPath((l + l2) / 2L, (l3 + l4) / 2L, vPath);
            Editor.vsm.addGlyph((Glyph)vPath, "rdfSpace");
            String string2 = element5.getAttributeNS("http://www.w3.org/1999/xlink", "href");
            if (string2.startsWith(PROPERTY_MAPID_PREFIX)) {
                PathIterator pathIterator = vPath.getJava2DPathIterator();
                float[] fArray = new float[6];
                while (!pathIterator.isDone()) {
                    pathIterator.currentSegment(fArray);
                    pathIterator.next();
                }
                double d = 0.0;
                Point2D point2D = GeometryManager.computeStepValue(fArray[2], -fArray[3], fArray[4], -fArray[5]);
                if (point2D.getX() == 0.0) {
                    d = 0.0;
                    if (point2D.getY() < 0.0) {
                        d = Math.PI;
                    }
                } else {
                    d = Math.atan(point2D.getY() / point2D.getX());
                    d = point2D.getX() < 0.0 ? (d += 1.5707963267948966) : (d -= 1.5707963267948966);
                }
                VTriangleOr vTriangleOr = new VTriangleOr((l2 + l) / 2L, -(l4 + l3) / 2L, 0.0f, Math.max(l2 - l, l4 - l3) / 2L, Color.black, (float)d);
                Editor.vsm.addGlyph((Glyph)vTriangleOr, "rdfSpace");
                VText vText = SVGReader.createText((Element)((Element)element5.getElementsByTagName("text").item(0)), (VirtualSpaceManager)Editor.vsm);
                vText.setTextAnchor(VText.TEXT_ANCHOR_START);
                Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                Vector vector2 = this.application.getProperties(((Element)element5.getElementsByTagName("text").item(0)).getFirstChild().getNodeValue());
                IProperty iProperty = this.getPropertyByMapID(vector2, string2);
                if (iProperty != null) {
                    iProperty.setGlyph(vPath, vTriangleOr);
                    iProperty.setGlyphText(vText);
                }
            } else if (string2.startsWith(TF_PROPERTY_MAPID_PREFIX)) {
                Vector vector3 = this.getPropertiesByMapID(string2);
                int n2 = 0;
                while (n2 < vector3.size()) {
                    IProperty iProperty = (IProperty)vector3.elementAt(n2);
                    iProperty.setGlyph(vPath, null);
                    ++n2;
                }
            } else {
                System.err.println("Error: processSVGNode: unable to identify edge mapID " + string2);
            }
        }
    }

    void generateTableForm(Element element, String string) {
        Vector vector = (Vector)this.tfMapID2pvPairs.get(string);
        if (vector != null) {
            VRectangleOr vRectangleOr = null;
            NodeList nodeList = element.getElementsByTagName("polygon");
            if (nodeList.getLength() > 0) {
                vRectangleOr = SVGReader.createRectangleFromPolygon((Element)((Element)nodeList.item(0)));
            } else {
                nodeList = element.getElementsByTagName("rect");
                if (nodeList.getLength() > 0) {
                    vRectangleOr = SVGReader.createRectangleFromPolygon((Element)((Element)nodeList.item(0)));
                }
            }
            if (vRectangleOr != null) {
                IResource iResource;
                ILiteral iLiteral;
                Rectangle2D rectangle2D;
                long l = vRectangleOr.vx - vRectangleOr.getWidth();
                long l2 = vRectangleOr.vy + vRectangleOr.getHeight();
                long l3 = vRectangleOr.vx + vRectangleOr.getWidth();
                long l4 = vRectangleOr.vy - vRectangleOr.getHeight();
                long l5 = (l2 - l4) / (long)vector.size() / 2L;
                double d = 0.0;
                double d2 = 0.0;
                IProperty iProperty = null;
                Object object = null;
                Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
                graphics.setFont(VirtualSpaceManager.getMainFont());
                int n = 0;
                while (n < vector.size()) {
                    iProperty = (IProperty)((Vector)vector.elementAt(n)).elementAt(1);
                    rectangle2D = graphics.getFontMetrics().getStringBounds(iProperty.getIdent(), graphics);
                    if (rectangle2D.getWidth() > d) {
                        d = rectangle2D.getWidth();
                    }
                    if ((object = (Object)((Vector)vector.elementAt(n)).elementAt(2)) instanceof ILiteral) {
                        iLiteral = (ILiteral)object;
                        if (iLiteral.getText().length() > 0 && (rectangle2D = graphics.getFontMetrics().getStringBounds(iLiteral.getText(), graphics)).getWidth() > d2) {
                            d2 = rectangle2D.getWidth();
                        }
                    } else if (object instanceof IResource && (iResource = (IResource)object).getGraphLabel().length() > 0 && (rectangle2D = graphics.getFontMetrics().getStringBounds(iResource.getGraphLabel(), graphics)).getWidth() > d2) {
                        d2 = rectangle2D.getWidth();
                    }
                    ++n;
                }
                double d3 = d / (d + d2);
                double d4 = d2 / (d + d2);
                if (d4 < 0.2) {
                    d4 = 0.2;
                    d3 = 0.8;
                } else if (d3 < 0.2) {
                    d3 = 0.2;
                    d4 = 0.8;
                }
                long l6 = Math.round((double)(l3 - l) * d3 / 2.0);
                long l7 = Math.round((double)(l3 - l) * d4 / 2.0);
                Vector vector2 = null;
                StyleInfoR styleInfoR = Editor.gssMngr.getStyle((IResource)((Vector)vector.firstElement()).firstElement());
                vector2 = styleInfoR != null && styleInfoR.getPropertyOrdering() != null ? Utils.sortProperties(vector, styleInfoR.getPropertyOrdering()) : vector;
                VText vText = null;
                int n2 = 0;
                while (n2 < vector2.size()) {
                    String string2;
                    iProperty = (IProperty)((Vector)vector2.elementAt(n2)).elementAt(1);
                    VRectangle vRectangle = new VRectangle(l + l6, l2 - (long)(2 * n2 + 1) * l5, 0.0f, l6, l5, Color.white);
                    vRectangle.setFill(true);
                    Editor.vsm.addGlyph((Glyph)vRectangle, "rdfSpace");
                    iProperty.setTableCellGlyph(vRectangle);
                    vText = new VText(l + l6, l2 - (long)(2 * n2 + 1) * l5, 0.0f, Color.black, iProperty.getIdent(), VText.TEXT_ANCHOR_START);
                    Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                    iProperty.setGlyphText(vText);
                    iProperty.setTableFormLayout(true);
                    object = ((Vector)vector2.elementAt(n2)).elementAt(2);
                    vRectangle = new VRectangle(l + 2L * l6 + l7 - 1L, l2 - (long)(2 * n2 + 1) * l5, 0.0f, l7, l5, Color.white);
                    vRectangle.setFill(true);
                    Editor.vsm.addGlyph((Glyph)vRectangle, "rdfSpace");
                    if (object instanceof ILiteral) {
                        iLiteral = (ILiteral)object;
                        string2 = iLiteral.getText();
                        vText = new VText(l + 2L * l6 + l7 - 1L, l2 - (long)(2 * n2 + 1) * l5, 0.0f, Color.black, string2, VText.TEXT_ANCHOR_START);
                        Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                        iLiteral.setGlyph((Glyph)vRectangle);
                        iLiteral.setGlyphText(vText);
                        iLiteral.setTableFormLayout(true);
                    } else if (object instanceof IResource) {
                        iResource = (IResource)object;
                        string2 = iResource.getGraphLabel();
                        vText = new VText(l + 2L * l6 + l7 - 1L, l2 - (long)(2 * n2 + 1) * l5, 0.0f, Color.black, string2, VText.TEXT_ANCHOR_START);
                        Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                        iResource.setGlyph((Glyph)vRectangle);
                        iResource.setGlyphText(vText);
                        iResource.setTableFormLayout(true);
                    } else {
                        System.err.println("Error: processSVGNode/generateTableForm: bad object for " + string + " : " + object.toString());
                    }
                    ++n2;
                }
                try {
                    if (vector2.size() == 1) {
                        graphics.setFont(vText.getFont());
                        rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
                        iProperty.getTableCellGlyph().setHeight(Math.round(rectangle2D.getHeight()));
                        ((RectangularShape)((INode)object).getGlyph()).setHeight(Math.round(rectangle2D.getHeight()));
                    }
                }
                catch (Exception exception) {}
            } else {
                System.err.println("Error: processSVGNode/generateTableForm: failed to identify a table shape for " + string);
            }
        } else {
            System.err.println("Error: processSVGNode/generateTableForm: unable to identify table mapID " + string);
        }
    }

    void cleanMapIDs() {
        Enumeration<Object> enumeration;
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            ((ILiteral)enumeration2.nextElement()).setMapID(null);
        }
        Enumeration enumeration3 = this.application.propertiesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            Vector vector = (Vector)enumeration3.nextElement();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((IProperty)enumeration.nextElement()).setMapID(null);
            }
        }
        enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            ((IResource)enumeration.nextElement()).setMapID(null);
        }
        if (this.tfMapID2pvPairs != null) {
            this.tfMapID2pvPairs.clear();
            this.tfMapID2pvPairs = null;
        }
    }

    IResource getResourceByMapID(String string) {
        IResource iResource = null;
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            IResource iResource2 = (IResource)enumeration.nextElement();
            if (iResource2.getMapID() == null || !iResource2.getMapID().equals(string)) continue;
            iResource = iResource2;
            break;
        }
        return iResource;
    }

    ILiteral getLiteralByMapID(String string) {
        ILiteral iLiteral = null;
        int n = 0;
        while (n < this.application.literals.size()) {
            ILiteral iLiteral2 = (ILiteral)this.application.literals.elementAt(n);
            if (iLiteral2.getMapID() != null && iLiteral2.getMapID().equals(string)) {
                iLiteral = iLiteral2;
                break;
            }
            ++n;
        }
        return iLiteral;
    }

    IProperty getPropertyByMapID(Vector vector, String string) {
        IProperty iProperty = null;
        int n = 0;
        while (n < vector.size()) {
            IProperty iProperty2 = (IProperty)vector.elementAt(n);
            if (iProperty2.getMapID() != null && iProperty2.getMapID().equals(string)) {
                iProperty = iProperty2;
                break;
            }
            ++n;
        }
        return iProperty;
    }

    Vector getPropertiesByMapID(String string) {
        Vector<IProperty> vector = new Vector<IProperty>();
        Enumeration enumeration = this.application.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration.nextElement();
            int n = 0;
            while (n < vector2.size()) {
                IProperty iProperty = (IProperty)vector2.elementAt(n);
                if (iProperty.getMapID() != null && iProperty.getMapID().equals(string)) {
                    vector.add(iProperty);
                }
                ++n;
            }
        }
        return vector;
    }

    void incID(StringBuffer stringBuffer) {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < stringBuffer.length()) {
            by = (byte)stringBuffer.charAt(n);
            if (by < 122) {
                stringBuffer.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < stringBuffer.length()) {
                stringBuffer.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            stringBuffer.append('0');
        }
    }

    void incNodeID() {
        this.incID(this.nextNodeID);
    }

    void incEdgeID() {
        this.incID(this.nextEdgeID);
    }

    void incTFEdgeID() {
        this.incID(this.nextTFEdgeID);
    }

    void incStructID() {
        this.incID(this.nextStructID);
    }

    Vector processStatement(Resource resource, Property property, Resource resource2) {
        IResource iResource = this.addResource(resource);
        IProperty iProperty = this.addProperty(property);
        IResource iResource2 = this.addResource(resource2);
        iResource.addOutgoingPredicate(iProperty);
        iProperty.setSubject(iResource);
        iProperty.setObject(iResource2);
        iResource2.addIncomingPredicate(iProperty);
        Vector<INode> vector = new Vector<INode>();
        vector.add(iResource);
        vector.add(iProperty);
        vector.add(iResource2);
        return vector;
    }

    Vector processStyledStatement(Resource resource, Property property, Resource resource2) {
        IResource iResource = this.addResource(resource);
        IProperty iProperty = this.addProperty(property);
        IResource iResource2 = this.addResource(resource2);
        iResource.addOutgoingPredicate(iProperty);
        iProperty.setSubject(iResource);
        iProperty.setObject(iResource2);
        iResource2.addIncomingPredicate(iProperty);
        Vector<INode> vector = new Vector<INode>();
        vector.add(iResource);
        vector.add(iProperty);
        vector.add(iResource2);
        vector.add((INode)resource);
        vector.add((INode)property);
        vector.add((INode)resource2);
        return vector;
    }

    Vector processStatement(Resource resource, Property property, Literal literal) {
        IResource iResource = this.addResource(resource);
        IProperty iProperty = this.addProperty(property);
        ILiteral iLiteral = this.addLiteral(literal);
        iResource.addOutgoingPredicate(iProperty);
        iProperty.setSubject(iResource);
        iProperty.setObject(iLiteral);
        iLiteral.setIncomingPredicate(iProperty);
        Vector<INode> vector = new Vector<INode>();
        vector.add(iResource);
        vector.add(iProperty);
        vector.add(iLiteral);
        if (iProperty.getIdent().equals(Editor.RDFS_NAMESPACE_URI + "label")) {
            iResource.setLabel(iLiteral.getValue());
        }
        return vector;
    }

    Vector processStyledStatement(Resource resource, Property property, Literal literal) {
        IResource iResource = this.addResource(resource);
        IProperty iProperty = this.addProperty(property);
        ILiteral iLiteral = this.addLiteral(literal);
        iResource.addOutgoingPredicate(iProperty);
        iProperty.setSubject(iResource);
        iProperty.setObject(iLiteral);
        iLiteral.setIncomingPredicate(iProperty);
        Vector<INode> vector = new Vector<INode>();
        vector.add(iResource);
        vector.add(iProperty);
        vector.add(iLiteral);
        vector.add((INode)resource);
        vector.add((INode)property);
        vector.add((INode)literal);
        if (iProperty.getIdent().equals(Editor.RDFS_NAMESPACE_URI + "label")) {
            iResource.setLabel(iLiteral.getValue());
        }
        return vector;
    }

    IResource addResource(Resource resource) {
        IResource iResource = new IResource(resource);
        if (!this.application.resourcesByURI.containsKey(iResource.getIdentity())) {
            this.application.resourcesByURI.put(iResource.getIdentity(), iResource);
            return iResource;
        }
        return (IResource)this.application.resourcesByURI.get(iResource.getIdentity());
    }

    IProperty addProperty(Property property) {
        IProperty iProperty = new IProperty(property);
        if (this.application.propertiesByURI.containsKey(iProperty.getIdent())) {
            Vector vector = (Vector)this.application.propertiesByURI.get(iProperty.getIdent());
            vector.add(iProperty);
        } else {
            Vector<IProperty> vector = new Vector<IProperty>();
            vector.add(iProperty);
            this.application.propertiesByURI.put(iProperty.getIdent(), vector);
        }
        this.application.addPropertyType(iProperty.getNamespace(), iProperty.getLocalname(), true);
        return iProperty;
    }

    ILiteral addLiteral(Literal literal) {
        ILiteral iLiteral = new ILiteral(literal);
        this.application.literals.add(iLiteral);
        return iLiteral;
    }

    void generateJenaModel() {
        this.application.rdfModel = new ModelMem();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = this.application.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                INode iNode;
                IProperty iProperty = (IProperty)enumeration2.nextElement();
                IResource iResource = iProperty.getSubject();
                INode iNode2 = iProperty.getObject();
                if (iResource == null || iNode2 == null || iProperty.isCommented()) continue;
                Resource resource = null;
                if (hashtable.containsKey(iResource)) {
                    resource = (Resource)hashtable.get(iResource);
                } else if (iResource.isAnon()) {
                    try {
                        resource = this.application.rdfModel.createResource();
                        hashtable.put(iResource, resource);
                    }
                    catch (RDFException rDFException) {
                        JOptionPane.showMessageDialog(Editor.cmp, "An error occured while creating anonymous resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                    }
                } else {
                    try {
                        resource = this.application.rdfModel.createResource(iResource.getIdentity());
                        hashtable.put(iResource, resource);
                    }
                    catch (RDFException rDFException) {
                        JOptionPane.showMessageDialog(Editor.cmp, "An error occured while creating resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                    }
                }
                Property property = null;
                try {
                    if (hashtable2.containsKey(iProperty.getIdent())) {
                        property = (Property)hashtable2.get(iProperty.getIdent());
                    } else {
                        property = this.application.rdfModel.createProperty(iProperty.getNamespace(), iProperty.getLocalname());
                        hashtable.put(iProperty.getIdent(), property);
                    }
                }
                catch (RDFException rDFException) {
                    JOptionPane.showMessageDialog(Editor.cmp, "An error occured while creating property\n" + iProperty.toString() + "\n" + (Object)((Object)rDFException));
                }
                Resource resource2 = null;
                if (iNode2 instanceof IResource) {
                    iNode = (IResource)iNode2;
                    if (hashtable.containsKey(iNode)) {
                        resource2 = (Resource)hashtable.get(iNode);
                    } else if (((IResource)iNode).isAnon()) {
                        try {
                            resource2 = this.application.rdfModel.createResource();
                            hashtable.put(iNode, resource2);
                        }
                        catch (RDFException rDFException) {
                            JOptionPane.showMessageDialog(Editor.cmp, "An error occured while creating anonymous resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                        }
                    } else {
                        try {
                            resource2 = this.application.rdfModel.createResource(((IResource)iNode).getIdentity());
                            hashtable.put(iNode, resource2);
                        }
                        catch (RDFException rDFException) {
                            JOptionPane.showMessageDialog(Editor.cmp, "An error occured while creating resource\n" + iResource.toString() + "\n" + (Object)((Object)rDFException));
                        }
                    }
                } else {
                    iNode = (ILiteral)iNode2;
                    try {
                        String string;
                        if (((ILiteral)iNode).getDatatype() != null) {
                            if (((ILiteral)iNode).getLang() != null) {
                                try {
                                    resource2 = this.application.rdfModel.createTypedLiteral(((ILiteral)iNode).getValue(), ((ILiteral)iNode).getLang(), ((ILiteral)iNode).getDatatype());
                                }
                                catch (DatatypeFormatException datatypeFormatException) {
                                    this.application.errorMessages.append("A datatype format error occured while creating the following typed literal:\n");
                                    this.application.errorMessages.append("Lexical form: " + ((ILiteral)iNode).getValue() + "\n");
                                    this.application.errorMessages.append("Datatype: " + ((ILiteral)iNode).getDatatype() + "\n");
                                    this.application.errorMessages.append(datatypeFormatException.getMessage() + "\n");
                                    this.application.reportError = true;
                                }
                            } else {
                                string = Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS ? Editor.DEFAULT_LANGUAGE_IN_LITERALS : "";
                                resource2 = this.application.rdfModel.createTypedLiteral(((ILiteral)iNode).getValue(), string, ((ILiteral)iNode).getDatatype());
                            }
                        } else if (((ILiteral)iNode).getLang() != null) {
                            resource2 = this.application.rdfModel.createLiteral(((ILiteral)iNode).getValue(), ((ILiteral)iNode).getLang());
                        } else {
                            string = Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS ? Editor.DEFAULT_LANGUAGE_IN_LITERALS : "";
                            resource2 = this.application.rdfModel.createLiteral(((ILiteral)iNode).getValue(), string);
                        }
                    }
                    catch (RDFException rDFException) {
                        JOptionPane.showMessageDialog(Editor.cmp, "An error occured while creating literal\n" + iNode2.toString() + "\n" + (Object)((Object)rDFException));
                        this.application.errorMessages.append(rDFException.getMessage() + "\n");
                        this.application.reportError = true;
                    }
                }
                try {
                    iNode = this.application.rdfModel.createStatement(resource, property, (RDFNode)resource2);
                    this.application.rdfModel.add((Statement)iNode);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Editor.cmp, "An error occured while creating the Jena model:\nadding statement " + iProperty.toString() + "(" + iResource.toString() + "," + iNode2.toString() + ")\n" + exception);
                    this.application.errorMessages.append(exception.getMessage() + "\n");
                    this.application.reportError = true;
                }
            }
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Model model, File file) {
        Editor.vsm.getView("Graph").setStatusBarText("Exporting to RDF/XML " + file.toString() + " ...");
        try {
            RDFWriter rDFWriter;
            if (Editor.ABBREV_SYNTAX) {
                rDFWriter = model.getWriter(RDFXMLAB);
                rDFWriter.setProperty("allowBadURIs", (Object)"true");
                rDFWriter.setProperty("showXmlDeclaration", (Object)"true");
                if (Editor.BASE_URI.length() > 0 && !Utils.isWhiteSpaceCharsOnly(Editor.BASE_URI)) {
                    rDFWriter.setProperty("xmlbase", (Object)Editor.BASE_URI);
                }
            } else {
                rDFWriter = model.getWriter(RDFXML);
                rDFWriter.setProperty("allowBadURIs", (Object)"true");
                rDFWriter.setProperty("showXmlDeclaration", (Object)"true");
                if (Editor.BASE_URI.length() > 0 && !Utils.isWhiteSpaceCharsOnly(Editor.BASE_URI)) {
                    rDFWriter.setProperty("xmlbase", (Object)Editor.BASE_URI);
                }
            }
            rDFWriter.setErrorHandler((RDFErrorHandler)new SerializeErrorHandler(this.application));
            int n = 0;
            while (true) {
                if (n >= Editor.tblp.nsTableModel.getRowCount()) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    rDFWriter.write(model, (OutputStream)fileOutputStream, Editor.BASE_URI);
                    Editor.vsm.getView("Graph").setStatusBarText("Exporting to RDF/XML " + file.toString() + " ...done");
                    break;
                }
                if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                    model.setNsPrefix((String)Editor.tblp.nsTableModel.getValueAt(n, 0), (String)Editor.tblp.nsTableModel.getValueAt(n, 1));
                }
                ++n;
            }
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDF exception in RDFLoader.save() " + (Object)((Object)rDFException) + "\nSee command line for details.\n");
            rDFException.printStackTrace();
            this.application.reportError = true;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("I/O exception in RDFLoader.save() " + iOException + "\nSee command line for details.\n");
            iOException.printStackTrace();
            this.application.reportError = true;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Exception in RDFLoader.save() " + exception + "\nSee command line for details.\n");
            exception.printStackTrace();
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuffer serialize(Model model) {
        try {
            RDFWriter rDFWriter;
            if (Editor.ABBREV_SYNTAX) {
                rDFWriter = model.getWriter(RDFXMLAB);
                rDFWriter.setProperty("allowBadURIs", (Object)"true");
                rDFWriter.setProperty("showXmlDeclaration", (Object)"true");
                if (Editor.BASE_URI.length() > 0 && !Utils.isWhiteSpaceCharsOnly(Editor.BASE_URI)) {
                    rDFWriter.setProperty("xmlbase", (Object)Editor.BASE_URI);
                }
            } else {
                rDFWriter = model.getWriter(RDFXML);
                rDFWriter.setProperty("allowBadURIs", (Object)"true");
                rDFWriter.setProperty("showXmlDeclaration", (Object)"true");
                if (Editor.BASE_URI.length() > 0 && !Utils.isWhiteSpaceCharsOnly(Editor.BASE_URI)) {
                    rDFWriter.setProperty("xmlbase", (Object)Editor.BASE_URI);
                }
            }
            rDFWriter.setErrorHandler((RDFErrorHandler)new SerializeErrorHandler(this.application));
            int n = 0;
            while (true) {
                if (n >= Editor.tblp.nsTableModel.getRowCount()) {
                    StringWriter stringWriter = new StringWriter();
                    rDFWriter.write(model, (Writer)stringWriter, Editor.BASE_URI);
                    return stringWriter.getBuffer();
                }
                if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                    model.setNsPrefix((String)Editor.tblp.nsTableModel.getValueAt(n, 0), (String)Editor.tblp.nsTableModel.getValueAt(n, 1));
                }
                ++n;
            }
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDF exception in RDFLoader.save() " + (Object)((Object)rDFException) + "\nSee command line for details.\n");
            rDFException.printStackTrace();
            this.application.reportError = true;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Exception in RDFLoader.save() " + exception + "\nSee command line for details.\n");
            exception.printStackTrace();
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        return new StringBuffer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Model model, OutputStream outputStream) {
        Editor.vsm.getView("Graph").setStatusBarText("Writing RDF/XML to stream ...");
        try {
            RDFWriter rDFWriter;
            if (Editor.ABBREV_SYNTAX) {
                rDFWriter = model.getWriter(RDFXMLAB);
                rDFWriter.setProperty("allowBadURIs", (Object)"true");
                rDFWriter.setProperty("showXmlDeclaration", (Object)"true");
                if (Editor.BASE_URI.length() > 0 && !Utils.isWhiteSpaceCharsOnly(Editor.BASE_URI)) {
                    rDFWriter.setProperty("xmlbase", (Object)Editor.BASE_URI);
                }
            } else {
                rDFWriter = model.getWriter(RDFXML);
                rDFWriter.setProperty("allowBadURIs", (Object)"true");
                rDFWriter.setProperty("showXmlDeclaration", (Object)"true");
                if (Editor.BASE_URI.length() > 0 && !Utils.isWhiteSpaceCharsOnly(Editor.BASE_URI)) {
                    rDFWriter.setProperty("xmlbase", (Object)Editor.BASE_URI);
                }
            }
            rDFWriter.setErrorHandler((RDFErrorHandler)new SerializeErrorHandler(this.application));
            int n = 0;
            while (true) {
                if (n >= Editor.tblp.nsTableModel.getRowCount()) {
                    rDFWriter.write(model, outputStream, Editor.BASE_URI);
                    Editor.vsm.getView("Graph").setStatusBarText("Writing RDF/XML to stream ...done");
                    break;
                }
                if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                    model.setNsPrefix((String)Editor.tblp.nsTableModel.getValueAt(n, 0), (String)Editor.tblp.nsTableModel.getValueAt(n, 1));
                }
                ++n;
            }
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDF exception in RDFLoader.save() " + (Object)((Object)rDFException) + "\nSee command line for details.\n");
            rDFException.printStackTrace();
            this.application.reportError = true;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("Exception in RDFLoader.save() " + exception + "\nSee command line for details.\n");
            exception.printStackTrace();
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    public void saveAsN3(Model model, File file) {
        Editor.vsm.getView("Graph").setStatusBarText("Exporting to Notation 3 " + file.toString() + " ...");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            RDFWriter rDFWriter = model.getWriter(N3);
            rDFWriter.setErrorHandler((RDFErrorHandler)new SerializeErrorHandler(this.application));
            rDFWriter.write(model, (OutputStream)fileOutputStream, Editor.BASE_URI);
            Editor.vsm.getView("Graph").setStatusBarText("Exporting to Notation 3 " + file.toString() + " ...done");
        }
        catch (Exception exception) {
            this.application.errorMessages.append("RDF exception in RDFLoader.saveAsN3() " + exception + "\n");
            this.application.reportError = true;
            exception.printStackTrace();
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    public void saveAsTriples(Model model, File file) {
        Editor.vsm.getView("Graph").setStatusBarText("Exporting to N-Triples " + file.toString() + " ...");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            RDFWriter rDFWriter = model.getWriter(NTRIPLE);
            rDFWriter.setErrorHandler((RDFErrorHandler)new SerializeErrorHandler(this.application));
            rDFWriter.write(model, (OutputStream)fileOutputStream, Editor.BASE_URI);
            Editor.vsm.getView("Graph").setStatusBarText("Exporting to N-Triples " + file.toString() + " ...done");
        }
        catch (Exception exception) {
            this.application.errorMessages.append("RDF exception in RDFLoader.saveAsTriples() " + exception + "\n");
            this.application.reportError = true;
            exception.printStackTrace();
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
    }

    void loadAndStyle(Object object, int n) {
        ProgPanel progPanel = new ProgPanel("Resetting...", " ", "Loading RDF and applying stylesheets");
        PrintWriter printWriter = null;
        try {
            Object object2;
            progPanel.setPBValue(5);
            this.application.rdfModel = new ModelMem();
            if (object instanceof File) {
                this.rdfF = (File)object;
                object2 = new FileInputStream(this.rdfF);
                progPanel.setLabel("Loading local file " + this.rdfF.toString() + " ...");
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n, this.application.rdfModel);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                Editor.BASE_URI = this.rdfF.toURL().toString();
                this.parser.read(this.application.rdfModel, (InputStream)object2, Editor.BASE_URI);
            } else if (object instanceof URL) {
                this.rdfU = (URL)object;
                progPanel.setLabel("Loading remote file " + this.rdfU.toString() + " ...");
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n, this.application.rdfModel);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                Editor.BASE_URI = this.rdfU.toString();
                this.parser.read(this.application.rdfModel, this.rdfU.toString());
            } else if (object instanceof InputStream) {
                progPanel.setLabel("Reading stream ...");
                printWriter = this.createDOTFile();
                progPanel.setPBValue(10);
                progPanel.setLabel("Initializing ARP(Jena) ...");
                this.initParser(n, this.application.rdfModel);
                progPanel.setPBValue(20);
                progPanel.setLabel("Parsing RDF ...");
                this.parser.read(this.application.rdfModel, (InputStream)object, Editor.BASE_URI);
            }
            this.application.declareNSBindings(this.application.rdfModel.getNsPrefixMap(), this.application.rdfModel.listNameSpaces());
            progPanel.setPBValue(40);
            progPanel.setLabel("Building styling rules ...");
            Editor.gssMngr.initStyleTables();
            object2 = new StyledSH(this.application, this.application.rdfModel);
            StmtIterator stmtIterator = this.application.rdfModel.listStatements();
            Vector vector = new Vector();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (statement.getObject() instanceof Resource) {
                    ((StyledSH)object2).statement(statement.getSubject(), statement.getPredicate(), (Resource)statement.getObject(), vector);
                    continue;
                }
                if (statement.getObject() instanceof Literal) {
                    ((StyledSH)object2).statement(statement.getSubject(), statement.getPredicate(), (Literal)statement.getObject(), vector);
                    continue;
                }
                System.err.println("Error: RDFLoader.load(): unknown kind of object: " + statement.getObject());
            }
            stmtIterator.close();
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n2);
                if (vector2.elementAt(2) instanceof IResource) {
                    ((StyledSH)object2).statementDotResource((IResource)vector2.elementAt(0), (Resource)vector2.elementAt(3), (IProperty)vector2.elementAt(1), (Property)vector2.elementAt(4), (IResource)vector2.elementAt(2), (Resource)vector2.elementAt(5));
                    vector2.removeAllElements();
                } else {
                    ((StyledSH)object2).statementDotLiteral((IResource)vector2.elementAt(0), (Resource)vector2.elementAt(3), (IProperty)vector2.elementAt(1), (Property)vector2.elementAt(4), (ILiteral)vector2.elementAt(2), (Literal)vector2.elementAt(5));
                    vector2.removeAllElements();
                }
                ++n2;
            }
            vector.removeAllElements();
            vector = null;
            progPanel.setPBValue(50);
            progPanel.setLabel("Creating temporary SVG file ...");
            this.literalLbNum = new Integer(0);
            this.generateStyledDOTFile(((StyledSH)object2).getVisibleStatements(), ((StyledSH)object2).getVisibleResources(), printWriter);
            ((StyledSH)object2).clean();
            this.svgF = Utils.createTempFile(Editor.m_TmpDir.toString(), "isv", ".svg");
            progPanel.setPBValue(60);
            progPanel.setLabel("Calling GraphViz (this can take several minutes) ...");
            this.callDOT(printWriter);
            progPanel.setPBValue(80);
            progPanel.setLabel("Parsing SVG ...");
            this.displaySVGAndStyle(this.application.xmlMngr.parse(this.svgF, false), progPanel);
            this.cleanMapIDs();
            progPanel.setPBValue(90);
            progPanel.setLabel("Applying styling rules ...");
            this.assignStyleToGraph();
            Editor.gssMngr.cleanStyleTables();
            this.application.showAnonIds(ConfigManager.SHOW_ANON_ID);
            this.application.showResourceLabels(Editor.DISP_AS_LABEL);
            progPanel.setPBValue(100);
            progPanel.setLabel("Deleting temporary files and data structures...");
            if (Editor.dltOnExit) {
                this.deleteFiles();
            }
            Editor.vsm.getGlobalView(Editor.vsm.getVirtualSpace("rdfSpace").getCamera(0), ConfigManager.ANIM_DURATION);
            this.application.centerRadarView();
            this.application.rdfModel = null;
        }
        catch (IOException iOException) {
            this.application.errorMessages.append("RDFLoader.loadAndStyle() " + iOException + "\n");
            this.application.reportError = true;
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("RDFLoader.loadAndStyle() " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        progPanel.destroy();
    }

    void generateStyledDOTFile(Hashtable hashtable, Hashtable hashtable2, PrintWriter printWriter) {
        boolean bl = false;
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector[] vectorArray = (Vector[])hashtable.get(string);
            int n = 0;
            while (n < vectorArray[0].size()) {
                ISVJenaStatement iSVJenaStatement = (ISVJenaStatement)vectorArray[0].elementAt(n);
                if (iSVJenaStatement.objectIsResource()) {
                    this.printDOTStatementNERO(iSVJenaStatement, printWriter);
                } else {
                    this.printDOTStatementNELO(iSVJenaStatement, printWriter);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vectorArray[1].size()) {
                vector.add(vectorArray[1].elementAt(n2));
                ++n2;
            }
        }
        this.printDOTStatementsTF(vector, printWriter);
        Enumeration enumeration2 = hashtable2.elements();
        while (enumeration2.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration2.nextElement();
            this.printDOTResource((IResource)vector2.elementAt(0), (Resource)vector2.elementAt(1), vector2.elementAt(2), printWriter);
        }
    }

    void printDOTStatementNERO(ISVJenaStatement iSVJenaStatement, PrintWriter printWriter) {
        if (printWriter == null) {
            return;
        }
        try {
            String string;
            String string2;
            boolean bl = true;
            if (iSVJenaStatement.isubject.getMapID() == null) {
                string2 = RESOURCE_MAPID_PREFIX + this.nextNodeID.toString();
                iSVJenaStatement.isubject.setMapID(string2);
                this.incNodeID();
                bl = false;
            }
            if (iSVJenaStatement.jsubject.isAnon()) {
                if (!bl) {
                    string2 = GraphStylesheet.gss2dotShape(iSVJenaStatement.getSubjectShapeType());
                    if (string2.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()) + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string2 + "\",fixedsize=true,URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()) + "\" [shape=\"" + string2 + "\",URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    }
                }
                printWriter.print("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()));
            } else {
                string2 = iSVJenaStatement.isubject.getGraphLabel();
                if (!bl) {
                    string = GraphStylesheet.gss2dotShape(iSVJenaStatement.getSubjectShapeType());
                    if (string.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + string2 + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string + "\",fixedsize=true,URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + string2 + "\" [shape=\"" + string + "\",URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    }
                }
                printWriter.print("\"" + string2);
            }
            printWriter.print("\" -> ");
            string2 = PROPERTY_MAPID_PREFIX + this.nextEdgeID.toString();
            iSVJenaStatement.ipredicate.setMapID(string2);
            this.incEdgeID();
            bl = true;
            if (iSVJenaStatement.iobjectr.getMapID() == null) {
                string = RESOURCE_MAPID_PREFIX + this.nextNodeID.toString();
                iSVJenaStatement.iobjectr.setMapID(string);
                this.incNodeID();
                bl = false;
            }
            if (iSVJenaStatement.jobjectr.isAnon()) {
                printWriter.println("\"" + iSVJenaStatement.iobjectr.getGraphLabel() + "\" [label=\"" + iSVJenaStatement.jpredicate.getURI() + "\\l\",URL=\"" + string2 + "\"];");
                if (!bl) {
                    string = GraphStylesheet.gss2dotShape(iSVJenaStatement.getObjectShapeType());
                    if (string.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + iSVJenaStatement.iobjectr.getGraphLabel() + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string + "\",fixedsize=true,URL=\"" + iSVJenaStatement.iobjectr.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + iSVJenaStatement.iobjectr.getGraphLabel() + "\" [shape=\"" + string + "\",URL=\"" + iSVJenaStatement.iobjectr.getMapID() + "\",style=filled];");
                    }
                }
            } else {
                printWriter.println("\"" + iSVJenaStatement.iobjectr.getGraphLabel() + "\" [label=\"" + iSVJenaStatement.jpredicate.getURI() + "\\l\",URL=\"" + string2 + "\"];");
                if (!bl) {
                    string = GraphStylesheet.gss2dotShape(iSVJenaStatement.getObjectShapeType());
                    if (string.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + iSVJenaStatement.iobjectr.getGraphLabel() + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string + "\",fixedsize=true,URL=\"" + iSVJenaStatement.iobjectr.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + iSVJenaStatement.iobjectr.getGraphLabel() + "\" [shape=\"" + string + "\",URL=\"" + iSVJenaStatement.iobjectr.getMapID() + "\",style=filled];");
                    }
                }
            }
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("Error: printDOTStatementNERO(): " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
    }

    void printDOTStatementNELO(ISVJenaStatement iSVJenaStatement, PrintWriter printWriter) {
        if (printWriter == null) {
            return;
        }
        try {
            String string;
            String string2;
            boolean bl = true;
            if (iSVJenaStatement.isubject.getMapID() == null) {
                string2 = RESOURCE_MAPID_PREFIX + this.nextNodeID.toString();
                iSVJenaStatement.isubject.setMapID(string2);
                this.incNodeID();
                bl = false;
            }
            if (iSVJenaStatement.jsubject.isAnon()) {
                if (!bl) {
                    string2 = GraphStylesheet.gss2dotShape(iSVJenaStatement.getSubjectShapeType());
                    if (string2.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()) + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string2 + "\",fixedsize=true,URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()) + "\" [shape=\"" + string2 + "\",URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    }
                }
                printWriter.print("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()));
            } else {
                string2 = iSVJenaStatement.isubject.getGraphLabel();
                if (!bl) {
                    string = GraphStylesheet.gss2dotShape(iSVJenaStatement.getSubjectShapeType());
                    if (string.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + string2 + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string + "\",fixedsize=true,URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + string2 + "\" [shape=\"" + string + "\",URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    }
                }
                printWriter.print("\"" + string2);
            }
            string2 = PROPERTY_MAPID_PREFIX + this.nextEdgeID.toString();
            iSVJenaStatement.ipredicate.setMapID(string2);
            this.incEdgeID();
            string = new String(iSVJenaStatement.jobjectl.getString());
            string = string.replace('\n', ' ');
            string = string.replace('\f', ' ');
            string = string.replace('\r', ' ');
            if (string.indexOf(34) != -1) {
                string = Utils.replaceString(string, "\"", "\\\"");
            }
            String string3 = string.length() >= Editor.MAX_LIT_CHAR_COUNT ? string.substring(0, Editor.MAX_LIT_CHAR_COUNT) + " ..." : string;
            String string4 = LITERAL_MAPID_PREFIX + this.nextNodeID.toString();
            iSVJenaStatement.iobjectl.setMapID(string4);
            this.incNodeID();
            String string5 = "Literal_" + this.literalLbNum.toString();
            this.literalLbNum = new Integer(this.literalLbNum + 1);
            printWriter.print("\" -> \"" + string5);
            printWriter.println("\" [label=\"" + iSVJenaStatement.jpredicate.getURI() + "\\l\",URL=\"" + string2 + "\"];");
            String string6 = GraphStylesheet.gss2dotShape(iSVJenaStatement.getObjectShapeType());
            if (string6.equals(GraphStylesheet._dotCircle)) {
                printWriter.println("\"" + string5 + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string6 + "\",fixedsize=true,label=\"" + string3 + "\\l\",URL=\"" + string4 + "\",style=filled];");
            } else {
                printWriter.println("\"" + string5 + "\" [shape=\"" + string6 + "\",label=\"" + string3 + "\\l\",URL=\"" + string4 + "\",style=filled];");
            }
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("Error: printDOTStatementNELO(): " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
    }

    void printDOTStatementsTF(Vector vector, PrintWriter printWriter) {
        Vector vector2;
        ISVJenaStatement iSVJenaStatement;
        if (printWriter == null) {
            return;
        }
        Hashtable<IResource, Vector> hashtable = new Hashtable<IResource, Vector>();
        int n = 0;
        while (n < vector.size()) {
            iSVJenaStatement = (ISVJenaStatement)vector.elementAt(n);
            if (hashtable.containsKey(iSVJenaStatement.isubject)) {
                vector2 = (Vector)hashtable.get(iSVJenaStatement.isubject);
                vector2.add(iSVJenaStatement);
            } else {
                vector2 = new Vector();
                vector2.add(iSVJenaStatement);
                hashtable.put(iSVJenaStatement.isubject, vector2);
            }
            ++n;
        }
        this.tfMapID2pvPairs = new Hashtable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            vector2 = (Vector)enumeration.nextElement();
            if (vector2 == null) continue;
            iSVJenaStatement = (ISVJenaStatement)vector2.firstElement();
            boolean bl = true;
            if (iSVJenaStatement.isubject.getMapID() == null) {
                string2 = RESOURCE_MAPID_PREFIX + this.nextNodeID.toString();
                iSVJenaStatement.isubject.setMapID(string2);
                this.incNodeID();
                bl = false;
            }
            if (iSVJenaStatement.jsubject.isAnon()) {
                if (!bl) {
                    string2 = GraphStylesheet.gss2dotShape(iSVJenaStatement.getSubjectShapeType());
                    if (string2.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()) + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string2 + "\",fixedsize=true,URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()) + "\" [shape=\"" + string2 + "\",URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    }
                }
                printWriter.print("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(iSVJenaStatement.jsubject.getId()));
            } else {
                string2 = iSVJenaStatement.isubject.getGraphLabel();
                if (!bl) {
                    string = GraphStylesheet.gss2dotShape(iSVJenaStatement.getSubjectShapeType());
                    if (string.equals(GraphStylesheet._dotCircle)) {
                        printWriter.println("\"" + string2 + "\" [label=\"" + hackReplacementText + "\",shape=\"" + string + "\",fixedsize=true,URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    } else {
                        printWriter.println("\"" + string2 + "\" [shape=\"" + string + "\",URL=\"" + iSVJenaStatement.isubject.getMapID() + "\",style=filled];");
                    }
                }
                printWriter.print("\"" + string2);
            }
            string2 = STRUCT_PREFIX + this.nextStructID.toString();
            string = STRUCT_MAPID_PREFIX + this.nextStructID.toString();
            this.incStructID();
            String string3 = TF_PROPERTY_MAPID_PREFIX + this.nextTFEdgeID.toString();
            this.incTFEdgeID();
            printWriter.print("\" -> \"" + string2 + "\" [URL=\"" + string3 + "\"];\n" + string2 + " [shape=\"record\",URL=\"" + string + "\",label=\"");
            String string4 = "";
            String string5 = "";
            String string6 = "";
            Vector vector3 = new Vector();
            int n2 = 0;
            while (n2 < vector2.size()) {
                iSVJenaStatement = (ISVJenaStatement)vector2.elementAt(n2);
                iSVJenaStatement.ipredicate.setMapID(string3);
                Vector<INode> vector4 = new Vector<INode>();
                vector4.add(iSVJenaStatement.isubject);
                vector4.add(iSVJenaStatement.ipredicate);
                try {
                    String string7 = iSVJenaStatement.jpredicate.getURI();
                    if (string7.length() > string4.length()) {
                        string4 = string7;
                    }
                    if (iSVJenaStatement.iobjectr != null) {
                        if (!iSVJenaStatement.jobjectr.isAnon()) {
                            vector4.add(iSVJenaStatement.iobjectr);
                            string7 = iSVJenaStatement.iobjectr.getGraphLabel();
                            if (string7.length() > string6.length()) {
                                string6 = string7;
                            }
                        }
                    } else if (iSVJenaStatement.iobjectl != null) {
                        vector4.add(iSVJenaStatement.iobjectl);
                        string7 = iSVJenaStatement.jobjectl.getString();
                        if (string7.length() > string5.length()) {
                            string5 = string7;
                        }
                    }
                }
                catch (RDFException rDFException) {
                    this.application.errorMessages.append("Error: printDOTStatementsTF(): " + (Object)((Object)rDFException) + "\n");
                    this.application.reportError = true;
                }
                vector3.add(vector4);
                ++n2;
            }
            this.tfMapID2pvPairs.put(string, vector3);
            if (string6.length() > Editor.MAX_LIT_CHAR_COUNT || string6.length() > string5.length()) {
                string5 = string6;
            } else {
                string5 = Utils.replaceString(string5, "\n", "\\ ");
                string5 = Utils.replaceString(string5, "\f", "\\ ");
                string5 = Utils.replaceString(string5, "\r", "\\ ");
                string5 = Utils.replaceString(string5, "\t", "\\ ");
                if ((string5 = Utils.replaceString(string5, " ", "\\ ")).indexOf(34) != -1) {
                    string5 = Utils.replaceString(string5, "\"", "\\\"");
                }
                string5 = string5.length() >= Editor.MAX_LIT_CHAR_COUNT ? string5.substring(0, Editor.MAX_LIT_CHAR_COUNT) + "\\ ..." : string5;
            }
            int n3 = 0;
            while (n3 < vector2.size() - 1) {
                printWriter.print("{" + string4 + " | " + string5 + "} | ");
                ++n3;
            }
            printWriter.print("{" + string4 + " | " + string5 + "}");
            printWriter.print("\"];\n");
        }
    }

    void printDOTResource(IResource iResource, Resource resource, Object object, PrintWriter printWriter) {
        if (printWriter == null) {
            return;
        }
        try {
            String string;
            boolean bl = true;
            if (iResource.getMapID() == null) {
                string = RESOURCE_MAPID_PREFIX + this.nextNodeID.toString();
                iResource.setMapID(string);
                this.incNodeID();
                bl = false;
            }
            if (iResource.isAnon()) {
                if (!bl) {
                    printWriter.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(resource.getId()) + "\" [shape=\"" + GraphStylesheet.gss2dotShape(object) + "\",URL=\"" + iResource.getMapID() + "\",style=filled];");
                }
            } else {
                string = iResource.getGraphLabel();
                if (!bl) {
                    printWriter.println("\"" + string + "\" [shape=\"" + GraphStylesheet.gss2dotShape(object) + "\",URL=\"" + iResource.getMapID() + "\",style=filled];");
                }
            }
        }
        catch (RDFException rDFException) {
            this.application.errorMessages.append("Error: printDOTResource(): " + (Object)((Object)rDFException) + "\n");
            this.application.reportError = true;
        }
    }

    void displaySVGAndStyle(Document document, ProgPanel progPanel) {
        Object object;
        Element element = document.getDocumentElement();
        progPanel.setPBValue(82);
        progPanel.setSecLabel("Initalizing ZVTM Virtual Space...");
        if (element.hasAttribute("width") && element.hasAttribute("height")) {
            object = element.getAttribute("width");
            String string = element.getAttribute("height");
            try {
                long l = -new Long(((String)object).substring(0, ((String)object).length() - 2)).longValue() / 2L;
                long l2 = -new Long(string.substring(0, string.length() - 2)).longValue() / 2L;
                SVGReader.setPositionOffset((long)l, (long)l2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        progPanel.setPBValue(84);
        progPanel.setSecLabel("Building ZVTM Glyphs...");
        object = element.getElementsByTagName("g").item(0).getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeType() == 1) {
                this.processSVGNode((Element)node, true, progPanel);
            }
            ++n;
        }
        progPanel.setPBValue(88);
        progPanel.setSecLabel("Adjusting Geometry...");
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            this.application.geomMngr.correctResourceTextAndShape((IResource)enumeration.nextElement());
        }
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            this.application.geomMngr.correctLiteralTextAndShape((ILiteral)enumeration2.nextElement());
        }
        Enumeration enumeration3 = this.application.propertiesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            Vector vector = (Vector)enumeration3.nextElement();
            int n2 = 0;
            while (n2 < vector.size()) {
                this.application.geomMngr.correctPropertyTextAndShape((IProperty)vector.elementAt(n2));
                ++n2;
            }
        }
        SVGReader.setPositionOffset((long)0L, (long)0L);
        progPanel.setPBValue(89);
        progPanel.setSecLabel(" ");
    }

    void assignStyleToGraph() {
        int n;
        StyleInfoP styleInfoP;
        IProperty iProperty;
        int n2;
        Vector vector;
        StyleInfoL styleInfoL;
        ILiteral iLiteral;
        Font font;
        int n3;
        int n4;
        VText vText;
        Glyph glyph;
        Integer n5;
        short s;
        short s2;
        int n6;
        String string;
        float f;
        float[] fArray;
        Color color;
        Color color2;
        boolean bl;
        StyleInfoR styleInfoR;
        IResource iResource;
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            iResource = (IResource)enumeration.nextElement();
            if (!iResource.isVisuallyRepresented()) continue;
            styleInfoR = Editor.gssMngr.getStyle(iResource);
            bl = styleInfoR.getVisibility().equals(GraphStylesheet.VISIBILITY_HIDDEN);
            color2 = styleInfoR.getFillColor();
            color = styleInfoR.getStrokeColor();
            fArray = styleInfoR.getStrokeDashArray();
            f = styleInfoR.getStrokeWidth().floatValue();
            string = styleInfoR.getFontFamily();
            n6 = styleInfoR.getFontSize();
            s2 = styleInfoR.getFontWeight();
            s = styleInfoR.getFontStyle();
            n5 = styleInfoR.getTextAlignment();
            glyph = iResource.getGlyph();
            vText = iResource.getGlyphText();
            if (color2 != null) {
                n4 = ConfigManager.addColor(color2);
                iResource.setFillColor(n4);
            } else {
                n4 = ConfigManager.defaultRFIndex;
                iResource.setFillColor(n4);
            }
            if (color != null) {
                n3 = ConfigManager.addColor(color);
                iResource.setStrokeColor(n3);
            } else {
                n3 = ConfigManager.defaultRTBIndex;
                iResource.setStrokeColor(n3);
            }
            ConfigManager.assignStrokeToGlyph(glyph, f, fArray);
            font = ConfigManager.rememberFont(ConfigManager.fonts, string, n6, s2, s);
            if (font != null && vText != null) {
                vText.setSpecialFont(font);
            }
            if (n5.equals(Style.TA_CENTER) || vText == null) continue;
            this.application.geomMngr.alignText(glyph, vText, n5);
            iResource.setTextAlign(n5);
        }
        int n7 = 0;
        while (n7 < this.application.literals.size()) {
            iLiteral = (ILiteral)this.application.literals.elementAt(n7);
            if (iLiteral.isVisuallyRepresented()) {
                styleInfoL = Editor.gssMngr.getStyle(iLiteral);
                bl = styleInfoL.getVisibility().equals(GraphStylesheet.VISIBILITY_HIDDEN);
                color2 = styleInfoL.getFillColor();
                color = styleInfoL.getStrokeColor();
                fArray = styleInfoL.getStrokeDashArray();
                f = styleInfoL.getStrokeWidth().floatValue();
                string = styleInfoL.getFontFamily();
                n6 = styleInfoL.getFontSize();
                s2 = styleInfoL.getFontWeight();
                s = styleInfoL.getFontStyle();
                n5 = styleInfoL.getTextAlignment();
                glyph = iLiteral.getGlyph();
                vText = iLiteral.getGlyphText();
                if (color2 != null) {
                    n4 = ConfigManager.addColor(color2);
                    iLiteral.setFillColor(n4);
                } else {
                    n4 = ConfigManager.defaultLFIndex;
                    iLiteral.setFillColor(n4);
                }
                if (color != null) {
                    n3 = ConfigManager.addColor(color);
                    iLiteral.setStrokeColor(n3);
                } else {
                    n3 = ConfigManager.defaultLTBIndex;
                    iLiteral.setStrokeColor(n3);
                }
                ConfigManager.assignStrokeToGlyph(glyph, f, fArray);
                font = ConfigManager.rememberFont(ConfigManager.fonts, string, n6, s2, s);
                if (font != null && vText != null) {
                    vText.setSpecialFont(font);
                }
                if (!n5.equals(Style.TA_CENTER) && vText != null) {
                    this.application.geomMngr.alignText(glyph, vText, n5);
                    iLiteral.setTextAlign(n5);
                }
            }
            ++n7;
        }
        Enumeration enumeration2 = this.application.propertiesByURI.elements();
        while (enumeration2.hasMoreElements()) {
            vector = (Vector)enumeration2.nextElement();
            n2 = 0;
            while (n2 < vector.size()) {
                iProperty = (IProperty)vector.elementAt(n2);
                if (iProperty.isVisuallyRepresented()) {
                    styleInfoP = Editor.gssMngr.getStyle(iProperty);
                    bl = styleInfoP.getVisibility().equals(GraphStylesheet.VISIBILITY_HIDDEN);
                    color2 = styleInfoP.getFillColor();
                    color = styleInfoP.getStrokeColor();
                    fArray = styleInfoP.getStrokeDashArray();
                    f = styleInfoP.getStrokeWidth().floatValue();
                    string = styleInfoP.getFontFamily();
                    n6 = styleInfoP.getFontSize();
                    s2 = styleInfoP.getFontWeight();
                    s = styleInfoP.getFontStyle();
                    glyph = iProperty.getGlyph();
                    vText = iProperty.getGlyphText();
                    VTriangleOr vTriangleOr = iProperty.getGlyphHead();
                    if (iProperty.isLaidOutInTableForm()) {
                        if (color2 != null) {
                            n4 = ConfigManager.addColor(color2);
                            iProperty.setCellFillColor(n4);
                            if (color != null) {
                                n3 = ConfigManager.addColor(color);
                                iProperty.setStrokeColor(n3);
                                iProperty.setTextColor(n3);
                            } else {
                                iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                                if (iProperty.getObject() instanceof ILiteral) {
                                    iProperty.setTextColor(ConfigManager.defaultLTBIndex);
                                } else {
                                    iProperty.setTextColor(ConfigManager.defaultRTBIndex);
                                }
                            }
                        } else if (iProperty.getObject() instanceof ILiteral) {
                            n4 = ConfigManager.defaultLFIndex;
                            iProperty.setCellFillColor(n4);
                            if (color != null) {
                                n3 = ConfigManager.addColor(color);
                                iProperty.setStrokeColor(n3);
                                iProperty.setTextColor(n3);
                            } else {
                                iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                                iProperty.setTextColor(ConfigManager.defaultLTBIndex);
                            }
                        } else {
                            n4 = ConfigManager.defaultRFIndex;
                            iProperty.setCellFillColor(n4);
                            if (color != null) {
                                n3 = ConfigManager.addColor(color);
                                iProperty.setStrokeColor(n3);
                                iProperty.setTextColor(n3);
                            } else {
                                iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                                iProperty.setTextColor(ConfigManager.defaultRTBIndex);
                            }
                        }
                    } else if (color != null) {
                        n3 = ConfigManager.addColor(color);
                        iProperty.setStrokeColor(n3);
                        iProperty.setTextColor(n3);
                    } else {
                        iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                        iProperty.setTextColor(ConfigManager.defaultPTIndex);
                    }
                    ConfigManager.assignStrokeToGlyph(glyph, f, fArray);
                    if (vTriangleOr != null && glyph.getStrokeWidth() > 2.0f) {
                        vTriangleOr.reSize(glyph.getStrokeWidth() / 2.0f);
                    }
                    if ((font = ConfigManager.rememberFont(ConfigManager.fonts, string, n6, s2, s)) != null && vText != null) {
                        vText.setSpecialFont(font);
                    }
                }
                ++n2;
            }
        }
        n2 = 1;
        boolean bl2 = true;
        Enumeration enumeration3 = this.application.resourcesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            iResource = (IResource)enumeration3.nextElement();
            if (!iResource.isVisuallyRepresented()) continue;
            styleInfoR = Editor.gssMngr.getStyle(iResource);
            boolean bl3 = bl = styleInfoR.getVisibility().equals(GraphStylesheet.VISIBILITY_HIDDEN);
            if (bl) {
                iResource.setVisible(false);
                vector = iResource.getIncomingPredicates();
                if (vector != null) {
                    n = 0;
                    while (n < vector.size()) {
                        iProperty = (IProperty)vector.elementAt(n);
                        iProperty.setVisible(false);
                        ++n;
                    }
                }
                if ((vector = iResource.getOutgoingPredicates()) == null) continue;
                n = 0;
                while (n < vector.size()) {
                    iProperty = (IProperty)vector.elementAt(n);
                    iProperty.setVisible(false);
                    if (iProperty.getObject() instanceof ILiteral) {
                        iProperty.getObject().setVisible(false);
                    }
                    ++n;
                }
                continue;
            }
            if (TablePanel.SHOW_ISOLATED_NODES) continue;
            n2 = 1;
            bl2 = true;
            vector = iResource.getIncomingPredicates();
            if (vector != null) {
                n = 0;
                while (n < vector.size()) {
                    iProperty = (IProperty)vector.elementAt(n);
                    if (iProperty.isVisuallyRepresented()) {
                        if (Editor.gssMngr.getStyle(iProperty).getVisibility().equals(GraphStylesheet.VISIBILITY_VISIBLE)) {
                            n2 = 0;
                            bl2 = false;
                            break;
                        }
                    }
                    ++n;
                }
            }
            if (bl2 && (vector = iResource.getOutgoingPredicates()) != null) {
                n = 0;
                while (n < vector.size()) {
                    iProperty = (IProperty)vector.elementAt(n);
                    if (iProperty.isVisuallyRepresented()) {
                        if (Editor.gssMngr.getStyle(iProperty).getVisibility().equals(GraphStylesheet.VISIBILITY_VISIBLE)) {
                            n2 = 0;
                            break;
                        }
                    }
                    ++n;
                }
            }
            if (n2 == 0) continue;
            iResource.setVisible(false);
        }
        n = 0;
        while (n < this.application.literals.size()) {
            iLiteral = (ILiteral)this.application.literals.elementAt(n);
            if (iLiteral.isVisuallyRepresented()) {
                styleInfoL = Editor.gssMngr.getStyle(iLiteral);
                boolean bl4 = bl = styleInfoL.getVisibility().equals(GraphStylesheet.VISIBILITY_HIDDEN);
                if (bl) {
                    iLiteral.setVisible(false);
                    iLiteral.getIncomingPredicate().setVisible(false);
                }
            }
            ++n;
        }
        Enumeration enumeration4 = this.application.propertiesByURI.elements();
        while (enumeration4.hasMoreElements()) {
            vector = (Vector)enumeration4.nextElement();
            int n8 = 0;
            while (n8 < vector.size()) {
                iProperty = (IProperty)vector.elementAt(n8);
                if (iProperty.isVisuallyRepresented()) {
                    styleInfoP = Editor.gssMngr.getStyle(iProperty);
                    boolean bl5 = bl = styleInfoP.getVisibility().equals(GraphStylesheet.VISIBILITY_HIDDEN);
                    if (bl) {
                        iProperty.setVisible(false);
                        if (iProperty.getObject() instanceof ILiteral) {
                            iProperty.getObject().setVisible(false);
                        }
                    }
                }
                ++n8;
            }
        }
    }

    public void error(Exception exception) {
        String string = "RDFErrorHandler:Error: " + RDFLoader.format(exception);
        this.application.errorMessages.append(string + "\n");
        this.application.reportError = true;
    }

    public void fatalError(Exception exception) {
        String string = "RDFErrorHandler:Fatal Error: " + RDFLoader.format(exception);
        this.application.errorMessages.append(string + "\n");
        this.application.reportError = true;
    }

    public void warning(Exception exception) {
        String string = "RDFErrorHandler:Warning: " + RDFLoader.format(exception);
        this.application.errorMessages.append(string + "\n");
        this.application.reportError = true;
    }

    private static String format(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        if (exception instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)exception;
            return string + "[Line = " + sAXParseException.getLineNumber() + ", Column = " + sAXParseException.getColumnNumber() + "]";
        }
        return exception.toString();
    }

    protected Glyph getResourceShape(IResource iResource, Element element, boolean bl, ProgPanel progPanel) {
        if (bl) {
            Serializable serializable;
            Object object;
            VEllipse vEllipse;
            NodeList nodeList;
            StyleInfoR styleInfoR = Editor.gssMngr.getStyle(iResource);
            Object object2 = styleInfoR.getShape();
            if (object2 == null) {
                if (styleInfoR.getIcon() != null) {
                    block27: {
                        nodeList = element.getElementsByTagName("ellipse");
                        vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                        object = null;
                        if (styleInfoR.getIcon().toString().equals(GraphStylesheet._gssFetch)) {
                            try {
                                serializable = new URL(iResource.getIdentity());
                                progPanel.setSecLabel("Retrieving " + ((URL)serializable).toString() + " ...");
                                if (serializable != null) {
                                    if (Editor.gssMngr.storeIcon((URL)serializable)) {
                                        object = new VImage(vEllipse.vx, vEllipse.vy, 0.0f, Editor.gssMngr.getIcon((URL)serializable).getImage());
                                        object.setDrawBorderPolicy(VImage.DRAW_BORDER_ALWAYS);
                                        progPanel.setSecLabel("Retrieving " + ((URL)serializable).toString() + " ...OK");
                                        break block27;
                                    }
                                }
                                if (GraphStylesheet.DEBUG_GSS) {
                                    System.err.println("Error: there does not seem to be any icon at the following URI :" + serializable);
                                }
                                object2 = GraphStylesheet.DEFAULT_RESOURCE_SHAPE;
                                progPanel.setSecLabel("Retrieving " + ((URL)serializable).toString() + " ...Failed");
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (GraphStylesheet.DEBUG_GSS) {
                                    System.err.println("Error:RDFLoader.getResourceShape(): malformed icon URI: " + iResource.getIdentity());
                                    malformedURLException.printStackTrace();
                                }
                                break block27;
                            }
                        }
                        object = new VImage(vEllipse.vx, vEllipse.vy, 0.0f, Editor.gssMngr.getIcon(styleInfoR.getIcon()).getImage());
                        object.setDrawBorderPolicy(VImage.DRAW_BORDER_ALWAYS);
                    }
                    if (object != null) {
                        if (object.getWidth() >= object.getHeight()) {
                            object.setWidth(vEllipse.getWidth());
                        } else {
                            object.setHeight(vEllipse.getHeight());
                        }
                        return object;
                    }
                } else {
                    object2 = GraphStylesheet.DEFAULT_RESOURCE_SHAPE;
                }
            }
            if (object2 != null && object2 instanceof Integer) {
                if (object2.equals(Style.ELLIPSE)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    return SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                }
                if (object2.equals(Style.CIRCLE)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VCircle(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object2.equals(Style.DIAMOND)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VDiamond(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object2.equals(Style.OCTAGON)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VOctagon(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object2.equals(Style.ROUND_RECTANGLE)) {
                    nodeList = element.getElementsByTagName("polygon");
                    return SVGReader.createRoundRectFromPolygon((Element)((Element)nodeList.item(0)));
                }
                if (object2.equals(Style.TRIANGLEN)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangle(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object2.equals(Style.TRIANGLES)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangleOr(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor(), (float)Math.PI);
                }
                if (object2.equals(Style.TRIANGLEE)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangleOr(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor(), -1.5707964f);
                }
                if (object2.equals(Style.TRIANGLEW)) {
                    nodeList = element.getElementsByTagName("ellipse");
                    vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangleOr(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor(), 1.5707964f);
                }
                if (object2.equals(Style.RECTANGLE)) {
                    nodeList = element.getElementsByTagName("polygon");
                    return SVGReader.createRectangleFromPolygon((Element)((Element)nodeList.item(0)));
                }
                System.err.println("Error: RDFLoader.getResourceShape(): requested shape type unknown: " + object2.toString());
                return new VRectangle(0L, 0L, 0.0f, 1L, 1L, Color.white);
            }
            if (object2 != null && object2 instanceof CustomShape) {
                nodeList = element.getElementsByTagName("ellipse");
                vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                object = ((CustomShape)object2).getVertices();
                serializable = ((CustomShape)object2).getOrientation();
                return new VShape(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), object, vEllipse.getColor(), serializable != null ? ((Float)serializable).floatValue() : 0.0f);
            }
            if (object2 != null && object2 instanceof CustomPolygon) {
                nodeList = element.getElementsByTagName("ellipse");
                vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                object = ((CustomPolygon)object2).getVertices();
                serializable = new VPolygon(GeometryManager.computeVPolygonCoords(vEllipse.vx, vEllipse.vy, vEllipse.getHeight(), object), vEllipse.getColor());
                return serializable;
            }
            System.err.println("Error: RDFLoader.getResourceShape(): requested shape type unknown: " + object2.toString());
            return new VEllipse(0L, 0L, 0.0f, 1L, 1L, Color.white);
        }
        NodeList nodeList = element.getElementsByTagName("ellipse");
        return SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
    }

    protected Glyph getLiteralShape(ILiteral iLiteral, Element element, boolean bl, ProgPanel progPanel) {
        if (bl) {
            StyleInfoL styleInfoL = Editor.gssMngr.getStyle(iLiteral);
            Object object = styleInfoL.getShape();
            if (object == null) {
                if (styleInfoL.getIcon() != null) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    VImage vImage = new VImage(vEllipse.vx, vEllipse.vy, 0.0f, Editor.gssMngr.getIcon(styleInfoL.getIcon()).getImage());
                    vImage.setDrawBorderPolicy(VImage.DRAW_BORDER_ALWAYS);
                    if (vImage.getWidth() >= vImage.getHeight()) {
                        vImage.setWidth(vEllipse.getWidth());
                    } else {
                        vImage.setHeight(vEllipse.getHeight());
                    }
                    return vImage;
                }
                object = GraphStylesheet.DEFAULT_LITERAL_SHAPE;
            }
            if (object != null && object instanceof Integer) {
                if (object.equals(Style.RECTANGLE)) {
                    NodeList nodeList = element.getElementsByTagName("polygon");
                    return SVGReader.createRectangleFromPolygon((Element)((Element)nodeList.item(0)));
                }
                if (object.equals(Style.ROUND_RECTANGLE)) {
                    NodeList nodeList = element.getElementsByTagName("polygon");
                    return SVGReader.createRoundRectFromPolygon((Element)((Element)nodeList.item(0)));
                }
                if (object.equals(Style.CIRCLE)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VCircle(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object.equals(Style.DIAMOND)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VDiamond(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object.equals(Style.OCTAGON)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VOctagon(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object.equals(Style.TRIANGLEN)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangle(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor());
                }
                if (object.equals(Style.TRIANGLES)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangleOr(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor(), (float)Math.PI);
                }
                if (object.equals(Style.TRIANGLEE)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangleOr(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor(), -1.5707964f);
                }
                if (object.equals(Style.TRIANGLEW)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                    return new VTriangleOr(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), vEllipse.getColor(), 1.5707964f);
                }
                if (object.equals(Style.ELLIPSE)) {
                    NodeList nodeList = element.getElementsByTagName("ellipse");
                    return SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                }
                System.err.println("Error: RDFLoader.getLiteralShape(): requested shape type unknown: " + object.toString());
                return new VRectangle(0L, 0L, 0.0f, 1L, 1L, Color.white);
            }
            if (object != null && object instanceof CustomShape) {
                NodeList nodeList = element.getElementsByTagName("ellipse");
                VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                float[] fArray = ((CustomShape)object).getVertices();
                Float f = ((CustomShape)object).getOrientation();
                return new VShape(vEllipse.vx, vEllipse.vy, 0.0f, vEllipse.getHeight(), fArray, vEllipse.getColor(), f != null ? f.floatValue() : 0.0f);
            }
            if (object != null && object instanceof CustomPolygon) {
                NodeList nodeList = element.getElementsByTagName("ellipse");
                VEllipse vEllipse = SVGReader.createEllipse((Element)((Element)nodeList.item(0)));
                float[] fArray = ((CustomPolygon)object).getVertices();
                VPolygon vPolygon = new VPolygon(GeometryManager.computeVPolygonCoords(vEllipse.vx, vEllipse.vy, vEllipse.getHeight(), fArray), vEllipse.getColor());
                return vPolygon;
            }
            System.err.println("Error: RDFLoader.getLiteralShape(): requested shape type unknown: " + object.toString());
            return new VRectangle(0L, 0L, 0.0f, 1L, 1L, Color.white);
        }
        NodeList nodeList = element.getElementsByTagName("polygon");
        return SVGReader.createRectangleFromPolygon((Element)((Element)nodeList.item(0)));
    }

    static {
        formatRDFXML = "RDF/XML";
        formatNTRIPLES = "N-Triples";
        formatN3 = "Notation3";
        formatList = new Vector();
        formatList.add(formatRDFXML);
        formatList.add(formatNTRIPLES);
        formatList.add(formatN3);
        errorModePropertyName = "http://jena.hpl.hp.com/arp/properties/error-mode";
        errorModePropertyValue = "default";
        RESOURCE_MAPID_PREFIX = "R_";
        LITERAL_MAPID_PREFIX = "L_";
        PROPERTY_MAPID_PREFIX = "P_";
        TF_PROPERTY_MAPID_PREFIX = "F_";
        STRUCT_MAPID_PREFIX = "S_";
        STRUCT_PREFIX = "struct";
        hackReplacementText = ".is";
    }

    private class StyledSH {
        Editor application;
        Model model;
        Hashtable visibleStatements;
        Hashtable visibleResources;

        public StyledSH(Editor editor, Model model) {
            this.application = editor;
            this.model = model;
            this.visibleStatements = new Hashtable();
            this.visibleResources = new Hashtable();
        }

        void addVisibleStatement(IResource iResource, IProperty iProperty, IResource iResource2, Resource resource, Property property, Resource resource2, boolean bl, Object object, Object object2) {
            Object object3;
            ISVJenaStatement iSVJenaStatement = new ISVJenaStatement(iResource, iProperty, iResource2, resource, property, resource2, object, object2);
            String string = iResource.getIdentity();
            if (this.visibleStatements.containsKey(string)) {
                object3 = (Vector[])this.visibleStatements.get(string);
                if (bl && GSSManager.objectCanBeDisplayedInTable(iResource2)) {
                    object3[1].add(iSVJenaStatement);
                } else {
                    object3[0].add(iSVJenaStatement);
                }
            } else {
                object3 = new Vector[2];
                Vector<ISVJenaStatement> vector = new Vector<ISVJenaStatement>();
                Vector<ISVJenaStatement> vector2 = new Vector<ISVJenaStatement>();
                if (bl && GSSManager.objectCanBeDisplayedInTable(iResource2)) {
                    vector2.add(iSVJenaStatement);
                } else {
                    vector.add(iSVJenaStatement);
                }
                object3[0] = vector;
                object3[1] = vector2;
                this.visibleStatements.put(string, object3);
            }
            object3 = iResource2.getIdentity();
            if (this.visibleResources.containsKey(string)) {
                this.visibleResources.remove(string);
            }
            if (this.visibleResources.containsKey(object3)) {
                this.visibleResources.remove(object3);
            }
        }

        void addVisibleStatement(IResource iResource, IProperty iProperty, ILiteral iLiteral, Resource resource, Property property, Literal literal, boolean bl, Object object, Object object2) {
            ISVJenaStatement iSVJenaStatement = new ISVJenaStatement(iResource, iProperty, iLiteral, resource, property, literal, object, object2);
            String string = iResource.getIdentity();
            if (this.visibleStatements.containsKey(string)) {
                Vector[] vectorArray = (Vector[])this.visibleStatements.get(string);
                if (bl) {
                    vectorArray[1].add(iSVJenaStatement);
                } else {
                    vectorArray[0].add(iSVJenaStatement);
                }
            } else {
                Vector[] vectorArray = new Vector[2];
                Vector<ISVJenaStatement> vector = new Vector<ISVJenaStatement>();
                Vector<ISVJenaStatement> vector2 = new Vector<ISVJenaStatement>();
                if (bl) {
                    vector2.add(iSVJenaStatement);
                } else {
                    vector.add(iSVJenaStatement);
                }
                vectorArray[0] = vector;
                vectorArray[1] = vector2;
                this.visibleStatements.put(string, vectorArray);
            }
            if (this.visibleResources.containsKey(string)) {
                this.visibleResources.remove(string);
            }
        }

        void addVisibleResource(IResource iResource, Resource resource, Object object) {
            String string = iResource.getIdentity();
            if (!this.visibleStatements.containsKey(string) && !this.visibleResources.containsKey(string)) {
                Vector<Object> vector = new Vector<Object>();
                vector.add(iResource);
                vector.add(resource);
                vector.add(object);
                this.visibleResources.put(string, vector);
            }
        }

        public void statement(Resource resource, Property property, Resource resource2, Vector vector) {
            vector.add(RDFLoader.this.processStyledStatement(resource, property, resource2));
        }

        public void statement(Resource resource, Property property, Literal literal, Vector vector) {
            vector.add(RDFLoader.this.processStyledStatement(resource, property, literal));
        }

        public void statementDotResource(IResource iResource, Resource resource, IProperty iProperty, Property property, IResource iResource2, Resource resource2) {
            Object object;
            StyleInfoR styleInfoR = Editor.gssMngr.computeAndGetStyle(iResource);
            StyleInfoP styleInfoP = Editor.gssMngr.computeAndGetStyle(iProperty);
            StyleInfoR styleInfoR2 = Editor.gssMngr.computeAndGetStyle(iResource2);
            Integer n = styleInfoR.getVisibility();
            boolean bl = styleInfoR.getLayout().equals(GraphStylesheet.TABLE_FORM);
            Integer n2 = styleInfoP.getVisibility();
            boolean bl2 = styleInfoP.getLayout().equals(GraphStylesheet.TABLE_FORM);
            Integer n3 = styleInfoR2.getVisibility();
            boolean bl3 = styleInfoR2.getLayout().equals(GraphStylesheet.TABLE_FORM);
            Object object2 = styleInfoR.getShape();
            if (object2 == null) {
                object2 = styleInfoR.getIcon() != null ? Style.CIRCLE : GraphStylesheet.DEFAULT_RESOURCE_SHAPE;
            }
            if ((object = styleInfoR2.getShape()) == null) {
                object = styleInfoR2.getIcon() != null ? Style.CIRCLE : GraphStylesheet.DEFAULT_RESOURCE_SHAPE;
            }
            if (n2.equals(GraphStylesheet.DISPLAY_NONE)) {
                if (TablePanel.SHOW_ISOLATED_NODES && !n.equals(GraphStylesheet.DISPLAY_NONE) && !n.equals(GraphStylesheet.VISIBILITY_HIDDEN)) {
                    this.addVisibleResource(iResource, resource, object2);
                }
                if (TablePanel.SHOW_ISOLATED_NODES && !n3.equals(GraphStylesheet.DISPLAY_NONE) && !n3.equals(GraphStylesheet.VISIBILITY_HIDDEN)) {
                    this.addVisibleResource(iResource2, resource2, object);
                }
            } else if (!n.equals(GraphStylesheet.DISPLAY_NONE) && !n.equals(GraphStylesheet.VISIBILITY_HIDDEN)) {
                if (n3.equals(GraphStylesheet.DISPLAY_NONE)) {
                    if (TablePanel.SHOW_ISOLATED_NODES) {
                        this.addVisibleResource(iResource, resource, object2);
                    }
                } else {
                    this.addVisibleStatement(iResource, iProperty, iResource2, resource, property, resource2, bl || bl2, object2, object);
                }
            } else if (!n3.equals(GraphStylesheet.DISPLAY_NONE) && !n3.equals(GraphStylesheet.VISIBILITY_HIDDEN) && TablePanel.SHOW_ISOLATED_NODES) {
                this.addVisibleResource(iResource2, resource2, object);
            }
        }

        public void statementDotLiteral(IResource iResource, Resource resource, IProperty iProperty, Property property, ILiteral iLiteral, Literal literal) {
            Object object;
            StyleInfoR styleInfoR = Editor.gssMngr.computeAndGetStyle(iResource);
            StyleInfoP styleInfoP = Editor.gssMngr.computeAndGetStyle(iProperty);
            StyleInfoL styleInfoL = Editor.gssMngr.computeAndGetStyle(iLiteral);
            Integer n = styleInfoR.getVisibility();
            boolean bl = styleInfoR.getLayout().equals(GraphStylesheet.TABLE_FORM);
            Integer n2 = styleInfoP.getVisibility();
            boolean bl2 = styleInfoP.getLayout().equals(GraphStylesheet.TABLE_FORM);
            Integer n3 = styleInfoL.getVisibility();
            boolean bl3 = styleInfoL.getLayout().equals(GraphStylesheet.TABLE_FORM);
            Object object2 = styleInfoR.getShape();
            if (object2 == null) {
                object2 = styleInfoR.getIcon() != null ? Style.CIRCLE : GraphStylesheet.DEFAULT_RESOURCE_SHAPE;
            }
            if ((object = styleInfoL.getShape()) == null) {
                object = styleInfoL.getIcon() != null ? Style.CIRCLE : GraphStylesheet.DEFAULT_LITERAL_SHAPE;
            }
            if (n2.equals(GraphStylesheet.DISPLAY_NONE)) {
                if (TablePanel.SHOW_ISOLATED_NODES && !n.equals(GraphStylesheet.DISPLAY_NONE) && !n.equals(GraphStylesheet.VISIBILITY_HIDDEN)) {
                    this.addVisibleResource(iResource, resource, object2);
                }
            } else if (!n.equals(GraphStylesheet.DISPLAY_NONE) && !n.equals(GraphStylesheet.VISIBILITY_HIDDEN)) {
                if (n3.equals(GraphStylesheet.DISPLAY_NONE)) {
                    if (TablePanel.SHOW_ISOLATED_NODES) {
                        this.addVisibleResource(iResource, resource, object2);
                    }
                } else {
                    this.addVisibleStatement(iResource, iProperty, iLiteral, resource, property, literal, bl || bl2 || bl3, object2, object);
                }
            }
        }

        void clean() {
            this.visibleStatements.clear();
            this.visibleStatements = null;
            this.visibleResources.clear();
            this.visibleResources = null;
        }

        Hashtable getVisibleStatements() {
            return this.visibleStatements;
        }

        Hashtable getVisibleResources() {
            return this.visibleResources;
        }
    }

    private class SH {
        PrintWriter pw;
        Editor application;
        int numLiterals = 0;

        public SH(PrintWriter printWriter, Editor editor) {
            this.pw = printWriter;
            this.application = editor;
        }

        public void statement(Resource resource, Property property, Resource resource2) {
            Vector vector = RDFLoader.this.processStatement(resource, property, resource2);
            this.statementDotResource((IResource)vector.elementAt(0), resource, (IProperty)vector.elementAt(1), property, (IResource)vector.elementAt(2), resource2);
        }

        public void statement(Resource resource, Property property, Literal literal) {
            Vector vector = RDFLoader.this.processStatement(resource, property, literal);
            ++this.numLiterals;
            this.statementDotLiteral((IResource)vector.elementAt(0), resource, (IProperty)vector.elementAt(1), property, (ILiteral)vector.elementAt(2), literal);
        }

        public void statementDotResource(IResource iResource, Resource resource, IProperty iProperty, Property property, IResource iResource2, Resource resource2) {
            if (this.pw == null) {
                return;
            }
            this.printFirstPart(resource, iResource);
            this.pw.print("\" -> ");
            String string = PROPERTY_MAPID_PREFIX + this.application.rdfLdr.nextEdgeID.toString();
            iProperty.setMapID(string);
            this.application.rdfLdr.incEdgeID();
            boolean bl = true;
            if (iResource2.getMapID() == null) {
                String string2 = RESOURCE_MAPID_PREFIX + this.application.rdfLdr.nextNodeID.toString();
                iResource2.setMapID(string2);
                this.application.rdfLdr.incNodeID();
                bl = false;
            }
            if (resource2.isAnon()) {
                this.pw.println("\"" + iResource2.getGraphLabel() + "\" [label=\"" + property.getURI() + "\\l\",URL=\"" + string + "\"];");
                if (!bl) {
                    this.pw.println("\"" + iResource2.getGraphLabel() + "\" [URL=\"" + iResource2.getMapID() + "\"];");
                }
            } else {
                this.pw.println("\"" + iResource2.getGraphLabel() + "\" [label=\"" + property.getURI() + "\\l\",URL=\"" + string + "\"];");
                if (!bl) {
                    this.pw.println("\"" + iResource2.getGraphLabel() + "\" [URL=\"" + iResource2.getMapID() + "\"];");
                }
            }
        }

        public void statementDotLiteral(IResource iResource, Resource resource, IProperty iProperty, Property property, ILiteral iLiteral, Literal literal) {
            if (this.pw == null) {
                return;
            }
            this.printFirstPart(resource, iResource);
            try {
                String string = new String(literal.getString());
                string = string.replace('\n', ' ');
                string = string.replace('\f', ' ');
                string = string.replace('\r', ' ');
                if (string.indexOf(34) != -1) {
                    string = Utils.replaceString(string, "\"", "\\\"");
                }
                String string2 = string.length() >= Editor.MAX_LIT_CHAR_COUNT ? string.substring(0, Editor.MAX_LIT_CHAR_COUNT) + " ..." : string;
                String string3 = PROPERTY_MAPID_PREFIX + this.application.rdfLdr.nextEdgeID.toString();
                iProperty.setMapID(string3);
                this.application.rdfLdr.incEdgeID();
                String string4 = LITERAL_MAPID_PREFIX + this.application.rdfLdr.nextNodeID.toString();
                iLiteral.setMapID(string4);
                this.application.rdfLdr.incNodeID();
                String string5 = "Literal_" + Integer.toString(this.numLiterals);
                this.pw.print("\" -> \"" + string5);
                this.pw.println("\" [label=\"" + property.getURI() + "\\l\",URL=\"" + string3 + "\"];");
                this.pw.println("\"" + string5 + "\" [shape=box,label=\"" + string2 + "\\l\",URL=\"" + string4 + "\"];");
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("Error: SH.statementDotLiteral: " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        }

        public void printFirstPart(Resource resource, IResource iResource) {
            try {
                String string;
                boolean bl = true;
                if (iResource.getMapID() == null) {
                    string = RESOURCE_MAPID_PREFIX + this.application.rdfLdr.nextNodeID.toString();
                    iResource.setMapID(string);
                    this.application.rdfLdr.incNodeID();
                    bl = false;
                }
                if (resource.isAnon()) {
                    if (!bl) {
                        this.pw.println("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(resource.getId()) + "\" [URL=\"" + iResource.getMapID() + "\"];");
                    }
                    this.pw.print("\"" + Editor.ANON_NODE + IResource.getJenaAnonId(resource.getId()));
                } else {
                    string = iResource.getGraphLabel();
                    if (!bl) {
                        this.pw.println("\"" + string + "\" [URL=\"" + iResource.getMapID() + "\"];");
                    }
                    this.pw.print("\"" + string);
                }
            }
            catch (RDFException rDFException) {
                this.application.errorMessages.append("Error: SH.printFirstPart(): " + (Object)((Object)rDFException) + "\n");
                this.application.reportError = true;
            }
        }
    }
}

