/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.IResource;

class NewResPanel
extends JDialog
implements KeyListener,
ActionListener {
    Editor application;
    IResource node;
    JRadioButton uriBt;
    JRadioButton idBt;
    JTextField tf;
    JButton ok;
    JButton cancel;

    NewResPanel(Editor editor, IResource iResource) {
        super((JFrame)Editor.vsm.getActiveView().getFrame(), "New Resource...", true);
        this.application = editor;
        this.node = iResource;
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(3, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        JLabel jLabel = new JLabel("About:");
        jPanel.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.uriBt = new JRadioButton("URI");
        this.idBt = new JRadioButton("ID");
        jPanel.add(this.uriBt);
        buttonGroup.add(this.uriBt);
        jPanel.add(this.idBt);
        buttonGroup.add(this.idBt);
        container.add(jPanel);
        this.uriBt.setSelected(true);
        this.tf = new JTextField("");
        this.tf.setFont(Editor.swingFont);
        this.tf.addKeyListener(this);
        container.add(this.tf);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.ok.addKeyListener(this);
        jPanel2.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        jPanel2.add(this.cancel);
        container.add(jPanel2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }

            public void windowActivated(WindowEvent windowEvent) {
                NewResPanel.this.tf.requestFocus();
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - 250) / 2, (dimension.height - 100) / 2);
        this.setSize(250, 100);
        this.setVisible(true);
        this.addNotify();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.ok();
        } else if (actionEvent.getSource() == this.cancel) {
            this.application.cancelNewNode(this.node);
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getSource() == this.tf || keyEvent.getSource() == this.ok) {
                this.ok();
            } else if (keyEvent.getSource() == this.cancel) {
                this.application.cancelNewNode(this.node);
                this.dispose();
            }
        }
    }

    void ok() {
        if (this.uriBt.isSelected()) {
            String string = this.tf.getText();
            if (ConfigManager.ALLOW_PFX_IN_TXTFIELDS) {
                string = this.application.tryToSolveBinding(string);
            }
            if (!this.application.resourceAlreadyExists(string)) {
                if (!string.startsWith(Editor.ANON_NODE.substring(0, Editor.ANON_NODE.length() - 1))) {
                    this.application.storeResource(this.node, string, true);
                    this.dispose();
                } else {
                    JOptionPane.showMessageDialog(this, Editor.ANON_NODE + " is reserved for anonymous nodes.");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Resource " + string + " already exists.");
            }
        } else {
            String string;
            String string2 = this.tf.getText();
            String string3 = string = string2.startsWith(Editor.BASE_URI) ? string2.substring(Editor.BASE_URI.length(), string2.length()) : string2;
            if (!this.application.resourceAlreadyExists(Editor.BASE_URI + "#" + string) && !this.application.resourceAlreadyExists(Editor.BASE_URI + string)) {
                if (!string.startsWith(Editor.ANON_NODE.substring(0, Editor.ANON_NODE.length() - 1))) {
                    this.application.storeResource(this.node, string, false);
                    this.dispose();
                } else {
                    JOptionPane.showMessageDialog(this, Editor.ANON_NODE + " is reserved for anonymous nodes.");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Resource " + string + " already exists.");
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

