/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IResource;

class NewPropPanel
extends JFrame
implements KeyListener,
ActionListener,
FocusListener {
    Editor application;
    JButton ok;
    JButton cancel;
    IResource subject;
    INode object;
    JComboBox pnscbb;
    JComboBox plncbb;
    JTextField subjTf;
    JTextField objTf;
    Object lastFocusedTf = null;

    NewPropPanel(Editor editor) {
        super("New Statement...");
        Object object;
        this.application = editor;
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel();
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 85);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        JLabel jLabel = new JLabel("Subject");
        this.buildConstraints(gridBagConstraints2, 0, 0, 1, 1, 20, 33);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel.add(jLabel);
        this.subjTf = new JTextField("Select a resource in the Graph window");
        this.buildConstraints(gridBagConstraints2, 1, 0, 2, 1, 80, 0);
        gridBagLayout2.setConstraints(this.subjTf, gridBagConstraints2);
        jPanel.add(this.subjTf);
        this.subjTf.addFocusListener(this);
        this.subjTf.setEditable(false);
        JLabel jLabel2 = new JLabel("Predicate");
        this.buildConstraints(gridBagConstraints2, 0, 1, 1, 1, 20, 33);
        gridBagLayout2.setConstraints(jLabel2, gridBagConstraints2);
        jPanel.add(jLabel2);
        Vector vector = this.application.getAllPropertyNS();
        this.pnscbb = new JComboBox(vector);
        this.pnscbb.setSelectedItem(vector.firstElement());
        this.plncbb = new JComboBox(this.application.getProperties4NS((String)vector.firstElement()));
        this.pnscbb.setMaximumRowCount(10);
        this.plncbb.setMaximumRowCount(10);
        this.buildConstraints(gridBagConstraints2, 1, 1, 1, 1, 40, 0);
        gridBagLayout2.setConstraints(this.pnscbb, gridBagConstraints2);
        jPanel.add(this.pnscbb);
        this.buildConstraints(gridBagConstraints2, 2, 1, 1, 1, 40, 0);
        gridBagLayout2.setConstraints(this.plncbb, gridBagConstraints2);
        jPanel.add(this.plncbb);
        if (this.application.selectedPropertyConstructorNS != null && this.application.selectedPropertyConstructorLN != null) {
            object = Editor.getNSBinding(this.application.selectedPropertyConstructorNS);
            this.pnscbb.setSelectedItem(object != null ? object : this.application.selectedPropertyConstructorNS);
            this.plncbb.setSelectedItem(this.application.selectedPropertyConstructorLN);
        }
        object = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    NewPropPanel.this.plncbb.removeAllItems();
                    Vector vector = NewPropPanel.this.application.getProperties4NS((String)itemEvent.getItem());
                    int n = 0;
                    while (n < vector.size()) {
                        NewPropPanel.this.plncbb.addItem(vector.elementAt(n));
                        ++n;
                    }
                }
            }
        };
        this.pnscbb.addItemListener((ItemListener)object);
        JLabel jLabel3 = new JLabel("Object");
        this.buildConstraints(gridBagConstraints2, 0, 2, 1, 1, 20, 33);
        gridBagLayout2.setConstraints(jLabel3, gridBagConstraints2);
        jPanel.add(jLabel3);
        this.objTf = new JTextField("Select a resource or a literal in the Graph window");
        this.buildConstraints(gridBagConstraints2, 1, 2, 2, 1, 80, 0);
        gridBagLayout2.setConstraints(this.objTf, gridBagConstraints2);
        jPanel.add(this.objTf);
        this.objTf.addFocusListener(this);
        this.objTf.setEditable(false);
        JPanel jPanel2 = new JPanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 15);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        jPanel2.setLayout(new GridLayout(1, 2));
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.ok.addKeyListener(this);
        jPanel2.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        jPanel2.add(this.cancel);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NewPropPanel.this.cancel();
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - 500) / 2, (dimension.height - 120) / 2);
        this.setSize(500, 120);
        this.setVisible(true);
    }

    void setSubjectOrObject(Glyph glyph) {
        if (this.lastFocusedTf == this.subjTf) {
            this.setSubject(glyph);
        } else if (this.lastFocusedTf == this.objTf) {
            this.setObject(glyph);
        }
    }

    void setSubject(Glyph glyph) {
        try {
            this.subject = (IResource)glyph.getOwner();
            this.subjTf.setText(this.subject.getIdentity());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            JOptionPane.showMessageDialog(this, "A literal cannot be the subject of a statement.");
        }
    }

    void setObject(Glyph glyph) {
        try {
            this.object = (INode)glyph.getOwner();
            if (this.object instanceof IResource) {
                this.object = (INode)glyph.getOwner();
                this.objTf.setText(((IResource)this.object).getIdentity());
            } else if (this.object instanceof ILiteral) {
                if (((ILiteral)this.object).getIncomingPredicate() != null) {
                    this.object = null;
                    JOptionPane.showMessageDialog(this, "This literal is already the object of a statement.");
                } else {
                    this.objTf.setText(((ILiteral)this.object).getText());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void setFocusToSubject() {
        this.subjTf.requestFocus();
    }

    void setFocusToObject() {
        this.objTf.requestFocus();
    }

    void ok() {
        if (this.subject != null && this.object != null) {
            Vector<LongPoint> vector = new Vector<LongPoint>();
            vector.add(this.subject.getGlyph().getLocation());
            vector.add(this.object.getGlyph().getLocation());
            String string = (String)this.pnscbb.getSelectedItem();
            String string2 = this.application.getNSURIfromPrefix(string);
            this.application.createNewProperty(this.subject, this.object, vector, string2 != null ? string2 : string, (String)this.plncbb.getSelectedItem());
            this.application.eeh.propertyDialog = null;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "You must specify the subject, predicate and object of the new statement");
        }
    }

    void cancel() {
        this.application.eeh.propertyDialog = null;
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.ok();
        } else if (actionEvent.getSource() == this.cancel) {
            this.cancel();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getSource() == this.ok) {
                this.ok();
            } else if (keyEvent.getSource() == this.cancel) {
                this.cancel();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.subjTf) {
            this.lastFocusedTf = this.subjTf;
            this.subjTf.setBackground(ConfigManager.pastelBlue);
        } else if (focusEvent.getSource() == this.objTf) {
            this.lastFocusedTf = this.objTf;
            this.objTf.setBackground(ConfigManager.pastelBlue);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.subjTf) {
            this.subjTf.setBackground(this.getBackground());
        } else if (focusEvent.getSource() == this.objTf) {
            this.objTf.setBackground(this.getBackground());
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

