/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.HSepPanel;

class InfoPanel
extends JFrame
implements ActionListener {
    Editor application;
    int nbProcs = 1;
    long totalMemKb = 0L;
    long maxMemKb = 0L;
    long freeMemKb = 0L;
    long usedMemKb = 0L;
    JButton okBt;
    JButton gcBt;
    JButton refreshBt;
    JLabel l2;
    JLabel l4;
    JLabel l6;
    JLabel l8;
    JLabel l24;
    JLabel l12;
    JLabel l14;
    JLabel l16;
    JLabel l18;

    InfoPanel(Editor editor, String string, String string2, int n, int n2, int n3) {
        this.application = editor;
        this.retrieveSystemInfo();
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Project File");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.l2 = new JLabel(string);
        this.l2.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l2, gridBagConstraints);
        container.add(this.l2);
        JLabel jLabel2 = new JLabel("Last RDF import");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        container.add(jLabel2);
        this.l24 = new JLabel(string2);
        this.l24.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l24, gridBagConstraints);
        container.add(this.l24);
        HSepPanel hSepPanel = new HSepPanel(1, true, Color.black);
        this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 100, 10);
        gridBagLayout.setConstraints(hSepPanel, gridBagConstraints);
        container.add(hSepPanel);
        JLabel jLabel3 = new JLabel("Number of resources");
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        container.add(jLabel3);
        this.l4 = new JLabel(new Integer(n).toString());
        this.l4.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l4, gridBagConstraints);
        container.add(this.l4);
        JLabel jLabel4 = new JLabel("Number of literals");
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        container.add(jLabel4);
        this.l6 = new JLabel(new Integer(n2).toString());
        this.l6.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l6, gridBagConstraints);
        container.add(this.l6);
        JLabel jLabel5 = new JLabel("Number of statements");
        this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        container.add(jLabel5);
        this.l8 = new JLabel(new Integer(n3).toString());
        this.l8.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 5, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l8, gridBagConstraints);
        container.add(this.l8);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        HSepPanel hSepPanel2 = new HSepPanel(1, true, Color.black);
        this.buildConstraints(gridBagConstraints, 0, 6, 2, 1, 100, 10);
        gridBagLayout.setConstraints(hSepPanel2, gridBagConstraints);
        container.add(hSepPanel2);
        gridBagConstraints.anchor = 17;
        JLabel jLabel6 = new JLabel("Number of processors available");
        this.buildConstraints(gridBagConstraints, 0, 7, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        container.add(jLabel6);
        JLabel jLabel7 = new JLabel(new Integer(this.nbProcs).toString());
        jLabel7.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 7, 1, 1, 50, 0);
        gridBagLayout.setConstraints(jLabel7, gridBagConstraints);
        container.add(jLabel7);
        HSepPanel hSepPanel3 = new HSepPanel(1, true, Color.black);
        this.buildConstraints(gridBagConstraints, 0, 8, 2, 1, 100, 10);
        gridBagLayout.setConstraints(hSepPanel3, gridBagConstraints);
        container.add(hSepPanel3);
        JLabel jLabel8 = new JLabel("Free Memory");
        this.buildConstraints(gridBagConstraints, 0, 9, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel8, gridBagConstraints);
        container.add(jLabel8);
        this.l12 = new JLabel(this.freeMemKb + "Kb");
        this.l12.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 9, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l12, gridBagConstraints);
        container.add(this.l12);
        JLabel jLabel9 = new JLabel("Used Memory");
        this.buildConstraints(gridBagConstraints, 0, 10, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel9, gridBagConstraints);
        container.add(jLabel9);
        this.l14 = new JLabel(this.usedMemKb + "Kb");
        this.l14.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 10, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l14, gridBagConstraints);
        container.add(this.l14);
        JLabel jLabel10 = new JLabel("Available Memory");
        this.buildConstraints(gridBagConstraints, 0, 11, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel10, gridBagConstraints);
        container.add(jLabel10);
        this.l16 = new JLabel(this.totalMemKb + "Kb");
        this.l16.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 11, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l16, gridBagConstraints);
        container.add(this.l16);
        JLabel jLabel11 = new JLabel("System Memory");
        this.buildConstraints(gridBagConstraints, 0, 12, 1, 1, 50, 10);
        gridBagLayout.setConstraints(jLabel11, gridBagConstraints);
        container.add(jLabel11);
        this.l18 = new JLabel(this.maxMemKb + "Kb");
        this.l18.setForeground(ConfigManager.darkerPastelBlue);
        this.buildConstraints(gridBagConstraints, 1, 12, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.l18, gridBagConstraints);
        container.add(this.l18);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.gcBt = new JButton("Manual Garbage Collecting");
        this.buildConstraints(gridBagConstraints, 0, 13, 1, 1, 50, 10);
        gridBagLayout.setConstraints(this.gcBt, gridBagConstraints);
        container.add(this.gcBt);
        this.gcBt.addActionListener(this);
        gridBagConstraints.fill = 2;
        HSepPanel hSepPanel4 = new HSepPanel(1, true, Color.black);
        this.buildConstraints(gridBagConstraints, 0, 14, 2, 1, 100, 10);
        gridBagLayout.setConstraints(hSepPanel4, gridBagConstraints);
        container.add(hSepPanel4);
        this.okBt = new JButton("OK");
        this.buildConstraints(gridBagConstraints, 0, 15, 1, 1, 50, 10);
        gridBagLayout.setConstraints(this.okBt, gridBagConstraints);
        container.add(this.okBt);
        this.okBt.addActionListener(this);
        this.refreshBt = new JButton("Refresh");
        this.buildConstraints(gridBagConstraints, 1, 15, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.refreshBt, gridBagConstraints);
        container.add(this.refreshBt);
        this.refreshBt.addActionListener(this);
        this.setTitle("IsaViz Project Information");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                InfoPanel.this.destroy();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setSize(500, 270);
        this.setLocation(10, 10);
        this.setVisible(true);
    }

    void destroy() {
        this.setVisible(false);
        this.dispose();
    }

    void retrieveSystemInfo() {
        this.nbProcs = Runtime.getRuntime().availableProcessors();
        this.totalMemKb = Runtime.getRuntime().totalMemory() / 1024L;
        this.maxMemKb = Runtime.getRuntime().maxMemory() / 1024L;
        this.freeMemKb = Runtime.getRuntime().freeMemory() / 1024L;
        this.usedMemKb = this.totalMemKb - this.freeMemKb;
    }

    void updateMemStats() {
        this.l12.setText(this.freeMemKb + "Kb");
        this.l14.setText(this.usedMemKb + "Kb");
        this.l16.setText(this.totalMemKb + "Kb");
        this.l18.setText(this.maxMemKb + "Kb");
    }

    void updateProjStats() {
        String string = Editor.projectFile == null ? "" : Editor.projectFile.toString();
        String string2 = Editor.lastRDF == null ? "" : Editor.lastRDF;
        int n = 0;
        Enumeration enumeration = this.application.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                enumeration2.nextElement();
                ++n;
            }
        }
        int n2 = this.application.resourcesByURI.size();
        int n3 = this.application.literals.size();
        this.l2.setText(string);
        this.l24.setText(string2);
        this.l4.setText(new Integer(n2).toString());
        this.l6.setText(new Integer(n3).toString());
        this.l8.setText(new Integer(n).toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okBt) {
            this.destroy();
        } else if (object == this.gcBt) {
            Editor.collectGarbage();
            this.retrieveSystemInfo();
            this.updateMemStats();
        } else if (object == this.refreshBt) {
            this.retrieveSystemInfo();
            this.updateMemStats();
            this.updateProjStats();
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

