/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VPolygon;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRoundRect;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GeometryManager;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ProgPanel;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ISVManager {
    Editor application;
    Hashtable uniqueIDs2INodes;
    Hashtable inodes2UniqueIDs;
    StringBuffer nextUniqueID;
    protected static File img_subdir = null;
    protected Vector fonts = null;
    protected Hashtable strokes = null;
    protected Hashtable subject2sharededge = null;

    ISVManager(Editor editor) {
        this.application = editor;
    }

    public void openProject(File file) {
        ProgPanel progPanel = new ProgPanel("Resetting...", "Loading ISV");
        this.application.reset(true);
        this.application.resetGraphStylesheets();
        Editor.lastOpenPrjDir = file.getParentFile();
        progPanel.setPBValue(10);
        progPanel.setLabel("Loading file " + file.toString() + " ...");
        Editor.projectFile = file;
        Editor.vsm.getView("Graph").setCursorIcon(3);
        Editor.vsm.getView("Graph").setStatusBarText("Loading project to " + file.toString() + " ...");
        this.uniqueIDs2INodes = new Hashtable();
        progPanel.setPBValue(20);
        progPanel.setLabel("Parsing...");
        try {
            Element element;
            int n;
            NodeList nodeList;
            Document document = this.application.xmlMngr.parse(file, false);
            document.normalize();
            Element element2 = document.getDocumentElement();
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "baseURI").getLength() > 0) {
                Editor.BASE_URI = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "baseURI").item(0)).getAttribute("value");
            }
            progPanel.setPBValue(30);
            progPanel.setLabel("Processing namespace bindings...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "nsBindings").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "nsBindings").item(0)).getElementsByTagNameNS(Editor.isavizURI, "nsBinding");
                n = 0;
                while (n < nodeList.getLength()) {
                    element = (Element)nodeList.item(n);
                    this.application.addNamespaceBinding(element.getAttribute("prefix"), element.getAttribute("uri"), new Boolean(element.getAttribute("dispPrefix")), true, true);
                    ++n;
                }
            }
            progPanel.setPBValue(40);
            progPanel.setLabel("Processing property types...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "propertyTypes").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "propertyTypes").item(0)).getElementsByTagNameNS(Editor.isavizURI, "propertyType");
                n = 0;
                while (n < nodeList.getLength()) {
                    element = (Element)nodeList.item(n);
                    this.application.addPropertyType(element.getAttribute("ns"), element.getAttribute("name"), true);
                    ++n;
                }
            }
            progPanel.setPBValue(45);
            progPanel.setLabel("Processing color table...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "colorTable").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "colorTable").item(0)).getElementsByTagNameNS(Editor.isavizURI, "color");
                ConfigManager.colors = new Color[nodeList.getLength()];
                String string = null;
                String string2 = null;
                String string3 = null;
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    element = (Element)nodeList.item(n2);
                    try {
                        string = element.getAttribute("r");
                        string2 = element.getAttribute("g");
                        string3 = element.getAttribute("b");
                        ConfigManager.colors[n2] = new Color(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3));
                    }
                    catch (Exception exception) {
                        System.err.println("ISVManager:Error: failed to instantiate color (" + string + "," + string2 + "," + string3 + ")");
                        ConfigManager.colors[n2] = Color.white;
                    }
                    ++n2;
                }
            }
            this.fonts = new Vector();
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "fontTable").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "fontTable").item(0)).getElementsByTagNameNS(Editor.isavizURI, "font");
                int n3 = 0;
                while (n3 < nodeList.getLength()) {
                    element = (Element)nodeList.item(n3);
                    this.fonts.add(Font.decode(element.getAttribute("desc")));
                    ++n3;
                }
            }
            this.strokes = new Hashtable();
            progPanel.setPBValue(50);
            progPanel.setLabel("Processing resources...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "resources").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "resources").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iresource");
                int n4 = 0;
                while (n4 < nodeList.getLength()) {
                    this.createIResourceFromISV((Element)nodeList.item(n4));
                    ++n4;
                }
            }
            progPanel.setPBValue(60);
            progPanel.setLabel("Processing literals...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "literals").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "literals").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iliteral");
                int n5 = 0;
                while (n5 < nodeList.getLength()) {
                    this.createILiteralFromISV((Element)nodeList.item(n5));
                    ++n5;
                }
            }
            progPanel.setPBValue(80);
            progPanel.setLabel("Processing properties...");
            this.subject2sharededge = new Hashtable();
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "properties").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "properties").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iproperty");
                int n6 = 0;
                while (n6 < nodeList.getLength()) {
                    this.createIPropertyFromISV((Element)nodeList.item(n6));
                    ++n6;
                }
            }
            this.subject2sharededge.clear();
            progPanel.setLabel("Building graphical representation...");
            progPanel.setPBValue(100);
            this.application.showAnonIds(ConfigManager.SHOW_ANON_ID);
            this.application.showResourceLabels(Editor.DISP_AS_LABEL);
            this.uniqueIDs2INodes.clear();
            this.uniqueIDs2INodes = null;
            this.fonts.removeAllElements();
            this.strokes.clear();
            Editor.vsm.getGlobalView(Editor.vsm.getVirtualSpace("rdfSpace").getCamera(0), ConfigManager.ANIM_DURATION);
            this.application.centerRadarView();
            Editor.vsm.getView("Graph").setStatusBarText("Loading project to " + file.toString() + " ...done");
        }
        catch (Exception exception) {
            this.application.errorMessages.append("An error occured while loading file " + file + "\nThis might not be a valid ISV project file.\n" + exception);
            this.application.reportError = true;
            exception.printStackTrace();
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        Editor.vsm.getView("Graph").setCursorIcon(-1);
        progPanel.destroy();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveProject(File file) {
        Object object;
        Object object2;
        Editor.projectFile = file;
        Editor.lastSavePrjDir = file.getParentFile();
        Editor.vsm.getView("Graph").setCursorIcon(3);
        Editor.vsm.getView("Graph").setStatusBarText("Saving project to " + file.toString() + " ...");
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        Document document = dOMImplementationImpl.createDocument(Editor.isavizURI, "isv:project", null);
        Element element = document.getDocumentElement();
        element.setAttribute("xmlns:isv", Editor.isavizURI);
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:baseURI");
        element.appendChild(element2);
        element2.setAttribute("value", Editor.BASE_URI);
        Element element3 = document.createElementNS(Editor.isavizURI, "isv:nsBindings");
        element.appendChild(element3);
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                if (((String)Editor.tblp.nsTableModel.getValueAt(n, 1)).length() > 0) {
                    Element element4 = document.createElementNS(Editor.isavizURI, "isv:nsBinding");
                    element4.setAttribute("prefix", (String)Editor.tblp.nsTableModel.getValueAt(n, 0));
                    element4.setAttribute("uri", (String)Editor.tblp.nsTableModel.getValueAt(n, 1));
                    element4.setAttribute("dispPrefix", ((Boolean)Editor.tblp.nsTableModel.getValueAt(n, 2)).toString());
                    element3.appendChild(element4);
                }
            }
            ++n;
        }
        Element element5 = document.createElementNS(Editor.isavizURI, "isv:propertyTypes");
        element.appendChild(element5);
        DefaultTableModel defaultTableModel = (DefaultTableModel)Editor.tblp.prTable.getModel();
        int n2 = 0;
        while (n2 < defaultTableModel.getRowCount()) {
            Element element6 = document.createElementNS(Editor.isavizURI, "isv:propertyType");
            element6.setAttribute("ns", (String)defaultTableModel.getValueAt(n2, 0));
            element6.setAttribute("name", (String)defaultTableModel.getValueAt(n2, 2));
            element5.appendChild(element6);
            ++n2;
        }
        this.inodes2UniqueIDs = new Hashtable();
        this.nextUniqueID = new StringBuffer("0");
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            this.inodes2UniqueIDs.put(enumeration.nextElement(), this.nextUniqueID.toString());
            this.incPrjID();
        }
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            this.inodes2UniqueIDs.put(enumeration2.nextElement(), this.nextUniqueID.toString());
            this.incPrjID();
        }
        Element element7 = document.createElementNS(Editor.isavizURI, "isv:colorTable");
        element.appendChild(element7);
        int n3 = 0;
        while (n3 < ConfigManager.colors.length) {
            Element element8 = document.createElementNS(Editor.isavizURI, "isv:color");
            element8.setAttribute("r", Integer.toString(ConfigManager.colors[n3].getRed()));
            element8.setAttribute("g", Integer.toString(ConfigManager.colors[n3].getGreen()));
            element8.setAttribute("b", Integer.toString(ConfigManager.colors[n3].getBlue()));
            element7.appendChild(element8);
            ++n3;
        }
        Element element9 = document.createElementNS(Editor.isavizURI, "isv:fontTable");
        element.appendChild(element9);
        Hashtable hashtable = new Hashtable();
        Vector<Font> vector = new Vector<Font>();
        vector.add(Editor.vtmFont);
        Element element10 = document.createElementNS(Editor.isavizURI, "isv:resources");
        element.appendChild(element10);
        Enumeration enumeration3 = this.application.resourcesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            object2 = (IResource)enumeration3.nextElement();
            element10.appendChild(((IResource)object2).toISV(document, this, hashtable, file, vector));
        }
        object2 = document.createElementNS(Editor.isavizURI, "isv:literals");
        element.appendChild((Node)object2);
        Enumeration enumeration4 = this.application.literals.elements();
        while (enumeration4.hasMoreElements()) {
            object2.appendChild(((ILiteral)enumeration4.nextElement()).toISV(document, this, hashtable, file, vector));
        }
        hashtable.clear();
        img_subdir = null;
        Element element11 = document.createElementNS(Editor.isavizURI, "isv:properties");
        element.appendChild(element11);
        Enumeration enumeration5 = this.application.propertiesByURI.elements();
        while (enumeration5.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration5.nextElement();
            object = vector2.elements();
            while (object.hasMoreElements()) {
                element11.appendChild(((IProperty)object.nextElement()).toISV(document, this, vector));
            }
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            object = document.createElementNS(Editor.isavizURI, "isv:font");
            object.setAttribute("desc", Utils.encodeFont((Font)vector.elementAt(n4)));
            element9.appendChild((Node)object);
            ++n4;
        }
        vector.removeAllElements();
        this.inodes2UniqueIDs.clear();
        this.inodes2UniqueIDs = null;
        this.application.xmlMngr.serialize(document, file);
        Editor.vsm.getView("Graph").setStatusBarText("Saving project to " + file.toString() + " ...done");
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        Editor.vsm.getView("Graph").setCursorIcon(-1);
    }

    protected String getPrjId(Object object) {
        return (String)this.inodes2UniqueIDs.get(object);
    }

    private void incPrjID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextUniqueID.length()) {
            by = (byte)this.nextUniqueID.charAt(n);
            if (by < 122) {
                this.nextUniqueID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextUniqueID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextUniqueID.length()) {
                this.nextUniqueID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextUniqueID.append('0');
        }
    }

    /*
     * Unable to fully structure code
     */
    IResource createIResourceFromISV(Element var1_1) {
        block35: {
            block36: {
                var2_2 = null;
                var3_3 = false;
                if (var1_1.hasAttribute("isAnon")) {
                    var3_3 = new Boolean(var1_1.getAttribute("isAnon"));
                }
                var4_4 = true;
                if (var1_1.hasAttribute("display")) {
                    var4_4 = var1_1.getAttribute("display").equals("false") == false;
                }
                var5_5 = 0L;
                var7_6 = 0L;
                var9_7 = null;
                var10_8 = var1_1.getElementsByTagNameNS(Editor.isavizURI, "URIorID");
                if (var10_8.getLength() <= 0) break block36;
                var11_9 = (Element)var10_8.item(0);
                if (var4_4) {
                    var5_5 = new Long(var11_9.getAttribute("x"));
                    var7_6 = new Long(var11_9.getAttribute("y"));
                }
                if (var3_3) {
                    var12_12 = null;
                    if (var11_9.getElementsByTagNameNS(Editor.isavizURI, "anonID").getLength() > 0) {
                        var12_12 = Editor.ANON_NODE + var11_9.getElementsByTagNameNS(Editor.isavizURI, "anonID").item(0).getFirstChild().getNodeValue();
                    }
                    var2_2 = this.application.addAnonymousResource(var12_12);
                } else if (var11_9.getElementsByTagNameNS(Editor.isavizURI, "uri").getLength() > 0) {
                    var13_13 = false;
                    try {
                        var14_17 = (Element)var11_9.getElementsByTagNameNS(Editor.isavizURI, "uri").item(0);
                        var12_12 = var14_17.getFirstChild().getNodeValue();
                        if (var14_17.hasAttribute("fID")) {
                            var13_13 = Boolean.valueOf(var14_17.getAttribute("fID"));
                        }
                    }
                    catch (NullPointerException var14_18) {
                        var12_12 = "";
                    }
                    var2_2 = this.application.addResource(var12_12);
                    var2_2.setURIFragment(var13_13);
                } else {
                    try {
                        var12_12 = var11_9.getElementsByTagNameNS(Editor.isavizURI, "namespace").item(0).getFirstChild().getNodeValue();
                    }
                    catch (NullPointerException var14_19) {
                        var12_12 = Editor.BASE_URI;
                    }
                    try {
                        var13_14 = var11_9.getElementsByTagNameNS(Editor.isavizURI, "localname").item(0).getFirstChild().getNodeValue();
                    }
                    catch (NullPointerException var14_20) {
                        var13_14 = "";
                    }
                    var2_2 = this.application.addResource(var12_12 + var13_14);
                }
                var9_7 = var2_2.getGraphLabel();
                var13_15 = 0;
                if (true) ** GOTO lbl61
                do {
                    var12_12 = (String)Editor.tblp.nsTableModel.getValueAt(var13_15, 1);
                    if (var9_7.startsWith(var12_12)) {
                        if (((Boolean)Editor.tblp.nsTableModel.getValueAt(var13_15, 2)).booleanValue()) {
                            var9_7 = (String)Editor.tblp.nsTableModel.getValueAt(var13_15, 0) + ":" + var9_7.substring(var12_12.length(), var9_7.length());
                        }
                        break block35;
                    }
                    ++var13_15;
lbl61:
                    // 2 sources

                } while (var13_15 < Editor.tblp.nsTableModel.getRowCount());
                break block35;
            }
            var2_2 = new IResource();
        }
        if (var4_4) {
            var11_10 = new Long(var1_1.getAttribute("x"));
            var13_16 = new Long(var1_1.getAttribute("y"));
            var15_21 = null;
            var16_22 = var1_1.getAttribute("shape");
            if (var16_22.length() > 0) {
                var15_21 = ISVManager.buildShape(var16_22.trim(), var1_1, true, var11_10, var13_16);
            } else {
                var17_23 = new Long(var1_1.getAttribute("w"));
                var19_25 = new Long(var1_1.getAttribute("h"));
                var15_21 = new VEllipse(var11_10, var13_16, 0.0f, var17_23, var19_25, ConfigManager.resourceColorF);
            }
            Editor.vsm.addGlyph(var15_21, "rdfSpace");
            var2_2.setGlyph(var15_21);
            var17_24 = null;
            if (var9_7 != null) {
                var17_24 = new VText(var5_5, var7_6, 0.0f, ConfigManager.resourceColorTB, var9_7);
                Editor.vsm.addGlyph((Glyph)var17_24, "rdfSpace");
                var2_2.setGlyphText(var17_24);
            }
            if (var1_1.hasAttribute("fill")) {
                var18_26 = Integer.parseInt(var1_1.getAttribute("fill"));
                var2_2.setFillColor(var18_26);
            } else {
                var2_2.setFillColor(ConfigManager.defaultRFIndex);
            }
            if (var1_1.hasAttribute("stroke")) {
                var18_26 = Integer.parseInt(var1_1.getAttribute("stroke"));
                var2_2.setStrokeColor(var18_26);
            } else {
                var2_2.setStrokeColor(ConfigManager.defaultRTBIndex);
            }
            if (var1_1.hasAttribute("stroke-width")) {
                var18_27 = Float.parseFloat(var1_1.getAttribute("stroke-width"));
                if (var1_1.hasAttribute("stroke-dasharray")) {
                    ConfigManager.assignStrokeToGlyph(var18_27, var1_1.getAttribute("stroke-dasharray").trim(), var15_21);
                } else {
                    ConfigManager.assignStrokeToGlyph(var15_21, var18_27);
                }
            } else if (var1_1.hasAttribute("stroke-dasharray")) {
                ConfigManager.assignStrokeToGlyph(1.0f, var1_1.getAttribute("stroke-dasharray").trim(), var15_21);
            }
            if (var17_24 != null && var1_1.hasAttribute("font")) {
                var18_28 = Integer.parseInt(var1_1.getAttribute("font"));
                var17_24.setSpecialFont((Font)this.fonts.elementAt(var18_28));
            }
            if (var1_1.hasAttribute("text-align")) {
                var2_2.setTextAlign(Integer.parseInt(var1_1.getAttribute("text-align")));
            }
            if (var1_1.hasAttribute("table")) {
                var2_2.setTableFormLayout(new Boolean(var1_1.getAttribute("table")));
            }
        }
        this.uniqueIDs2INodes.put(var1_1.getAttribute("id"), var2_2);
        if (var1_1.hasAttribute("commented") && (var11_11 = new Boolean(var1_1.getAttribute("commented")).booleanValue())) {
            this.application.commentNode(var2_2, true);
        }
        return var2_2;
    }

    ILiteral createILiteralFromISV(Element element) {
        boolean bl;
        ILiteral iLiteral = null;
        boolean bl2 = true;
        if (element.hasAttribute("display")) {
            bl2 = !element.getAttribute("display").equals("false");
        }
        boolean bl3 = true;
        if (element.hasAttribute("escapeXML")) {
            bl3 = new Boolean(element.getAttribute("escapeXML"));
        }
        long l = 0L;
        long l2 = 0L;
        String string = "";
        NodeList nodeList = element.getElementsByTagNameNS(Editor.isavizURI, "value");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            if (bl2) {
                l = new Long(element2.getAttribute("x"));
                l2 = new Long(element2.getAttribute("y"));
            }
            String string2 = "";
            if (element2.getFirstChild() != null) {
                string2 = element2.getFirstChild().getNodeValue();
            }
            string = string2.length() >= Editor.MAX_LIT_CHAR_COUNT ? string2.substring(0, Editor.MAX_LIT_CHAR_COUNT) + " ..." : string2;
            iLiteral = this.application.addLiteral(string2, null, bl3);
        } else {
            iLiteral = this.application.addLiteral("", null, true);
        }
        if (bl2) {
            int n;
            long l3 = new Long(element.getAttribute("x"));
            long l4 = new Long(element.getAttribute("y"));
            Glyph glyph = null;
            String string3 = element.getAttribute("shape");
            if (string3.length() > 0) {
                glyph = ISVManager.buildShape(string3.trim(), element, false, l3, l4);
            } else {
                long l5 = new Long(element.getAttribute("w"));
                long l6 = new Long(element.getAttribute("h"));
                glyph = new VRectangle(l3, l4, 0.0f, l5, l6, ConfigManager.literalColorF);
            }
            Editor.vsm.addGlyph(glyph, "rdfSpace");
            iLiteral.setGlyph(glyph);
            VText vText = null;
            if (string != null && string.length() > 0) {
                vText = new VText(l, l2, 0.0f, ConfigManager.literalColorTB, string);
                Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
                iLiteral.setGlyphText(vText);
            }
            if (element.hasAttribute("fill")) {
                n = Integer.parseInt(element.getAttribute("fill"));
                iLiteral.setFillColor(n);
            } else {
                iLiteral.setFillColor(ConfigManager.defaultLFIndex);
            }
            if (element.hasAttribute("stroke")) {
                n = Integer.parseInt(element.getAttribute("stroke"));
                iLiteral.setStrokeColor(n);
            } else {
                iLiteral.setStrokeColor(ConfigManager.defaultLTBIndex);
            }
            if (element.hasAttribute("stroke-width")) {
                float f = Float.parseFloat(element.getAttribute("stroke-width"));
                if (element.hasAttribute("stroke-dasharray")) {
                    ConfigManager.assignStrokeToGlyph(f, element.getAttribute("stroke-dasharray").trim(), glyph);
                } else {
                    ConfigManager.assignStrokeToGlyph(glyph, f);
                }
            } else if (element.hasAttribute("stroke-dasharray")) {
                ConfigManager.assignStrokeToGlyph(1.0f, element.getAttribute("stroke-dasharray").trim(), glyph);
            }
            if (vText != null && element.hasAttribute("font")) {
                int n2 = Integer.parseInt(element.getAttribute("font"));
                vText.setSpecialFont((Font)this.fonts.elementAt(n2));
            }
            if (element.hasAttribute("text-align")) {
                iLiteral.setTextAlign(Integer.parseInt(element.getAttribute("text-align")));
            }
            if (element.hasAttribute("table")) {
                iLiteral.setTableFormLayout(new Boolean(element.getAttribute("table")));
            }
        }
        if (element.hasAttribute("dtURI")) {
            iLiteral.setDatatype(element.getAttribute("dtURI"));
        }
        if (element.hasAttribute("xml:lang")) {
            iLiteral.setLanguage(element.getAttribute("xml:lang"));
        } else if (element.hasAttribute("lang")) {
            iLiteral.setLanguage(element.getAttribute("lang"));
        }
        this.uniqueIDs2INodes.put(element.getAttribute("id"), iLiteral);
        if (element.hasAttribute("commented") && (bl = new Boolean(element.getAttribute("commented")).booleanValue())) {
            this.application.commentNode(iLiteral, true);
        }
        return iLiteral;
    }

    /*
     * Unable to fully structure code
     */
    IProperty createIPropertyFromISV(Element var1_1) {
        block38: {
            block37: {
                var2_2 = null;
                var3_3 = true;
                if (var1_1.hasAttribute("display")) {
                    var3_3 = var1_1.getAttribute("display").equals("false") == false;
                }
                var4_4 = var1_1.getElementsByTagNameNS(Editor.isavizURI, "uri");
                var5_5 = "";
                var6_6 = "";
                var7_7 = 0L;
                var9_8 = 0L;
                var11_9 = null;
                if (var4_4.getLength() <= 0) break block37;
                var12_10 = (Element)var4_4.item(0);
                var5_5 = var12_10.getElementsByTagNameNS(Editor.isavizURI, "namespace").item(0).getFirstChild().getNodeValue();
                var6_6 = var12_10.getElementsByTagNameNS(Editor.isavizURI, "localname").item(0).getFirstChild().getNodeValue();
                if (var3_3) {
                    var7_7 = new Long(var12_10.getAttribute("x"));
                    var9_8 = new Long(var12_10.getAttribute("y"));
                }
                var13_11 = false;
                var14_13 = 0;
                if (true) ** GOTO lbl30
                do {
                    if (((String)Editor.tblp.nsTableModel.getValueAt(var14_13, 1)).equals(var5_5)) {
                        var11_9 = ((Boolean)Editor.tblp.nsTableModel.getValueAt(var14_13, 2)).booleanValue() ? (String)Editor.tblp.nsTableModel.getValueAt(var14_13, 0) + ":" + var6_6 : var5_5 + var6_6;
                        var13_11 = true;
                        break;
                    }
                    ++var14_13;
lbl30:
                    // 2 sources

                } while (var14_13 < Editor.tblp.nsTableModel.getRowCount());
                if (!var13_11) {
                    var11_9 = var5_5 + var6_6;
                }
                var2_2 = this.application.addProperty(var5_5, var6_6);
                break block38;
            }
            var2_2 = new IProperty();
        }
        var12_10 = (IResource)this.uniqueIDs2INodes.get(var1_1.getAttribute("sb"));
        var2_2.setSubject((IResource)var12_10);
        var12_10.addOutgoingPredicate(var2_2);
        var13_12 = this.uniqueIDs2INodes.get(var1_1.getAttribute("ob"));
        if (var13_12 instanceof IResource) {
            var14_14 = (IResource)var13_12;
            var2_2.setObject((IResource)var14_14);
            var14_14.addIncomingPredicate(var2_2);
        } else {
            var14_14 = (ILiteral)var13_12;
            var2_2.setObject((ILiteral)var14_14);
            var14_14.setIncomingPredicate(var2_2);
            if (var2_2.getIdent().equals(Editor.RDFS_NAMESPACE_URI + "label")) {
                var12_10.setLabel(var14_14.getValue());
            }
        }
        if (var3_3) {
            if (var1_1.hasAttribute("table")) {
                var2_2.setTableFormLayout(new Boolean(var1_1.getAttribute("table")));
                if (var2_2.isLaidOutInTableForm()) {
                    if (this.subject2sharededge.containsKey(var2_2.getSubject())) {
                        var14_14 = (Vector)this.subject2sharededge.get(var2_2.getSubject());
                        var15_16 = (VPath)var14_14.elementAt(0);
                        var2_2.setGlyph(var15_16, null);
                    } else {
                        var14_14 = ISVManager.buildEdge(var1_1);
                        var15_16 = (VPath)var14_14.elementAt(0);
                        Editor.vsm.addGlyph((Glyph)var15_16, "rdfSpace");
                        var2_2.setGlyph(var15_16, null);
                        this.subject2sharededge.put(var2_2.getSubject(), var14_14);
                    }
                } else {
                    var14_14 = ISVManager.buildEdge(var1_1);
                    var15_16 = (VPath)var14_14.elementAt(0);
                    Editor.vsm.addGlyph((Glyph)var15_16, "rdfSpace");
                    var16_21 = null;
                    if (var14_14.size() >= 2) {
                        var16_21 = (VTriangleOr)var14_14.elementAt(1);
                        Editor.vsm.addGlyph((Glyph)var16_21, "rdfSpace");
                    }
                    var2_2.setGlyph(var15_16, var16_21);
                }
            } else {
                var14_14 = ISVManager.buildEdge(var1_1);
                var15_16 = (VPath)var14_14.elementAt(0);
                Editor.vsm.addGlyph((Glyph)var15_16, "rdfSpace");
                var16_21 = null;
                if (var14_14.size() >= 2) {
                    var16_21 = (VTriangleOr)var14_14.elementAt(1);
                    Editor.vsm.addGlyph((Glyph)var16_21, "rdfSpace");
                }
                var2_2.setGlyph(var15_16, var16_21);
            }
            var14_14 = null;
            if (var11_9 != null) {
                if (var2_2.isLaidOutInTableForm()) {
                    if (var2_2.getObject() instanceof IResource) {
                        var14_14 = new VText(var7_7, var9_8, 0.0f, ConfigManager.resourceColorTB, var11_9);
                        var2_2.textIndex = ConfigManager.defaultRTBIndex;
                    } else {
                        var14_14 = new VText(var7_7, var9_8, 0.0f, ConfigManager.literalColorTB, var11_9);
                        var2_2.textIndex = ConfigManager.defaultLTBIndex;
                    }
                } else {
                    var14_14 = new VText(var7_7, var9_8, 0.0f, ConfigManager.propertyColorT, var11_9);
                    var2_2.textIndex = ConfigManager.defaultPTIndex;
                }
                var2_2.setGlyphText((VText)var14_14);
            }
            if (var1_1.hasAttribute("stroke")) {
                var15_17 = Integer.parseInt(var1_1.getAttribute("stroke"));
                var2_2.setStrokeColor(var15_17);
                if (!var2_2.isLaidOutInTableForm()) {
                    var2_2.setTextColor(var15_17);
                }
            } else {
                var2_2.setStrokeColor(ConfigManager.defaultPBIndex);
            }
            if (var1_1.hasAttribute("stroke-width")) {
                var15_18 = Float.parseFloat(var1_1.getAttribute("stroke-width"));
                if (var1_1.hasAttribute("stroke-dasharray")) {
                    ConfigManager.assignStrokeToGlyph(var15_18, var1_1.getAttribute("stroke-dasharray").trim(), var2_2.getGlyph());
                } else {
                    ConfigManager.assignStrokeToGlyph(var2_2.getGlyph(), var15_18);
                }
            } else if (var1_1.hasAttribute("stroke-dasharray")) {
                ConfigManager.assignStrokeToGlyph(1.0f, var1_1.getAttribute("stroke-dasharray").trim(), var2_2.getGlyph());
            }
            if (var14_14 != null && var1_1.hasAttribute("font")) {
                var15_19 = Integer.parseInt(var1_1.getAttribute("font"));
                var14_14.setSpecialFont((Font)this.fonts.elementAt(var15_19));
            }
            if (var1_1.hasAttribute("text-align")) {
                var2_2.setTextAlign(Integer.parseInt(var1_1.getAttribute("text-align")));
            }
            if (var2_2.isLaidOutInTableForm() && var1_1.getElementsByTagNameNS(Editor.isavizURI, "cell").getLength() > 0) {
                var15_20 = (Element)var1_1.getElementsByTagNameNS(Editor.isavizURI, "cell").item(0);
                var16_22 = new Long(var15_20.getAttribute("x"));
                var18_23 = new Long(var15_20.getAttribute("y"));
                var20_24 = new Long(var15_20.getAttribute("w"));
                var22_25 = new Long(var15_20.getAttribute("h"));
                var24_26 = new VRectangle(var16_22, var18_23, 0.0f, var20_24, var22_25, Color.white);
                Editor.vsm.addGlyph((Glyph)var24_26, "rdfSpace");
                var2_2.setTableCellGlyph(var24_26);
                if (var1_1.hasAttribute("fill")) {
                    var25_27 = Integer.parseInt(var1_1.getAttribute("fill"));
                    var2_2.setCellFillColor(var25_27);
                }
                if (var1_1.hasAttribute("tstroke")) {
                    var25_27 = Integer.parseInt(var1_1.getAttribute("tstroke"));
                    var2_2.setTextColor(var25_27);
                }
            }
            if (var14_14 != null) {
                Editor.vsm.addGlyph((Glyph)var14_14, "rdfSpace");
            }
        }
        if (var1_1.hasAttribute("commented") && (var14_15 = new Boolean(var1_1.getAttribute("commented")).booleanValue())) {
            this.application.commentPredicate(var2_2, true);
        }
        return var2_2;
    }

    public static Glyph buildShape(String string, Element element, boolean bl, long l, long l2) {
        Object object;
        block45: {
            object = null;
            if (string.startsWith("[") && string.endsWith("]")) {
                float[] fArray = Style.parseCustomShape(string);
                if (fArray != null) {
                    try {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        float f2 = Float.parseFloat(element.getAttribute("or"));
                        object = new VShape(l, l2, 0.0f, (long)f, fArray, ConfigManager.resourceColorF, f2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (bl) {
                            object = new VEllipse(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.resourceColorF);
                            break block45;
                        }
                        object = new VRectangle(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.literalColorF);
                    }
                } else {
                    object = bl ? new VEllipse(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.resourceColorF) : new VRectangle(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.literalColorF);
                }
            } else if (string.startsWith("{") && string.endsWith("}")) {
                float[] fArray = Style.parseCustomPolygon(string);
                if (fArray != null) {
                    LongPoint[] longPointArray = new LongPoint[fArray.length / 2];
                    int n = 0;
                    while (n < longPointArray.length) {
                        longPointArray[n] = new LongPoint((long)fArray[2 * n], (long)fArray[2 * n + 1]);
                        ++n;
                    }
                    object = new VPolygon(longPointArray, Color.white);
                } else {
                    object = bl ? new VEllipse(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.resourceColorF) : new VRectangle(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.literalColorF);
                }
            } else if (string.equals("icon")) {
                File file = new File(Editor.projectFile.getParent(), element.getAttributeNS("http://www.w3.org/1999/xlink", "href"));
                if (file.exists()) {
                    try {
                        ImageIcon imageIcon = new ImageIcon(file.toURL());
                        if (imageIcon != null) {
                            object = new VImage(l, l2, 0.0f, imageIcon.getImage());
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("ISVManager.openProject()/buildShape():Error: failed to instantiate bitmap image file " + file.toString());
                        malformedURLException.printStackTrace();
                    }
                } else {
                    System.err.println("ISVManager.openProject()/buildShape():Error: failed to instantiate bitmap image file " + file.toString());
                }
                long l3 = new Long(element.getAttribute("w"));
                long l4 = new Long(element.getAttribute("h"));
                if (object != null) {
                    ((VImage)object).setDrawBorderPolicy(VImage.DRAW_BORDER_ALWAYS);
                    RectangularShape rectangularShape = (RectangularShape)object;
                    if (rectangularShape.getWidth() >= rectangularShape.getHeight()) {
                        rectangularShape.setWidth(l3);
                    } else {
                        rectangularShape.setHeight(l4);
                    }
                } else {
                    object = new VRectangle(l, l2, 0.0f, l3, l4, Color.white);
                }
            } else {
                try {
                    Integer n = new Integer(string);
                    if (n.equals(Style.ELLIPSE)) {
                        long l5 = new Long(element.getAttribute("w"));
                        long l6 = new Long(element.getAttribute("h"));
                        object = new VEllipse(l, l2, 0.0f, l5, l6, ConfigManager.resourceColorF);
                    } else if (n.equals(Style.RECTANGLE)) {
                        long l7 = new Long(element.getAttribute("w"));
                        long l8 = new Long(element.getAttribute("h"));
                        object = new VRectangle(l, l2, 0.0f, l7, l8, ConfigManager.resourceColorF);
                    } else if (n.equals(Style.ROUND_RECTANGLE)) {
                        long l9 = new Long(element.getAttribute("w"));
                        long l10 = new Long(element.getAttribute("h"));
                        object = new VRoundRect(l, l2, 0.0f, l9, l10, ConfigManager.resourceColorF, Math.round(SVGReader.RRARCR * (float)Math.min(l9, l10)), Math.round(SVGReader.RRARCR * (float)Math.min(l9, l10)));
                    } else if (n.equals(Style.CIRCLE)) {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        object = new VCircle(l, l2, 0.0f, (long)f, ConfigManager.resourceColorF);
                    } else if (n.equals(Style.DIAMOND)) {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        object = new VDiamond(l, l2, 0.0f, (long)f, ConfigManager.resourceColorF);
                    } else if (n.equals(Style.OCTAGON)) {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        object = new VOctagon(l, l2, 0.0f, (long)f, ConfigManager.resourceColorF);
                    } else if (n.equals(Style.TRIANGLEN)) {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        object = new VTriangleOr(l, l2, 0.0f, (long)f, ConfigManager.resourceColorF, 0.0f);
                    } else if (n.equals(Style.TRIANGLES)) {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        object = new VTriangleOr(l, l2, 0.0f, (long)f, ConfigManager.resourceColorF, (float)Math.PI);
                    } else if (n.equals(Style.TRIANGLEE)) {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        object = new VTriangleOr(l, l2, 0.0f, (long)f, ConfigManager.resourceColorF, -1.5707964f);
                    } else if (n.equals(Style.TRIANGLEW)) {
                        float f = Float.parseFloat(element.getAttribute("sz"));
                        object = new VTriangleOr(l, l2, 0.0f, (long)f, ConfigManager.resourceColorF, 1.5707964f);
                    } else {
                        long l11 = new Long(element.getAttribute("w"));
                        long l12 = new Long(element.getAttribute("h"));
                        object = new VEllipse(l, l2, 0.0f, l11, l12, ConfigManager.resourceColorF);
                    }
                }
                catch (Exception exception) {
                    object = bl ? new VEllipse(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.resourceColorF) : new VRectangle(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.literalColorF);
                }
            }
        }
        return object;
    }

    public static Vector buildEdge(Element element) {
        Vector<Object> vector = new Vector<Object>();
        Element element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "path").item(0);
        String string = element2.getAttribute("d");
        VPath vPath = new VPath(0.0f, ConfigManager.propertyColorB, string);
        vector.add(vPath);
        if (element.getElementsByTagNameNS(Editor.isavizURI, "head").getLength() > 0) {
            Element element3 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "head").item(0);
            long l = new Long(element3.getAttribute("x"));
            long l2 = new Long(element3.getAttribute("y"));
            long l3 = new Long(element3.getAttribute("w"));
            float f = new Float(element3.getAttribute("or")).floatValue();
            VTriangleOr vTriangleOr = new VTriangleOr(l, l2, 0.0f, l3, ConfigManager.propertyColorB, f);
            vector.add(vTriangleOr);
        }
        return vector;
    }
}

