/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.Resource;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VPolygon;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRoundRect;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangle;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.ISVManager;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class IResource
extends INode {
    Vector incomingPredicates;
    Vector outgoingPredicates;
    private boolean anonymous = false;
    private String anonymousID;
    private String uri;
    private boolean fragmentID = false;
    private String label;
    String mapID;
    Glyph gl1;
    VText gl2;

    public static String getJenaAnonId(AnonId anonId) {
        StringBuffer stringBuffer = new StringBuffer(anonId.toString());
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '-') {
                stringBuffer.delete(0, n + 1);
                break;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public IResource(Resource resource) {
        this.fillIndex = ConfigManager.defaultRFIndex;
        this.strokeIndex = ConfigManager.defaultRTBIndex;
        try {
            if (resource.isAnon()) {
                this.anonymous = true;
                this.anonymousID = Editor.ANON_NODE + IResource.getJenaAnonId(resource.getId());
                this.fragmentID = false;
            } else {
                this.anonymous = false;
                this.uri = resource.getURI();
                if (this.uri.startsWith(Editor.BASE_URI)) {
                    this.setURIFragment(true);
                }
            }
        }
        catch (RDFException rDFException) {
            System.err.println("Error: IResouce(Resource - Jena): " + (Object)((Object)rDFException));
        }
    }

    public IResource() {
        this.fillIndex = ConfigManager.defaultRFIndex;
        this.strokeIndex = ConfigManager.defaultRTBIndex;
    }

    void setURI(String string) {
        this.uri = string;
    }

    void setURIFragment(boolean bl) {
        this.fragmentID = bl;
    }

    boolean isURIFragment() {
        return this.fragmentID;
    }

    void setAnonymousID(String string) {
        this.anonymousID = string;
    }

    boolean isAnon() {
        return this.anonymous;
    }

    void setAnon(boolean bl) {
        this.anonymous = bl;
    }

    public String getIdentity() {
        if (this.anonymous) {
            return this.anonymousID;
        }
        return this.uri;
    }

    public String getGraphLabel() {
        if (this.anonymous) {
            return this.anonymousID;
        }
        try {
            String string = this.uri;
            if (this.fragmentID && string.startsWith(Editor.BASE_URI)) {
                string = string.substring(Editor.BASE_URI.length());
            }
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public void setLabel(String string) {
        this.label = string.length() == 0 ? null : string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setMapID(String string) {
        this.mapID = string;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void addIncomingPredicate(IProperty iProperty) {
        if (this.incomingPredicates == null) {
            this.incomingPredicates = new Vector();
            this.incomingPredicates.add(iProperty);
        } else if (!this.incomingPredicates.contains(iProperty)) {
            this.incomingPredicates.add(iProperty);
        }
    }

    public void removeIncomingPredicate(IProperty iProperty) {
        if (this.incomingPredicates != null && this.incomingPredicates.contains(iProperty)) {
            this.incomingPredicates.remove(iProperty);
            if (this.incomingPredicates.isEmpty()) {
                this.incomingPredicates = null;
            }
        }
    }

    public Vector getIncomingPredicates() {
        return this.incomingPredicates;
    }

    public void addOutgoingPredicate(IProperty iProperty) {
        if (this.outgoingPredicates == null) {
            this.outgoingPredicates = new Vector();
            this.outgoingPredicates.add(iProperty);
        } else if (!this.outgoingPredicates.contains(iProperty)) {
            this.outgoingPredicates.add(iProperty);
        }
    }

    public void removeOutgoingPredicate(IProperty iProperty) {
        if (this.outgoingPredicates != null && this.outgoingPredicates.contains(iProperty)) {
            this.outgoingPredicates.remove(iProperty);
            if (this.outgoingPredicates.isEmpty()) {
                this.outgoingPredicates = null;
            }
        }
    }

    public Vector getOutgoingPredicates() {
        return this.outgoingPredicates;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.isVisuallyRepresented()) {
            if (this.selected) {
                this.gl1.setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
                this.gl1.setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
                VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
                virtualSpace.onTop(this.gl1);
                virtualSpace.onTop((Glyph)this.gl2);
            } else if (this.commented) {
                this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            } else {
                this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
                this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl2 != null) {
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                }
            }
        }
    }

    public void comment(boolean bl, Editor editor) {
        block12: {
            int n;
            block11: {
                int n2;
                this.commented = bl;
                if (!this.commented) break block11;
                if (this.isVisuallyRepresented()) {
                    this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                    this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    if (this.gl2 != null) {
                        this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                }
                if (this.incomingPredicates != null) {
                    n2 = 0;
                    while (n2 < this.incomingPredicates.size()) {
                        editor.commentPredicate((IProperty)this.incomingPredicates.elementAt(n2), true);
                        ++n2;
                    }
                }
                if (this.outgoingPredicates == null) break block12;
                n2 = 0;
                while (n2 < this.outgoingPredicates.size()) {
                    editor.commentPredicate((IProperty)this.outgoingPredicates.elementAt(n2), true);
                    ++n2;
                }
                break block12;
            }
            if (this.isVisuallyRepresented()) {
                this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
                this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl2 != null) {
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                }
            }
            if (this.incomingPredicates != null) {
                n = 0;
                while (n < this.incomingPredicates.size()) {
                    editor.commentPredicate((IProperty)this.incomingPredicates.elementAt(n), false);
                    ++n;
                }
            }
            if (this.outgoingPredicates != null) {
                n = 0;
                while (n < this.outgoingPredicates.size()) {
                    editor.commentPredicate((IProperty)this.outgoingPredicates.elementAt(n), false);
                    ++n;
                }
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.gl1 != null) {
            this.gl1.setVisible(bl);
            this.gl1.setSensitivity(bl);
        }
        if (this.gl2 != null) {
            this.gl2.setVisible(bl);
            this.gl2.setSensitivity(bl);
        }
    }

    public void setGlyph(Glyph glyph) {
        this.gl1 = glyph;
        this.gl1.setType("resG");
        this.gl1.setOwner((Object)this);
    }

    public void setGlyphText(VText vText) {
        if (vText != null) {
            this.gl2 = vText;
            this.gl2.setType("resT");
            this.gl2.setOwner((Object)this);
        } else {
            this.gl2 = null;
        }
    }

    public Glyph getGlyph() {
        return this.gl1;
    }

    public VText getGlyphText() {
        return this.gl2;
    }

    public Element toISV(Document document, ISVManager iSVManager, Hashtable hashtable, File file, Vector vector) {
        Object object;
        Element element = document.createElementNS(Editor.isavizURI, "isv:iresource");
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:URIorID");
        if (!this.anonymous) {
            object = document.createElementNS(Editor.isavizURI, "isv:uri");
            object.appendChild(document.createTextNode(this.uri));
            if (this.fragmentID) {
                object.setAttribute("fID", "true");
            }
            element2.appendChild((Node)object);
        } else if (this.anonymousID != null) {
            object = document.createElementNS(Editor.isavizURI, "isv:anonID");
            object.appendChild(document.createTextNode(Utils.erasePrefix(this.anonymousID)));
            element2.appendChild((Node)object);
        }
        element.appendChild(element2);
        if (this.isVisuallyRepresented()) {
            element.setAttribute("display", "true");
            if (this.table) {
                element.setAttribute("table", "true");
            }
            if (this.gl2 != null) {
                element2.setAttribute("x", String.valueOf(this.gl2.vx));
                element2.setAttribute("y", String.valueOf(this.gl2.vy));
            }
            element.setAttribute("x", String.valueOf(this.gl1.vx));
            element.setAttribute("y", String.valueOf(this.gl1.vy));
            element.setAttribute("fill", String.valueOf(this.fillIndex));
            element.setAttribute("stroke", String.valueOf(this.strokeIndex));
            if (this.gl1.getStroke() != null) {
                if (this.gl1.getStroke().getLineWidth() != Glyph.DEFAULT_STROKE_WIDTH) {
                    element.setAttribute("stroke-width", String.valueOf(this.gl1.getStroke().getLineWidth()));
                }
                if (this.gl1.getStroke().getDashArray() != null) {
                    element.setAttribute("stroke-dasharray", Utils.arrayOffloatAsCSStrings(this.gl1.getStroke().getDashArray()));
                }
            }
            if (this.getTextAlign() != Style.TA_CENTER.intValue()) {
                element.setAttribute("text-align", String.valueOf(this.getTextAlign()));
            }
            if (this.gl1 instanceof VEllipse) {
                element.setAttribute("shape", Style.ELLIPSE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else if (this.gl1 instanceof VRectangle) {
                element.setAttribute("shape", Style.RECTANGLE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else if (this.gl1 instanceof VRoundRect) {
                element.setAttribute("shape", Style.ROUND_RECTANGLE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else if (this.gl1 instanceof VImage) {
                object = Utils.exportBitmap((VImage)this.gl1, file, hashtable);
                if (object != null) {
                    element.setAttribute("shape", "icon");
                    element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", ISVManager.img_subdir.getName() + "/" + ((File)object).getName());
                } else {
                    element.setAttribute("shape", Style.ELLIPSE.toString());
                }
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else if (this.gl1 instanceof VPolygon) {
                element.setAttribute("shape", "{" + ((VPolygon)this.gl1).getVerticesAsText() + "}");
            } else if (this.gl1 instanceof VShape) {
                element.setAttribute("shape", "[" + ((VShape)this.gl1).getVerticesAsText() + "]");
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
                element.setAttribute("or", String.valueOf(this.gl1.getOrient()));
            } else if (this.gl1 instanceof VCircle) {
                element.setAttribute("shape", Style.CIRCLE.toString());
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else if (this.gl1 instanceof VDiamond) {
                element.setAttribute("shape", Style.DIAMOND.toString());
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else if (this.gl1 instanceof VOctagon) {
                element.setAttribute("shape", Style.OCTAGON.toString());
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else if (this.gl1 instanceof VTriangle) {
                if (this.gl1.getOrient() == (float)Math.PI) {
                    element.setAttribute("shape", Style.TRIANGLES.toString());
                } else if (this.gl1.getOrient() == -1.5707964f) {
                    element.setAttribute("shape", Style.TRIANGLEE.toString());
                } else if (this.gl1.getOrient() == 1.5707964f) {
                    element.setAttribute("shape", Style.TRIANGLEW.toString());
                } else {
                    element.setAttribute("shape", Style.TRIANGLEN.toString());
                }
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else {
                element.setAttribute("shape", Style.ELLIPSE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            }
            if (this.gl2 != null) {
                int n = vector.indexOf(this.gl2.getFont());
                if (n == -1) {
                    vector.add(this.gl2.getFont());
                    n = vector.size() - 1;
                }
                if (n != 0) {
                    element.setAttribute("font", String.valueOf(n));
                }
            }
        } else {
            element.setAttribute("display", "false");
        }
        if (this.anonymous) {
            element.setAttribute("isAnon", "true");
        }
        if (this.commented) {
            element.setAttribute("commented", "true");
        }
        element.setAttribute("id", iSVManager.getPrjId(this));
        return element;
    }

    public String toString() {
        return super.toString() + " " + this.getIdentity();
    }

    public String getText() {
        return this.getIdentity() == null ? "" : this.getIdentity();
    }

    public void displayOnTop() {
        Editor.vsm.getVirtualSpace("rdfSpace").onTop(this.gl1);
        Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl2);
    }

    public void setFillColor(int n) {
        this.fillIndex = n;
        this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
    }

    public int getFillIndex() {
        return this.fillIndex;
    }

    public void setStrokeColor(int n) {
        this.strokeIndex = n;
        this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
        if (this.gl2 != null) {
            this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
        }
    }

    public int getStrokeIndex() {
        return this.strokeIndex;
    }

    public boolean hasRDFType(String string) {
        if (this.outgoingPredicates != null) {
            int n = 0;
            while (n < this.outgoingPredicates.size()) {
                IProperty iProperty = (IProperty)this.outgoingPredicates.elementAt(n);
                if (iProperty.getIdent().equals(GraphStylesheet._rdfType) && iProperty.getObject() instanceof IResource && ((IResource)iProperty.getObject()).getIdentity().equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

