/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.Property;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import java.awt.geom.PathIterator;
import java.util.Vector;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ISVManager;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class IProperty
extends INode {
    int textIndex;
    IResource subject;
    INode object;
    private String namespace = "";
    private String localname = "";
    VPath gl1;
    VTriangleOr gl2;
    VText gl3;
    VRectangle gl4;
    String mapID;

    public IProperty(Property property) {
        this.strokeIndex = ConfigManager.defaultPBIndex;
        this.textIndex = ConfigManager.defaultPTIndex;
        this.namespace = property.getNameSpace();
        this.localname = property.getLocalName();
    }

    public IProperty() {
        this.strokeIndex = ConfigManager.defaultPBIndex;
        this.textIndex = ConfigManager.defaultPTIndex;
    }

    void setNamespace(String string) {
        this.namespace = string;
    }

    void setLocalname(String string) {
        this.localname = string;
    }

    public String getIdent() {
        try {
            String string = this.namespace + this.localname;
            return string.equals("nullnull") ? null : string;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalname() {
        return this.localname;
    }

    public void setMapID(String string) {
        this.mapID = string;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void setSubject(IResource iResource) {
        this.subject = iResource;
    }

    public IResource getSubject() {
        return this.subject;
    }

    public void setObject(IResource iResource) {
        this.object = iResource;
    }

    public void setObject(ILiteral iLiteral) {
        this.object = iLiteral;
    }

    public INode getObject() {
        return this.object;
    }

    public void setSelected(boolean bl, boolean bl2) {
        super.setSelected(bl);
        if (this.isVisuallyRepresented()) {
            if (this.selected) {
                this.gl1.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
                if (this.gl3 != null) {
                    this.gl3.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
                if (bl2 && this.gl4 != null) {
                    this.gl4.setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
                    this.gl4.setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
                if (!this.table) {
                    ConfigManager.makeGlyphStrokeThicker((Glyph)this.gl1, 2.0f);
                }
                this.displayOnTop();
            } else {
                if (this.commented) {
                    this.gl1.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    if (this.gl2 != null) {
                        this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                    if (this.gl3 != null) {
                        this.gl3.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                    if (this.gl4 != null) {
                        this.gl4.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                        this.gl4.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                } else {
                    this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                    if (this.gl2 != null) {
                        this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                    }
                    if (this.gl3 != null) {
                        this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                    }
                    if (this.gl4 != null) {
                        this.gl4.setColor(ConfigManager.colors[this.fillIndex]);
                        this.gl4.setBorderColor(ConfigManager.colors[this.textIndex]);
                    }
                }
                if (!this.table) {
                    ConfigManager.makeGlyphStrokeThicker((Glyph)this.gl1, -2.0f);
                }
            }
        }
    }

    public void comment(boolean bl, Editor editor) {
        if (bl) {
            this.commented = bl;
            if (this.isVisuallyRepresented()) {
                this.gl1.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
                if (this.gl3 != null) {
                    this.gl3.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
                if (this.gl4 != null) {
                    this.gl4.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                    this.gl4.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            }
        } else if (this.subject != null) {
            if (this.object != null) {
                if (!this.subject.isCommented() && !this.object.isCommented()) {
                    this.commented = bl;
                    if (this.isVisuallyRepresented()) {
                        this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                        if (this.gl2 != null) {
                            this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                        }
                        if (this.gl3 != null) {
                            this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                        }
                        if (this.gl4 != null) {
                            this.gl4.setColor(ConfigManager.colors[this.fillIndex]);
                            this.gl4.setBorderColor(ConfigManager.colors[this.textIndex]);
                        }
                    }
                }
            } else if (!this.subject.isCommented()) {
                this.commented = bl;
                if (this.isVisuallyRepresented()) {
                    this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                    if (this.gl2 != null) {
                        this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                    }
                    if (this.gl3 != null) {
                        this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                    }
                    if (this.gl4 != null) {
                        this.gl4.setColor(ConfigManager.colors[this.fillIndex]);
                        this.gl4.setBorderColor(ConfigManager.colors[this.textIndex]);
                    }
                }
            }
        } else if (this.object != null && !this.object.isCommented()) {
            this.commented = bl;
            if (this.isVisuallyRepresented()) {
                this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl2 != null) {
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                }
                if (this.gl3 != null) {
                    this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                }
                if (this.gl4 != null) {
                    this.gl4.setColor(ConfigManager.colors[this.fillIndex]);
                    this.gl4.setBorderColor(ConfigManager.colors[this.textIndex]);
                }
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.gl1 != null) {
            this.gl1.setVisible(bl);
            this.gl1.setSensitivity(bl);
        }
        if (this.gl2 != null) {
            this.gl2.setVisible(bl);
            this.gl2.setSensitivity(bl);
        }
        if (this.gl3 != null) {
            this.gl3.setVisible(bl);
            this.gl3.setSensitivity(bl);
        }
        if (this.gl4 != null) {
            this.gl4.setVisible(bl);
            this.gl4.setSensitivity(bl);
        }
    }

    public void setGlyph(VPath vPath, VTriangleOr vTriangleOr) {
        this.gl1 = vPath;
        this.gl1.setType("prdG");
        this.gl1.setOwner((Object)this);
        this.gl2 = vTriangleOr;
        if (this.gl2 != null) {
            this.gl2.setType("prdH");
            this.gl2.setOwner((Object)this);
            this.gl2.setPaintBorder(false);
        }
    }

    protected void setGlyphHead(VTriangleOr vTriangleOr) {
        this.gl2 = vTriangleOr;
        if (this.gl2 != null) {
            this.gl2.setPaintBorder(false);
            this.gl2.setType("prdH");
            this.gl2.setOwner((Object)this);
        }
    }

    public void setGlyphText(VText vText) {
        this.gl3 = vText;
        this.gl3.setType("prdT");
        this.gl3.setOwner((Object)this);
    }

    public void setTableCellGlyph(VRectangle vRectangle) {
        this.gl4 = vRectangle;
        this.gl4.setType("prdC");
        this.gl4.setOwner((Object)this);
    }

    public Glyph getGlyph() {
        return this.gl1;
    }

    public VTriangleOr getGlyphHead() {
        return this.gl2;
    }

    public VText getGlyphText() {
        return this.gl3;
    }

    public VRectangle getTableCellGlyph() {
        return this.gl4;
    }

    public boolean isVisuallyRepresented() {
        return this.gl1 != null && this.gl1.isVisible() || this.gl4 != null && this.gl4.isVisible();
    }

    public Element toISV(Document document, ISVManager iSVManager, Vector vector) {
        Element element = document.createElementNS(Editor.isavizURI, "isv:iproperty");
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:uri");
        Element element3 = document.createElementNS(Editor.isavizURI, "isv:namespace");
        element3.appendChild(document.createTextNode(this.namespace));
        Element element4 = document.createElementNS(Editor.isavizURI, "isv:localname");
        element4.appendChild(document.createTextNode(this.localname));
        element2.appendChild(element3);
        element2.appendChild(element4);
        element.appendChild(element2);
        if (this.isVisuallyRepresented()) {
            element.setAttribute("display", "true");
            Element element5 = document.createElementNS(Editor.isavizURI, "isv:path");
            if (this.gl3 != null) {
                element2.setAttribute("x", String.valueOf(this.gl3.vx));
                element2.setAttribute("y", String.valueOf(this.gl3.vy));
                int n = vector.indexOf(this.gl3.getFont());
                if (n == -1) {
                    vector.add(this.gl3.getFont());
                    n = vector.size() - 1;
                }
                if (n != 0) {
                    element.setAttribute("font", String.valueOf(n));
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            PathIterator pathIterator = this.gl1.getJava2DPathIterator();
            float[] fArray = new float[6];
            int n = 90;
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(fArray);
                switch (n2) {
                    case 0: {
                        if (n != 77) {
                            stringBuffer.append('M');
                        } else {
                            stringBuffer.append(' ');
                        }
                        n = 77;
                        stringBuffer.append(Utils.abl2c(fArray[0]) + " " + Utils.abl2c(fArray[1]));
                        break;
                    }
                    case 1: {
                        if (n != 76) {
                            stringBuffer.append('L');
                        } else {
                            stringBuffer.append(' ');
                        }
                        n = 76;
                        stringBuffer.append(Utils.abl2c(fArray[0]) + " " + Utils.abl2c(fArray[1]));
                        break;
                    }
                    case 2: {
                        if (n != 81) {
                            stringBuffer.append('Q');
                        } else {
                            stringBuffer.append(' ');
                        }
                        n = 81;
                        stringBuffer.append(Utils.abl2c(fArray[0]) + " " + Utils.abl2c(fArray[1]) + " " + Utils.abl2c(fArray[2]) + " " + Utils.abl2c(fArray[3]));
                        break;
                    }
                    case 3: {
                        if (n != 67) {
                            stringBuffer.append('C');
                        } else {
                            stringBuffer.append(' ');
                        }
                        n = 67;
                        stringBuffer.append(Utils.abl2c(fArray[0]) + " " + Utils.abl2c(fArray[1]) + " " + Utils.abl2c(fArray[2]) + " " + Utils.abl2c(fArray[3]) + " " + Utils.abl2c(fArray[4]) + " " + Utils.abl2c(fArray[5]));
                    }
                }
                pathIterator.next();
            }
            element5.setAttribute("d", stringBuffer.toString());
            element.appendChild(element5);
            if (this.table) {
                element.setAttribute("table", "true");
                element.setAttribute("fill", String.valueOf(this.fillIndex));
                element.setAttribute("tstroke", String.valueOf(this.textIndex));
                if (this.gl4 != null) {
                    Element element6 = document.createElementNS(Editor.isavizURI, "isv:cell");
                    element6.setAttribute("x", String.valueOf(this.gl4.vx));
                    element6.setAttribute("y", String.valueOf(this.gl4.vy));
                    element6.setAttribute("w", String.valueOf(this.gl4.getWidth()));
                    element6.setAttribute("h", String.valueOf(this.gl4.getHeight()));
                    element.appendChild(element6);
                }
            } else if (this.gl2 != null) {
                Element element7 = document.createElementNS(Editor.isavizURI, "isv:head");
                element7.setAttribute("x", String.valueOf(this.gl2.vx));
                element7.setAttribute("y", String.valueOf(this.gl2.vy));
                element7.setAttribute("w", Utils.abl2c(String.valueOf(this.gl2.getSize())));
                element7.setAttribute("or", String.valueOf(this.gl2.getOrient()));
                element.appendChild(element7);
            }
            element.setAttribute("stroke", String.valueOf(this.strokeIndex));
            if (this.gl1.getStroke() != null) {
                if (this.gl1.getStroke().getLineWidth() != Glyph.DEFAULT_STROKE_WIDTH) {
                    element.setAttribute("stroke-width", String.valueOf(this.gl1.getStroke().getLineWidth()));
                }
                if (this.gl1.getStroke().getDashArray() != null) {
                    element.setAttribute("stroke-dasharray", Utils.arrayOffloatAsCSStrings(this.gl1.getStroke().getDashArray()));
                }
            }
            if (this.gl1.getStrokeWidth() != 1.0f) {
                // empty if block
            }
            if (this.getTextAlign() != Style.TA_CENTER.intValue()) {
                element.setAttribute("text-align", String.valueOf(this.getTextAlign()));
            }
        } else {
            element.setAttribute("display", "false");
        }
        if (this.subject != null) {
            element.setAttribute("sb", iSVManager.getPrjId(this.subject));
        }
        if (this.object != null) {
            element.setAttribute("ob", iSVManager.getPrjId(this.object));
        }
        if (this.commented) {
            element.setAttribute("commented", "true");
        }
        return element;
    }

    public String toString() {
        return super.toString() + " " + this.getIdent();
    }

    public String getText() {
        return this.getIdent() != null ? this.getIdent() : "";
    }

    public void displayOnTop() {
        if (this.gl4 != null) {
            Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl4);
        }
        Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl1);
        if (this.gl2 != null) {
            Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl2);
        }
        if (this.gl3 != null) {
            Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl3);
        }
    }

    public void setTextColor(int n) {
        this.textIndex = n;
        if (this.gl3 != null) {
            this.gl3.setColor(ConfigManager.colors[this.textIndex]);
        }
        if (this.gl4 != null) {
            this.gl4.setBorderColor(ConfigManager.colors[this.textIndex]);
        }
    }

    public int getTextIndex() {
        return this.textIndex;
    }

    public void setStrokeColor(int n) {
        this.strokeIndex = n;
        this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
        if (this.gl2 != null) {
            this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
        }
    }

    public int getStrokeIndex() {
        return this.strokeIndex;
    }

    public void setCellFillColor(int n) {
        this.fillIndex = n;
        if (this.gl4 != null) {
            this.gl4.setColor(ConfigManager.colors[this.fillIndex]);
        }
    }

    public int getCellFillIndex() {
        return this.fillIndex;
    }

    public static boolean sharedPropertyArc(IProperty iProperty) {
        Vector vector;
        boolean bl = false;
        if (iProperty.getSubject() != null && (vector = iProperty.getSubject().getOutgoingPredicates()) != null) {
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty2 = (IProperty)vector.elementAt(n);
                if (iProperty2.getGlyph() == iProperty.getGlyph()) {
                    return true;
                }
                ++n;
            }
        }
        return bl;
    }

    public static Vector getAllPropertiesInSameTableAs(IProperty iProperty) {
        Vector vector;
        Vector<IProperty> vector2 = new Vector<IProperty>();
        if (iProperty.isLaidOutInTableForm() && iProperty.getSubject() != null && (vector = iProperty.getSubject().getOutgoingPredicates()) != null) {
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty2 = (IProperty)vector.elementAt(n);
                if (iProperty2.getGlyph() == iProperty.getGlyph() && iProperty2 != iProperty) {
                    vector2.add(iProperty2);
                }
                ++n;
            }
        }
        return vector2;
    }

    public static Vector getTableIncomingEdge(IProperty iProperty) {
        Vector vector;
        Vector<Object> vector2 = null;
        if (iProperty.getSubject() != null && (vector = iProperty.getSubject().getOutgoingPredicates()) != null) {
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty2 = (IProperty)vector.elementAt(n);
                if (iProperty2.getGlyph() != null && iProperty.getGlyph() == iProperty2.getGlyph()) {
                    vector2 = new Vector<Object>();
                    vector2.add(iProperty2.getGlyph());
                    vector2.add(iProperty2.getGlyphHead());
                    return vector2;
                }
                ++n;
            }
        }
        return vector2;
    }
}

