/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VPolygon;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRoundRect;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangle;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.ISVManager;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ILiteral
extends INode {
    private boolean escapeXML = true;
    private String language;
    private String value;
    private RDFDatatype datatype;
    IProperty incomingPred;
    Glyph gl1;
    VText gl2;
    String mapID;

    public ILiteral(Literal literal) {
        this.fillIndex = ConfigManager.defaultLFIndex;
        this.strokeIndex = ConfigManager.defaultLTBIndex;
        try {
            this.escapeXML = literal.getWellFormed();
            if (literal.getLanguage().length() > 0) {
                this.language = literal.getLanguage();
            }
            this.datatype = literal.getDatatype();
            this.value = literal.getLexicalForm();
        }
        catch (RDFException rDFException) {
            System.err.println("Error: ILiteral(Literal - Jena): " + (Object)((Object)rDFException));
        }
    }

    public ILiteral() {
        this.fillIndex = ConfigManager.defaultLFIndex;
        this.strokeIndex = ConfigManager.defaultLTBIndex;
    }

    void setLanguage(String string) {
        this.language = string;
    }

    public String getLang() {
        return this.language;
    }

    void setEscapeXMLChars(boolean bl) {
        this.escapeXML = bl;
    }

    public boolean escapesXMLChars() {
        return this.escapeXML;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setDatatype(String string) {
        this.datatype = string == null ? null : (string.length() != 0 && !Utils.isWhiteSpaceCharsOnly(string) ? TypeMapper.getInstance().getSafeTypeByName(string) : null);
    }

    public void setDatatype(RDFDatatype rDFDatatype) {
        this.datatype = rDFDatatype;
    }

    public RDFDatatype getDatatype() {
        return this.datatype;
    }

    public void setMapID(String string) {
        this.mapID = string;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void setIncomingPredicate(IProperty iProperty) {
        this.incomingPred = iProperty;
    }

    public IProperty getIncomingPredicate() {
        return this.incomingPred;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.isVisuallyRepresented()) {
            if (this.selected) {
                this.gl1.setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
                this.gl1.setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
                VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
                virtualSpace.onTop(this.gl1);
                virtualSpace.onTop((Glyph)this.gl2);
            } else if (this.commented) {
                this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            } else {
                this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
                this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl2 != null) {
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                }
            }
        }
    }

    public void comment(boolean bl, Editor editor) {
        this.commented = bl;
        if (this.commented) {
            if (this.isVisuallyRepresented()) {
                this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            }
            if (this.incomingPred != null) {
                editor.commentPredicate(this.incomingPred, true);
            }
        } else {
            if (this.isVisuallyRepresented()) {
                this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
                this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl2 != null) {
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                }
            }
            if (this.incomingPred != null) {
                editor.commentPredicate(this.incomingPred, false);
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.gl1 != null) {
            this.gl1.setVisible(bl);
            this.gl1.setSensitivity(bl);
        }
        if (this.gl2 != null) {
            this.gl2.setVisible(bl);
            this.gl2.setSensitivity(bl);
        }
    }

    public void setGlyph(Glyph glyph) {
        this.gl1 = glyph;
        this.gl1.setType("litG");
        this.gl1.setOwner((Object)this);
    }

    public void setGlyphText(VText vText) {
        this.gl2 = vText;
        if (this.gl2 != null) {
            this.gl2.setType("litT");
            this.gl2.setOwner((Object)this);
        }
    }

    public Glyph getGlyph() {
        return this.gl1;
    }

    public VText getGlyphText() {
        return this.gl2;
    }

    public Element toISV(Document document, ISVManager iSVManager, Hashtable hashtable, File file, Vector vector) {
        Object object;
        Element element = document.createElementNS(Editor.isavizURI, "isv:iliteral");
        if (this.gl2 != null && this.getValue() != null && this.getValue().length() > 0) {
            object = document.createElementNS(Editor.isavizURI, "isv:value");
            object.appendChild(document.createTextNode(this.getValue()));
            object.setAttribute("x", String.valueOf(this.gl2.vx));
            object.setAttribute("y", String.valueOf(this.gl2.vy));
            element.appendChild((Node)object);
        }
        if (!this.escapeXML) {
            element.setAttribute("escapeXML", "false");
        }
        if (this.language != null) {
            element.setAttribute("xml:lang", this.language);
        }
        if (this.datatype != null) {
            element.setAttribute("dtURI", this.datatype.getURI());
        }
        if (this.isVisuallyRepresented()) {
            element.setAttribute("display", "true");
            if (this.table) {
                element.setAttribute("table", "true");
            }
            element.setAttribute("x", String.valueOf(this.gl1.vx));
            element.setAttribute("y", String.valueOf(this.gl1.vy));
            element.setAttribute("fill", String.valueOf(this.fillIndex));
            element.setAttribute("stroke", String.valueOf(this.strokeIndex));
            if (this.gl1.getStroke() != null) {
                if (this.gl1.getStroke().getLineWidth() != Glyph.DEFAULT_STROKE_WIDTH) {
                    element.setAttribute("stroke-width", String.valueOf(this.gl1.getStroke().getLineWidth()));
                }
                if (this.gl1.getStroke().getDashArray() != null) {
                    element.setAttribute("stroke-dasharray", Utils.arrayOffloatAsCSStrings(this.gl1.getStroke().getDashArray()));
                }
            }
            if (this.getTextAlign() != Style.TA_CENTER.intValue()) {
                element.setAttribute("text-align", String.valueOf(this.getTextAlign()));
            }
            if (this.gl1 instanceof VEllipse) {
                element.setAttribute("shape", Style.ELLIPSE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else if (this.gl1 instanceof VRoundRect) {
                element.setAttribute("shape", Style.ROUND_RECTANGLE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else if (this.gl1 instanceof VImage) {
                element.setAttribute("shape", "icon");
                object = Utils.exportBitmap((VImage)this.gl1, file, hashtable);
                if (object != null) {
                    element.setAttribute("shape", "icon");
                    element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", ISVManager.img_subdir.getName() + "/" + ((File)object).getName());
                } else {
                    element.setAttribute("shape", Style.RECTANGLE.toString());
                }
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else if (this.gl1 instanceof VPolygon) {
                element.setAttribute("shape", "[" + ((VPolygon)this.gl1).getVerticesAsText() + "]");
            } else if (this.gl1 instanceof VShape) {
                element.setAttribute("shape", "{" + ((VShape)this.gl1).getVerticesAsText() + "}");
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
                element.setAttribute("or", String.valueOf(this.gl1.getOrient()));
            } else if (this.gl1 instanceof VCircle) {
                element.setAttribute("shape", Style.CIRCLE.toString());
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else if (this.gl1 instanceof VDiamond) {
                element.setAttribute("shape", Style.DIAMOND.toString());
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else if (this.gl1 instanceof VOctagon) {
                element.setAttribute("shape", Style.OCTAGON.toString());
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else if (this.gl1 instanceof VTriangle) {
                if (this.gl1.getOrient() == (float)Math.PI) {
                    element.setAttribute("shape", Style.TRIANGLES.toString());
                } else if (this.gl1.getOrient() == -1.5707964f) {
                    element.setAttribute("shape", Style.TRIANGLEE.toString());
                } else if (this.gl1.getOrient() == 1.5707964f) {
                    element.setAttribute("shape", Style.TRIANGLEW.toString());
                } else {
                    element.setAttribute("shape", Style.TRIANGLEN.toString());
                }
                element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
            } else if (this.gl1 instanceof VRectangle) {
                element.setAttribute("shape", Style.RECTANGLE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            } else {
                element.setAttribute("shape", Style.ELLIPSE.toString());
                element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
                element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
            }
            if (this.gl2 != null) {
                int n = vector.indexOf(this.gl2.getFont());
                if (n == -1) {
                    vector.add(this.gl2.getFont());
                    n = vector.size() - 1;
                }
                if (n != 0) {
                    element.setAttribute("font", String.valueOf(n));
                }
            }
        } else {
            element.setAttribute("display", "false");
        }
        if (this.commented) {
            element.setAttribute("commented", "true");
        }
        element.setAttribute("id", iSVManager.getPrjId(this));
        return element;
    }

    public String toString() {
        String string = super.toString();
        if (this.getValue() != null) {
            string = string + " " + this.getValue();
        }
        if (this.getDatatype() != null) {
            string = string + " [" + this.getDatatype().getURI() + "]";
        }
        return string;
    }

    public String getText() {
        if (this.value != null) {
            return this.value.length() >= Editor.MAX_LIT_CHAR_COUNT ? this.value.substring(0, Editor.MAX_LIT_CHAR_COUNT) : this.value;
        }
        return "";
    }

    public void displayOnTop() {
        Editor.vsm.getVirtualSpace("rdfSpace").onTop(this.gl1);
        if (this.gl2 != null) {
            Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl2);
        }
    }

    public void setFillColor(int n) {
        this.fillIndex = n;
        this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
    }

    public int getFillIndex() {
        return this.fillIndex;
    }

    public void setStrokeColor(int n) {
        this.strokeIndex = n;
        this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
        if (this.gl2 != null) {
            this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
        }
    }

    public int getStrokeIndex() {
        return this.strokeIndex;
    }
}

