/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangleNR;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VPolygon;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRoundRect;
import com.xerox.VTM.glyphs.VSegment;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangle;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import net.claribole.zvtm.glyphs.GlyphUtils;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.ControlPoint;
import org.w3c.IsaViz.CustomPolygon;
import org.w3c.IsaViz.CustomShape;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ISVCommand;
import org.w3c.IsaViz.ISVGeom;
import org.w3c.IsaViz.LitResizer;
import org.w3c.IsaViz.PathSegment;
import org.w3c.IsaViz.PropResizer;
import org.w3c.IsaViz.ResResizer;
import org.w3c.IsaViz.Resizer;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.StyleInfo;
import org.w3c.IsaViz.StyleInfoL;
import org.w3c.IsaViz.StyleInfoR;
import org.w3c.IsaViz.TableColResizer;

class GeometryManager {
    static int ARROW_HEAD_SIZE = 5;
    static int DEFAULT_NODE_WIDTH = 40;
    static int DEFAULT_NODE_HEIGHT = 18;
    Editor application;
    Resizer lastResizer;

    GeometryManager(Editor editor) {
        this.application = editor;
    }

    void resetLastResizer() {
        this.lastResizer = null;
    }

    void adjustPaths(INode iNode) {
        if (iNode.isVisuallyRepresented()) {
            Vector<PathSegment> vector = new Vector<PathSegment>();
            double[] dArray = new double[6];
            if (iNode instanceof IResource) {
                Point2D point2D;
                LongPoint longPoint;
                Point2D point2D2;
                int n;
                PathIterator pathIterator;
                VPath vPath;
                IProperty iProperty;
                int n2;
                IResource iResource = (IResource)iNode;
                Glyph glyph = iNode.getGlyph();
                Shape shape = GlyphUtils.getJava2DShape((Glyph)glyph);
                Vector vector2 = iResource.getOutgoingPredicates();
                if (vector2 != null) {
                    n2 = 0;
                    while (n2 < vector2.size()) {
                        iProperty = (IProperty)vector2.elementAt(n2);
                        if (iProperty.isVisuallyRepresented()) {
                            vPath = (VPath)iProperty.getGlyph();
                            pathIterator = vPath.getJava2DPathIterator();
                            vector.removeAllElements();
                            while (!pathIterator.isDone()) {
                                n = pathIterator.currentSegment(dArray);
                                vector.add(new PathSegment(dArray, n));
                                pathIterator.next();
                            }
                            point2D2 = ((PathSegment)vector.firstElement()).getMainPoint();
                            if (shape.contains(point2D2)) {
                                if (glyph instanceof VPolygon) {
                                    longPoint = ((VPolygon)glyph).getCentroid();
                                    point2D = GeometryManager.computeStepValue(longPoint.x, longPoint.y, point2D2.getX(), point2D2.getY());
                                } else {
                                    point2D = GeometryManager.computeStepValue(glyph.vx, glyph.vy, point2D2.getX(), point2D2.getY());
                                }
                                while (shape.contains(point2D2)) {
                                    point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                                }
                            } else {
                                if (glyph instanceof VPolygon) {
                                    longPoint = ((VPolygon)glyph).getCentroid();
                                    point2D = GeometryManager.computeStepValue(point2D2.getX(), point2D2.getY(), longPoint.x, longPoint.y);
                                } else {
                                    point2D = GeometryManager.computeStepValue(point2D2.getX(), point2D2.getY(), glyph.vx, glyph.vy);
                                }
                                while (!shape.contains(point2D2)) {
                                    point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                                }
                            }
                            ((PathSegment)vector.firstElement()).setMainPoint(point2D2);
                            this.reconstructVPathFromPathSegments(vPath, vector);
                        }
                        ++n2;
                    }
                }
                if ((vector2 = iResource.getIncomingPredicates()) != null) {
                    n2 = 0;
                    while (n2 < vector2.size()) {
                        iProperty = (IProperty)vector2.elementAt(n2);
                        if (iProperty.isVisuallyRepresented()) {
                            vPath = (VPath)iProperty.getGlyph();
                            pathIterator = vPath.getJava2DPathIterator();
                            vector.removeAllElements();
                            while (!pathIterator.isDone()) {
                                n = pathIterator.currentSegment(dArray);
                                vector.add(new PathSegment(dArray, n));
                                pathIterator.next();
                            }
                            point2D2 = ((PathSegment)vector.lastElement()).getMainPoint();
                            if (shape.contains(point2D2)) {
                                point2D = GeometryManager.computeStepValue(glyph.vx, glyph.vy, point2D2.getX(), point2D2.getY());
                                while (shape.contains(point2D2)) {
                                    point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                                }
                            } else {
                                point2D = GeometryManager.computeStepValue(point2D2.getX(), point2D2.getY(), glyph.vx, glyph.vy);
                                while (!shape.contains(point2D2)) {
                                    point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                                }
                            }
                            ((PathSegment)vector.lastElement()).setMainPoint(point2D2);
                            this.reconstructVPathFromPathSegments(vPath, vector);
                            longPoint = ((IProperty)vector2.elementAt(n2)).getGlyphHead();
                            double[] dArray2 = this.getLastTwoVPathPoints(vector);
                            GeometryManager.createPathArrowHead(dArray2[0], dArray2[1], dArray2[2], dArray2[3], (VTriangleOr)longPoint);
                        }
                        ++n2;
                    }
                }
            } else {
                IProperty iProperty;
                ILiteral iLiteral = (ILiteral)iNode;
                Glyph glyph = iNode.getGlyph();
                Shape shape = GlyphUtils.getJava2DShape((Glyph)glyph);
                if (iLiteral.getIncomingPredicate() != null && (iProperty = iLiteral.getIncomingPredicate()).isVisuallyRepresented()) {
                    VPath vPath = (VPath)iProperty.getGlyph();
                    PathIterator pathIterator = vPath.getJava2DPathIterator();
                    vector.removeAllElements();
                    while (!pathIterator.isDone()) {
                        int n = pathIterator.currentSegment(dArray);
                        vector.add(new PathSegment(dArray, n));
                        pathIterator.next();
                    }
                    Point2D point2D = ((PathSegment)vector.lastElement()).getMainPoint();
                    if (shape.contains(point2D)) {
                        Point2D point2D3 = GeometryManager.computeStepValue(glyph.vx, glyph.vy, point2D.getX(), point2D.getY());
                        while (shape.contains(point2D)) {
                            point2D.setLocation(point2D.getX() + point2D3.getX(), point2D.getY() + point2D3.getY());
                        }
                    } else {
                        Point2D point2D4 = GeometryManager.computeStepValue(point2D.getX(), point2D.getY(), glyph.vx, glyph.vy);
                        while (!shape.contains(point2D)) {
                            point2D.setLocation(point2D.getX() + point2D4.getX(), point2D.getY() + point2D4.getY());
                        }
                    }
                    ((PathSegment)vector.lastElement()).setMainPoint(point2D);
                    this.reconstructVPathFromPathSegments(vPath, vector);
                    VTriangleOr vTriangleOr = iLiteral.getIncomingPredicate().getGlyphHead();
                    double[] dArray3 = this.getLastTwoVPathPoints(vector);
                    GeometryManager.createPathArrowHead(dArray3[0], dArray3[1], dArray3[2], dArray3[3], vTriangleOr);
                }
            }
            Editor.vsm.repaintNow();
        }
    }

    void adjustTablePath(IProperty iProperty) {
        if (iProperty.isVisuallyRepresented()) {
            Point2D point2D;
            Vector vector = iProperty.getSubject().getOutgoingPredicates();
            Vector<VRectangle> vector2 = new Vector<VRectangle>();
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty2 = (IProperty)vector.elementAt(n);
                if (iProperty2.getGlyph() == iProperty.getGlyph()) {
                    vector2.add(iProperty2.getTableCellGlyph());
                }
                ++n;
            }
            VRectangle vRectangle = (VRectangle)GeometryManager.getNorthMostGlyph(vector2);
            VRectangle vRectangle2 = (VRectangle)GeometryManager.getSouthMostGlyph(vector2);
            VRectangle vRectangle3 = new VRectangle(vRectangle.vx, (vRectangle.vy + vRectangle2.vy) / 2L, 0.0f, vRectangle.getWidth(), (Math.abs(vRectangle2.vy - vRectangle.vy) + vRectangle.getHeight() + vRectangle2.getHeight()) / 2L, Color.black);
            Shape shape = GlyphUtils.getJava2DShape((Glyph)vRectangle3);
            VPath vPath = (VPath)iProperty.getGlyph();
            PathIterator pathIterator = vPath.getJava2DPathIterator();
            Vector<PathSegment> vector3 = new Vector<PathSegment>();
            double[] dArray = new double[6];
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(dArray);
                vector3.add(new PathSegment(dArray, n2));
                pathIterator.next();
            }
            Point2D point2D2 = ((PathSegment)vector3.lastElement()).getMainPoint();
            if (shape.contains(point2D2)) {
                point2D = GeometryManager.computeStepValue(vRectangle3.vx, vRectangle3.vy, point2D2.getX(), point2D2.getY());
                while (shape.contains(point2D2)) {
                    point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                }
            } else {
                point2D = GeometryManager.computeStepValue(point2D2.getX(), point2D2.getY(), vRectangle3.vx, vRectangle3.vy);
                while (!shape.contains(point2D2)) {
                    point2D2.setLocation(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
                }
            }
            ((PathSegment)vector3.lastElement()).setMainPoint(point2D2);
            this.reconstructVPathFromPathSegments(vPath, vector3);
            point2D = iProperty.getGlyphHead();
            double[] dArray2 = this.getLastTwoVPathPoints(vector3);
            GeometryManager.createPathArrowHead(dArray2[0], dArray2[1], dArray2[2], dArray2[3], (VTriangleOr)point2D);
            Editor.vsm.repaintNow();
        }
    }

    void adjustResourceTextAndShape(IResource iResource, String string) {
        if (iResource.isVisuallyRepresented()) {
            if (iResource.isLaidOutInTableForm()) {
                VText vText = iResource.getGlyphText();
                if (string != null) {
                    vText.setText(string);
                }
                Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
                graphics.setFont(vText.getFont());
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
                VRectangle vRectangle = (VRectangle)iResource.getGlyph();
                this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), (Glyph)vRectangle, new Integer(iResource.getTextAlign()));
            } else {
                VText vText = iResource.getGlyphText();
                if (string != null) {
                    vText.setText(string);
                }
                Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
                graphics.setFont(vText.getFont());
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
                Glyph glyph = iResource.getGlyph();
                if (glyph instanceof RectangularShape && !(glyph instanceof VImage)) {
                    RectangularShape rectangularShape = (RectangularShape)glyph;
                    rectangularShape.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
                    if ((double)rectangularShape.getWidth() < 1.5 * (double)rectangularShape.getHeight()) {
                        rectangularShape.setWidth(Math.round(1.5 * (double)rectangularShape.getHeight()));
                    }
                    this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), glyph, new Integer(iResource.getTextAlign()));
                    this.adjustPaths(iResource);
                } else {
                    this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), glyph, new Integer(iResource.getTextAlign()));
                    this.adjustPaths(iResource);
                }
            }
        }
    }

    void correctResourceTextAndShape(IResource iResource) {
        if (iResource.isVisuallyRepresented()) {
            if (iResource.isLaidOutInTableForm()) {
                VText vText = iResource.getGlyphText();
                VRectangle vRectangle = (VRectangle)iResource.getGlyph();
                Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
                graphics.setFont(vText.getFont());
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
                this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), (Glyph)vRectangle, new Integer(iResource.getTextAlign()));
            } else {
                VText vText = iResource.getGlyphText();
                Glyph glyph = iResource.getGlyph();
                Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
                graphics.setFont(vText.getFont());
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
                if (glyph instanceof RectangularShape && !(glyph instanceof VImage)) {
                    RectangularShape rectangularShape = (RectangularShape)glyph;
                    rectangularShape.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
                    if ((double)rectangularShape.getWidth() < 1.5 * (double)rectangularShape.getHeight()) {
                        rectangularShape.setWidth(Math.round(1.5 * (double)rectangularShape.getHeight()));
                    }
                    this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), glyph, new Integer(iResource.getTextAlign()));
                    this.adjustPaths(iResource);
                } else {
                    this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), glyph, new Integer(iResource.getTextAlign()));
                    this.adjustPaths(iResource);
                }
            }
        }
    }

    void correctLiteralTextAndShape(ILiteral iLiteral) {
        VText vText;
        if (iLiteral.isVisuallyRepresented() && (vText = iLiteral.getGlyphText()) != null && vText.getText().length() > 0) {
            if (iLiteral.isLaidOutInTableForm()) {
                VRectangle vRectangle = (VRectangle)iLiteral.getGlyph();
                Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
                graphics.setFont(vText.getFont());
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
                this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), (Glyph)vRectangle, new Integer(iLiteral.getTextAlign()));
            } else {
                Glyph glyph = iLiteral.getGlyph();
                Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
                graphics.setFont(vText.getFont());
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
                if (glyph instanceof RectangularShape && !(glyph instanceof VImage)) {
                    RectangularShape rectangularShape = (RectangularShape)glyph;
                    rectangularShape.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
                    if ((double)rectangularShape.getWidth() < 1.5 * (double)rectangularShape.getHeight()) {
                        rectangularShape.setWidth(Math.round(1.5 * (double)rectangularShape.getHeight()));
                    }
                    this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), glyph, new Integer(iLiteral.getTextAlign()));
                    this.adjustPaths(iLiteral);
                } else {
                    this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), glyph, new Integer(iLiteral.getTextAlign()));
                    this.adjustPaths(iLiteral);
                }
            }
        }
    }

    void correctPropertyTextAndShape(IProperty iProperty) {
        if (iProperty.isVisuallyRepresented() && iProperty.isLaidOutInTableForm()) {
            VText vText = iProperty.getGlyphText();
            VRectangle vRectangle = iProperty.getTableCellGlyph();
            Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
            graphics.setFont(vText.getFont());
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
            this.alignText(vText, new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight())), (Glyph)vRectangle, new Integer(iProperty.getTextAlign()));
            this.adjustTablePath(iProperty);
        }
    }

    void adjustResourceText(IResource iResource) {
        VText vText;
        if (iResource.isVisuallyRepresented() && (vText = iResource.getGlyphText()) != null) {
            Glyph glyph = iResource.getGlyph();
            LongPoint longPoint = vText.getBounds(Editor.vsm.getActiveCamera().getIndex());
            this.alignText(vText, longPoint, glyph, new Integer(iResource.getTextAlign()));
        }
    }

    void adjustLiteralText(ILiteral iLiteral) {
        VText vText;
        if (iLiteral.isVisuallyRepresented() && (vText = iLiteral.getGlyphText()) != null) {
            Glyph glyph = iLiteral.getGlyph();
            LongPoint longPoint = vText.getBounds(Editor.vsm.getActiveCamera().getIndex());
            this.alignText(vText, longPoint, glyph, new Integer(iLiteral.getTextAlign()));
        }
    }

    void adjustPropertyText(IProperty iProperty) {
        VText vText;
        if (iProperty.isVisuallyRepresented() && iProperty.isLaidOutInTableForm() && (vText = iProperty.getGlyphText()) != null) {
            VRectangle vRectangle = iProperty.getTableCellGlyph();
            LongPoint longPoint = vText.getBounds(Editor.vsm.getActiveCamera().getIndex());
            this.alignText(vText, longPoint, (Glyph)vRectangle, Style.TA_CENTER);
        }
    }

    void alignText(VText vText, LongPoint longPoint, Glyph glyph, Integer n) {
        Rectangle2D rectangle2D = GlyphUtils.getJava2DShape((Glyph)glyph).getBounds2D();
        if (n.equals(Style.TA_CENTER)) {
            if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
                vText.moveTo(glyph.vx - longPoint.x / 2L, glyph.vy - longPoint.y / 4L);
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                vText.moveTo(glyph.vx, glyph.vy - longPoint.y / 4L);
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_END) {
                vText.moveTo(glyph.vx + longPoint.x / 2L, glyph.vy - longPoint.y / 4L);
            }
        } else if (n.equals(Style.TA_BELOW)) {
            if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
                vText.moveTo(glyph.vx - longPoint.x / 2L, Math.round(rectangle2D.getMinY() - (double)longPoint.y));
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                vText.moveTo(glyph.vx, Math.round(rectangle2D.getMinY() - (double)longPoint.y));
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_END) {
                vText.moveTo(glyph.vx + longPoint.x / 2L, Math.round(rectangle2D.getMinY() - (double)longPoint.y));
            }
        } else if (n.equals(Style.TA_ABOVE)) {
            if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
                vText.moveTo(glyph.vx - longPoint.x / 2L, Math.round(rectangle2D.getMaxY() + (double)(longPoint.y / 2L)));
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                vText.moveTo(glyph.vx, Math.round(rectangle2D.getMaxY() + (double)(longPoint.y / 2L)));
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_END) {
                vText.moveTo(glyph.vx + longPoint.x / 2L, Math.round(rectangle2D.getMaxY() + (double)(longPoint.y / 2L)));
            }
        } else if (n.equals(Style.TA_LEFT)) {
            if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
                vText.moveTo(Math.round(rectangle2D.getMinX() - (double)longPoint.x), glyph.vy - longPoint.y / 4L);
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                vText.moveTo(Math.round(rectangle2D.getMinX() - (double)(longPoint.x / 2L)), glyph.vy - longPoint.y / 4L);
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_END) {
                vText.moveTo(Math.round(rectangle2D.getMinX()), glyph.vy - longPoint.y / 4L);
            }
        } else if (n.equals(Style.TA_RIGHT)) {
            if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
                vText.moveTo(Math.round(rectangle2D.getMaxX()), glyph.vy - longPoint.y / 4L);
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                vText.moveTo(Math.round(rectangle2D.getMaxX() + (double)(longPoint.x / 2L)), glyph.vy - longPoint.y / 4L);
            } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_END) {
                vText.moveTo(Math.round(rectangle2D.getMaxX() + (double)longPoint.x), glyph.vy - longPoint.y / 4L);
            }
        }
    }

    void alignText(Glyph glyph, VText vText, Integer n) {
        if (glyph != null && vText != null) {
            Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
            graphics.setFont(vText.getFont());
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
            LongPoint longPoint = new LongPoint(Math.round(rectangle2D.getWidth()), Math.round(rectangle2D.getHeight()));
            rectangle2D = GlyphUtils.getJava2DShape((Glyph)glyph).getBounds2D();
            if (n.equals(Style.TA_BELOW)) {
                vText.moveTo(vText.vx, Math.round(rectangle2D.getMinY() - (double)longPoint.y));
            } else if (n.equals(Style.TA_ABOVE)) {
                vText.moveTo(vText.vx, Math.round(rectangle2D.getMaxY() + (double)longPoint.y));
            } else if (n.equals(Style.TA_LEFT)) {
                if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
                    vText.moveTo(Math.round(rectangle2D.getMinX() - (double)longPoint.x), vText.vy);
                } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                    vText.moveTo(Math.round(rectangle2D.getMinX() - (double)(longPoint.x / 2L)), vText.vy);
                } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_END) {
                    vText.moveTo(Math.round(rectangle2D.getMinX()), vText.vy);
                }
            } else if (n.equals(Style.TA_RIGHT)) {
                if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
                    vText.moveTo(Math.round(rectangle2D.getMaxX()), vText.vy);
                } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                    vText.moveTo(Math.round(rectangle2D.getMaxX() + (double)(longPoint.x / 2L)), vText.vy);
                } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_END) {
                    vText.moveTo(Math.round(rectangle2D.getMaxX() + (double)longPoint.x), vText.vy);
                }
            }
        }
    }

    void updateAPropertyText(IProperty iProperty, String string) {
        VText vText = iProperty.getGlyphText();
        if (vText != null) {
            Graphics graphics = Editor.vsm.getView("Graph").getGraphicsContext();
            graphics.setFont(vText.getFont());
            Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(vText.getText(), graphics);
            long l = Math.round((double)vText.vx + rectangle2D.getWidth() / 2.0);
            long l2 = Math.round((double)vText.vy + rectangle2D.getHeight() / 2.0);
            vText.setText(string);
            rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
            vText.moveTo(Math.round((double)l - rectangle2D.getWidth() / 2.0), Math.round((double)l2 - rectangle2D.getHeight() / 2.0));
        }
    }

    void initResourceResizer(IResource iResource) {
        this.destroyLastResizer();
        iResource.displayOnTop();
        if (iResource.isLaidOutInTableForm()) {
            this.lastResizer = new TableColResizer(iResource, TableColResizer.RIGHT_COLUMN);
            Vector vector = ((TableColResizer)this.lastResizer).getPropertiesInTable();
            Vector<IProperty> vector2 = new Vector<IProperty>();
            Vector<INode> vector3 = new Vector<INode>();
            Vector<INode> vector4 = new Vector<INode>();
            vector3.add(iResource);
            IProperty iProperty = (IProperty)iResource.getIncomingPredicates().firstElement();
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty2 = (IProperty)vector.elementAt(n);
                Editor.vsm.stickToGlyph((Glyph)iProperty2.getTableCellGlyph(), iResource.getGlyph());
                Editor.vsm.stickToGlyph((Glyph)iProperty2.getGlyphText(), iResource.getGlyph());
                vector2.add(iProperty2);
                if (iProperty2 != iProperty) {
                    Editor.vsm.stickToGlyph(iProperty2.getObject().getGlyph(), iResource.getGlyph());
                    try {
                        Editor.vsm.stickToGlyph((Glyph)iProperty2.getObject().getGlyphText(), iResource.getGlyph());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (iProperty2.getObject() instanceof IResource) {
                        vector3.add(iProperty2.getObject());
                    } else {
                        vector4.add(iProperty2.getObject());
                    }
                }
                ++n;
            }
            ISVGeom iSVGeom = new ISVGeom(this.application, vector2, vector3, vector4);
            this.application.addCmdToUndoStack(iSVGeom);
        } else {
            IProperty iProperty;
            Object object;
            Vector<IResource> vector = new Vector<IResource>();
            vector.add(iResource);
            Vector<IProperty> vector5 = new Vector<IProperty>();
            if (iResource.getIncomingPredicates() != null) {
                object = iResource.getIncomingPredicates().elements();
                while (object.hasMoreElements()) {
                    iProperty = (IProperty)object.nextElement();
                    if (!iProperty.isVisuallyRepresented()) continue;
                    vector5.add(iProperty);
                }
            }
            if (iResource.getOutgoingPredicates() != null) {
                object = iResource.getOutgoingPredicates().elements();
                while (object.hasMoreElements()) {
                    iProperty = (IProperty)object.nextElement();
                    if (!iProperty.isVisuallyRepresented()) continue;
                    vector5.add(iProperty);
                }
            }
            object = new ISVGeom(this.application, vector5, vector, new Vector());
            this.application.addCmdToUndoStack((ISVCommand)object);
            this.lastResizer = new ResResizer(iResource);
        }
        if (iResource.getGlyphText() != null) {
            Editor.vsm.stickToGlyph((Glyph)iResource.getGlyphText(), iResource.getGlyph());
        }
    }

    void initLiteralResizer(ILiteral iLiteral) {
        this.destroyLastResizer();
        iLiteral.displayOnTop();
        if (iLiteral.isLaidOutInTableForm()) {
            this.lastResizer = new TableColResizer(iLiteral, TableColResizer.RIGHT_COLUMN);
            Vector vector = ((TableColResizer)this.lastResizer).getPropertiesInTable();
            Vector<IProperty> vector2 = new Vector<IProperty>();
            Vector<INode> vector3 = new Vector<INode>();
            Vector<INode> vector4 = new Vector<INode>();
            vector4.add(iLiteral);
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty = (IProperty)vector.elementAt(n);
                Editor.vsm.stickToGlyph((Glyph)iProperty.getTableCellGlyph(), iLiteral.getGlyph());
                Editor.vsm.stickToGlyph((Glyph)iProperty.getGlyphText(), iLiteral.getGlyph());
                vector2.add(iProperty);
                if (iProperty != iLiteral.getIncomingPredicate()) {
                    Editor.vsm.stickToGlyph(iProperty.getObject().getGlyph(), iLiteral.getGlyph());
                    try {
                        Editor.vsm.stickToGlyph((Glyph)iProperty.getObject().getGlyphText(), iLiteral.getGlyph());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (iProperty.getObject() instanceof IResource) {
                        vector3.add(iProperty.getObject());
                    } else {
                        vector4.add(iProperty.getObject());
                    }
                }
                ++n;
            }
            ISVGeom iSVGeom = new ISVGeom(this.application, vector2, vector3, vector4);
            this.application.addCmdToUndoStack(iSVGeom);
        } else {
            Vector<ILiteral> vector = new Vector<ILiteral>();
            vector.add(iLiteral);
            Vector<IProperty> vector5 = new Vector<IProperty>();
            if (iLiteral.getIncomingPredicate() != null && iLiteral.getIncomingPredicate().isVisuallyRepresented()) {
                vector5.add(iLiteral.getIncomingPredicate());
            }
            ISVGeom iSVGeom = new ISVGeom(this.application, vector5, new Vector(), vector);
            this.application.addCmdToUndoStack(iSVGeom);
            this.lastResizer = new LitResizer(iLiteral);
        }
        if (iLiteral.getGlyphText() != null) {
            Editor.vsm.stickToGlyph((Glyph)iLiteral.getGlyphText(), iLiteral.getGlyph());
        }
    }

    void initPropertyResizer(IProperty iProperty) {
        this.destroyLastResizer();
        Vector<IProperty> vector = new Vector<IProperty>();
        vector.add(iProperty);
        ISVGeom iSVGeom = new ISVGeom(this.application, vector, new Vector(), new Vector());
        this.application.addCmdToUndoStack(iSVGeom);
        iProperty.displayOnTop();
        this.lastResizer = new PropResizer(iProperty);
    }

    void initPropCellResizer(IProperty iProperty) {
        this.destroyLastResizer();
        this.lastResizer = new TableColResizer(iProperty, TableColResizer.LEFT_COLUMN);
        Vector vector = ((TableColResizer)this.lastResizer).getPropertiesInTable();
        Vector<IProperty> vector2 = new Vector<IProperty>();
        Vector<INode> vector3 = new Vector<INode>();
        Vector<INode> vector4 = new Vector<INode>();
        vector2.add(iProperty);
        int n = 0;
        while (n < vector.size()) {
            IProperty iProperty2 = (IProperty)vector.elementAt(n);
            if (iProperty2 != iProperty) {
                Editor.vsm.stickToGlyph((Glyph)iProperty2.getTableCellGlyph(), (Glyph)iProperty.getTableCellGlyph());
                Editor.vsm.stickToGlyph((Glyph)iProperty2.getGlyphText(), (Glyph)iProperty.getTableCellGlyph());
                vector2.add(iProperty2);
            }
            Editor.vsm.stickToGlyph(iProperty2.getObject().getGlyph(), (Glyph)iProperty.getTableCellGlyph());
            try {
                Editor.vsm.stickToGlyph((Glyph)iProperty2.getObject().getGlyphText(), (Glyph)iProperty.getTableCellGlyph());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iProperty2.getObject() instanceof IResource) {
                vector3.add(iProperty2.getObject());
            } else {
                vector4.add(iProperty2.getObject());
            }
            ++n;
        }
        ISVGeom iSVGeom = new ISVGeom(this.application, vector2, vector3, vector4);
        this.application.addCmdToUndoStack(iSVGeom);
        if (iProperty.getGlyphText() != null) {
            Editor.vsm.stickToGlyph((Glyph)iProperty.getGlyphText(), (Glyph)iProperty.getTableCellGlyph());
        }
    }

    void destroyLastResizer() {
        if (this.lastResizer != null) {
            this.lastResizer.destroy();
            this.lastResizer = null;
        }
    }

    void resize(Glyph glyph) {
        try {
            this.lastResizer.updateMainGlyph(glyph);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void endResize() {
        Editor.vsm.unstickFromMouse();
        INode iNode = (INode)this.lastResizer.getMainGlyph().getOwner();
        if (iNode.isLaidOutInTableForm()) {
            if (iNode instanceof IResource) {
                IProperty iProperty = (IProperty)((IResource)iNode).getIncomingPredicates().firstElement();
                Glyph glyph = iProperty.getGlyph();
                this.adjustTablePath(iProperty);
                Vector vector = iProperty.getSubject().getOutgoingPredicates();
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        iProperty = (IProperty)vector.elementAt(n);
                        if (iProperty.getGlyph() == glyph) {
                            if (iProperty.getObject() instanceof IResource) {
                                this.adjustResourceText((IResource)iProperty.getObject());
                            } else {
                                this.adjustLiteralText((ILiteral)iProperty.getObject());
                            }
                        }
                        ++n;
                    }
                }
            } else if (iNode instanceof ILiteral) {
                IProperty iProperty = ((ILiteral)iNode).getIncomingPredicate();
                Glyph glyph = iProperty.getGlyph();
                this.adjustTablePath(iProperty);
                Vector vector = iProperty.getSubject().getOutgoingPredicates();
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        iProperty = (IProperty)vector.elementAt(n);
                        if (iProperty.getGlyph() == glyph) {
                            if (iProperty.getObject() instanceof IResource) {
                                this.adjustResourceText((IResource)iProperty.getObject());
                            } else {
                                this.adjustLiteralText((ILiteral)iProperty.getObject());
                            }
                        }
                        ++n;
                    }
                }
            } else if (iNode instanceof IProperty) {
                IProperty iProperty = (IProperty)iNode;
                Glyph glyph = iProperty.getGlyph();
                this.adjustTablePath(iProperty);
                Vector vector = iProperty.getSubject().getOutgoingPredicates();
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        iProperty = (IProperty)vector.elementAt(n);
                        if (iProperty.getGlyph() == glyph) {
                            this.adjustPropertyText(iProperty);
                        }
                        ++n;
                    }
                }
            }
        } else if (iNode instanceof IResource) {
            this.adjustResourceText((IResource)iNode);
            this.adjustPaths(iNode);
        } else if (iNode instanceof ILiteral) {
            this.adjustLiteralText((ILiteral)iNode);
            this.adjustPaths(iNode);
        }
    }

    void move(Glyph glyph) {
        try {
            this.lastResizer.updateHandles();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void endMove() {
        INode iNode = (INode)this.lastResizer.getMainGlyph().getOwner();
        try {
            Editor.vsm.unstickAllGlyphs(this.lastResizer.getMainGlyph());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Editor.vsm.unstickFromMouse();
        if (iNode.isLaidOutInTableForm()) {
            if (iNode instanceof IResource) {
                this.adjustTablePath((IProperty)((IResource)iNode).getIncomingPredicates().firstElement());
            } else if (iNode instanceof ILiteral) {
                this.adjustTablePath(((ILiteral)iNode).getIncomingPredicate());
            } else if (iNode instanceof IProperty) {
                this.adjustTablePath((IProperty)iNode);
            }
        } else {
            this.adjustPaths(iNode);
        }
        this.application.centerRadarView();
    }

    void updatePathAfterResize() {
        try {
            this.lastResizer.updateMainGlyph(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void reconstructVPathFromPathSegments(VPath vPath, Vector vector) {
        vPath.resetPath();
        int n = 0;
        while (n < vector.size()) {
            PathSegment pathSegment = (PathSegment)vector.elementAt(n);
            double[] dArray = pathSegment.getCoords();
            switch (pathSegment.getType()) {
                case 3: {
                    vPath.addCbCurve((long)dArray[4], (long)dArray[5], (long)dArray[0], (long)dArray[1], (long)dArray[2], (long)dArray[3], true);
                    break;
                }
                case 2: {
                    vPath.addQdCurve((long)dArray[2], (long)dArray[3], (long)dArray[0], (long)dArray[1], true);
                    break;
                }
                case 1: {
                    vPath.addSegment((long)dArray[0], (long)dArray[1], true);
                    break;
                }
                case 0: {
                    vPath.jump((long)dArray[0], (long)dArray[1], true);
                }
            }
            ++n;
        }
    }

    double[] getLastTwoVPathPoints(Vector vector) {
        double[] dArray = new double[4];
        double[] dArray2 = ((PathSegment)vector.lastElement()).getCoords();
        int n = ((PathSegment)vector.lastElement()).getType();
        if (n == 1) {
            Point2D point2D = ((PathSegment)vector.elementAt(vector.size() - 2)).getMainPoint();
            dArray[0] = point2D.getX();
            dArray[1] = point2D.getY();
            dArray[2] = dArray2[0];
            dArray[3] = dArray2[1];
        } else if (n == 3) {
            dArray[0] = dArray2[2];
            dArray[1] = dArray2[3];
            dArray[2] = dArray2[4];
            dArray[3] = dArray2[5];
        } else if (n == 2) {
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            dArray[2] = dArray2[2];
            dArray[3] = dArray2[3];
        } else {
            System.err.println("Error: Editor.getLastTwoVPathPoints: bad segment type " + n);
        }
        return dArray;
    }

    void insertSegmentInPath(Glyph glyph) {
        ControlPoint controlPoint = (ControlPoint)glyph.getOwner();
        if (controlPoint.type < 2) {
            PropResizer propResizer = controlPoint.owner;
            ControlPoint controlPoint2 = (ControlPoint)controlPoint.nextHandle.getOwner();
            Editor.vsm.getVirtualSpace("rdfSpace").destroyGlyph((Glyph)controlPoint.s2);
            controlPoint.s2 = null;
            controlPoint2.s1 = null;
            LongPoint longPoint = new LongPoint((long)Math.round(controlPoint.handle.vx + (controlPoint2.handle.vx - controlPoint.handle.vx) / 3L), (long)Math.round(controlPoint.handle.vy + (controlPoint2.handle.vy - controlPoint.handle.vy) / 3L));
            LongPoint longPoint2 = new LongPoint((long)Math.round(controlPoint.handle.vx + (controlPoint2.handle.vx - controlPoint.handle.vx) * 2L / 3L), (long)Math.round(controlPoint.handle.vy + (controlPoint2.handle.vy - controlPoint.handle.vy) * 2L / 3L));
            RectangleNR rectangleNR = new RectangleNR(longPoint.x, longPoint.y, 0.0f, 4L, 4L, Color.red);
            RectangleNR rectangleNR2 = new RectangleNR(longPoint2.x, longPoint2.y, 0.0f, 4L, 4L, Color.black);
            Editor.vsm.addGlyph((Glyph)rectangleNR, "rdfSpace");
            Editor.vsm.addGlyph((Glyph)rectangleNR2, "rdfSpace");
            LongPoint longPoint3 = new LongPoint(controlPoint.handle.vx, controlPoint.handle.vy);
            LongPoint longPoint4 = new LongPoint(controlPoint2.handle.vx, controlPoint2.handle.vy);
            VSegment vSegment = new VSegment((longPoint3.x + longPoint.x) / 2L, (longPoint3.y + longPoint.y) / 2L, 0.0f, (longPoint.x - longPoint3.x) / 2L, (longPoint3.y - longPoint.y) / 2L, Color.red);
            VSegment vSegment2 = new VSegment((longPoint.x + longPoint2.x) / 2L, (longPoint.y + longPoint2.y) / 2L, 0.0f, (longPoint2.x - longPoint.x) / 2L, (longPoint.y - longPoint2.y) / 2L, Color.red);
            VSegment vSegment3 = new VSegment((longPoint2.x + longPoint4.x) / 2L, (longPoint2.y + longPoint4.y) / 2L, 0.0f, (longPoint4.x - longPoint2.x) / 2L, (longPoint2.y - longPoint4.y) / 2L, Color.red);
            Editor.vsm.addGlyph((Glyph)vSegment, "rdfSpace");
            Editor.vsm.addGlyph((Glyph)vSegment2, "rdfSpace");
            Editor.vsm.addGlyph((Glyph)vSegment3, "rdfSpace");
            controlPoint.setSecondSegment(vSegment, rectangleNR);
            ControlPoint controlPoint3 = new ControlPoint(rectangleNR, controlPoint.handle, vSegment, 3, propResizer);
            controlPoint3.setSecondSegment(vSegment2, rectangleNR2);
            ControlPoint controlPoint4 = new ControlPoint(rectangleNR2, rectangleNR, vSegment2, 0, propResizer);
            controlPoint4.setSecondSegment(vSegment3, controlPoint2.handle);
            controlPoint2.prevHandle = rectangleNR2;
            controlPoint2.s1 = vSegment3;
            ControlPoint[] controlPointArray = new ControlPoint[propResizer.cps.length + 2];
            int n = 0;
            ControlPoint controlPoint5 = propResizer.cps[n];
            while (n < controlPointArray.length - 1) {
                controlPointArray[n] = controlPoint5;
                controlPoint5 = (ControlPoint)controlPoint5.nextHandle.getOwner();
                ++n;
            }
            controlPointArray[n] = controlPoint5;
            propResizer.cps = controlPointArray;
            propResizer.updateMainGlyph(null);
        }
    }

    void deleteSegmentInPath(Glyph glyph) {
        ControlPoint controlPoint = (ControlPoint)glyph.getOwner();
        if (controlPoint.type == 0) {
            PropResizer propResizer = controlPoint.owner;
            ControlPoint controlPoint2 = (ControlPoint)controlPoint.prevHandle.getOwner();
            ControlPoint controlPoint3 = (ControlPoint)controlPoint.nextHandle.getOwner();
            VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
            virtualSpace.destroyGlyph((Glyph)controlPoint.handle);
            virtualSpace.destroyGlyph((Glyph)controlPoint.s1);
            virtualSpace.destroyGlyph((Glyph)controlPoint.s2);
            while (controlPoint3.type > 2) {
                virtualSpace.destroyGlyph((Glyph)controlPoint3.handle);
                virtualSpace.destroyGlyph((Glyph)controlPoint3.s2);
                controlPoint3 = (ControlPoint)controlPoint3.nextHandle.getOwner();
            }
            ControlPoint controlPoint4 = controlPoint3;
            LongPoint longPoint = new LongPoint(controlPoint2.handle.vx, controlPoint2.handle.vy);
            LongPoint longPoint2 = new LongPoint(controlPoint4.handle.vx, controlPoint4.handle.vy);
            VSegment vSegment = new VSegment((longPoint.x + longPoint2.x) / 2L, (longPoint.y + longPoint2.y) / 2L, 0.0f, (longPoint2.x - longPoint.x) / 2L, (longPoint.y - longPoint2.y) / 2L, Color.red);
            Editor.vsm.addGlyph((Glyph)vSegment, "rdfSpace");
            controlPoint2.setSecondSegment(vSegment, controlPoint4.handle);
            controlPoint4.prevHandle = controlPoint2.handle;
            controlPoint4.s1 = vSegment;
            Vector<ControlPoint> vector = new Vector<ControlPoint>();
            controlPoint3 = propResizer.cps[0];
            vector.add(controlPoint3);
            while (controlPoint3.nextHandle != null) {
                controlPoint3 = (ControlPoint)controlPoint3.nextHandle.getOwner();
                vector.add(controlPoint3);
            }
            propResizer.cps = vector.toArray(new ControlPoint[vector.size()]);
            propResizer.updateMainGlyph(null);
        }
    }

    static VPath invertPath(long l, long l2, VPath vPath) {
        double d;
        double d2;
        double d3;
        double d4;
        PathIterator pathIterator = vPath.getJava2DPathIterator();
        double[] dArray = new double[6];
        int n = pathIterator.currentSegment(dArray);
        pathIterator.next();
        if (n == 0) {
            d4 = dArray[0];
            d3 = dArray[1];
        } else {
            d4 = 0.0;
            d3 = 0.0;
        }
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(dArray);
            pathIterator.next();
        }
        if (n == 3) {
            d2 = dArray[4];
            d = dArray[5];
        } else if (n == 2) {
            d2 = dArray[2];
            d = dArray[3];
        } else if (n == 1) {
            d2 = dArray[0];
            d = dArray[1];
        } else if (n == 4) {
            d2 = d4;
            d = d3;
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        double d5 = Math.sqrt(Math.pow((double)l - d4, 2.0) + Math.pow((double)l2 - d3, 2.0));
        double d6 = Math.sqrt(Math.pow((double)l - d2, 2.0) + Math.pow((double)l2 - d, 2.0));
        if (d5 < d6) {
            pathIterator = vPath.getJava2DPathIterator();
            Vector<PathSegment> vector = new Vector<PathSegment>();
            while (!pathIterator.isDone()) {
                n = pathIterator.currentSegment(dArray);
                vector.add(new PathSegment(dArray, n));
                pathIterator.next();
            }
            VPath vPath2 = new VPath();
            PathSegment pathSegment = (PathSegment)vector.elementAt(vector.size() - 1);
            if (pathSegment.getType() == 3) {
                vPath2.jump((long)pathSegment.cds[4], (long)pathSegment.cds[5], true);
            } else if (pathSegment.getType() == 0) {
                vPath2.jump((long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
            } else if (pathSegment.getType() == 2) {
                vPath2.jump((long)pathSegment.cds[2], (long)pathSegment.cds[3], true);
            } else if (pathSegment.getType() == 1) {
                vPath2.jump((long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
            }
            int n2 = vector.size() - 1;
            while (n2 > 0) {
                pathSegment = (PathSegment)vector.elementAt(n2);
                PathSegment pathSegment2 = (PathSegment)vector.elementAt(n2 - 1);
                if (pathSegment.getType() == 3) {
                    if (pathSegment2.getType() == 3) {
                        vPath2.addCbCurve((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    } else if (pathSegment2.getType() == 0) {
                        vPath2.addCbCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    } else if (pathSegment2.getType() == 2) {
                        vPath2.addCbCurve((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    } else if (pathSegment2.getType() == 1) {
                        vPath2.addCbCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[2], (long)pathSegment.cds[3], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    }
                } else if (pathSegment.getType() == 0) {
                    if (pathSegment2.getType() == 3) {
                        vPath2.jump((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], true);
                    } else if (pathSegment2.getType() == 0) {
                        vPath2.jump((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
                    } else if (pathSegment2.getType() == 2) {
                        vPath2.jump((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], true);
                    } else if (pathSegment2.getType() == 1) {
                        vPath2.jump((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
                    }
                } else if (pathSegment.getType() == 2) {
                    if (pathSegment2.getType() == 3) {
                        vPath2.addQdCurve((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], (long)pathSegment.cds[4], (long)pathSegment.cds[5], true);
                    } else if (pathSegment2.getType() == 0) {
                        vPath2.addQdCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    } else if (pathSegment2.getType() == 2) {
                        vPath2.addQdCurve((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], (long)pathSegment.cds[2], (long)pathSegment.cds[3], true);
                    } else if (pathSegment2.getType() == 1) {
                        vPath2.addQdCurve((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], (long)pathSegment.cds[0], (long)pathSegment.cds[1], true);
                    }
                } else if (pathSegment.getType() == 1) {
                    if (pathSegment2.getType() == 3) {
                        vPath2.addSegment((long)pathSegment2.cds[4], (long)pathSegment2.cds[5], true);
                    } else if (pathSegment2.getType() == 0) {
                        vPath2.addSegment((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
                    } else if (pathSegment2.getType() == 2) {
                        vPath2.addSegment((long)pathSegment2.cds[2], (long)pathSegment2.cds[3], true);
                    } else if (pathSegment2.getType() == 1) {
                        vPath2.addSegment((long)pathSegment2.cds[0], (long)pathSegment2.cds[1], true);
                    }
                }
                --n2;
            }
            return vPath2;
        }
        return vPath;
    }

    public static LongPoint[] computeVPolygonCoords(long l, long l2, long l3, float[] fArray) {
        if (fArray.length >= 2) {
            LongPoint[] longPointArray = new LongPoint[fArray.length / 2];
            int n = 0;
            while (n < longPointArray.length) {
                longPointArray[n] = new LongPoint(l + (long)fArray[2 * n], l2 + (long)fArray[2 * n + 1]);
                ++n;
            }
            return longPointArray;
        }
        return null;
    }

    public static Glyph getNorthMostGlyph(Vector vector) {
        if (vector != null && vector.size() > 0) {
            Glyph glyph = (Glyph)vector.firstElement();
            int n = 1;
            while (n < vector.size()) {
                if (((Glyph)vector.elementAt((int)n)).vy > glyph.vy) {
                    glyph = (Glyph)vector.elementAt(n);
                }
                ++n;
            }
            return glyph;
        }
        return null;
    }

    public static Glyph getSouthMostGlyph(Vector vector) {
        if (vector != null && vector.size() > 0) {
            Glyph glyph = (Glyph)vector.firstElement();
            int n = 1;
            while (n < vector.size()) {
                if (((Glyph)vector.elementAt((int)n)).vy < glyph.vy) {
                    glyph = (Glyph)vector.elementAt(n);
                }
                ++n;
            }
            return glyph;
        }
        return null;
    }

    public static VTriangleOr createPathArrowHead(LongPoint longPoint, LongPoint longPoint2, VTriangleOr vTriangleOr) {
        return GeometryManager.createPathArrowHead(longPoint.x, longPoint.y, longPoint2.x, longPoint2.y, vTriangleOr);
    }

    public static VTriangleOr createPathArrowHead(double d, double d2, double d3, double d4, VTriangleOr vTriangleOr) {
        Point2D point2D = GeometryManager.computeStepValue(d, d2, d3, d4);
        double d5 = 0.0;
        if (point2D.getX() == 0.0) {
            d5 = 0.0;
            if (point2D.getY() < 0.0) {
                d5 = Math.PI;
            }
        } else {
            d5 = Math.atan(point2D.getY() / point2D.getX());
            d5 = point2D.getX() < 0.0 ? (d5 += 1.5707963267948966) : (d5 -= 1.5707963267948966);
        }
        if (vTriangleOr != null) {
            vTriangleOr.moveTo((long)d3, (long)d4);
            vTriangleOr.orientTo((float)d5);
            return vTriangleOr;
        }
        return new VTriangleOr((long)d3, (long)d4, 0.0f, (long)ARROW_HEAD_SIZE, ConfigManager.propertyColorB, (float)d5);
    }

    public static Point2D computeStepValue(LongPoint longPoint, LongPoint longPoint2) {
        double d;
        double d2;
        int n;
        int n2 = longPoint2.x >= longPoint.x ? 1 : -1;
        int n3 = n = longPoint2.y >= longPoint.y ? 1 : -1;
        if (longPoint2.x == longPoint.x) {
            d2 = 0.0;
            d = n;
        } else {
            double d3 = (double)(longPoint2.y - longPoint.y) / (double)(longPoint2.x - longPoint.x);
            if (Math.abs(d3) > 1.0) {
                d2 = (double)n2 / Math.abs(d3);
                d = n;
            } else {
                d2 = n2;
                d = (double)n * Math.abs(d3);
            }
        }
        return new Point2D.Double(d2, d);
    }

    public static Point2D computeStepValue(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        int n;
        int n2 = d3 >= d ? 1 : -1;
        int n3 = n = d4 >= d2 ? 1 : -1;
        if (d3 == d) {
            d6 = 0.0;
            d5 = n;
        } else {
            double d7 = (d4 - d2) / (d3 - d);
            if (Math.abs(d7) > 1.0) {
                d6 = (double)n2 / Math.abs(d7);
                d5 = n;
            } else {
                d6 = n2;
                d5 = (double)n * Math.abs(d7);
            }
        }
        return new Point2D.Double(d6, d5);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Glyph getNodeShape(INode iNode, StyleInfo styleInfo) {
        Serializable serializable;
        Object object;
        block46: {
            block47: {
                object = null;
                URL uRL = null;
                if (styleInfo instanceof StyleInfoR) {
                    object = ((StyleInfoR)styleInfo).getShape();
                    uRL = ((StyleInfoR)styleInfo).getIcon();
                } else {
                    object = ((StyleInfoL)styleInfo).getShape();
                    uRL = ((StyleInfoL)styleInfo).getIcon();
                }
                if (object != null) break block46;
                if (uRL == null) break block47;
                if (iNode instanceof IResource) {
                    void var5_9;
                    block45: {
                        Object var5_5 = null;
                        if (uRL.toString().equals(GraphStylesheet._gssFetch)) {
                            try {
                                serializable = new URL(((IResource)iNode).getIdentity());
                                if (serializable != null) {
                                    if (Editor.gssMngr.storeIcon((URL)serializable)) {
                                        VImage vImage = new VImage(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, Editor.gssMngr.getIcon((URL)serializable).getImage());
                                        vImage.setDrawBorderPolicy(VImage.DRAW_BORDER_ALWAYS);
                                        break block45;
                                    }
                                }
                                if (GraphStylesheet.DEBUG_GSS) {
                                    System.err.println("Error: there does not seem to be any icon at the following URI :" + serializable);
                                }
                                object = GraphStylesheet.DEFAULT_RESOURCE_SHAPE;
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (GraphStylesheet.DEBUG_GSS) {
                                    System.err.println("Error:RDFLoader.getNodeShape(): malformed icon URI: " + ((IResource)iNode).getIdentity());
                                    malformedURLException.printStackTrace();
                                }
                                break block45;
                            }
                        }
                        VImage vImage = new VImage(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, Editor.gssMngr.getIcon(uRL).getImage());
                        vImage.setDrawBorderPolicy(VImage.DRAW_BORDER_ALWAYS);
                    }
                    if (var5_9 != null) {
                        if (iNode.getGlyph() instanceof RectangularShape) {
                            if (var5_9.getWidth() >= var5_9.getHeight()) {
                                var5_9.setWidth(((RectangularShape)iNode.getGlyph()).getWidth());
                                return var5_9;
                            }
                            var5_9.setHeight(((RectangularShape)iNode.getGlyph()).getHeight());
                            return var5_9;
                        }
                        if (var5_9.getWidth() >= var5_9.getHeight()) {
                            var5_9.setWidth((long)Math.round(iNode.getGlyph().getSize()));
                            return var5_9;
                        }
                        var5_9.setHeight((long)Math.round(iNode.getGlyph().getSize()));
                        return var5_9;
                    }
                    break block46;
                } else {
                    VImage vImage = new VImage(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, Editor.gssMngr.getIcon(uRL).getImage());
                    vImage.setDrawBorderPolicy(VImage.DRAW_BORDER_ALWAYS);
                    if (iNode.getGlyph() instanceof RectangularShape) {
                        if (vImage.getWidth() >= vImage.getHeight()) {
                            vImage.setWidth(((RectangularShape)iNode.getGlyph()).getWidth());
                            return vImage;
                        }
                        vImage.setHeight(((RectangularShape)iNode.getGlyph()).getHeight());
                        return vImage;
                    }
                    if (vImage.getWidth() >= vImage.getHeight()) {
                        vImage.setWidth((long)Math.round(iNode.getGlyph().getSize()));
                        return vImage;
                    }
                    vImage.setHeight((long)Math.round(iNode.getGlyph().getSize()));
                    return vImage;
                }
            }
            object = iNode instanceof IResource ? GraphStylesheet.DEFAULT_RESOURCE_SHAPE : GraphStylesheet.DEFAULT_LITERAL_SHAPE;
        }
        if (object != null && object instanceof Integer) {
            long l;
            if (object.equals(Style.ELLIPSE)) {
                if (iNode.getGlyph() instanceof RectangularShape) {
                    long l2 = ((RectangularShape)iNode.getGlyph()).getWidth();
                    long l3 = ((RectangularShape)iNode.getGlyph()).getHeight();
                    return new VEllipse(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, l2, l3, iNode.getGlyph().getColor());
                }
                long l4 = Math.round(iNode.getGlyph().getSize());
                return new VEllipse(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, l4, l4, iNode.getGlyph().getColor());
            }
            if (object.equals(Style.RECTANGLE)) {
                if (iNode.getGlyph() instanceof RectangularShape) {
                    long l5 = ((RectangularShape)iNode.getGlyph()).getWidth();
                    long l6 = ((RectangularShape)iNode.getGlyph()).getHeight();
                    return new VRectangle(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, l5, l6, iNode.getGlyph().getColor());
                }
                long l7 = Math.round(iNode.getGlyph().getSize());
                return new VRectangle(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, l7, l7, iNode.getGlyph().getColor());
            }
            if (object.equals(Style.CIRCLE)) {
                long l8;
                if (!(iNode.getGlyph() instanceof RectangularShape)) return new VCircle(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, (long)Math.round(iNode.getGlyph().getSize()), iNode.getGlyph().getColor());
                long l9 = ((RectangularShape)iNode.getGlyph()).getWidth();
                long l10 = ((RectangularShape)iNode.getGlyph()).getHeight();
                long l11 = iNode.getGlyph().vx;
                long l12 = iNode.getGlyph().vy;
                if (l9 > l10) {
                    l8 = l10;
                    return new VCircle(l11, l12, 0.0f, l8, iNode.getGlyph().getColor());
                }
                l8 = l9;
                return new VCircle(l11, l12, 0.0f, l8, iNode.getGlyph().getColor());
            }
            if (object.equals(Style.DIAMOND)) {
                long l13;
                if (!(iNode.getGlyph() instanceof RectangularShape)) return new VDiamond(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, (long)Math.round(iNode.getGlyph().getSize()), iNode.getGlyph().getColor());
                long l14 = ((RectangularShape)iNode.getGlyph()).getWidth();
                long l15 = ((RectangularShape)iNode.getGlyph()).getHeight();
                long l16 = iNode.getGlyph().vx;
                long l17 = iNode.getGlyph().vy;
                if (l14 > l15) {
                    l13 = l15;
                    return new VDiamond(l16, l17, 0.0f, l13, iNode.getGlyph().getColor());
                }
                l13 = l14;
                return new VDiamond(l16, l17, 0.0f, l13, iNode.getGlyph().getColor());
            }
            if (object.equals(Style.OCTAGON)) {
                long l18;
                if (!(iNode.getGlyph() instanceof RectangularShape)) return new VOctagon(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, (long)Math.round(iNode.getGlyph().getSize()), iNode.getGlyph().getColor());
                long l19 = ((RectangularShape)iNode.getGlyph()).getWidth();
                long l20 = ((RectangularShape)iNode.getGlyph()).getHeight();
                long l21 = iNode.getGlyph().vx;
                long l22 = iNode.getGlyph().vy;
                if (l19 > l20) {
                    l18 = l20;
                    return new VOctagon(l21, l22, 0.0f, l18, iNode.getGlyph().getColor());
                }
                l18 = l19;
                return new VOctagon(l21, l22, 0.0f, l18, iNode.getGlyph().getColor());
            }
            if (object.equals(Style.ROUND_RECTANGLE)) {
                if (iNode.getGlyph() instanceof RectangularShape) {
                    long l23 = ((RectangularShape)iNode.getGlyph()).getWidth();
                    long l24 = ((RectangularShape)iNode.getGlyph()).getHeight();
                    return new VRoundRect(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, l23, l24, iNode.getGlyph().getColor(), Math.round(SVGReader.RRARCR * (float)Math.min(l23, l24)), Math.round(SVGReader.RRARCR * (float)Math.min(l23, l24)));
                }
                long l25 = Math.round(iNode.getGlyph().getSize());
                return new VRoundRect(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, l25, l25, iNode.getGlyph().getColor(), Math.round(SVGReader.RRARCR * (float)l25), Math.round(SVGReader.RRARCR * (float)l25));
            }
            if (object.equals(Style.TRIANGLEN)) {
                long l26;
                if (!(iNode.getGlyph() instanceof RectangularShape)) return new VTriangle(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, (long)Math.round(iNode.getGlyph().getSize()), iNode.getGlyph().getColor());
                long l27 = ((RectangularShape)iNode.getGlyph()).getWidth();
                long l28 = ((RectangularShape)iNode.getGlyph()).getHeight();
                long l29 = iNode.getGlyph().vx;
                long l30 = iNode.getGlyph().vy;
                if (l27 > l28) {
                    l26 = l28;
                    return new VTriangle(l29, l30, 0.0f, l26, iNode.getGlyph().getColor());
                }
                l26 = l27;
                return new VTriangle(l29, l30, 0.0f, l26, iNode.getGlyph().getColor());
            }
            if (object.equals(Style.TRIANGLES)) {
                long l31;
                if (!(iNode.getGlyph() instanceof RectangularShape)) return new VTriangleOr(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, (long)Math.round(iNode.getGlyph().getSize()), iNode.getGlyph().getColor(), (float)Math.PI);
                long l32 = ((RectangularShape)iNode.getGlyph()).getWidth();
                long l33 = ((RectangularShape)iNode.getGlyph()).getHeight();
                long l34 = iNode.getGlyph().vx;
                long l35 = iNode.getGlyph().vy;
                if (l32 > l33) {
                    l31 = l33;
                    return new VTriangleOr(l34, l35, 0.0f, l31, iNode.getGlyph().getColor(), (float)Math.PI);
                }
                l31 = l32;
                return new VTriangleOr(l34, l35, 0.0f, l31, iNode.getGlyph().getColor(), (float)Math.PI);
            }
            if (object.equals(Style.TRIANGLEE)) {
                long l36;
                if (!(iNode.getGlyph() instanceof RectangularShape)) return new VTriangleOr(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, (long)Math.round(iNode.getGlyph().getSize()), iNode.getGlyph().getColor(), -1.5707964f);
                long l37 = ((RectangularShape)iNode.getGlyph()).getWidth();
                long l38 = ((RectangularShape)iNode.getGlyph()).getHeight();
                long l39 = iNode.getGlyph().vx;
                long l40 = iNode.getGlyph().vy;
                if (l37 > l38) {
                    l36 = l38;
                    return new VTriangleOr(l39, l40, 0.0f, l36, iNode.getGlyph().getColor(), -1.5707964f);
                }
                l36 = l37;
                return new VTriangleOr(l39, l40, 0.0f, l36, iNode.getGlyph().getColor(), -1.5707964f);
            }
            if (!object.equals(Style.TRIANGLEW)) {
                System.err.println("Error: GeometryManager.getNodeShape(): requested shape type unknown: " + object.toString());
                return null;
            }
            if (!(iNode.getGlyph() instanceof RectangularShape)) return new VTriangleOr(iNode.getGlyph().vx, iNode.getGlyph().vy, 0.0f, (long)Math.round(iNode.getGlyph().getSize()), iNode.getGlyph().getColor(), 1.5707964f);
            long l41 = ((RectangularShape)iNode.getGlyph()).getWidth();
            long l42 = ((RectangularShape)iNode.getGlyph()).getHeight();
            long l43 = iNode.getGlyph().vx;
            long l44 = iNode.getGlyph().vy;
            if (l41 > l42) {
                l = l42;
                return new VTriangleOr(l43, l44, 0.0f, l, iNode.getGlyph().getColor(), 1.5707964f);
            }
            l = l41;
            return new VTriangleOr(l43, l44, 0.0f, l, iNode.getGlyph().getColor(), 1.5707964f);
        }
        if (object != null && object instanceof CustomShape) {
            float f;
            float[] fArray = ((CustomShape)object).getVertices();
            serializable = ((CustomShape)object).getOrientation();
            if (iNode.getGlyph() instanceof RectangularShape) {
                float f2;
                long l = ((RectangularShape)iNode.getGlyph()).getWidth();
                long l45 = ((RectangularShape)iNode.getGlyph()).getHeight();
                long l46 = iNode.getGlyph().vx;
                long l47 = iNode.getGlyph().vy;
                long l48 = l > l45 ? l45 : l;
                Color color = iNode.getGlyph().getColor();
                if (serializable != null) {
                    f2 = ((Float)serializable).floatValue();
                    return new VShape(l46, l47, 0.0f, l48, fArray, color, f2);
                }
                f2 = 0.0f;
                return new VShape(l46, l47, 0.0f, l48, fArray, color, f2);
            }
            long l = iNode.getGlyph().vx;
            long l49 = iNode.getGlyph().vy;
            long l50 = Math.round(iNode.getGlyph().getSize());
            Color color = iNode.getGlyph().getColor();
            if (serializable != null) {
                f = ((Float)serializable).floatValue();
                return new VShape(l, l49, 0.0f, l50, fArray, color, f);
            }
            f = 0.0f;
            return new VShape(l, l49, 0.0f, l50, fArray, color, f);
        }
        if (object != null && object instanceof CustomPolygon) {
            float[] fArray = ((CustomPolygon)object).getVertices();
            if (!(iNode.getGlyph() instanceof RectangularShape)) {
                return new VPolygon(GeometryManager.computeVPolygonCoords(iNode.getGlyph().vx, iNode.getGlyph().vy, Math.round(iNode.getGlyph().getSize()), fArray), iNode.getGlyph().getColor());
            }
            long l = ((RectangularShape)iNode.getGlyph()).getWidth();
            long l51 = ((RectangularShape)iNode.getGlyph()).getHeight();
            return new VPolygon(GeometryManager.computeVPolygonCoords(iNode.getGlyph().vx, iNode.getGlyph().vy, l > l51 ? l51 : l, fArray), iNode.getGlyph().getColor());
        }
        System.err.println("Error: GeometryManager.getNodeShape(): requested shape type unknown: " + object.toString());
        return null;
    }
}

