/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import org.w3c.IsaViz.GSSStatement;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.Utils;

public class GSSSOStatement
extends GSSStatement {
    String subjectType;
    String subjectURI;
    String objectType;
    String objectValueOrURI;
    Boolean literalObject;

    GSSSOStatement(String string, String string2, String string3, String string4, Boolean bl) {
        this.subjectType = string;
        if (this.subjectType != null && this.subjectType.length() == 0) {
            this.subjectType = null;
        }
        this.subjectURI = string2;
        if (this.subjectURI != null && this.subjectURI.length() == 0) {
            this.subjectURI = null;
        }
        this.objectType = string3;
        if (this.objectType != null && this.objectType.length() == 0) {
            this.objectType = null;
        }
        this.objectValueOrURI = string4;
        if (this.objectValueOrURI != null) {
            if (this.objectValueOrURI.length() > 0) {
                this.objectValueOrURI = Utils.delLeadingAndTrailingSpaces(this.objectValueOrURI);
            }
            if (this.objectValueOrURI.length() == 0) {
                this.objectValueOrURI = null;
            }
        }
        this.literalObject = bl;
    }

    public String getSubjectType() {
        return this.subjectType;
    }

    public String getSubjectURI() {
        return this.subjectURI;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectValueOrURI() {
        return this.objectValueOrURI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean selects(IProperty iProperty) {
        Object object;
        boolean bl = true;
        IResource iResource = iProperty.getSubject();
        INode iNode = iProperty.getObject();
        if (this.subjectType != null) {
            if (iResource == null) return false;
            if (!iResource.hasRDFType(this.subjectType)) {
                return false;
            }
        }
        if (this.subjectURI != null) {
            if (iResource == null) return false;
            if (!iResource.getIdentity().equals(this.subjectURI)) {
                return false;
            }
        }
        if (iNode == null) return false;
        if (iNode instanceof IResource) {
            if (this.literalObject != null && this.literalObject.booleanValue()) {
                return false;
            }
            if (this.objectType != null && !((IResource)iNode).hasRDFType(this.objectType)) {
                return false;
            }
            if (this.objectValueOrURI == null) return bl;
            if (((IResource)iNode).getIdentity().equals(this.objectValueOrURI)) return bl;
            return false;
        }
        if (this.literalObject != null && !this.literalObject.booleanValue()) {
            return false;
        }
        if (this.objectType != null) {
            object = ((ILiteral)iNode).getDatatype();
            if (this.objectType.equals(GraphStylesheet._gssPlainLiterals)) {
                if (object != null) {
                    return false;
                }
            } else if (this.objectType.equals(GraphStylesheet._gssAllDatatypes)) {
                if (object == null) {
                    return false;
                }
            } else {
                if (object == null) {
                    return false;
                }
                if (!this.objectType.equals(object.getURI())) {
                    return false;
                }
            }
        }
        if (this.objectValueOrURI == null) return bl;
        object = ((ILiteral)iNode).getValue();
        if (object == null) return false;
        if (((String)(object = Utils.delLeadingAndTrailingSpaces((String)object))).length() <= 0) return false;
        if (this.objectValueOrURI.equals(object)) return bl;
        return false;
    }
}

