/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.xerox.VTM.engine.SwingWorker;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GSSEditor;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.RDFLoader;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.StyleInfoL;
import org.w3c.IsaViz.StyleInfoP;
import org.w3c.IsaViz.StyleInfoR;
import org.w3c.IsaViz.TextViewer;
import org.w3c.IsaViz.Utils;

class GSSManager {
    static File lastStyleDir = null;
    static boolean ALLOW_INCREMENTAL_STYLING = false;
    Editor application;
    Hashtable stylesheetFiles;
    Hashtable resource2styleTable;
    Hashtable property2styleTable;
    Hashtable literal2styleTable;
    GraphStylesheet[] stylesheets;
    Hashtable url2icon;

    public static String getType(Resource resource) {
        String string = null;
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            if (!statement.getPredicate().getURI().equals(GraphStylesheet._rdfType)) continue;
            RDFNode rDFNode = statement.getObject();
            if (rDFNode == null) break;
            string = rDFNode.toString();
            break;
        }
        stmtIterator.close();
        return string;
    }

    public static String getType(IResource iResource) {
        String string = null;
        Vector vector = iResource.getOutgoingPredicates();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty = (IProperty)vector.elementAt(n);
                if (iProperty.getIdent().equals(GraphStylesheet._rdfType)) {
                    INode iNode = iProperty.getObject();
                    if (iNode instanceof IResource) {
                        string = ((IResource)iNode).getIdentity();
                        break;
                    }
                    if (iNode instanceof ILiteral) {
                        string = ((ILiteral)iNode).getValue();
                        break;
                    }
                }
                ++n;
            }
        }
        return string;
    }

    public static boolean objectCanBeDisplayedInTable(IResource iResource) {
        Vector vector = iResource.getIncomingPredicates();
        Vector vector2 = iResource.getOutgoingPredicates();
        if (vector2 == null || vector2.size() == 0) {
            if (vector != null) {
                return vector.size() == 1;
            }
            return false;
        }
        return false;
    }

    GSSManager(Editor editor) {
        this.application = editor;
        this.stylesheetFiles = new Hashtable();
        this.url2icon = new Hashtable();
    }

    void reset() {
        this.stylesheetFiles.clear();
        this.url2icon.clear();
    }

    public void loadStylesheet(final File file, final int n) {
        lastStyleDir = file.getParentFile();
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Editor.tblp.setCursor(new Cursor(3));
                Editor.tblp.setSTPBValue(0);
                GraphStylesheet graphStylesheet = new GraphStylesheet();
                graphStylesheet.load(file, GSSManager.this.application.isvMngr.application, n);
                if (GSSManager.this.application.reportError) {
                    Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
                    GSSManager.this.application.reportError = false;
                }
                GSSManager.this.stylesheetFiles.put(file, graphStylesheet);
                Editor.tblp.addStylesheet(file);
                Editor.tblp.setSTPBValue(100);
                Editor.tblp.setCursor(Cursor.getDefaultCursor());
                return null;
            }
        };
        swingWorker.start();
    }

    public void loadStylesheet(final URL uRL, final int n) {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Editor.tblp.setCursor(new Cursor(3));
                Editor.tblp.setSTPBValue(0);
                GraphStylesheet graphStylesheet = new GraphStylesheet();
                graphStylesheet.load(uRL, GSSManager.this.application.isvMngr.application, n);
                if (GSSManager.this.application.reportError) {
                    Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
                    GSSManager.this.application.reportError = false;
                }
                GSSManager.this.stylesheetFiles.put(uRL, graphStylesheet);
                Editor.tblp.addStylesheet(uRL);
                Editor.tblp.setSTPBValue(100);
                Editor.tblp.setCursor(Cursor.getDefaultCursor());
                return null;
            }
        };
        swingWorker.start();
    }

    void removeSelectedStylesheet() {
        Object object = Editor.tblp.removeSelectedStylesheet();
        if (object != null) {
            this.stylesheetFiles.remove(object);
        }
    }

    void editSelectedStylesheet(Object object) {
        if (object != null) {
            if (object instanceof File) {
                new GSSEditor(this.application).loadStylesheet((File)object, false);
            } else if (object instanceof URL) {
                new GSSEditor(this.application).loadStylesheet((URL)object, false);
            }
        }
    }

    Vector getStylesheetList() {
        Vector vector = Editor.tblp.getStylesheetList();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(this.stylesheetFiles.get(vector.elementAt(n)));
            ++n;
        }
        return vector2;
    }

    void applyStylesheets() {
        Vector vector = this.getStylesheetList();
        if (vector.size() > 0) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Editor.vsm.getView("Graph").setCursorIcon(3);
                    GSSManager.this.application.generateJenaModel();
                    File file = Utils.createTempFile(Editor.m_TmpDir.toString(), "mrg", ".rdf");
                    boolean bl = Editor.ABBREV_SYNTAX;
                    Editor.ABBREV_SYNTAX = true;
                    GSSManager.this.application.rdfLdr.save(GSSManager.this.application.rdfModel, file);
                    if (!bl) {
                        Editor.ABBREV_SYNTAX = false;
                    }
                    GSSManager.this.application.reset(false);
                    GSSManager.this.application.rdfLdr.loadAndStyle(file, RDFLoader.RDF_XML_READER);
                    if (Editor.dltOnExit && file != null) {
                        file.deleteOnExit();
                    }
                    GSSManager.this.application.updatePrefixBindingsInGraph();
                    Editor.vsm.getView("Graph").setCursorIcon(-1);
                    if (GraphStylesheet.DEBUG_GSS) {
                        TextViewer textViewer = new TextViewer(GraphStylesheet.debugBuffer2, "GSS Debugger - Rule Evaluation", 0, true);
                    }
                    return null;
                }
            };
            swingWorker.start();
        }
    }

    protected void initStyleTables() {
        Vector vector = this.getStylesheetList();
        this.stylesheets = new GraphStylesheet[vector.size()];
        int n = vector.size() - 1;
        while (n >= 0) {
            this.stylesheets[vector.size() - 1 - n] = (GraphStylesheet)vector.elementAt(n);
            --n;
        }
        this.resource2styleTable = new Hashtable();
        this.property2styleTable = new Hashtable();
        this.literal2styleTable = new Hashtable();
    }

    protected void cleanStyleTables() {
        this.resource2styleTable.clear();
        this.property2styleTable.clear();
        this.literal2styleTable.clear();
        this.resource2styleTable = null;
        this.property2styleTable = null;
        this.literal2styleTable = null;
    }

    StyleInfoR getStyle(IResource iResource) {
        return (StyleInfoR)this.resource2styleTable.get(iResource);
    }

    StyleInfoR computeAndGetStyle(IResource iResource) {
        StyleInfoR styleInfoR;
        if (this.resource2styleTable.containsKey(iResource)) {
            styleInfoR = (StyleInfoR)this.resource2styleTable.get(iResource);
        } else {
            styleInfoR = new StyleInfoR();
            this.resource2styleTable.put(iResource, styleInfoR);
            int n = 0;
            while (n < this.stylesheets.length) {
                Vector vector = this.stylesheets[n].evaluateRules(iResource);
                int n2 = 0;
                while (n2 < vector.size()) {
                    Object e = vector.elementAt(n2);
                    if (this.stylesheets[n].rStyleRules.containsKey(e)) {
                        Vector vector2 = (Vector)this.stylesheets[n].rStyleRules.get(e);
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            styleInfoR.applyStyle((Style)this.stylesheets[n].styles.get(vector2.elementAt(n3)));
                            ++n3;
                        }
                    }
                    styleInfoR.applyLayout((Integer)this.stylesheets[n].rLayoutRules.get(e));
                    styleInfoR.applyVisibility((Integer)this.stylesheets[n].rVisRules.get(e));
                    Object v = this.stylesheets[n].sortRules.get(e);
                    if (v != null) {
                        if (v instanceof String) {
                            styleInfoR.setPropertyOrdering(this.stylesheets[n].orderings.get(v));
                        } else if (v instanceof Integer) {
                            styleInfoR.setPropertyOrdering(v);
                        } else if (GraphStylesheet.DEBUG_GSS) {
                            System.err.println("Error: GSSManager.computeAndGetStyle() failed to build an ordering of properties for resource " + iResource.toString() + " because the specification of this ordering is incorrect: " + v);
                        }
                    }
                    if (styleInfoR.isFullySpecified() || styleInfoR.isDisplayNone() || styleInfoR.isVisibilityHiddenAndShapeSpecified()) {
                        return styleInfoR;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return styleInfoR;
    }

    StyleInfoP getStyle(IProperty iProperty) {
        return (StyleInfoP)this.property2styleTable.get(iProperty);
    }

    StyleInfoP computeAndGetStyle(IProperty iProperty) {
        StyleInfoP styleInfoP;
        if (this.property2styleTable.containsKey(iProperty)) {
            styleInfoP = (StyleInfoP)this.property2styleTable.get(iProperty);
        } else {
            styleInfoP = new StyleInfoP();
            this.property2styleTable.put(iProperty, styleInfoP);
            int n = 0;
            while (n < this.stylesheets.length) {
                Vector vector = this.stylesheets[n].evaluateRules(iProperty);
                int n2 = 0;
                while (n2 < vector.size()) {
                    Object e = vector.elementAt(n2);
                    if (this.stylesheets[n].pStyleRules.containsKey(e)) {
                        Vector vector2 = (Vector)this.stylesheets[n].pStyleRules.get(e);
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            styleInfoP.applyStyle((Style)this.stylesheets[n].styles.get(vector2.elementAt(n3)));
                            ++n3;
                        }
                    }
                    styleInfoP.applyLayout((Integer)this.stylesheets[n].pLayoutRules.get(e));
                    styleInfoP.applyVisibility((Integer)this.stylesheets[n].pVisRules.get(e));
                    if (styleInfoP.isFullySpecified() || styleInfoP.isDisplayNone() || styleInfoP.isVisibilityHidden()) {
                        return styleInfoP;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return styleInfoP;
    }

    StyleInfoL getStyle(ILiteral iLiteral) {
        return (StyleInfoL)this.literal2styleTable.get(iLiteral);
    }

    StyleInfoL computeAndGetStyle(ILiteral iLiteral) {
        StyleInfoL styleInfoL;
        if (this.literal2styleTable.containsKey(iLiteral)) {
            styleInfoL = (StyleInfoL)this.literal2styleTable.get(iLiteral);
        } else {
            styleInfoL = new StyleInfoL();
            this.literal2styleTable.put(iLiteral, styleInfoL);
            int n = 0;
            while (n < this.stylesheets.length) {
                Vector vector = this.stylesheets[n].evaluateRules(iLiteral);
                int n2 = 0;
                while (n2 < vector.size()) {
                    Object e = vector.elementAt(n2);
                    if (this.stylesheets[n].lStyleRules.containsKey(e)) {
                        Vector vector2 = (Vector)this.stylesheets[n].lStyleRules.get(e);
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            styleInfoL.applyStyle((Style)this.stylesheets[n].styles.get(vector2.elementAt(n3)));
                            ++n3;
                        }
                    }
                    styleInfoL.applyLayout((Integer)this.stylesheets[n].lLayoutRules.get(e));
                    styleInfoL.applyVisibility((Integer)this.stylesheets[n].lVisRules.get(e));
                    if (styleInfoL.isFullySpecified() || styleInfoL.isDisplayNone() || styleInfoL.isVisibilityHiddenAndShapeSpecified()) {
                        return styleInfoL;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return styleInfoL;
    }

    void incStyling(IResource iResource) {
        if (iResource != null && ALLOW_INCREMENTAL_STYLING) {
            this.initStyleTables();
            this.assignStyle(iResource);
            if (iResource.getIncomingPredicates() != null) {
                Enumeration enumeration = iResource.getIncomingPredicates().elements();
                while (enumeration.hasMoreElements()) {
                    IProperty iProperty = (IProperty)enumeration.nextElement();
                    this.assignStyle(iProperty);
                    if (iProperty.getSubject() != null) {
                        this.assignStyle(iProperty.getSubject());
                        if (iProperty.getSubject().getIncomingPredicates() != null) {
                            Enumeration enumeration2 = iProperty.getSubject().getIncomingPredicates().elements();
                            while (enumeration2.hasMoreElements()) {
                                IProperty iProperty2 = (IProperty)enumeration2.nextElement();
                                this.assignStyle(iProperty2);
                                if (iProperty2.getSubject() == null) continue;
                                this.assignStyle(iProperty2.getSubject());
                            }
                        }
                    }
                    if (iProperty.getObject() == null || iProperty.getObject() == iResource) continue;
                    if (iProperty.getObject() instanceof IResource) {
                        this.assignStyle((IResource)iProperty.getObject());
                        continue;
                    }
                    this.assignStyle((ILiteral)iProperty.getObject());
                }
            }
            this.cleanStyleTables();
        }
    }

    void incStyling(ILiteral iLiteral) {
        if (iLiteral != null && ALLOW_INCREMENTAL_STYLING) {
            this.initStyleTables();
            this.assignStyle(iLiteral);
            if (iLiteral.getIncomingPredicate() != null) {
                this.assignStyle(iLiteral.getIncomingPredicate());
                if (iLiteral.getIncomingPredicate().getSubject() != null) {
                    this.assignStyle(iLiteral.getIncomingPredicate().getSubject());
                }
            }
            this.cleanStyleTables();
        }
    }

    void incStyling(IProperty iProperty) {
        if (iProperty != null && ALLOW_INCREMENTAL_STYLING) {
            this.initStyleTables();
            this.assignStyle(iProperty);
            if (iProperty.getObject() != null) {
                if (iProperty.getObject() instanceof IResource) {
                    this.assignStyle((IResource)iProperty.getObject());
                } else {
                    this.assignStyle((ILiteral)iProperty.getObject());
                }
            }
            if (iProperty.getSubject() != null) {
                IProperty iProperty2;
                Enumeration enumeration;
                this.assignStyle(iProperty.getSubject());
                if (iProperty.getSubject().getOutgoingPredicates() != null) {
                    enumeration = iProperty.getSubject().getOutgoingPredicates().elements();
                    while (enumeration.hasMoreElements()) {
                        iProperty2 = (IProperty)enumeration.nextElement();
                        if (iProperty2 == iProperty) continue;
                        this.assignStyle(iProperty2);
                        if (iProperty2.getObject() == null) continue;
                        if (iProperty2.getObject() instanceof IResource) {
                            this.assignStyle((IResource)iProperty2.getObject());
                            continue;
                        }
                        this.assignStyle((ILiteral)iProperty2.getObject());
                    }
                }
                if (iProperty.getSubject().getIncomingPredicates() != null) {
                    enumeration = iProperty.getSubject().getIncomingPredicates().elements();
                    while (enumeration.hasMoreElements()) {
                        iProperty2 = (IProperty)enumeration.nextElement();
                        this.assignStyle(iProperty2);
                        if (iProperty2.getSubject() == null) continue;
                        this.assignStyle(iProperty2.getSubject());
                    }
                }
            }
            this.cleanStyleTables();
        }
    }

    void assignStyle(IResource iResource) {
        StyleInfoR styleInfoR = this.computeAndGetStyle(iResource);
        if (iResource.isVisuallyRepresented()) {
            Object object;
            Color color = styleInfoR.getFillColor();
            Color color2 = styleInfoR.getStrokeColor();
            float f = styleInfoR.getStrokeWidth().floatValue();
            float[] fArray = styleInfoR.getStrokeDashArray();
            String string = styleInfoR.getFontFamily();
            int n = styleInfoR.getFontSize();
            short s = styleInfoR.getFontWeight();
            short s2 = styleInfoR.getFontStyle();
            Integer n2 = styleInfoR.getTextAlignment();
            Glyph glyph = iResource.getGlyph();
            VText vText = iResource.getGlyphText();
            if (!iResource.isLaidOutInTableForm() && (object = this.application.geomMngr.getNodeShape(iResource, styleInfoR)) != null) {
                Editor.vsm.addGlyph(object, "rdfSpace");
                iResource.setGlyph((Glyph)object);
                Editor.mSpace.destroyGlyph(glyph);
                if (iResource.getGlyphText() != null) {
                    Editor.mSpace.above((Glyph)iResource.getGlyphText(), object);
                }
            }
            if (color != null) {
                int n3 = ConfigManager.addColor(color);
                iResource.setFillColor(n3);
            } else {
                int n4 = ConfigManager.defaultRFIndex;
                iResource.setFillColor(n4);
            }
            if (color2 != null) {
                int n5 = ConfigManager.addColor(color2);
                iResource.setStrokeColor(n5);
            } else {
                int n6 = ConfigManager.defaultRTBIndex;
                iResource.setStrokeColor(n6);
            }
            if (iResource.isSelected()) {
                iResource.getGlyph().setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
                iResource.getGlyph().setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                if (iResource.getGlyphText() != null) {
                    iResource.getGlyphText().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
            } else if (iResource.isCommented()) {
                iResource.getGlyph().setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                iResource.getGlyph().setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (iResource.getGlyphText() != null) {
                    iResource.getGlyphText().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            }
            ConfigManager.assignStrokeToGlyph(iResource.getGlyph(), f, fArray);
            object = ConfigManager.rememberFont(ConfigManager.fonts, string, n, s, s2);
            if (object != null && vText != null) {
                vText.setSpecialFont((Font)object);
            }
            if (!n2.equals(Style.TA_CENTER) && vText != null) {
                iResource.setTextAlign(n2);
            }
            this.application.geomMngr.correctResourceTextAndShape(iResource);
        }
    }

    void assignStyle(ILiteral iLiteral) {
        StyleInfoL styleInfoL = this.computeAndGetStyle(iLiteral);
        if (iLiteral.isVisuallyRepresented()) {
            Object object;
            Color color = styleInfoL.getFillColor();
            Color color2 = styleInfoL.getStrokeColor();
            float[] fArray = styleInfoL.getStrokeDashArray();
            float f = styleInfoL.getStrokeWidth().floatValue();
            String string = styleInfoL.getFontFamily();
            int n = styleInfoL.getFontSize();
            short s = styleInfoL.getFontWeight();
            short s2 = styleInfoL.getFontStyle();
            Integer n2 = styleInfoL.getTextAlignment();
            Glyph glyph = iLiteral.getGlyph();
            VText vText = iLiteral.getGlyphText();
            if (!iLiteral.isLaidOutInTableForm() && (object = this.application.geomMngr.getNodeShape(iLiteral, styleInfoL)) != null) {
                Editor.vsm.addGlyph(object, "rdfSpace");
                iLiteral.setGlyph((Glyph)object);
                Editor.mSpace.destroyGlyph(glyph);
                if (iLiteral.getGlyphText() != null) {
                    Editor.mSpace.above((Glyph)iLiteral.getGlyphText(), object);
                }
            }
            if (color != null) {
                int n3 = ConfigManager.addColor(color);
                iLiteral.setFillColor(n3);
            } else {
                int n4 = ConfigManager.defaultLFIndex;
                iLiteral.setFillColor(n4);
            }
            if (color2 != null) {
                int n5 = ConfigManager.addColor(color2);
                iLiteral.setStrokeColor(n5);
            } else {
                int n6 = ConfigManager.defaultLTBIndex;
                iLiteral.setStrokeColor(n6);
            }
            if (iLiteral.isSelected()) {
                iLiteral.getGlyph().setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
                iLiteral.getGlyph().setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                if (iLiteral.getGlyphText() != null) {
                    iLiteral.getGlyphText().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
            } else if (iLiteral.isCommented()) {
                iLiteral.getGlyph().setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                iLiteral.getGlyph().setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (iLiteral.getGlyphText() != null) {
                    iLiteral.getGlyphText().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            }
            ConfigManager.assignStrokeToGlyph(iLiteral.getGlyph(), f, fArray);
            object = ConfigManager.rememberFont(ConfigManager.fonts, string, n, s, s2);
            if (object != null && vText != null) {
                vText.setSpecialFont((Font)object);
            }
            if (!n2.equals(Style.TA_CENTER) && vText != null) {
                this.application.geomMngr.alignText(glyph, vText, n2);
                iLiteral.setTextAlign(n2);
            }
        }
    }

    void assignStyle(IProperty iProperty) {
        StyleInfoP styleInfoP = this.computeAndGetStyle(iProperty);
        if (iProperty.isVisuallyRepresented()) {
            Color color = styleInfoP.getFillColor();
            Color color2 = styleInfoP.getStrokeColor();
            float f = styleInfoP.getStrokeWidth().floatValue();
            float[] fArray = styleInfoP.getStrokeDashArray();
            String string = styleInfoP.getFontFamily();
            int n = styleInfoP.getFontSize();
            short s = styleInfoP.getFontWeight();
            short s2 = styleInfoP.getFontStyle();
            Glyph glyph = iProperty.getGlyph();
            VText vText = iProperty.getGlyphText();
            VTriangleOr vTriangleOr = iProperty.getGlyphHead();
            if (iProperty.isLaidOutInTableForm()) {
                if (color != null) {
                    int n2 = ConfigManager.addColor(color);
                    iProperty.setCellFillColor(n2);
                    if (color2 != null) {
                        int n3 = ConfigManager.addColor(color2);
                        iProperty.setStrokeColor(n3);
                        iProperty.setTextColor(n3);
                    } else {
                        iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                        if (iProperty.getObject() instanceof ILiteral) {
                            iProperty.setTextColor(ConfigManager.defaultLTBIndex);
                        } else {
                            iProperty.setTextColor(ConfigManager.defaultRTBIndex);
                        }
                    }
                } else if (iProperty.getObject() instanceof ILiteral) {
                    int n4 = ConfigManager.defaultLFIndex;
                    iProperty.setCellFillColor(n4);
                    if (color2 != null) {
                        int n5 = ConfigManager.addColor(color2);
                        iProperty.setStrokeColor(n5);
                        iProperty.setTextColor(n5);
                    } else {
                        iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                        iProperty.setTextColor(ConfigManager.defaultLTBIndex);
                    }
                } else {
                    int n6 = ConfigManager.defaultRFIndex;
                    iProperty.setCellFillColor(n6);
                    if (color2 != null) {
                        int n7 = ConfigManager.addColor(color2);
                        iProperty.setStrokeColor(n7);
                        iProperty.setTextColor(n7);
                    } else {
                        iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                        iProperty.setTextColor(ConfigManager.defaultRTBIndex);
                    }
                }
                if (iProperty.isSelected()) {
                    iProperty.getGlyph().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                    if (iProperty.getGlyphHead() != null) {
                        iProperty.getGlyphHead().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                    }
                    if (iProperty.getGlyphText() != null) {
                        iProperty.getGlyphText().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                    }
                    if (iProperty.getTableCellGlyph() != null) {
                        iProperty.getTableCellGlyph().setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
                        iProperty.getTableCellGlyph().setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                    }
                } else if (iProperty.isCommented()) {
                    iProperty.getGlyph().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    if (iProperty.getGlyphHead() != null) {
                        iProperty.getGlyphHead().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                    if (iProperty.getGlyphText() != null) {
                        iProperty.getGlyphText().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                    if (iProperty.getTableCellGlyph() != null) {
                        iProperty.getTableCellGlyph().setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                        iProperty.getTableCellGlyph().setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                }
            } else {
                if (color2 != null) {
                    int n8 = ConfigManager.addColor(color2);
                    iProperty.setStrokeColor(n8);
                    iProperty.setTextColor(n8);
                } else {
                    iProperty.setStrokeColor(ConfigManager.defaultPBIndex);
                    iProperty.setTextColor(ConfigManager.defaultPTIndex);
                }
                if (iProperty.isSelected()) {
                    iProperty.getGlyph().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                    if (iProperty.getGlyphHead() != null) {
                        iProperty.getGlyphHead().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                    }
                    if (iProperty.getGlyphText() != null) {
                        iProperty.getGlyphText().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                    }
                } else if (iProperty.isCommented()) {
                    iProperty.getGlyph().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    if (iProperty.getGlyphHead() != null) {
                        iProperty.getGlyphHead().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                    if (iProperty.getGlyphText() != null) {
                        iProperty.getGlyphText().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                }
            }
            ConfigManager.assignStrokeToGlyph(iProperty.getGlyph(), f, fArray);
            Font font = ConfigManager.rememberFont(ConfigManager.fonts, string, n, s, s2);
            if (font != null && vText != null) {
                vText.setSpecialFont(font);
            }
        }
    }

    boolean storeIcon(URL uRL) {
        if (!this.url2icon.containsKey(uRL)) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            if (imageIcon != null && imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
                this.url2icon.put(uRL, imageIcon);
                return true;
            }
            return false;
        }
        return true;
    }

    ImageIcon getIcon(URL uRL) {
        if (this.url2icon.containsKey(uRL)) {
            return (ImageIcon)this.url2icon.get(uRL);
        }
        if (this.storeIcon(uRL)) {
            return (ImageIcon)this.url2icon.get(uRL);
        }
        return null;
    }
}

