/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.SwingWorker;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.svg.SVGReader;
import com.xerox.VTM.svg.SVGWriter;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.claribole.zvtm.engine.AnimationListener;
import net.claribole.zvtm.engine.Location;
import net.claribole.zvtm.glyphs.GlyphUtils;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.DatatypeChooser;
import org.w3c.IsaViz.EditorEvtHdlr;
import org.w3c.IsaViz.GSSManager;
import org.w3c.IsaViz.GeometryManager;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.IContainer;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ISVCommand;
import org.w3c.IsaViz.ISVCopy;
import org.w3c.IsaViz.ISVCut;
import org.w3c.IsaViz.ISVDelete;
import org.w3c.IsaViz.ISVManager;
import org.w3c.IsaViz.ISVPaste;
import org.w3c.IsaViz.InfoPanel;
import org.w3c.IsaViz.MainCmdPanel;
import org.w3c.IsaViz.NavPanel;
import org.w3c.IsaViz.NewLitPanel;
import org.w3c.IsaViz.NewResPanel;
import org.w3c.IsaViz.PrintUtilities;
import org.w3c.IsaViz.PropertySummary;
import org.w3c.IsaViz.PropsPanel;
import org.w3c.IsaViz.RDFLoader;
import org.w3c.IsaViz.RadarEvtHdlr;
import org.w3c.IsaViz.SplashWindow;
import org.w3c.IsaViz.TablePanel;
import org.w3c.IsaViz.TextViewer;
import org.w3c.IsaViz.Utils;
import org.w3c.IsaViz.WebBrowser;
import org.w3c.IsaViz.XMLManager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Editor
implements AnimationListener {
    static String isavizURI = "http://www.w3.org/2001/10/IsaViz";
    static String RDFMS_NAMESPACE_PREFIX = "rdf";
    static String RDFMS_NAMESPACE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static String RDFS_NAMESPACE_PREFIX = "rdfs";
    static String RDFS_NAMESPACE_URI = "http://www.w3.org/2000/01/rdf-schema#";
    static String XSD_NAMESPACE_PREFIX = "xsd";
    static String XSD_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema#";
    static String DEFAULT_BASE_URI;
    static String BASE_URI;
    static String ANON_NODE;
    static String MEMBERSHIP_PROP_CONSTRUCTOR;
    static String DEFAULT_LANGUAGE_IN_LITERALS;
    static boolean ALWAYS_INCLUDE_LANG_IN_LITERALS;
    static boolean ABBREV_SYNTAX;
    static boolean DISP_AS_LABEL;
    static int MAX_LIT_CHAR_COUNT;
    static String GRAPH_ORIENTATION;
    JFileChooser fc;
    static File cfgFile;
    static String argFile;
    static String gssFile;
    static File projectFile;
    static String lastRDF;
    static String tmpRdfFile;
    static File m_GraphVizPath;
    static File m_GraphVizFontDir;
    static File m_TmpDir;
    static File projectDir;
    static File lastOpenPrjDir;
    static File lastSavePrjDir;
    static File rdfDir;
    static File lastImportRDFDir;
    static File lastExportRDFDir;
    static boolean dltOnExit;
    static int MAX_BRW_LIST_SIZE;
    static int UNDO_SIZE;
    static boolean SAVE_WINDOW_LAYOUT;
    static final String mainVirtualSpace = "rdfSpace";
    static VirtualSpace mSpace;
    static final String rdRegionVirtualSpace = "radarSpace";
    static VirtualSpace rSpace;
    static final String mainView = "Graph";
    static View mView;
    static final String radarView = "Overview";
    static View rView;
    static final String resShapeType = "resG";
    static final String resTextType = "resT";
    static final String propPathType = "prdG";
    static final String propHeadType = "prdH";
    static final String propTextType = "prdT";
    static final String propCellType = "prdC";
    static final String litShapeType = "litG";
    static final String litTextType = "litT";
    static Font smallFont;
    static Font tinyFont;
    static String vtmFontName;
    static int vtmFontSize;
    static Font vtmFont;
    static String swingFontName;
    static int swingFontSize;
    static Font swingFont;
    static int tinySwingFontSize;
    static Font tinySwingFont;
    static boolean ANTIALIASING;
    static VirtualSpaceManager vsm;
    EditorEvtHdlr eeh;
    RadarEvtHdlr reh;
    RDFLoader rdfLdr;
    XMLManager xmlMngr;
    ISVManager isvMngr;
    ConfigManager cfgMngr;
    static GSSManager gssMngr;
    GeometryManager geomMngr;
    static VRectangle observedRegion;
    TextViewer errorLog;
    ISVCommand[] undoStack;
    int undoIndex;
    static final int MAX_PREV_LOC = 10;
    static Vector previousLocations;
    static MainCmdPanel cmp;
    static TablePanel tblp;
    static PropsPanel propsp;
    static NavPanel navp;
    static WebBrowser webBrowser;
    static boolean autoDetectBrowser;
    static File browserPath;
    static String browserOptions;
    static boolean useProxy;
    static String proxyHost;
    static String proxyPort;
    Hashtable resourcesByURI;
    Hashtable propertiesByURI;
    Vector literals;
    StringBuffer nextAnonID = new StringBuffer("0");
    Vector selectedResources = new Vector();
    Vector selectedLiterals = new Vector();
    Vector selectedPredicates = new Vector();
    static INode lastSelectedItem;
    Vector copiedResources = new Vector();
    Vector copiedLiterals = new Vector();
    Vector copiedPredicates = new Vector();
    Model rdfModel;
    String selectedPropertyConstructorNS;
    String selectedPropertyConstructorLN;
    int searchIndex = 0;
    String lastSearchedString = "";
    Vector matchingList = new Vector();
    INode lastMatchingEntity = null;
    StringBuffer errorMessages;
    boolean reportError;
    static short MOVE_UP;
    static short MOVE_DOWN;
    static short MOVE_LEFT;
    static short MOVE_RIGHT;
    static short MOVE_UP_LEFT;
    static short MOVE_UP_RIGHT;
    static short MOVE_DOWN_LEFT;
    static short MOVE_DOWN_RIGHT;

    public Editor() {
        SplashWindow splashWindow = new SplashWindow(2000, "images/IsavizSplash.gif", false, null);
        File file = new File(System.getProperty("user.home") + "/isaviz.cfg");
        cfgFile = file.exists() ? file : new File("isaviz.cfg");
        splashWindow.setMessage("Loading Preferences from " + cfgFile.getAbsolutePath());
        vsm = new VirtualSpaceManager();
        vsm.setZoomLimit(-90);
        Editor.vsm.animator.setAnimationListener((AnimationListener)this);
        this.cfgMngr = new ConfigManager(this);
        this.geomMngr = new GeometryManager(this);
        this.isvMngr = new ISVManager(this);
        gssMngr = new GSSManager(this);
        splashWindow.setProgressBarValue(10);
        ConfigManager.initLookAndFeel();
        splashWindow.setProgressBarValue(20);
        splashWindow.setMessage("Looking for plug-ins");
        this.cfgMngr.initWindows();
        splashWindow.setProgressBarValue(30);
        splashWindow.setMessage("Initializing XML parser");
        this.xmlMngr = new XMLManager(this);
        splashWindow.setProgressBarValue(40);
        splashWindow.setMessage("Initializing Internal Data Structures");
        this.resourcesByURI = new Hashtable();
        splashWindow.setProgressBarValue(50);
        this.propertiesByURI = new Hashtable();
        splashWindow.setProgressBarValue(60);
        this.literals = new Vector();
        this.errorMessages = new StringBuffer();
        this.reportError = false;
        this.undoStack = new ISVCommand[UNDO_SIZE];
        this.undoIndex = -1;
        previousLocations = new Vector();
        splashWindow.setProgressBarValue(70);
        splashWindow.setMessage("Initializing Look & Feel");
        this.cfgMngr.assignColorsToGraph();
        splashWindow.setProgressBarValue(80);
        this.cfgMngr.initConfig();
        vsm.setMainFont(vtmFont);
        splashWindow.setProgressBarValue(90);
        this.cfgMngr.layoutWindows();
        splashWindow.setProgressBarValue(100);
        cfgFile = new File(System.getProperty("user.home") + "/isaviz.cfg");
        if (m_TmpDir.exists()) {
            File file2;
            if (gssFile != null && (file2 = new File(gssFile)).exists()) {
                if (argFile.endsWith(".nt")) {
                    gssMngr.loadStylesheet(file2, RDFLoader.NTRIPLE_READER);
                } else if (argFile.endsWith(".n3")) {
                    gssMngr.loadStylesheet(file2, RDFLoader.N3_READER);
                } else {
                    gssMngr.loadStylesheet(file2, RDFLoader.RDF_XML_READER);
                }
            }
            if (argFile != null) {
                if (argFile.endsWith(".isv")) {
                    this.isvMngr.openProject(new File(argFile));
                } else if (argFile.endsWith(".nt")) {
                    this.loadRDF(new File(argFile), RDFLoader.NTRIPLE_READER, true);
                } else if (argFile.endsWith(".n3")) {
                    this.loadRDF(new File(argFile), RDFLoader.N3_READER, true);
                } else {
                    this.loadRDF(new File(argFile), RDFLoader.RDF_XML_READER, true);
                }
            } else {
                vsm.getVirtualSpace(mainVirtualSpace).getCamera(0).setAltitude(0.0f);
            }
        } else {
            JOptionPane.showMessageDialog(cmp, "You need to select a temporary directory for IsaViz\nin the Directories tab of the Preferences Panel, or some functions will not work properly.\nThe current directory (" + m_TmpDir + ") does not exist.");
        }
    }

    void promptReset() {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "You are about to reset your project.\nAre you sure you want to continue?", "Warning", -1, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            vsm.getView(mainView).setStatusBarText("New project");
            this.reset(true);
            this.resetGraphStylesheets();
        }
    }

    public void reset(boolean bl) {
        if (this.rdfLdr != null) {
            this.rdfLdr.reset();
        }
        projectFile = null;
        propsp.reset();
        this.matchingList = new Vector();
        this.resourcesByURI.clear();
        this.propertiesByURI.clear();
        this.literals.removeAllElements();
        if (bl) {
            this.resetNamespaceBindings();
        }
        this.resetPropertyConstructors();
        this.resetPropertyBrowser();
        this.reportError = false;
        this.rdfModel = null;
        this.nextAnonID = new StringBuffer("0");
        this.resetSelected();
        this.resetCopied();
        lastSelectedItem = null;
        Utils.resetArray(this.undoStack);
        this.undoIndex = -1;
        cmp.enableUndo(false);
        previousLocations.removeAllElements();
        this.geomMngr.resetLastResizer();
        vsm.destroyGlyphsInSpace(mainVirtualSpace);
        SVGReader.setPositionOffset((long)0L, (long)0L);
        vsm.getVirtualSpace(mainVirtualSpace).getCamera(0).setAltitude(0.0f);
        vsm.getVirtualSpace(mainVirtualSpace).getCamera(0).setLocation(0L, 0L);
    }

    void resetSelected() {
        this.selectedResources.removeAllElements();
        this.selectedLiterals.removeAllElements();
        this.selectedPredicates.removeAllElements();
    }

    void resetCopied() {
        this.copiedResources.removeAllElements();
        this.copiedLiterals.removeAllElements();
        this.copiedPredicates.removeAllElements();
        cmp.enablePaste(false);
    }

    void resetNamespaceBindings() {
        tblp.resetNamespaceTable();
        this.addNamespaceBinding(RDFMS_NAMESPACE_PREFIX, RDFMS_NAMESPACE_URI, new Boolean(true), true, false);
        this.addNamespaceBinding(RDFS_NAMESPACE_PREFIX, RDFS_NAMESPACE_URI, new Boolean(true), true, false);
        this.addNamespaceBinding(XSD_NAMESPACE_PREFIX, XSD_NAMESPACE_URI, new Boolean(true), true, false);
        this.addNamespaceBinding(GraphStylesheet.GSS_NAMESPACE_PREFIX, GraphStylesheet._gssNS, new Boolean(true), true, false);
    }

    void resetPropertyConstructors() {
        tblp.resetPropertyTable();
        this.initRDFMSProperties();
        this.initRDFSProperties();
    }

    void resetPropertyBrowser() {
        tblp.resetBrowser();
    }

    void resetGraphStylesheets() {
        tblp.resetStylesheets();
        gssMngr.reset();
    }

    void openProject() {
        this.fc = new JFileChooser(lastOpenPrjDir != null ? lastOpenPrjDir : projectDir);
        this.fc.setDialogTitle("Open ISV Project");
        int n = this.fc.showOpenDialog(cmp);
        if (n == 0) {
            this.errorMessages.append("-----Loading ISV project-----\n");
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Editor.this.isvMngr.openProject(Editor.this.fc.getSelectedFile());
                    return null;
                }
            };
            swingWorker.start();
        }
        cmp.repaint();
    }

    void saveProject() {
        if (projectFile != null) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Editor.this.isvMngr.saveProject(projectFile);
                    return null;
                }
            };
            swingWorker.start();
        } else {
            this.saveProjectAs();
        }
    }

    void saveProjectAs() {
        this.fc = new JFileChooser(lastSavePrjDir != null ? lastSavePrjDir : projectDir);
        this.fc.setDialogTitle("Save ISV Project As");
        int n = this.fc.showSaveDialog(cmp);
        if (n == 0) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Editor.this.isvMngr.saveProject(Editor.this.fc.getSelectedFile());
                    return null;
                }
            };
            swingWorker.start();
        }
        cmp.repaint();
    }

    String nextAnonymousID() {
        this.incAnonID();
        while (this.resourcesByURI.containsKey(ANON_NODE + this.nextAnonID)) {
            this.incAnonID();
        }
        return ANON_NODE + this.nextAnonID;
    }

    private void incAnonID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextAnonID.length()) {
            by = (byte)this.nextAnonID.charAt(n);
            if (by < 122) {
                this.nextAnonID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextAnonID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextAnonID.length()) {
                this.nextAnonID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextAnonID.append('0');
        }
    }

    public void loadRDF(final File file, final int n, boolean bl) {
        if (m_GraphVizPath.exists()) {
            this.reset(false);
            this.errorMessages.append("-----Importing RDF-----\n");
            if (bl) {
                lastImportRDFDir = file.getParentFile();
            }
            if (this.rdfLdr == null) {
                this.rdfLdr = new RDFLoader(this);
            }
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    if (gssMngr.getStylesheetList().size() > 0) {
                        Editor.this.rdfLdr.loadAndStyle(file, n);
                    } else {
                        Editor.this.rdfLdr.load(file, n);
                    }
                    Editor.this.updatePrefixBindingsInGraph();
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    lastRDF = file.getAbsolutePath();
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void loadRDF(final URL uRL, final int n, boolean bl) {
        if (bl) {
            gssMngr.loadStylesheet(uRL, n);
        } else if (m_GraphVizPath.exists()) {
            this.reset(false);
            this.errorMessages.append("-----Importing RDF-----\n");
            if (this.rdfLdr == null) {
                this.rdfLdr = new RDFLoader(this);
            }
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    if (gssMngr.getStylesheetList().size() > 0) {
                        Editor.this.rdfLdr.loadAndStyle(uRL, n);
                    } else {
                        Editor.this.rdfLdr.load(uRL, n);
                    }
                    Editor.this.updatePrefixBindingsInGraph();
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    lastRDF = uRL.toString();
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void loadRDF(final InputStream inputStream, final int n) {
        if (m_GraphVizPath.exists()) {
            this.reset(false);
            this.errorMessages.append("-----Importing RDF-----\n");
            if (this.rdfLdr == null) {
                this.rdfLdr = new RDFLoader(this);
            }
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    if (gssMngr.getStylesheetList().size() > 0) {
                        Editor.this.rdfLdr.loadAndStyle(inputStream, n);
                    } else {
                        Editor.this.rdfLdr.load(inputStream, n);
                    }
                    Editor.this.updatePrefixBindingsInGraph();
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void mergeRDF(final File file, final int n, boolean bl) {
        if (m_GraphVizPath.exists()) {
            if (bl) {
                lastImportRDFDir = file.getParentFile();
            }
            this.errorMessages.append("-----Merging-----\n");
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    Editor.this.generateJenaModel();
                    try {
                        Editor.this.rdfModel.add(Editor.this.rdfLdr.merge(file, n));
                    }
                    catch (RDFException rDFException) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + (Object)((Object)rDFException) + "\n");
                        Editor.this.reportError = true;
                    }
                    catch (Exception exception) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + exception + "\n");
                        Editor.this.reportError = true;
                        exception.printStackTrace();
                    }
                    File file2 = Utils.createTempFile(m_TmpDir.toString(), "mrg", ".rdf");
                    boolean bl = ABBREV_SYNTAX;
                    ABBREV_SYNTAX = true;
                    Editor.this.rdfLdr.save(Editor.this.rdfModel, file2);
                    if (!bl) {
                        ABBREV_SYNTAX = false;
                    }
                    Editor.this.reset(false);
                    if (gssMngr.getStylesheetList().size() > 0) {
                        Editor.this.rdfLdr.loadAndStyle(file2, RDFLoader.RDF_XML_READER);
                    } else {
                        Editor.this.rdfLdr.load(file2, RDFLoader.RDF_XML_READER);
                    }
                    if (dltOnExit && file2 != null) {
                        file2.deleteOnExit();
                    }
                    Editor.this.updatePrefixBindingsInGraph();
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    lastRDF = file.getAbsolutePath();
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void mergeRDF(final URL uRL, final int n) {
        if (m_GraphVizPath.exists()) {
            this.errorMessages.append("-----Merging-----\n");
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    Editor.this.generateJenaModel();
                    try {
                        Editor.this.rdfModel.add(Editor.this.rdfLdr.merge(uRL, n));
                    }
                    catch (RDFException rDFException) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + (Object)((Object)rDFException) + "\n");
                        Editor.this.reportError = true;
                    }
                    catch (Exception exception) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + exception + "\n");
                        Editor.this.reportError = true;
                        exception.printStackTrace();
                    }
                    File file = Utils.createTempFile(m_TmpDir.toString(), "mrg", ".rdf");
                    boolean bl = ABBREV_SYNTAX;
                    ABBREV_SYNTAX = true;
                    Editor.this.rdfLdr.save(Editor.this.rdfModel, file);
                    if (!bl) {
                        ABBREV_SYNTAX = false;
                    }
                    Editor.this.reset(false);
                    if (gssMngr.getStylesheetList().size() > 0) {
                        Editor.this.rdfLdr.loadAndStyle(file, RDFLoader.RDF_XML_READER);
                    } else {
                        Editor.this.rdfLdr.load(file, RDFLoader.RDF_XML_READER);
                    }
                    Editor.this.updatePrefixBindingsInGraph();
                    if (dltOnExit) {
                        file.deleteOnExit();
                    }
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    lastRDF = uRL.toString();
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void mergeRDF(final InputStream inputStream, final int n) {
        if (m_GraphVizPath.exists()) {
            this.errorMessages.append("-----Merging-----\n");
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    Editor.this.generateJenaModel();
                    try {
                        Editor.this.rdfModel.add(Editor.this.rdfLdr.merge(inputStream, n));
                    }
                    catch (RDFException rDFException) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + (Object)((Object)rDFException) + "\n");
                        Editor.this.reportError = true;
                    }
                    catch (Exception exception) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + exception + "\n");
                        Editor.this.reportError = true;
                        exception.printStackTrace();
                    }
                    File file = Utils.createTempFile(m_TmpDir.toString(), "mrg", ".rdf");
                    boolean bl = ABBREV_SYNTAX;
                    ABBREV_SYNTAX = true;
                    Editor.this.rdfLdr.save(Editor.this.rdfModel, file);
                    if (!bl) {
                        ABBREV_SYNTAX = false;
                    }
                    Editor.this.reset(false);
                    if (gssMngr.getStylesheetList().size() > 0) {
                        Editor.this.rdfLdr.loadAndStyle(file, RDFLoader.RDF_XML_READER);
                    } else {
                        Editor.this.rdfLdr.load(file, RDFLoader.RDF_XML_READER);
                    }
                    if (dltOnExit && file != null) {
                        file.deleteOnExit();
                    }
                    Editor.this.updatePrefixBindingsInGraph();
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void loadPropertyTypes(final File file) {
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Editor.this.rdfLdr.loadProperties(file);
                return null;
            }
        };
        swingWorker.start();
    }

    void generateJenaModel() {
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.rdfLdr.generateJenaModel();
    }

    public void exportRDF(File file, boolean bl) {
        vsm.getView(mainView).setCursorIcon(3);
        if (bl) {
            lastExportRDFDir = file.getParentFile();
        }
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.rdfLdr.generateJenaModel();
        this.rdfLdr.save(this.rdfModel, file);
        vsm.getView(mainView).setCursorIcon(-1);
    }

    public void exportRDF(OutputStream outputStream) {
        vsm.getView(mainView).setCursorIcon(3);
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.rdfLdr.generateJenaModel();
        this.rdfLdr.save(this.rdfModel, outputStream);
        vsm.getView(mainView).setCursorIcon(-1);
    }

    public void exportN3(File file) {
        vsm.getView(mainView).setCursorIcon(3);
        lastExportRDFDir = file.getParentFile();
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.generateJenaModel();
        this.rdfLdr.saveAsN3(this.rdfModel, file);
        vsm.getView(mainView).setCursorIcon(-1);
    }

    public void exportNTriples(File file) {
        vsm.getView(mainView).setCursorIcon(3);
        lastExportRDFDir = file.getParentFile();
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.generateJenaModel();
        this.rdfLdr.saveAsTriples(this.rdfModel, file);
        vsm.getView(mainView).setCursorIcon(-1);
    }

    public void exportPNG(File file) {
        Object object;
        boolean bl = true;
        if (!Utils.javaVersionIs140OrLater()) {
            object = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(null, "This functionality is only available when running IsaViz using a JVM version 1.4.0 or later (it requires the ImageIO API).\nIsaViz detected JVM version " + System.getProperty("java.vm.version") + "\nDo you want to proceed anyway (this will probably cause an error)?", "Warning", -1, 2, null, (Object[])object, object[0]);
            if (n != 0) {
                bl = false;
            }
        }
        if (bl) {
            vsm.getView(mainView).setCursorIcon(3);
            lastExportRDFDir = file.getParentFile();
            vsm.getView(mainView).setStatusBarText("Exporting to PNG " + file.toString() + " ... (This operation can take some time)");
            object = ImageIO.getImageWritersByFormatName("png").next();
            try {
                ((ImageWriter)object).setOutput(ImageIO.createImageOutputStream(file));
                BufferedImage bufferedImage = vsm.getView(mainView).getImage();
                if (bufferedImage != null) {
                    ((ImageWriter)object).write(bufferedImage);
                    ((ImageWriter)object).dispose();
                    vsm.getView(mainView).setStatusBarText("Exporting to PNG " + file.toString() + " ...done");
                } else {
                    JOptionPane.showMessageDialog(cmp, "An error occured when retrieving the image.\n Please try again.");
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(cmp, "Error while exporting to PNG:\n" + iOException);
            }
            vsm.getView(mainView).setCursorIcon(-1);
        }
    }

    public void exportSVG(File file) {
        if (file != null) {
            vsm.getView(mainView).setCursorIcon(3);
            lastExportRDFDir = file.getParentFile();
            vsm.getView(mainView).setStatusBarText("Exporting to SVG " + file.toString() + " ... (This operation can take some time if the model contains bitmap icons)");
            if (file.exists()) {
                file.delete();
            }
            SVGWriter sVGWriter = new SVGWriter();
            Document document = sVGWriter.exportVirtualSpace(vsm.getVirtualSpace(mainVirtualSpace), (DOMImplementation)new DOMImplementationImpl(), file);
            this.xmlMngr.serialize(document, file);
            vsm.getView(mainView).setStatusBarText("Exporting to SVG " + file.toString() + " ...done");
            vsm.getView(mainView).setCursorIcon(-1);
        }
    }

    public void setAbbrevSyntax(boolean bl) {
        ABBREV_SYNTAX = bl;
    }

    public void displayLabels(boolean bl) {
        DISP_AS_LABEL = bl;
        this.showResourceLabels(DISP_AS_LABEL);
    }

    public void showAnonIds(boolean bl) {
        VirtualSpace virtualSpace = vsm.getVirtualSpace(mainVirtualSpace);
        Enumeration enumeration = this.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            IResource iResource = (IResource)enumeration.nextElement();
            if (!iResource.isAnon()) continue;
            if (bl) {
                virtualSpace.show((Glyph)iResource.getGlyphText());
                continue;
            }
            virtualSpace.hide((Glyph)iResource.getGlyphText());
        }
        ConfigManager.SHOW_ANON_ID = bl;
    }

    void showResourceLabels(boolean bl) {
        Vector vector = this.getProperties(RDFS_NAMESPACE_URI + "label");
        if (bl) {
            try {
                int n = 0;
                while (n < vector.size()) {
                    IProperty iProperty = (IProperty)vector.elementAt(n);
                    this.geomMngr.adjustResourceTextAndShape(iProperty.subject, iProperty.object.getText());
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                int n = 0;
                while (n < vector.size()) {
                    IProperty iProperty = (IProperty)vector.elementAt(n);
                    this.geomMngr.adjustResourceTextAndShape(iProperty.subject, iProperty.subject.getGraphLabel());
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    IResource addResource(String string) {
        String string2;
        IResource iResource = new IResource();
        iResource.setURI(string);
        if (string.startsWith(BASE_URI)) {
            iResource.setURIFragment(true);
        }
        if (!this.resourcesByURI.containsKey(string2 = iResource.getIdentity())) {
            this.resourcesByURI.put(string2, iResource);
            return iResource;
        }
        return (IResource)this.resourcesByURI.get(string2);
    }

    IResource addAnonymousResource(String string) {
        IResource iResource = new IResource();
        iResource.setAnon(true);
        iResource.setURIFragment(false);
        if (string != null) {
            iResource.setAnonymousID(string);
        } else {
            iResource.setAnonymousID(this.nextAnonymousID());
        }
        String string2 = iResource.getIdentity();
        if (!this.resourcesByURI.containsKey(string2)) {
            this.resourcesByURI.put(string2, iResource);
            return iResource;
        }
        return (IResource)this.resourcesByURI.get(string2);
    }

    IProperty addProperty(String string, String string2) {
        IProperty iProperty = new IProperty();
        iProperty.setNamespace(string);
        iProperty.setLocalname(string2);
        if (this.propertiesByURI.containsKey(iProperty.getIdent())) {
            Vector vector = (Vector)this.propertiesByURI.get(iProperty.getIdent());
            vector.add(iProperty);
        } else {
            Vector<IProperty> vector = new Vector<IProperty>();
            vector.add(iProperty);
            this.propertiesByURI.put(iProperty.getIdent(), vector);
        }
        this.addPropertyType(iProperty.getNamespace(), iProperty.getLocalname(), true);
        return iProperty;
    }

    ILiteral addLiteral(String string, String string2, boolean bl) {
        ILiteral iLiteral = new ILiteral();
        iLiteral.setValue(string);
        if (string2 != null) {
            iLiteral.setLanguage(string2);
        }
        iLiteral.setEscapeXMLChars(bl);
        this.literals.add(iLiteral);
        return iLiteral;
    }

    IResource getResource(String string) {
        IResource iResource = (IResource)this.resourcesByURI.get(string);
        return iResource;
    }

    Vector getProperties(String string) {
        Vector vector = (Vector)this.propertiesByURI.get(string);
        return vector;
    }

    void createNewResource(long l, long l2) {
        IResource iResource = new IResource();
        VEllipse vEllipse = new VEllipse(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.resourceColorF);
        iResource.setGlyph((Glyph)vEllipse);
        vsm.addGlyph((Glyph)vEllipse, mainVirtualSpace);
        vEllipse.setHSVbColor(ConfigManager.resTBh, ConfigManager.resTBs, ConfigManager.resTBv);
        new NewResPanel(this, iResource);
    }

    void storeResource(IResource iResource, String string, boolean bl) {
        VText vText;
        String string2;
        String string3;
        if (string.length() == 0) {
            iResource.setAnon(true);
            iResource.setAnonymousID(this.nextAnonymousID());
            string3 = iResource.getGraphLabel();
        } else if (bl) {
            iResource.setURI(string);
            iResource.setURIFragment(false);
            string2 = iResource.getGraphLabel();
            vText = Editor.getNSBindingFromFullURI(string2);
            if (vText != null && vText[2].equals("T")) {
                string2 = (String)vText[0] + ":" + string2.substring(vText[1].length(), string2.length());
            }
            string3 = string2;
        } else {
            if (BASE_URI.endsWith("#") || string.startsWith("#")) {
                iResource.setURI(BASE_URI + string);
            } else {
                iResource.setURI(BASE_URI + "#" + string);
            }
            iResource.setURIFragment(true);
            string3 = iResource.getGraphLabel();
        }
        string2 = (VEllipse)iResource.getGlyph();
        vText = new VText(((VEllipse)string2).vx, ((VEllipse)string2).vy, 0.0f, ConfigManager.resourceColorTB, string3);
        vsm.addGlyph((Glyph)vText, mainVirtualSpace);
        iResource.setGlyphText(vText);
        Rectangle2D rectangle2D = vsm.getView(mainView).getGraphicsContext().getFontMetrics().getStringBounds(vText.getText(), vsm.getView(mainView).getGraphicsContext());
        string2.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
        if ((double)string2.getWidth() < 1.5 * (double)string2.getHeight()) {
            string2.setWidth(Math.round(1.5 * (double)string2.getHeight()));
        }
        vText.moveTo(((VEllipse)string2).vx - (long)rectangle2D.getWidth() / 2L, ((VEllipse)string2).vy - (long)rectangle2D.getHeight() / 4L);
        if (iResource.isAnon() && !ConfigManager.SHOW_ANON_ID) {
            vsm.getVirtualSpace(mainVirtualSpace).hide((Glyph)vText);
        }
        this.resourcesByURI.put(iResource.getIdentity(), iResource);
        gssMngr.incStyling(iResource);
        this.centerRadarView();
    }

    void cancelNewNode(INode iNode) {
        vsm.getVirtualSpace(mainVirtualSpace).destroyGlyph(iNode.getGlyph());
    }

    void makeAnonymous(IResource iResource) {
        this.resourcesByURI.remove(iResource.getIdentity());
        iResource.setAnon(true);
        iResource.setAnonymousID(this.nextAnonymousID());
        this.resourcesByURI.put(iResource.getIdentity(), iResource);
        iResource.getGlyphText().setText(iResource.getIdentity());
        if (!ConfigManager.SHOW_ANON_ID) {
            vsm.getVirtualSpace(mainVirtualSpace).hide((Glyph)iResource.getGlyphText());
        }
        gssMngr.incStyling(iResource);
    }

    void changeResourceURI(IResource iResource, String string, boolean bl) {
        String[] stringArray;
        String string2;
        if (bl) {
            if (!string.equals(iResource.getIdentity())) {
                if (!this.resourceAlreadyExists(string)) {
                    this.resourcesByURI.remove(iResource.getIdentity());
                    if (iResource.isAnon()) {
                        iResource.setAnon(false);
                        if (!ConfigManager.SHOW_ANON_ID) {
                            vsm.getVirtualSpace(mainVirtualSpace).show((Glyph)iResource.getGlyphText());
                        }
                    }
                    iResource.setURI(string);
                    iResource.setURIFragment(false);
                    this.resourcesByURI.put(iResource.getIdentity(), iResource);
                } else {
                    JOptionPane.showMessageDialog(propsp, "A resource with URI " + string + " already exists");
                }
            }
        } else {
            String string3 = string2 = string.startsWith(BASE_URI) ? string.substring(BASE_URI.length(), string.length()) : string;
            if (!iResource.getIdentity().equals(BASE_URI + "#" + string2) && !iResource.getIdentity().equals(BASE_URI + string2)) {
                if (!this.resourceAlreadyExists(BASE_URI + "#" + string2)) {
                    this.resourcesByURI.remove(iResource.getIdentity());
                    if (iResource.isAnon()) {
                        iResource.setAnon(false);
                        if (!ConfigManager.SHOW_ANON_ID) {
                            vsm.getVirtualSpace(mainVirtualSpace).show((Glyph)iResource.getGlyphText());
                        }
                    }
                    if (BASE_URI.endsWith("#") || string.startsWith("#")) {
                        iResource.setURI(BASE_URI + string);
                    } else {
                        iResource.setURI(BASE_URI + "#" + string);
                    }
                    iResource.setURIFragment(true);
                    this.resourcesByURI.put(iResource.getIdentity(), iResource);
                } else {
                    JOptionPane.showMessageDialog(propsp, "A resource with ID " + string + " already exists");
                }
            }
        }
        if ((stringArray = Editor.getNSBindingFromFullURI(string2 = iResource.getGraphLabel())) != null && stringArray[2].equals("T")) {
            string2 = stringArray[0] + ":" + string2.substring(stringArray[1].length());
        }
        this.geomMngr.adjustResourceTextAndShape(iResource, string2);
        VText vText = iResource.getGlyphText();
        if (!vText.isVisible()) {
            vsm.getVirtualSpace(mainVirtualSpace).show((Glyph)vText);
        }
        gssMngr.incStyling(iResource);
    }

    boolean resourceAlreadyExists(String string) {
        return this.resourcesByURI.containsKey(string);
    }

    void createNewLiteral(long l, long l2) {
        ILiteral iLiteral = new ILiteral();
        VRectangle vRectangle = new VRectangle(l, l2, 0.0f, (long)GeometryManager.DEFAULT_NODE_WIDTH, (long)GeometryManager.DEFAULT_NODE_HEIGHT, ConfigManager.literalColorF);
        vsm.addGlyph((Glyph)vRectangle, mainVirtualSpace);
        vRectangle.setHSVbColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
        iLiteral.setGlyph((Glyph)vRectangle);
        new NewLitPanel(this, iLiteral);
    }

    void storeLiteral(ILiteral iLiteral, String string, boolean bl, String string2, String string3) {
        if (string2.length() > 0) {
            iLiteral.setLanguage(string2);
        }
        if (bl) {
            iLiteral.setDatatype(string3);
        }
        iLiteral.setEscapeXMLChars(true);
        this.setLiteralValue(iLiteral, string);
        this.literals.add(iLiteral);
        this.centerRadarView();
    }

    void setLiteralValue(ILiteral iLiteral, String string) {
        Object object;
        iLiteral.setValue(string);
        if (string.length() > 0) {
            Object object2 = object = iLiteral.getValue().length() >= MAX_LIT_CHAR_COUNT ? iLiteral.getValue().substring(0, MAX_LIT_CHAR_COUNT) + " ..." : iLiteral.getValue();
            if (iLiteral.getGlyphText() != null) {
                iLiteral.getGlyphText().setText((String)object);
            } else {
                Glyph glyph = iLiteral.getGlyph();
                VText vText = new VText(glyph.vx, glyph.vy, 0.0f, iLiteral.isSelected() ? ConfigManager.selectionColorTB : ConfigManager.literalColorTB, (String)object);
                vsm.addGlyph((Glyph)vText, mainVirtualSpace);
                iLiteral.setGlyphText(vText);
                this.geomMngr.correctLiteralTextAndShape(iLiteral);
            }
        } else if (iLiteral.getGlyphText() != null) {
            vsm.getVirtualSpace(mainVirtualSpace).destroyGlyph((Glyph)iLiteral.getGlyphText());
            iLiteral.setGlyphText(null);
        }
        object = iLiteral.getIncomingPredicate();
        if (object != null && ((IProperty)object).getNamespace().equals(RDFS_NAMESPACE_URI) && ((IProperty)object).getLocalname().equals("label")) {
            ((IProperty)object).subject.setLabel(iLiteral.getValue());
            if (DISP_AS_LABEL) {
                this.geomMngr.adjustResourceTextAndShape(((IProperty)object).subject, ((IProperty)object).subject.getLabel());
            }
        }
        gssMngr.incStyling(iLiteral);
    }

    static RDFDatatype displayAvailableDataTypes(String string) {
        return DatatypeChooser.getDatatypeChooser(propsp == null ? cmp : propsp, string);
    }

    static RDFDatatype displayAvailableDataTypes(Dialog dialog, String string) {
        return DatatypeChooser.getDatatypeChooser(dialog, string);
    }

    void createNewProperty(IResource iResource, INode iNode, Vector vector) {
        this.createNewProperty(iResource, iNode, vector, this.selectedPropertyConstructorNS, this.selectedPropertyConstructorLN);
    }

    void createNewProperty(IResource iResource, INode iNode, Vector vector, String string, String string2) {
        boolean bl = false;
        if (iNode instanceof ILiteral && ((ILiteral)iNode).getIncomingPredicate() != null) {
            bl = true;
            JOptionPane.showMessageDialog(vsm.getActiveView().getFrame(), "This literal is already the object of a statement.");
        }
        if (!bl) {
            long l;
            long l2;
            INode iNode2;
            IProperty iProperty = string.equals(RDFMS_NAMESPACE_URI) && string2.startsWith(MEMBERSHIP_PROP_CONSTRUCTOR.substring(0, 3)) ? this.addProperty(RDFMS_NAMESPACE_URI, IContainer.nextContainerIndex(iResource)) : this.addProperty(string, string2);
            iProperty.setSubject(iResource);
            iResource.addOutgoingPredicate(iProperty);
            if (iNode instanceof IResource) {
                iNode2 = (IResource)iNode;
                iProperty.setObject((IResource)iNode2);
                ((IResource)iNode2).addIncomingPredicate(iProperty);
            } else {
                iNode2 = (ILiteral)iNode;
                iProperty.setObject((ILiteral)iNode2);
                ((ILiteral)iNode2).setIncomingPredicate(iProperty);
                if (iProperty.getIdent().equals(RDFS_NAMESPACE_URI + "label")) {
                    iResource.setLabel(((ILiteral)iNode2).getValue());
                    iResource.getGlyphText().setText(iResource.getLabel());
                }
            }
            iNode2 = (LongPoint)vector.elementAt(0);
            LongPoint longPoint = (LongPoint)vector.elementAt(1);
            Point2D.Double double_ = new Point2D.Double(((LongPoint)iNode2).x, ((LongPoint)iNode2).y);
            Point2D point2D = GeometryManager.computeStepValue((LongPoint)iNode2, longPoint);
            Glyph glyph = iResource.getGlyph();
            Shape shape = GlyphUtils.getJava2DShape((Glyph)glyph);
            while (shape.contains(double_)) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX() + point2D.getX(), ((Point2D)double_).getY() + point2D.getY());
            }
            iNode2.setLocation(Math.round(((Point2D)double_).getX()), Math.round(((Point2D)double_).getY()));
            VPath vPath = new VPath(((LongPoint)iNode2).x, ((LongPoint)iNode2).y, 0.0f, ConfigManager.propertyColorB);
            int n = 1;
            while (n < vector.size() - 2) {
                iNode2 = (LongPoint)vector.elementAt(n);
                longPoint = (LongPoint)vector.elementAt(n + 1);
                vPath.addQdCurve((longPoint.x + ((LongPoint)iNode2).x) / 2L, (longPoint.y + ((LongPoint)iNode2).y) / 2L, ((LongPoint)iNode2).x, ((LongPoint)iNode2).y, true);
                ++n;
            }
            longPoint = (LongPoint)vector.elementAt(vector.size() - 2);
            iNode2 = (LongPoint)vector.lastElement();
            Point2D.Double double_2 = new Point2D.Double(((LongPoint)iNode2).x, ((LongPoint)iNode2).y);
            Point2D point2D2 = GeometryManager.computeStepValue((LongPoint)iNode2, longPoint);
            Glyph glyph2 = iNode.getGlyph();
            Shape shape2 = GlyphUtils.getJava2DShape((Glyph)glyph2);
            while (shape2.contains(double_2)) {
                ((Point2D)double_2).setLocation(((Point2D)double_2).getX() + point2D2.getX(), ((Point2D)double_2).getY() + point2D2.getY());
            }
            iNode2.setLocation(Math.round(((Point2D)double_2).getX()), Math.round(((Point2D)double_2).getY()));
            if (vector.size() > 2) {
                vPath.addQdCurve(((LongPoint)iNode2).x, ((LongPoint)iNode2).y, longPoint.x, longPoint.y, true);
            } else {
                vPath.addSegment(((LongPoint)iNode2).x, ((LongPoint)iNode2).y, true);
            }
            vsm.addGlyph((Glyph)vPath, mainVirtualSpace);
            VTriangleOr vTriangleOr = GeometryManager.createPathArrowHead(longPoint, (LongPoint)iNode2, null);
            vsm.addGlyph((Glyph)vTriangleOr, mainVirtualSpace);
            String string3 = "";
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < Editor.tblp.nsTableModel.getRowCount()) {
                if (((String)Editor.tblp.nsTableModel.getValueAt(n2, 1)).equals(string)) {
                    string3 = (Boolean)Editor.tblp.nsTableModel.getValueAt(n2, 2) != false ? (String)Editor.tblp.nsTableModel.getValueAt(n2, 0) + ":" + iProperty.getLocalname() : string + iProperty.getLocalname();
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                string3 = string + iProperty.getLocalname();
            }
            if (vector.size() % 2 != 0) {
                l2 = ((LongPoint)vector.elementAt((int)(vector.size() / 2))).x;
                l = ((LongPoint)vector.elementAt((int)(vector.size() / 2))).y;
            } else {
                l2 = (((LongPoint)vector.elementAt((int)(vector.size() / 2))).x + ((LongPoint)vector.elementAt((int)(vector.size() / 2 - 1))).x) / 2L;
                l = (((LongPoint)vector.elementAt((int)(vector.size() / 2))).y + ((LongPoint)vector.elementAt((int)(vector.size() / 2 - 1))).y) / 2L;
            }
            VText vText = new VText(l2, l, 0.0f, ConfigManager.propertyColorT, string3);
            vsm.addGlyph((Glyph)vText, mainVirtualSpace);
            iProperty.setGlyph(vPath, vTriangleOr);
            iProperty.setGlyphText(vText);
            gssMngr.incStyling(iProperty);
            if (!iProperty.isLaidOutInTableForm() && vTriangleOr != null && vPath.getStrokeWidth() > 2.0f) {
                vTriangleOr.reSize(vPath.getStrokeWidth() / 2.0f);
            }
            this.centerRadarView();
        }
    }

    void changePropertyURI(IProperty iProperty, String string, String string2) {
        String string3 = this.getNSURIfromPrefix(string);
        if (string3 == null) {
            string3 = string;
        }
        if (!iProperty.getIdent().equals(string3 + string2)) {
            if (iProperty.getNamespace().equals(RDFS_NAMESPACE_URI) && iProperty.getLocalname().equals("label")) {
                iProperty.subject.setLabel("");
                if (DISP_AS_LABEL) {
                    this.geomMngr.adjustResourceTextAndShape(iProperty.subject, iProperty.subject.getGraphLabel());
                }
            }
            if (string3.equals(RDFMS_NAMESPACE_URI) && string2.startsWith(MEMBERSHIP_PROP_CONSTRUCTOR.substring(0, 3))) {
                string2 = IContainer.nextContainerIndex(iProperty.subject);
            } else if (string3.equals(RDFS_NAMESPACE_URI) && string2.equals("label")) {
                iProperty.subject.setLabel(iProperty.object.getText());
                if (DISP_AS_LABEL) {
                    this.geomMngr.adjustResourceTextAndShape(iProperty.subject, iProperty.subject.getLabel());
                }
            }
            Vector vector = (Vector)this.propertiesByURI.get(iProperty.getIdent());
            vector.remove(iProperty);
            iProperty.setNamespace(string3);
            iProperty.setLocalname(string2);
            if (this.propertiesByURI.containsKey(iProperty.getIdent())) {
                Vector vector2 = (Vector)this.propertiesByURI.get(iProperty.getIdent());
                vector2.add(iProperty);
            } else {
                Vector<IProperty> vector3 = new Vector<IProperty>();
                vector3.add(iProperty);
                this.propertiesByURI.put(iProperty.getIdent(), vector3);
            }
            if (this.showThisNSAsPrefix(iProperty.getNamespace(), true)) {
                this.geomMngr.updateAPropertyText(iProperty, string + ":" + iProperty.getLocalname());
            } else {
                this.geomMngr.updateAPropertyText(iProperty, iProperty.getIdent());
            }
            gssMngr.incStyling(iProperty);
        }
    }

    static void changePropertySubject(IProperty iProperty, IResource iResource) {
        if (iProperty.getSubject() != null && iProperty.getSubject() != iResource) {
            IResource iResource2 = iProperty.getSubject();
            iResource2.removeOutgoingPredicate(iProperty);
        }
        iProperty.setSubject(iResource);
        iResource.addOutgoingPredicate(iProperty);
        gssMngr.incStyling(iProperty);
    }

    static void changePropertyObject(IProperty iProperty, INode iNode) {
        if (iProperty.getObject() != null && iProperty.getObject() != iNode) {
            INode iNode2 = iProperty.getObject();
            if (iNode2 instanceof ILiteral) {
                ((ILiteral)iNode2).setIncomingPredicate(null);
            } else {
                ((IResource)iNode2).removeIncomingPredicate(iProperty);
            }
        }
        if (iNode instanceof ILiteral) {
            iProperty.setObject((ILiteral)iNode);
            ((ILiteral)iNode).setIncomingPredicate(iProperty);
        } else {
            iProperty.setObject((IResource)iNode);
            ((IResource)iNode).addIncomingPredicate(iProperty);
        }
        gssMngr.incStyling(iProperty);
    }

    void selectResourcesMatching(String string) {
        if (string.length() > 0) {
            Enumeration enumeration = this.resourcesByURI.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf(string) == -1) continue;
                this.selectResource((IResource)this.resourcesByURI.get(string2), true);
            }
            if (lastSelectedItem != null) {
                propsp.updateDisplay(lastSelectedItem);
            }
        }
    }

    void selectPropertiesMatching(String string, String string2) {
        if (string.length() > 0 || string2.length() > 0) {
            String string3 = string;
            if (string.endsWith(":") && (string3 = this.getNSURIfromPrefix(string.substring(0, string.length() - 1))) == null) {
                string3 = "";
            }
            Enumeration enumeration = this.propertiesByURI.elements();
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
                while (enumeration2.hasMoreElements()) {
                    IProperty iProperty = (IProperty)enumeration2.nextElement();
                    if (string3.length() > 0) {
                        if (string2.length() > 0) {
                            if (iProperty.getNamespace().indexOf(string3) == -1 || iProperty.getLocalname().indexOf(string2) == -1) continue;
                            this.selectPredicate(iProperty, true);
                            continue;
                        }
                        if (iProperty.getNamespace().indexOf(string3) == -1) continue;
                        this.selectPredicate(iProperty, true);
                        continue;
                    }
                    if (string2.length() <= 0 || iProperty.getLocalname().indexOf(string2) == -1) continue;
                    this.selectPredicate(iProperty, true);
                }
            }
        }
        if (lastSelectedItem != null) {
            propsp.updateDisplay(lastSelectedItem);
        }
    }

    void selectLiteralsMatching(String string) {
        if (string.length() > 0) {
            Enumeration enumeration = this.literals.elements();
            while (enumeration.hasMoreElements()) {
                ILiteral iLiteral = (ILiteral)enumeration.nextElement();
                if (iLiteral.getValue().indexOf(string) == -1) continue;
                this.selectLiteral(iLiteral, true);
            }
            if (lastSelectedItem != null) {
                propsp.updateDisplay(lastSelectedItem);
            }
        }
    }

    void selectResource(IResource iResource, boolean bl) {
        if (bl != iResource.isSelected()) {
            iResource.setSelected(bl);
            if (bl) {
                if (!this.selectedResources.contains(iResource)) {
                    this.selectedResources.add(iResource);
                    lastSelectedItem = iResource;
                }
            } else {
                this.selectedResources.remove(iResource);
            }
        }
    }

    void selectPropertiesOfResource(IResource iResource) {
        IProperty iProperty;
        int n;
        Vector vector = iResource.getIncomingPredicates();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                iProperty = (IProperty)vector.elementAt(n);
                this.selectPredicate(iProperty, true);
                ++n;
            }
        }
        if ((vector = iResource.getOutgoingPredicates()) != null) {
            n = 0;
            while (n < vector.size()) {
                iProperty = (IProperty)vector.elementAt(n);
                this.selectPredicate(iProperty, true);
                ++n;
            }
        }
    }

    void selectLiteral(ILiteral iLiteral, boolean bl) {
        if (bl != iLiteral.isSelected()) {
            iLiteral.setSelected(bl);
            if (bl) {
                if (!this.selectedLiterals.contains(iLiteral)) {
                    this.selectedLiterals.add(iLiteral);
                    lastSelectedItem = iLiteral;
                }
            } else {
                this.selectedLiterals.remove(iLiteral);
            }
        }
    }

    void selectPropertiesOfLiteral(ILiteral iLiteral) {
        IProperty iProperty = iLiteral.getIncomingPredicate();
        if (iProperty != null) {
            this.selectPredicate(iProperty, true);
        }
    }

    void selectPredicate(IProperty iProperty, boolean bl) {
        this.selectPredicate(iProperty, bl, false);
    }

    void selectPredicate(IProperty iProperty, boolean bl, boolean bl2) {
        if (bl != iProperty.isSelected()) {
            if (bl2 && iProperty.isLaidOutInTableForm()) {
                if (bl) {
                    lastSelectedItem = iProperty;
                }
                if (iProperty.getSubject() != null) {
                    Vector vector = iProperty.getSubject().getOutgoingPredicates();
                    try {
                        int n = 0;
                        while (n < vector.size()) {
                            IProperty iProperty2 = (IProperty)vector.elementAt(n);
                            if (iProperty2.getGlyph() == iProperty.getGlyph()) {
                                iProperty2.setSelected(bl, true);
                                if (bl) {
                                    if (!this.selectedPredicates.contains(iProperty2)) {
                                        this.selectedPredicates.add(iProperty2);
                                    }
                                } else {
                                    this.selectedPredicates.remove(iProperty2);
                                }
                            }
                            ++n;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        System.err.println("Error:Editor.selectPredicate(): unable to select property " + iProperty);
                        nullPointerException.printStackTrace();
                    }
                }
            } else {
                iProperty.setSelected(bl, !bl2);
                if (bl) {
                    if (!this.selectedPredicates.contains(iProperty)) {
                        this.selectedPredicates.add(iProperty);
                        lastSelectedItem = iProperty;
                    }
                } else {
                    this.selectedPredicates.remove(iProperty);
                }
            }
        }
    }

    void selectNodesOfProperty(IProperty iProperty) {
        this.selectResource(iProperty.getSubject(), true);
        INode iNode = iProperty.getObject();
        if (iNode instanceof IResource) {
            this.selectResource((IResource)iNode, true);
        } else {
            this.selectLiteral((ILiteral)iNode, true);
        }
    }

    void selectAllNodes() {
        Vector vector = mSpace.getGlyphsOfType(resShapeType);
        int n = 0;
        while (n < vector.size()) {
            this.selectResource((IResource)((Glyph)vector.elementAt(n)).getOwner(), true);
            ++n;
        }
        vector = mSpace.getGlyphsOfType(litShapeType);
        int n2 = 0;
        while (n2 < vector.size()) {
            this.selectLiteral((ILiteral)((Glyph)vector.elementAt(n2)).getOwner(), true);
            ++n2;
        }
    }

    void selectAllEdges() {
        Vector vector = mSpace.getGlyphsOfType(propPathType);
        int n = 0;
        while (n < vector.size()) {
            this.selectPredicate((IProperty)((Glyph)vector.elementAt(n)).getOwner(), true);
            ++n;
        }
    }

    void unselectLastSelection() {
        propsp.reset();
        tblp.updatePropertyBrowser(null, false);
        this.unselectAll();
        lastSelectedItem = null;
    }

    void unselectAll() {
        propsp.reset();
        int n = this.selectedResources.size() - 1;
        while (n >= 0) {
            this.selectResource((IResource)this.selectedResources.elementAt(n), false);
            --n;
        }
        int n2 = this.selectedLiterals.size() - 1;
        while (n2 >= 0) {
            this.selectLiteral((ILiteral)this.selectedLiterals.elementAt(n2), false);
            --n2;
        }
        int n3 = this.selectedPredicates.size() - 1;
        while (n3 >= 0) {
            this.selectPredicate((IProperty)this.selectedPredicates.elementAt(n3), false);
            --n3;
        }
        if (!this.selectedResources.isEmpty()) {
            System.err.println("Debug: Editor.unselectAll(): selectedResources should be empty");
        }
        if (!this.selectedLiterals.isEmpty()) {
            System.err.println("Debug: Editor.unselectAll(): selectedLiterals should be empty ; size=" + this.selectedLiterals.size());
        }
        if (!this.selectedPredicates.isEmpty()) {
            System.err.println("Debug: Editor.unselectAll(): selectedPredicates should be empty");
        }
        lastSelectedItem = null;
    }

    void deleteResource(IResource iResource) {
        int n;
        Vector vector = iResource.getIncomingPredicates();
        if (vector != null) {
            n = vector.size() - 1;
            while (n >= 0) {
                this.deleteProperty((IProperty)vector.elementAt(n));
                --n;
            }
        }
        if ((vector = iResource.getOutgoingPredicates()) != null) {
            n = vector.size() - 1;
            while (n >= 0) {
                this.deleteProperty((IProperty)vector.elementAt(n));
                --n;
            }
        }
        if (iResource.isVisuallyRepresented()) {
            VirtualSpace virtualSpace = vsm.getVirtualSpace(mainVirtualSpace);
            virtualSpace.destroyGlyph(iResource.getGlyph());
            if (iResource.getGlyphText() != null) {
                virtualSpace.destroyGlyph((Glyph)iResource.getGlyphText());
            }
        }
        this.removeResource(iResource);
    }

    void removeResource(IResource iResource) {
        if (this.resourcesByURI.containsKey(iResource.getIdentity())) {
            this.resourcesByURI.remove(iResource.getIdentity());
        }
        this.selectResource(iResource, false);
    }

    void deleteLiteral(ILiteral iLiteral) {
        if (iLiteral.getIncomingPredicate() != null) {
            this.deleteProperty(iLiteral.getIncomingPredicate());
        }
        if (iLiteral.isVisuallyRepresented()) {
            VirtualSpace virtualSpace = vsm.getVirtualSpace(mainVirtualSpace);
            virtualSpace.destroyGlyph(iLiteral.getGlyph());
            if (iLiteral.getGlyphText() != null) {
                virtualSpace.destroyGlyph((Glyph)iLiteral.getGlyphText());
            }
        }
        this.removeLiteral(iLiteral);
    }

    void removeLiteral(ILiteral iLiteral) {
        this.literals.remove(iLiteral);
        this.selectLiteral(iLiteral, false);
    }

    void deleteProperty(IProperty iProperty) {
        IResource iResource = null;
        INode iNode = null;
        if (iProperty.getSubject() != null) {
            iResource = iProperty.getSubject();
            iResource.removeOutgoingPredicate(iProperty);
            if (iProperty.getNamespace().equals(RDFS_NAMESPACE_URI) && iProperty.getLocalname().equals("label")) {
                this.geomMngr.adjustResourceTextAndShape(iProperty.subject, iProperty.subject.getGraphLabel());
            }
        }
        if (iProperty.getObject() != null) {
            iNode = iProperty.getObject();
            if (iNode instanceof IResource) {
                ((IResource)iNode).removeIncomingPredicate(iProperty);
            } else {
                ((ILiteral)iNode).setIncomingPredicate(null);
            }
            if (iNode.isLaidOutInTableForm()) {
                iNode.setTableFormLayout(false);
            }
        }
        if (iProperty.isVisuallyRepresented()) {
            VirtualSpace virtualSpace = vsm.getVirtualSpace(mainVirtualSpace);
            if (iProperty.isLaidOutInTableForm() && IProperty.sharedPropertyArc(iProperty)) {
                Vector vector;
                if ((iProperty.getGlyph().getOwner() == iProperty || iProperty.getGlyphHead() != null && iProperty.getGlyphHead().getOwner() == iProperty) && (vector = IProperty.getAllPropertiesInSameTableAs(iProperty)).size() > 0) {
                    iProperty.getGlyph().setOwner(vector.firstElement());
                    if (iProperty.getGlyphHead() != null) {
                        iProperty.getGlyphHead().setOwner(vector.firstElement());
                    }
                }
            } else {
                virtualSpace.destroyGlyph(iProperty.getGlyph());
                if (iProperty.getGlyphHead() != null) {
                    virtualSpace.destroyGlyph((Glyph)iProperty.getGlyphHead());
                }
            }
            if (iProperty.getGlyphText() != null) {
                virtualSpace.destroyGlyph((Glyph)iProperty.getGlyphText());
            }
            if (iProperty.getTableCellGlyph() != null) {
                virtualSpace.destroyGlyph((Glyph)iProperty.getTableCellGlyph());
            }
        }
        this.removeProperty(iProperty);
    }

    void removeProperty(IProperty iProperty) {
        if (this.propertiesByURI.containsKey(iProperty.getIdent())) {
            Vector vector = (Vector)this.propertiesByURI.get(iProperty.getIdent());
            vector.remove(iProperty);
            if (vector.isEmpty()) {
                this.propertiesByURI.remove(iProperty.getIdent());
            }
        }
        this.selectPredicate(iProperty, false);
    }

    void commentNode(INode iNode, boolean bl) {
        if (bl && !iNode.isCommented()) {
            iNode.comment(bl, this);
        } else if (!bl && iNode.isCommented()) {
            iNode.comment(bl, this);
        }
    }

    void commentPredicate(IProperty iProperty, boolean bl) {
        if (bl && !iProperty.isCommented()) {
            iProperty.comment(bl, this);
        } else if (!bl && iProperty.isCommented()) {
            iProperty.comment(bl, this);
        }
    }

    void declareNSBindings(Map map, NsIterator nsIterator) {
        String string;
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = (String)map.get(string2);
            hashtable.put(string, string2);
        }
        Vector<String> vector = new Vector<String>();
        while (nsIterator.hasNext()) {
            string = nsIterator.nextNs();
            if (hashtable.containsKey(string)) continue;
            vector.add(string);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = (String)hashtable.get(string);
            this.addNamespaceBinding(string2, string, new Boolean(true), true, true);
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            this.addNamespaceBinding("", (String)enumeration2.nextElement(), new Boolean(false), true, false);
        }
        hashtable.clear();
        vector.removeAllElements();
    }

    boolean addNamespaceBinding(String string, String string2, Boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            if (string.length() > 0 && string.equals((String)Editor.tblp.nsTableModel.getValueAt(n, 0))) {
                bl4 = true;
                if (!bl2) {
                    JOptionPane.showMessageDialog(tblp, "Prefix " + string + " is already assigned to namespace " + (String)Editor.tblp.nsTableModel.getValueAt(n, 1));
                }
                if (!bl3) {
                    return false;
                }
            }
            if (string2.equals((String)Editor.tblp.nsTableModel.getValueAt(n, 1))) {
                bl5 = true;
                if (!bl2) {
                    JOptionPane.showMessageDialog(tblp, "Namespace URI " + string2 + " is already binded to prefix " + (String)Editor.tblp.nsTableModel.getValueAt(n, 0));
                }
                if (!bl3) {
                    return false;
                }
                Editor.tblp.nsTableModel.setValueAt(string, n, 0);
                Editor.tblp.nsTableModel.setValueAt(bl, n, 2);
                return true;
            }
            ++n;
        }
        if (string.equals(ANON_NODE.substring(0, ANON_NODE.length() - 1))) {
            bl4 = true;
            if (!bl2) {
                JOptionPane.showMessageDialog(tblp, "Prefix '" + string + "' is already used as the anonymous node prefix");
            }
        }
        if (!bl4 && !bl5) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(string);
            vector.add(string2);
            vector.add(bl);
            int n2 = 0;
            while (n2 < Editor.tblp.nsTableModel.getRowCount()) {
                String string3 = (String)Editor.tblp.nsTableModel.getValueAt(n2, 1);
                if (string3.compareTo(string2) > 0) break;
                ++n2;
            }
            Editor.tblp.nsTableModel.insertRow(n2, vector);
            this.updatePropertyTabPrefix(string2, string);
            return true;
        }
        return false;
    }

    void removeNamespaceBinding(int n) {
        Object object;
        String string = (String)Editor.tblp.nsTableModel.getValueAt(n, 1);
        Editor.tblp.nsTableModel.removeRow(n);
        if (Editor.tblp.nsTable.getRowCount() > n) {
            Editor.tblp.nsTable.setRowSelectionInterval(n, n);
        } else if (Editor.tblp.nsTable.getRowCount() > 0) {
            int n2 = Editor.tblp.nsTable.getRowCount() - 1;
            Editor.tblp.nsTable.setRowSelectionInterval(n2, n2);
        }
        Enumeration enumeration = this.propertiesByURI.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            object = ((Vector)this.propertiesByURI.get(string2)).elements();
            while (object.hasMoreElements()) {
                IProperty iProperty = (IProperty)object.nextElement();
                this.geomMngr.updateAPropertyText(iProperty, iProperty.getIdent());
            }
        }
        Enumeration enumeration2 = this.resourcesByURI.keys();
        while (enumeration2.hasMoreElements()) {
            String string3 = (String)enumeration2.nextElement();
            if (!string3.startsWith(string)) continue;
            object = (IResource)this.resourcesByURI.get(string3);
            this.geomMngr.adjustResourceTextAndShape((IResource)object, ((IResource)object).getGraphLabel());
        }
        this.updatePropertyTabPrefix(string, "");
    }

    String tryToSolveBinding(String string) {
        if (string.startsWith("http:") || string.startsWith("ftp:") || string.startsWith("mailto:")) {
            return string;
        }
        int n = string.indexOf(":");
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = this.getNSURIfromPrefix(string2);
            if (string3 != null && string3.length() > 0) {
                return string3 + string.substring(string2.length() + 1, string.length());
            }
            return string;
        }
        return string;
    }

    void updatePrefixBindingsInGraph() {
        if (tblp != null) {
            int n = 0;
            while (n < Editor.tblp.nsTableModel.getRowCount()) {
                if (((Boolean)Editor.tblp.nsTableModel.getValueAt(n, 2)).booleanValue()) {
                    String string = (String)Editor.tblp.nsTableModel.getValueAt(n, 1);
                    String string2 = (String)Editor.tblp.nsTableModel.getValueAt(n, 0);
                    if (string2 != null && string2.length() > 0) {
                        String string3;
                        Enumeration<Object> enumeration;
                        String string4;
                        Enumeration enumeration2 = this.propertiesByURI.keys();
                        while (enumeration2.hasMoreElements()) {
                            string4 = (String)enumeration2.nextElement();
                            if (!string4.startsWith(string)) continue;
                            enumeration = ((Vector)this.propertiesByURI.get(string4)).elements();
                            while (enumeration.hasMoreElements()) {
                                IProperty iProperty = (IProperty)enumeration.nextElement();
                                string3 = iProperty.getIdent();
                                this.geomMngr.updateAPropertyText(iProperty, string2 + ":" + string3.substring(string.length(), string3.length()));
                            }
                        }
                        enumeration = this.resourcesByURI.keys();
                        while (enumeration.hasMoreElements()) {
                            string4 = (String)enumeration.nextElement();
                            if (!string4.startsWith(string)) continue;
                            IResource iResource = (IResource)this.resourcesByURI.get(string4);
                            string3 = iResource.getGraphLabel();
                            this.geomMngr.adjustResourceTextAndShape(iResource, string2 + ":" + string3.substring(string.length(), string3.length()));
                        }
                    }
                }
                ++n;
            }
        }
    }

    void updateNamespaceBinding(int n, int n2, String string, String string2, Boolean bl, int n3) {
        if (n2 == 2) {
            if (bl.booleanValue() && string.length() > 0) {
                String string3;
                Object object;
                String string4;
                Enumeration enumeration = this.propertiesByURI.keys();
                while (enumeration.hasMoreElements()) {
                    string4 = (String)enumeration.nextElement();
                    if (!string4.startsWith(string2)) continue;
                    object = ((Vector)this.propertiesByURI.get(string4)).elements();
                    while (object.hasMoreElements()) {
                        IProperty iProperty = (IProperty)object.nextElement();
                        string3 = iProperty.getIdent();
                        this.geomMngr.updateAPropertyText(iProperty, string + ":" + string3.substring(string2.length()));
                    }
                }
                Enumeration enumeration2 = this.resourcesByURI.keys();
                while (enumeration2.hasMoreElements()) {
                    string4 = (String)enumeration2.nextElement();
                    if (!string4.startsWith(string2) || (string3 = ((IResource)(object = (IResource)this.resourcesByURI.get(string4))).getGraphLabel()).length() <= string2.length()) continue;
                    this.geomMngr.adjustResourceTextAndShape((IResource)object, string + ":" + string3.substring(string2.length(), string3.length()));
                }
            } else {
                Object object;
                String string5;
                Enumeration enumeration = this.propertiesByURI.keys();
                while (enumeration.hasMoreElements()) {
                    string5 = (String)enumeration.nextElement();
                    if (!string5.startsWith(string2)) continue;
                    object = ((Vector)this.propertiesByURI.get(string5)).elements();
                    while (object.hasMoreElements()) {
                        IProperty iProperty = (IProperty)object.nextElement();
                        this.geomMngr.updateAPropertyText(iProperty, iProperty.getIdent());
                    }
                }
                Enumeration enumeration3 = this.resourcesByURI.keys();
                while (enumeration3.hasMoreElements()) {
                    string5 = (String)enumeration3.nextElement();
                    if (!string5.startsWith(string2)) continue;
                    object = (IResource)this.resourcesByURI.get(string5);
                    this.geomMngr.adjustResourceTextAndShape((IResource)object, ((IResource)object).getGraphLabel());
                }
            }
        } else if (n2 == 0) {
            if (string.length() > 0) {
                if (bl.booleanValue()) {
                    Object object;
                    String string6;
                    Enumeration enumeration = this.propertiesByURI.keys();
                    while (enumeration.hasMoreElements()) {
                        string6 = (String)enumeration.nextElement();
                        if (!string6.startsWith(string2)) continue;
                        object = ((Vector)this.propertiesByURI.get(string6)).elements();
                        while (object.hasMoreElements()) {
                            IProperty iProperty = (IProperty)object.nextElement();
                            this.geomMngr.updateAPropertyText(iProperty, string + ":" + iProperty.getLocalname());
                        }
                    }
                    Enumeration enumeration4 = this.resourcesByURI.keys();
                    while (enumeration4.hasMoreElements()) {
                        String string7;
                        string6 = (String)enumeration4.nextElement();
                        if (!string6.startsWith(string2) || (string7 = ((IResource)(object = (IResource)this.resourcesByURI.get(string6))).getGraphLabel()).length() <= string2.length()) continue;
                        this.geomMngr.adjustResourceTextAndShape((IResource)object, string + ":" + string7.substring(string2.length(), string7.length()));
                    }
                }
                this.updatePropertyTabPrefix(string2, string);
            } else {
                Object object;
                String string8;
                Enumeration enumeration = this.propertiesByURI.keys();
                while (enumeration.hasMoreElements()) {
                    string8 = (String)enumeration.nextElement();
                    if (!string8.startsWith(string2)) continue;
                    object = ((Vector)this.propertiesByURI.get(string8)).elements();
                    while (object.hasMoreElements()) {
                        IProperty iProperty = (IProperty)object.nextElement();
                        this.geomMngr.updateAPropertyText(iProperty, iProperty.getIdent());
                    }
                }
                Enumeration enumeration5 = this.resourcesByURI.keys();
                while (enumeration5.hasMoreElements()) {
                    string8 = (String)enumeration5.nextElement();
                    if (!string8.startsWith(string2)) continue;
                    object = (IResource)this.resourcesByURI.get(string8);
                    this.geomMngr.adjustResourceTextAndShape((IResource)object, ((IResource)object).getGraphLabel());
                }
                this.updatePropertyTabPrefix(string2, string);
            }
        }
    }

    boolean showThisNSAsPrefix(String string, boolean bl) {
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            if (((String)Editor.tblp.nsTableModel.getValueAt(n, 1)).equals(string) && bl || ((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).equals(string) && !bl) {
                return (Boolean)Editor.tblp.nsTableModel.getValueAt(n, 2);
            }
            ++n;
        }
        return false;
    }

    static String getNSBinding(String string) {
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            if (((String)Editor.tblp.nsTableModel.getValueAt(n, 1)).equals(string) && ((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                return (String)Editor.tblp.nsTableModel.getValueAt(n, 0);
            }
            ++n;
        }
        return null;
    }

    static String[] getNSBindingFromFullURI(String string) {
        String[] stringArray = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        String string6 = "F";
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            string3 = (String)Editor.tblp.nsTableModel.getValueAt(n, 0);
            string2 = (String)Editor.tblp.nsTableModel.getValueAt(n, 1);
            if (string.startsWith(string2) && string2.length() > string4.length()) {
                string5 = string3;
                string4 = string2;
                string6 = (Boolean)Editor.tblp.nsTableModel.getValueAt(n, 2) != false ? "T" : "F";
            }
            ++n;
        }
        if (string5 != null && string5.length() > 0) {
            stringArray = new String[]{string5, string4, string6};
            return stringArray;
        }
        return null;
    }

    String getNSURIfromPrefix(String string) {
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).equals(string) && ((String)Editor.tblp.nsTableModel.getValueAt(n, 1)).length() > 0) {
                return (String)Editor.tblp.nsTableModel.getValueAt(n, 1);
            }
            ++n;
        }
        return null;
    }

    boolean prefixAlreadyInUse(String string) {
        if (string.length() > 0) {
            int n = 0;
            while (n < Editor.tblp.nsTableModel.getRowCount()) {
                if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).equals(string)) {
                    return true;
                }
                ++n;
            }
            return string.equals(ANON_NODE.substring(0, ANON_NODE.length() - 1));
        }
        return false;
    }

    String processNodeTextForSB(INode iNode) {
        ILiteral iLiteral;
        String string = iNode.getText();
        if (iNode instanceof ILiteral && (iLiteral = (ILiteral)iNode).getDatatype() != null) {
            String string2 = iLiteral.getDatatype().getURI();
            String[] stringArray = Editor.getNSBindingFromFullURI(string2);
            if (stringArray != null && stringArray[2].equals("T")) {
                string2 = stringArray[0] + ":" + string2.substring(stringArray[1].length(), string2.length());
            }
            string = "[" + string2 + "]   " + string;
        }
        return string;
    }

    boolean addPropertyType(String string, String string2, boolean bl) {
        boolean bl2 = false;
        String string3 = "";
        if (string.length() > 0 && string2.length() > 0) {
            int n;
            Object object;
            if (string.charAt(string.length() - 1) == ':') {
                object = string.substring(0, string.length() - 1);
                n = 0;
                while (n < Editor.tblp.nsTableModel.getRowCount()) {
                    if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).equals(object)) {
                        string3 = (String)Editor.tblp.nsTableModel.getValueAt(n, 1);
                        break;
                    }
                    ++n;
                }
                if (string3.length() == 0) {
                    JOptionPane.showMessageDialog(tblp, "Prefix " + string + " is not binded to any namespace.");
                    return false;
                }
            } else {
                string3 = string;
            }
            object = (DefaultTableModel)Editor.tblp.prTable.getModel();
            n = 0;
            while (n < ((DefaultTableModel)object).getRowCount()) {
                if (((String)((DefaultTableModel)object).getValueAt(n, 2)).equals(string2) && ((String)((DefaultTableModel)object).getValueAt(n, 0)).equals(string3)) {
                    bl2 = true;
                    if (!bl) {
                        JOptionPane.showMessageDialog(tblp, "Property " + string3 + string2 + " is already defined.");
                    }
                    return false;
                }
                ++n;
            }
            if (!bl2) {
                int n2;
                String string4 = Editor.getNSBinding(string3);
                Vector<String> vector = new Vector<String>();
                vector.add(string3);
                vector.add(string4 == null ? "" : string4);
                vector.add(string2);
                if (Utils.isMembershipProperty(string2)) {
                    int n3 = ((DefaultTableModel)object).getRowCount();
                    int n4 = ((DefaultTableModel)object).getRowCount() - 1;
                    while (n4 > 0) {
                        String string5 = (String)((DefaultTableModel)object).getValueAt(n4, 2);
                        if (!((String)((DefaultTableModel)object).getValueAt(n4, 0)).equals(RDFMS_NAMESPACE_URI) || !Utils.isMembershipProperty(string5)) {
                            n3 = n4 + 1;
                            break;
                        }
                        --n4;
                    }
                    n2 = n3;
                    while (n2 < ((DefaultTableModel)object).getRowCount()) {
                        String string6 = ((String)((DefaultTableModel)object).getValueAt(n2, 0)).concat((String)((DefaultTableModel)object).getValueAt(n2, 2));
                        if (string6.compareTo(string3 + string2) > 0) break;
                        ++n2;
                    }
                    Editor.tblp.prTable.clearSelection();
                    this.selectedPropertyConstructorNS = RDFMS_NAMESPACE_URI;
                    this.selectedPropertyConstructorLN = MEMBERSHIP_PROP_CONSTRUCTOR;
                } else {
                    n2 = 0;
                    while (n2 < ((DefaultTableModel)object).getRowCount()) {
                        String string7 = ((String)((DefaultTableModel)object).getValueAt(n2, 0)).concat((String)((DefaultTableModel)object).getValueAt(n2, 2));
                        if (string7.compareTo(string3 + string2) > 0 || Utils.isMembershipProperty((String)((DefaultTableModel)object).getValueAt(n2, 2))) break;
                        ++n2;
                    }
                }
                ((DefaultTableModel)object).insertRow(n2, vector);
                return true;
            }
            return false;
        }
        return false;
    }

    void removePropertyConstructor(int n) {
        boolean bl = false;
        DefaultTableModel defaultTableModel = (DefaultTableModel)Editor.tblp.prTable.getModel();
        String string = (String)defaultTableModel.getValueAt(n, 0) + (String)defaultTableModel.getValueAt(n, 2);
        Enumeration enumeration = this.propertiesByURI.keys();
        while (enumeration.hasMoreElements()) {
            if (!((String)enumeration.nextElement()).equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n2 = JOptionPane.showOptionDialog(null, "At least one property in the model is of this type.\n Are you sure you want to remove the type from the list of types?\n(This will not remove the properties from the current model, but just the entry in this list).", "Warning", -1, 2, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                defaultTableModel.removeRow(n);
                if (Editor.tblp.prTable.getRowCount() > n) {
                    Editor.tblp.prTable.setRowSelectionInterval(n, n);
                } else if (Editor.tblp.prTable.getRowCount() > 0) {
                    int n3 = Editor.tblp.prTable.getRowCount() - 1;
                    Editor.tblp.prTable.setRowSelectionInterval(n3, n3);
                }
            }
        } else {
            defaultTableModel.removeRow(n);
            if (Editor.tblp.prTable.getRowCount() > n) {
                Editor.tblp.prTable.setRowSelectionInterval(n, n);
            } else if (Editor.tblp.prTable.getRowCount() > 0) {
                int n4 = Editor.tblp.prTable.getRowCount() - 1;
                Editor.tblp.prTable.setRowSelectionInterval(n4, n4);
            }
        }
    }

    void updatePropertyTabPrefix(String string, String string2) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)Editor.tblp.prTable.getModel();
        int n = 0;
        while (n < defaultTableModel.getRowCount()) {
            if (((String)defaultTableModel.getValueAt(n, 0)).equals(string)) {
                defaultTableModel.setValueAt(string2, n, 1);
            }
            ++n;
        }
    }

    void initRDFMSProperties() {
        this.addPropertyType(RDFMS_NAMESPACE_URI, MEMBERSHIP_PROP_CONSTRUCTOR, true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "object", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "predicate", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "subject", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "type", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "value", true);
    }

    void initRDFSProperties() {
        this.addPropertyType(RDFS_NAMESPACE_URI, "comment", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "domain", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "isDefinedBy", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "label", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "range", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "seeAlso", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "subClassOf", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "subPropertyOf", true);
    }

    void setSelectedPropertyConstructor(String string, String string2) {
        this.selectedPropertyConstructorNS = string;
        this.selectedPropertyConstructorLN = string2;
    }

    Vector getAllPropertyNS() {
        Vector<String> vector = new Vector<String>();
        TableModel tableModel = Editor.tblp.prTable.getModel();
        int n = 0;
        while (n < tableModel.getRowCount()) {
            String string = (String)tableModel.getValueAt(n, 0);
            String string2 = Editor.getNSBinding(string);
            if (string2 != null) {
                string = string2;
            }
            if (!vector.contains(string)) {
                vector.add(string);
            }
            ++n;
        }
        return vector;
    }

    Vector getProperties4NS(String string) {
        Vector<Object> vector = new Vector<Object>();
        TableModel tableModel = Editor.tblp.prTable.getModel();
        int n = 0;
        while (n < tableModel.getRowCount()) {
            String string2;
            if (((String)tableModel.getValueAt(n, 0)).equals(string) || (string2 = Editor.getNSBinding((String)tableModel.getValueAt(n, 0))) != null && string2.equals(string)) {
                vector.add(tableModel.getValueAt(n, 2));
            }
            ++n;
        }
        return vector;
    }

    public void setAnonymousNodePrefix(String string) {
        ANON_NODE = string;
    }

    public String getAnonymousNodePrefix() {
        return ANON_NODE;
    }

    void showTablePanel(boolean bl) {
        ConfigManager.showNSWindow = bl;
        if (ConfigManager.showNSWindow) {
            tblp.show();
        } else {
            tblp.hide();
        }
    }

    void showPropsPanel(boolean bl) {
        ConfigManager.showEditWindow = bl;
        if (ConfigManager.showEditWindow) {
            propsp.show();
        } else {
            propsp.hide();
        }
    }

    void showNavPanel(boolean bl) {
        ConfigManager.showNavWindow = bl;
        if (ConfigManager.showNavWindow) {
            navp.show();
        } else {
            navp.hide();
        }
    }

    void getGlobalView() {
        this.rememberLocation(vsm.getVirtualSpace(mainVirtualSpace).getCamera(0).getLocation());
        vsm.getGlobalView(vsm.getVirtualSpace(mainVirtualSpace).getCamera(0), ConfigManager.ANIM_DURATION);
    }

    void getHigherView() {
        Camera camera = vsm.getVirtualSpace(mainVirtualSpace).getCamera(0);
        this.rememberLocation(camera.getLocation());
        Float f = new Float(camera.getAltitude() + camera.getFocal());
        Editor.vsm.animator.createCameraAnimation((long)ConfigManager.ANIM_DURATION, (int)AnimManager.CA_ALT_SIG, (Object)f, camera.getID());
    }

    void getLowerView() {
        Camera camera = vsm.getVirtualSpace(mainVirtualSpace).getCamera(0);
        this.rememberLocation(camera.getLocation());
        Float f = new Float(-(camera.getAltitude() + camera.getFocal()) / 2.0f);
        Editor.vsm.animator.createCameraAnimation((long)ConfigManager.ANIM_DURATION, (int)AnimManager.CA_ALT_SIG, (Object)f, camera.getID());
    }

    void translateView(short s) {
        LongPoint longPoint;
        Camera camera = vsm.getVirtualSpace(mainVirtualSpace).getCamera(0);
        this.rememberLocation(camera.getLocation());
        long[] lArray = mView.getVisibleRegion(camera);
        if (s == MOVE_UP) {
            long l = Math.round((double)(lArray[1] - lArray[3]) / 2.4);
            longPoint = new LongPoint(0L, l);
        } else if (s == MOVE_DOWN) {
            long l = Math.round((double)(lArray[3] - lArray[1]) / 2.4);
            longPoint = new LongPoint(0L, l);
        } else if (s == MOVE_RIGHT) {
            long l = Math.round((double)(lArray[2] - lArray[0]) / 2.4);
            longPoint = new LongPoint(l, 0L);
        } else if (s == MOVE_LEFT) {
            long l = Math.round((double)(lArray[0] - lArray[2]) / 2.4);
            longPoint = new LongPoint(l, 0L);
        } else if (s == MOVE_UP_LEFT) {
            long l = Math.round((double)(lArray[0] - lArray[2]) / 2.4);
            long l2 = Math.round((double)(lArray[1] - lArray[3]) / 2.4);
            longPoint = new LongPoint(l, l2);
        } else if (s == MOVE_UP_RIGHT) {
            long l = Math.round((double)(lArray[2] - lArray[0]) / 2.4);
            long l3 = Math.round((double)(lArray[1] - lArray[3]) / 2.4);
            longPoint = new LongPoint(l, l3);
        } else if (s == MOVE_DOWN_RIGHT) {
            long l = Math.round((double)(lArray[2] - lArray[0]) / 2.4);
            long l4 = Math.round((double)(lArray[3] - lArray[1]) / 2.4);
            longPoint = new LongPoint(l, l4);
        } else {
            long l = Math.round((double)(lArray[0] - lArray[2]) / 2.4);
            long l5 = Math.round((double)(lArray[3] - lArray[1]) / 2.4);
            longPoint = new LongPoint(l, l5);
        }
        Editor.vsm.animator.createCameraAnimation((long)ConfigManager.ANIM_DURATION, (int)AnimManager.CA_TRANS_SIG, (Object)longPoint, camera.getID());
    }

    void showRadarView(boolean bl) {
        if (bl) {
            if (rView == null) {
                Vector<Camera> vector = new Vector<Camera>();
                vector.add(mSpace.getCamera(1));
                vector.add(rSpace.getCamera(0));
                vsm.addView(vector, radarView, ConfigManager.rdW, ConfigManager.rdH, false, true);
                this.reh = new RadarEvtHdlr(this);
                rView = vsm.getView(radarView);
                rView.setEventHandler((AppEventHandler)this.reh);
                rView.setResizable(false);
                rView.setActiveLayer(1);
                rView.setCursorIcon(13);
                vsm.getGlobalView(mSpace.getCamera(1), 100);
                this.cameraMoved();
            } else {
                rView.toFront();
            }
        }
    }

    void rememberLocation(Location location) {
        if (previousLocations.size() >= 10) {
            previousLocations.removeElementAt(0);
        }
        if (previousLocations.size() > 0) {
            if (!Location.equals((Location)((Location)previousLocations.lastElement()), (Location)location)) {
                previousLocations.add(location);
            }
        } else {
            previousLocations.add(location);
        }
    }

    void moveBack() {
        if (previousLocations.size() > 0) {
            Location location = (Location)previousLocations.lastElement();
            Location location2 = vsm.getActiveCamera().getLocation();
            Vector vector = Location.getDifference((Location)location2, (Location)location);
            Editor.vsm.animator.createCameraAnimation((long)ConfigManager.ANIM_DURATION, (int)AnimManager.CA_ALT_TRANS_SIG, (Object)vector, vsm.getActiveCamera().getID());
            previousLocations.removeElementAt(previousLocations.size() - 1);
        }
    }

    public void cameraMoved() {
        if (rView != null) {
            Camera camera = mSpace.getCamera(1);
            Camera camera2 = rSpace.getCamera(0);
            camera2.posx = camera.posx;
            camera2.posy = camera.posy;
            camera2.focal = camera.focal;
            camera2.altitude = camera.altitude;
            long[] lArray = mView.getVisibleRegion(mSpace.getCamera(0));
            observedRegion.moveTo((lArray[0] + lArray[2]) / 2L, (lArray[3] + lArray[1]) / 2L);
            observedRegion.setWidth((lArray[2] - lArray[0]) / 2L);
            observedRegion.setHeight((lArray[1] - lArray[3]) / 2L);
            vsm.repaintNow();
        }
    }

    void updateMainViewFromRadar() {
        Camera camera = mSpace.getCamera(0);
        camera.posx = Editor.observedRegion.vx;
        camera.posy = Editor.observedRegion.vy;
        vsm.repaintNow();
    }

    void centerRadarView() {
        if (rView != null) {
            vsm.getGlobalView(vsm.getVirtualSpace(mainVirtualSpace).getCamera(1), ConfigManager.ANIM_DURATION);
            this.cameraMoved();
        }
    }

    void setMaxLiteralCharCount(int n) {
        if (n != MAX_LIT_CHAR_COUNT) {
            MAX_LIT_CHAR_COUNT = n;
            int n2 = 0;
            while (n2 < this.literals.size()) {
                ILiteral iLiteral = (ILiteral)this.literals.elementAt(n2);
                String string = iLiteral.getValue().length() >= MAX_LIT_CHAR_COUNT ? iLiteral.getValue().substring(0, MAX_LIT_CHAR_COUNT) + " ..." : iLiteral.getValue();
                iLiteral.getGlyphText().setText(string);
                ++n2;
            }
        }
    }

    void setMode(int n) {
        if (n != 11) {
            this.geomMngr.destroyLastResizer();
        }
        this.eeh.mode = n;
    }

    void updatePropertyBrowser(INode iNode) {
        if (ConfigManager.showNSWindow && Editor.tblp.tabbedPane.getSelectedIndex() == 2) {
            tblp.updatePropertyBrowser(iNode, true);
        }
    }

    void quickSearch(String string) {
        if (string.length() > 0) {
            Vector vector;
            if (!string.toLowerCase().equals(this.lastSearchedString)) {
                this.lastSearchedString = string.toLowerCase();
                this.searchIndex = -1;
                this.matchingList.removeAllElements();
                vector = vsm.getVirtualSpace(mainVirtualSpace).getVisibleGlyphs();
                int n = 0;
                while (n < vector.size()) {
                    if (((Glyph)vector.elementAt(n)).getText() != null && ((Glyph)vector.elementAt(n)).getText().toLowerCase().indexOf(this.lastSearchedString) != -1) {
                        this.matchingList.add(vector.elementAt(n));
                    }
                    ++n;
                }
            }
            if (this.matchingList.size() > 0) {
                if (this.searchIndex < this.matchingList.size() - 1) {
                    ++this.searchIndex;
                } else {
                    vsm.getActiveView().setStatusBarText("Reached end of list, going back to the beginning");
                    this.searchIndex = 0;
                }
                vector = (Glyph)this.matchingList.elementAt(this.searchIndex);
                if (this.lastMatchingEntity != null) {
                    this.resetINodeColors(this.lastMatchingEntity);
                }
                this.lastMatchingEntity = (INode)vector.getOwner();
                vector.setHSVColor(ConfigManager.srhTh, ConfigManager.srhTs, ConfigManager.srhTv);
                if (this.lastMatchingEntity instanceof IResource || this.lastMatchingEntity instanceof ILiteral) {
                    vsm.centerOnGlyph(this.lastMatchingEntity.getGlyph(), vsm.getVirtualSpace(mainVirtualSpace).getCamera(0), 400);
                } else {
                    vsm.centerOnGlyph((Glyph)vector, vsm.getVirtualSpace(mainVirtualSpace).getCamera(0), 400);
                }
            }
        }
    }

    void resetQuickSearch() {
        this.searchIndex = -1;
        this.lastSearchedString = "";
        this.matchingList.removeAllElements();
        if (this.lastMatchingEntity != null) {
            this.resetINodeColors(this.lastMatchingEntity);
            this.lastMatchingEntity = null;
        }
    }

    void resetINodeColors(INode iNode) {
        if (this.lastMatchingEntity.isSelected()) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
        } else if (this.lastMatchingEntity.isCommented()) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
        } else if (this.lastMatchingEntity instanceof IResource) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.resTBh, ConfigManager.resTBs, ConfigManager.resTBv);
        } else if (this.lastMatchingEntity instanceof IProperty) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.prpTh, ConfigManager.prpTs, ConfigManager.prpTv);
        } else {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
        }
    }

    void cutSelection() {
        if (lastSelectedItem != null) {
            propsp.reset();
            this.resetCopied();
            ISVCut iSVCut = new ISVCut(this, this.selectedPredicates, this.selectedResources, this.selectedLiterals);
            iSVCut._do();
            this.addCmdToUndoStack(iSVCut);
            cmp.enablePaste(true);
        }
    }

    void copySelection() {
        if (lastSelectedItem != null) {
            this.resetCopied();
            ISVCopy iSVCopy = new ISVCopy(this, this.selectedPredicates, this.selectedResources, this.selectedLiterals);
            iSVCopy._do();
            cmp.enablePaste(true);
        }
    }

    void pasteSelection(long l, long l2) {
        ISVPaste iSVPaste = new ISVPaste(this, this.copiedPredicates, this.copiedResources, this.copiedLiterals, l, l2);
        iSVPaste._do();
        this.addCmdToUndoStack(iSVPaste);
        this.centerRadarView();
    }

    void deleteSelectedEntities() {
        if (lastSelectedItem != null) {
            IProperty iProperty;
            propsp.reset();
            int n = 0;
            while (n < this.selectedResources.size()) {
                Enumeration enumeration;
                Vector vector = ((IResource)this.selectedResources.elementAt(n)).getIncomingPredicates();
                if (vector != null) {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        iProperty = (IProperty)enumeration.nextElement();
                        if (iProperty.isSelected()) continue;
                        this.selectPredicate(iProperty, true);
                    }
                }
                if ((vector = ((IResource)this.selectedResources.elementAt(n)).getOutgoingPredicates()) != null) {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        iProperty = (IProperty)enumeration.nextElement();
                        if (iProperty.isSelected()) continue;
                        this.selectPredicate(iProperty, true);
                    }
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.selectedLiterals.size()) {
                iProperty = ((ILiteral)this.selectedLiterals.elementAt(n2)).getIncomingPredicate();
                if (iProperty != null && !iProperty.isSelected()) {
                    this.selectPredicate(iProperty, true);
                }
                ++n2;
            }
            ISVDelete iSVDelete = new ISVDelete(this, this.selectedPredicates, this.selectedResources, this.selectedLiterals);
            iSVDelete._do();
            this.addCmdToUndoStack(iSVDelete);
            this.centerRadarView();
        }
    }

    void undo() {
        if (this.undoIndex >= 0) {
            this.undoStack[this.undoIndex]._undo();
            this.undoStack[this.undoIndex] = null;
            --this.undoIndex;
            if (this.undoIndex < 0) {
                this.undoIndex = -1;
                cmp.enableUndo(false);
            }
        }
    }

    void addCmdToUndoStack(ISVCommand iSVCommand) {
        int n = Utils.getFirstEmptyIndex(this.undoStack);
        if (n == -1) {
            Utils.eraseFirstAddNewElem(this.undoStack, iSVCommand);
            this.undoIndex = this.undoStack.length - 1;
        } else {
            this.undoStack[n] = iSVCommand;
            this.undoIndex = n;
        }
        cmp.enableUndo(true);
    }

    void displayRawRDFXMLFile() {
        try {
            if (this.rdfLdr == null) {
                this.rdfLdr = new RDFLoader(this);
            }
            this.rdfLdr.generateJenaModel();
            StringBuffer stringBuffer = this.rdfLdr.serialize(this.rdfModel);
            TextViewer textViewer = new TextViewer(stringBuffer, "Raw RDF/XML Viewer", 0, false);
        }
        catch (Exception exception) {
            System.err.println("Error: Editor.displayRawFile: " + exception);
            exception.printStackTrace();
        }
    }

    void reLayoutGraph() {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "This will call GraphViz/DOT to compute a new layout for the model.\nThe new layout might be completely different from the current one, and you will not be able to undo this operation.\nDo you want to proceed?", "Warning", -1, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            File file = Utils.createTempFile(m_TmpDir.toString(), "tmp", ".rdf");
            this.exportRDF(file, false);
            this.loadRDF(file, RDFLoader.RDF_XML_READER, false);
            if (dltOnExit) {
                file.deleteOnExit();
            }
        }
    }

    void displayResOutgoingPredicates(IResource iResource) {
        new PropertySummary(iResource, this);
    }

    void showErrorMessages() {
        if (this.errorLog != null) {
            if (this.errorLog.isShowing()) {
                this.errorLog.toFront();
            } else {
                this.errorLog = new TextViewer(this.errorMessages, "Error log", 1000, true);
                vsm.getView(mainView).setStatusBarText("");
            }
        } else {
            this.errorLog = new TextViewer(this.errorMessages, "Error log", 1000, true);
            vsm.getView(mainView).setStatusBarText("");
        }
    }

    void printRequest() {
        BufferedImage bufferedImage = vsm.getView(mainView).getImage();
        if (bufferedImage != null) {
            PrintUtilities printUtilities = new PrintUtilities(bufferedImage);
            printUtilities.print();
        }
    }

    void showPrjSummary() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            object = ((Vector)enumeration.nextElement()).elements();
            while (object.hasMoreElements()) {
                object.nextElement();
                ++n;
            }
        }
        object = projectFile == null ? "" : projectFile.toString();
        InfoPanel infoPanel = new InfoPanel(this, (String)object, lastRDF, this.resourcesByURI.size(), this.literals.size(), n);
    }

    void displayURLinBrowser(IResource iResource) {
        if (!iResource.isAnon()) {
            this.displayURLinBrowser(iResource.getIdentity());
        } else {
            vsm.getActiveView().setStatusBarText("Anonymous resources do not have a URI");
        }
    }

    void displayURLinBrowser(String string) {
        if (webBrowser == null) {
            webBrowser = new WebBrowser();
        }
        webBrowser.show(string);
    }

    void alwaysUpdateViews(boolean bl) {
        vsm.setRepaintPolicy(bl);
    }

    void setAntialiasing(boolean bl) {
        ANTIALIASING = bl;
        vsm.getView(mainView).setAntialiasing(ANTIALIASING);
    }

    void saveConfig() {
        this.cfgMngr.saveConfig();
    }

    static void collectGarbage() {
        System.gc();
    }

    public void exit() {
        this.cfgMngr.saveURLs();
        System.exit(0);
    }

    void summary() {
        System.out.println("Resources " + this.resourcesByURI.size());
        System.out.println("Literals " + this.literals.size());
        int n = 0;
        Enumeration enumeration = this.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                enumeration2.nextElement();
                ++n;
            }
        }
        System.out.println("Properties " + n);
    }

    void nsBindings() {
        System.out.println("Namespace bindings");
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            System.out.println("p=" + Editor.tblp.nsTableModel.getValueAt(n, 0) + " uri=" + Editor.tblp.nsTableModel.getValueAt(n, 1) + " disp=" + Editor.tblp.nsTableModel.getValueAt(n, 2));
            ++n;
        }
    }

    void printClipboard() {
        int n;
        System.out.println("Clipboard");
        System.out.print("[");
        if (!this.copiedResources.isEmpty()) {
            n = 0;
            while (n < this.copiedResources.size() - 1) {
                System.out.print(this.copiedResources.elementAt(n).toString() + ",");
                ++n;
            }
            System.out.println(this.copiedResources.lastElement().toString() + "]");
        }
        if (!this.copiedLiterals.isEmpty()) {
            System.out.print("[");
            n = 0;
            while (n < this.copiedLiterals.size() - 1) {
                System.out.print(this.copiedLiterals.elementAt(n).toString() + ",");
                ++n;
            }
            System.out.println(this.copiedLiterals.lastElement().toString() + "]");
        }
        if (!this.copiedPredicates.isEmpty()) {
            System.out.print("[");
            n = 0;
            while (n < this.copiedPredicates.size() - 1) {
                System.out.print(this.copiedPredicates.elementAt(n).toString() + ",");
                ++n;
            }
            System.out.println(this.copiedPredicates.lastElement().toString() + "]");
        }
    }

    public static void commandLineHelp() {
        System.out.println("Usage : ");
        System.out.println("  java org.w3c.IsaView [options] [file_name.isv|file_name.rdf|file_name.nt|file_name.n3]");
        System.out.println("  Options:");
        System.out.println("          -gss  file_name.gss   loads a GSS stylesheet");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 3) {
            Editor.commandLineHelp();
        } else if (stringArray.length == 3) {
            if (stringArray[0].equals("-gss")) {
                gssFile = stringArray[1];
                argFile = stringArray[2];
            } else if (stringArray[1].equals("-gss")) {
                gssFile = stringArray[2];
                argFile = stringArray[0];
            } else {
                Editor.commandLineHelp();
            }
        } else if (stringArray.length == 2) {
            if (stringArray[0].equals("-gss")) {
                gssFile = stringArray[1];
            } else {
                Editor.commandLineHelp();
            }
        } else if (stringArray.length == 1) {
            argFile = stringArray[0];
        }
        Editor editor = new Editor();
    }

    static {
        BASE_URI = DEFAULT_BASE_URI = "";
        ANON_NODE = "genid:";
        MEMBERSHIP_PROP_CONSTRUCTOR = "_??   (Membership property auto-numbering: _1, _2, ...)";
        DEFAULT_LANGUAGE_IN_LITERALS = "en";
        ALWAYS_INCLUDE_LANG_IN_LITERALS = false;
        ABBREV_SYNTAX = true;
        DISP_AS_LABEL = true;
        MAX_LIT_CHAR_COUNT = 40;
        GRAPH_ORIENTATION = "LR";
        projectFile = null;
        lastRDF = null;
        tmpRdfFile = "tmp/serial.rdf";
        m_GraphVizPath = new File("C:\\ATT\\Graphviz\\bin\\dot.exe");
        m_GraphVizFontDir = new File("C:\\ATT\\Graphviz");
        m_TmpDir = new File("tmp");
        projectDir = new File("projects");
        lastOpenPrjDir = null;
        lastSavePrjDir = null;
        rdfDir = new File("export");
        lastImportRDFDir = null;
        lastExportRDFDir = null;
        dltOnExit = true;
        MAX_BRW_LIST_SIZE = 10;
        UNDO_SIZE = 5;
        SAVE_WINDOW_LAYOUT = false;
        smallFont = new Font("Dialog", 0, 10);
        tinyFont = new Font("Dialog", 0, 9);
        vtmFontName = "Dialog";
        vtmFontSize = 10;
        vtmFont = new Font(vtmFontName, 0, vtmFontSize);
        swingFontName = "Dialog";
        swingFontSize = 10;
        swingFont = new Font(swingFontName, 0, swingFontSize);
        tinySwingFontSize = 9;
        tinySwingFont = new Font(swingFontName, 0, tinySwingFontSize);
        ANTIALIASING = false;
        autoDetectBrowser = true;
        browserPath = new File("");
        browserOptions = "";
        useProxy = false;
        proxyHost = "";
        proxyPort = "80";
        MOVE_UP = 0;
        MOVE_DOWN = 1;
        MOVE_LEFT = (short)2;
        MOVE_RIGHT = (short)3;
        MOVE_UP_LEFT = (short)4;
        MOVE_UP_RIGHT = (short)5;
        MOVE_DOWN_LEFT = (short)6;
        MOVE_DOWN_RIGHT = (short)7;
    }
}

