/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.IsaViz.CustomOrdering;
import org.w3c.IsaViz.GSSEditor;
import org.w3c.IsaViz.GSSLitSelector;
import org.w3c.IsaViz.GSSPOStatement;
import org.w3c.IsaViz.GSSPrpSelector;
import org.w3c.IsaViz.GSSResSelector;
import org.w3c.IsaViz.GSSSOStatement;
import org.w3c.IsaViz.GSSSPStatement;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.RDFLoader;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.Utils;
import org.xml.sax.SAXParseException;

public class EditableStylesheet
implements RDFErrorHandler {
    GSSEditor editor;
    Hashtable styles = new Hashtable();
    Hashtable orderings = new Hashtable();
    Hashtable rStyleRules = new Hashtable();
    Hashtable lStyleRules;
    Hashtable pStyleRules = new Hashtable();
    Hashtable rVisRules;
    Hashtable lVisRules;
    Hashtable pVisRules;
    Hashtable rLayoutRules;
    Hashtable lLayoutRules;
    Hashtable pLayoutRules;
    Hashtable sortRules;
    Vector resourceSelectors;
    Vector propertySelectors;
    Vector literalSelectors;
    Hashtable styleStatements;
    Hashtable visibilityStatements;
    Hashtable layoutStatements;
    Hashtable sortStatements;
    Hashtable selectorTypes;
    Hashtable uriEQConstraints;
    Hashtable uriSWConstraints;
    Hashtable sos;
    Hashtable pos;
    Hashtable oos;
    Hashtable xosSubjects;
    Hashtable xosPredicates;
    Hashtable xosObjects;
    Hashtable valueCnstrnts;
    Hashtable classCnstrnts;
    Hashtable dtCnstrnts;
    Hashtable id2rselector;
    Hashtable id2pselector;
    Hashtable id2lselector;
    private URL stylesheetURL;

    public EditableStylesheet() {
        this.lStyleRules = new Hashtable();
        this.rVisRules = new Hashtable();
        this.pVisRules = new Hashtable();
        this.lVisRules = new Hashtable();
        this.rLayoutRules = new Hashtable();
        this.pLayoutRules = new Hashtable();
        this.lLayoutRules = new Hashtable();
        this.sortRules = new Hashtable();
    }

    void load(File file, GSSEditor gSSEditor) {
        this.editor = gSSEditor;
        try {
            this.stylesheetURL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("EditableStylesheet.load():Error: malformed stylesheet URL for local file: " + file.toString());
            this.editor.reportError = true;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader(RDFLoader.RDFXMLAB);
            rDFReader.setErrorHandler((RDFErrorHandler)this);
            rDFReader.setProperty(RDFLoader.errorModePropertyName, (Object)"lax");
            rDFReader.read(model, (InputStream)fileInputStream, GraphStylesheet.GSS_BASE_URI);
            this.processStatements(model.listStatements());
        }
        catch (Exception exception) {
            System.err.println("RDFErrorHandler:Warning:GraphStylehseet " + EditableStylesheet.format(exception));
            this.editor.reportError = true;
        }
    }

    void load(URL uRL, GSSEditor gSSEditor) {
        this.editor = gSSEditor;
        this.stylesheetURL = uRL;
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader(RDFLoader.RDFXMLAB);
            rDFReader.setErrorHandler((RDFErrorHandler)this);
            rDFReader.setProperty(RDFLoader.errorModePropertyName, (Object)"lax");
            rDFReader.read(model, uRL.toString());
            this.processStatements(model.listStatements());
        }
        catch (Exception exception) {
            System.err.println("RDFErrorHandler:Warning:GraphStylehseet " + EditableStylesheet.format(exception));
            this.editor.reportError = true;
        }
    }

    protected void processStatements(StmtIterator stmtIterator) {
        this.styleStatements = new Hashtable();
        this.visibilityStatements = new Hashtable();
        this.layoutStatements = new Hashtable();
        this.sortStatements = new Hashtable();
        this.selectorTypes = new Hashtable();
        this.uriEQConstraints = new Hashtable();
        this.uriSWConstraints = new Hashtable();
        this.sos = new Hashtable();
        this.pos = new Hashtable();
        this.oos = new Hashtable();
        this.xosSubjects = new Hashtable();
        this.xosPredicates = new Hashtable();
        this.xosObjects = new Hashtable();
        this.valueCnstrnts = new Hashtable();
        this.classCnstrnts = new Hashtable();
        this.dtCnstrnts = new Hashtable();
        try {
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (statement.getObject() instanceof Resource) {
                    this.processStatement(statement.getSubject(), (Resource)statement.getPredicate(), (Resource)statement.getObject());
                    continue;
                }
                if (!(statement.getObject() instanceof Literal)) continue;
                this.processStatement(statement.getSubject(), (Resource)statement.getPredicate(), (Literal)statement.getObject());
            }
            stmtIterator.close();
            this.buildCustomOrderings();
            this.buildSelectors();
            this.cleanSelectorTempData();
            this.buildRules();
        }
        catch (Exception exception) {
            System.err.println("EditableStylesheet.processStatements: Error: ");
            exception.printStackTrace();
        }
        this.cleanSelectorMapping();
        this.styleStatements.clear();
        this.styleStatements = null;
        this.visibilityStatements.clear();
        this.visibilityStatements = null;
        this.layoutStatements.clear();
        this.layoutStatements = null;
        this.sortStatements.clear();
        this.sortStatements = null;
        this.selectorTypes.clear();
        this.selectorTypes = null;
    }

    protected void cleanSelectorTempData() {
        this.uriEQConstraints.clear();
        this.uriEQConstraints = null;
        this.uriSWConstraints.clear();
        this.uriSWConstraints = null;
        this.sos.clear();
        this.sos = null;
        this.pos.clear();
        this.pos = null;
        this.oos.clear();
        this.oos = null;
        this.xosSubjects.clear();
        this.xosSubjects = null;
        this.xosPredicates.clear();
        this.xosPredicates = null;
        this.xosObjects.clear();
        this.xosObjects = null;
        this.valueCnstrnts.clear();
        this.valueCnstrnts = null;
        this.classCnstrnts.clear();
        this.classCnstrnts = null;
        this.dtCnstrnts.clear();
        this.dtCnstrnts = null;
    }

    protected void cleanSelectorMapping() {
        this.id2rselector.clear();
        this.id2rselector = null;
        this.id2pselector.clear();
        this.id2pselector = null;
        this.id2lselector.clear();
        this.id2lselector = null;
    }

    protected void processStatement(Resource resource, Resource resource2, Resource resource3) {
        String string;
        String string2 = resource.isAnon() ? resource.getId().toString() : resource.toString();
        String string3 = resource2.getURI();
        String string4 = string = resource3.isAnon() ? resource3.getId().toString() : resource3.toString();
        if (string3.equals(GraphStylesheet._gssStyle)) {
            this.rememberStyleRule(string2, string);
        } else if (string3.equals(GraphStylesheet._gssVisibility)) {
            this.rememberVisRule(string2, string);
        } else if (string3.equals(GraphStylesheet._gssDisplay)) {
            this.rememberVisRule(string2, string);
        } else if (string3.equals(GraphStylesheet._gssLayout)) {
            this.rememberLayoutRule(string2, string);
        } else if (string3.equals(GraphStylesheet._gssURIeq)) {
            this.declareURIeqConstraint(string2, string);
        } else if (string3.equals(GraphStylesheet._gssURIsw)) {
            this.declareURIswConstraint(string2, string);
        } else if (string3.equals(GraphStylesheet._gssSOS)) {
            this.declareSOS(string2, string);
        } else if (string3.equals(GraphStylesheet._gssPOS)) {
            this.declarePOS(string2, string);
        } else if (string3.equals(GraphStylesheet._gssOOS)) {
            this.declareOOS(string2, string);
        } else if (string3.equals(GraphStylesheet._rdfType)) {
            this.declareSelectorTypeOrCustomOrdering(string2, string);
        } else if (string3.equals(GraphStylesheet._gssSubject)) {
            this.declareXOSSubject(string2, string);
        } else if (string3.equals(GraphStylesheet._gssPredicate)) {
            this.declareXOSPredicate(string2, string);
        } else if (string3.equals(GraphStylesheet._gssObject)) {
            this.declareXOSObject(string2, string);
        } else if (string3.equals(GraphStylesheet._gssValue)) {
            this.declareValueConstraint(string2, string);
        } else if (string3.equals(GraphStylesheet._gssClass)) {
            this.declareClassConstraint(string2, string);
        } else if (string3.equals(GraphStylesheet._gssDatatype)) {
            this.declareDatatypeConstraint(string2, string);
        } else if (string3.equals(GraphStylesheet._gssShape)) {
            this.addPredefShapeAttributeToStyle(string2, string);
        } else if (string3.equals(GraphStylesheet._gssIcon)) {
            this.addIconAttributeToStyle(string2, string);
        } else if (string3.equals(GraphStylesheet._gssTextAlign)) {
            this.addTextAlignAttributeToStyle(string2, string);
        } else if (string3.equals(GraphStylesheet._gssSort)) {
            this.rememberSortRule(string2, string);
        } else if (string3.equals(GraphStylesheet._gssStrokeDashArray)) {
            this.addStrokeDashArrayToStyle(string2, string);
        } else if (string3.startsWith(GraphStylesheet._rdfItems)) {
            this.addItemToCustomOrdering(string2, string3, string);
        }
    }

    protected void processStatement(Resource resource, Resource resource2, Literal literal) {
        String string = resource.isAnon() ? resource.getId().toString() : resource.toString();
        String string2 = resource2.getURI();
        StringBuffer stringBuffer = new StringBuffer(literal.getLexicalForm());
        Utils.delLeadingAndTrailingSpaces(stringBuffer);
        if (string2.equals(GraphStylesheet._gssFill)) {
            this.addFillAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssStroke)) {
            this.addStrokeAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssStrokeWidth)) {
            this.addStrokeWAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssValue)) {
            this.declareValueConstraint(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssFontWeight)) {
            this.addFontWAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssFontStyle)) {
            this.addFontStAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssFontFamily)) {
            this.addFontFAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssFontSize)) {
            this.addFontSzAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssShape)) {
            this.addShapeOrPolygonAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssStrokeDashArray)) {
            this.addStrokeDashArrayToStyle(string, stringBuffer.toString());
        } else if (string2.equals(GraphStylesheet._gssURIsw)) {
            this.declareURIswConstraint(string, stringBuffer.toString());
        }
    }

    protected void rememberStyleRule(String string, String string2) {
        if (this.styleStatements.containsKey(string)) {
            Vector vector = (Vector)this.styleStatements.get(string);
            if (!Utils.containsString(vector, string2)) {
                vector.add(string2);
            }
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.styleStatements.put(string, vector);
        }
    }

    protected void rememberVisRule(String string, String string2) {
        if (string2.equals(GraphStylesheet._gssHide)) {
            this.visibilityStatements.put(string, GraphStylesheet.VISIBILITY_HIDDEN);
        } else if (string2.equals(GraphStylesheet._gssNone)) {
            this.visibilityStatements.put(string, GraphStylesheet.DISPLAY_NONE);
        } else if (string2.equals(GraphStylesheet._gssShow)) {
            this.visibilityStatements.put(string, GraphStylesheet.VISIBILITY_VISIBLE);
        } else {
            this.visibilityStatements.put(string, GraphStylesheet.VISIBILITY_VISIBLE);
        }
    }

    protected void rememberLayoutRule(String string, String string2) {
        if (string2.equals(GraphStylesheet._gssTable)) {
            this.layoutStatements.put(string, GraphStylesheet.TABLE_FORM);
        } else if (string2.equals(GraphStylesheet._gssNodeAndArc)) {
            this.layoutStatements.put(string, GraphStylesheet.NODE_EDGE);
        } else {
            this.layoutStatements.put(string, GraphStylesheet.NODE_EDGE);
        }
    }

    protected void rememberSortRule(String string, String string2) {
        if (string2.equals(GraphStylesheet._gssSortN)) {
            this.sortStatements.put(string, GraphStylesheet.SORT_BY_NAME);
        } else if (string2.equals(GraphStylesheet._gssSortNR)) {
            this.sortStatements.put(string, GraphStylesheet.SORT_BY_NAME_REV);
        } else if (string2.equals(GraphStylesheet._gssSortNS)) {
            this.sortStatements.put(string, GraphStylesheet.SORT_BY_NAMESPACE);
        } else if (string2.equals(GraphStylesheet._gssSortNSR)) {
            this.sortStatements.put(string, GraphStylesheet.SORT_BY_NAMESPACE_REV);
        } else {
            this.sortStatements.put(string, string2);
        }
    }

    protected void declareSelectorTypeOrCustomOrdering(String string, String string2) {
        if (string2.equals(GraphStylesheet._gssResource)) {
            this.selectorTypes.put(string, GraphStylesheet.RES_SEL);
        } else if (string2.equals(GraphStylesheet._gssProperty)) {
            this.selectorTypes.put(string, GraphStylesheet.PRP_SEL);
        } else if (string2.equals(GraphStylesheet._gssLiteral)) {
            this.selectorTypes.put(string, GraphStylesheet.LIT_SEL);
        }
    }

    protected void declareURIeqConstraint(String string, String string2) {
        this.uriEQConstraints.put(string, string2);
    }

    protected void declareURIswConstraint(String string, String string2) {
        this.uriSWConstraints.put(string, string2);
    }

    protected void declareSOS(String string, String string2) {
        if (this.sos.containsKey(string)) {
            Vector vector = (Vector)this.sos.get(string);
            vector.add(string2);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.sos.put(string, vector);
        }
    }

    protected void declarePOS(String string, String string2) {
        this.pos.put(string, string2);
    }

    protected void declareOOS(String string, String string2) {
        if (this.oos.containsKey(string)) {
            Vector vector = (Vector)this.oos.get(string);
            vector.add(string2);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.oos.put(string, vector);
        }
    }

    protected void declareXOSSubject(String string, String string2) {
        this.xosSubjects.put(string, string2);
    }

    protected void declareXOSPredicate(String string, String string2) {
        this.xosPredicates.put(string, string2);
    }

    protected void declareXOSObject(String string, String string2) {
        this.xosObjects.put(string, string2);
    }

    protected void declareValueConstraint(String string, String string2) {
        this.valueCnstrnts.put(string, string2);
    }

    protected void declareClassConstraint(String string, String string2) {
        this.classCnstrnts.put(string, string2);
    }

    protected void declareDatatypeConstraint(String string, String string2) {
        this.dtCnstrnts.put(string, string2);
    }

    protected Style createAndGetStyle(String string) {
        Style style;
        if (this.styles.containsKey(string)) {
            style = (Style)this.styles.get(string);
        } else {
            style = new Style(string);
            this.styles.put(string, style);
        }
        return style;
    }

    protected void addFillAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFill(string2);
    }

    protected void addStrokeAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setStroke(string2);
    }

    protected void addStrokeWAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setStrokeWidth(string2);
    }

    protected void addStrokeDashArrayToStyle(String string, String string2) {
        this.createAndGetStyle(string).setStrokeDashArray(string2);
    }

    protected void addFontFAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontFamily(string2);
    }

    protected void addFontStAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontStyle(string2);
    }

    protected void addFontSzAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontSize(string2);
    }

    protected void addFontWAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontWeight(string2);
    }

    protected void addPredefShapeAttributeToStyle(String string, String string2) {
        Style style = this.createAndGetStyle(string);
        style.setPredefShape(string2);
        if (style.getIcon() != null) {
            System.err.println("Error: Style " + string + " declares both gss:shape and gss:icon properties which are mutually exclusive. The gss:icon property will be ignored.");
            this.editor.reportError = true;
        }
    }

    protected void addShapeOrPolygonAttributeToStyle(String string, String string2) {
        Style style = this.createAndGetStyle(string);
        String string3 = string2.trim();
        if (string3.startsWith("{")) {
            style.setCustomPolygon(string2);
        } else if (string3.startsWith("[")) {
            style.setCustomShape(string2);
        } else {
            System.err.println("EditableStylesheet.addShapeOrPolygonAttributeToStyle:error: syntax error in shape or polygon definition " + string3);
            this.editor.reportError = true;
        }
        if (style.getIcon() != null) {
            System.err.println("Error: Style " + string + " declares both gss:shape and gss:icon properties which are mutually exclusive. The gss:icon property will be ignored.");
            this.editor.reportError = true;
        }
    }

    protected void addIconAttributeToStyle(String string, String string2) {
        Style style = this.createAndGetStyle(string);
        if (style.getShape() == null) {
            if (string2.equals(GraphStylesheet._gssFetch)) {
                try {
                    style.setIcon(new URL(GraphStylesheet._gssFetch));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Error: Style: Malformed URL " + string2);
                    malformedURLException.printStackTrace();
                    this.editor.reportError = true;
                }
            } else {
                URL uRL = Utils.getAbsoluteURL(string2, this.stylesheetURL);
                if (uRL != null) {
                    style.setIcon(uRL);
                } else {
                    System.err.println("Error: Style " + string + " declares a (possibly malformed) URL value for property gss:icon:\n" + string2 + "\nwhich could not be interpreted against the stylesheet document base URL:\n" + this.stylesheetURL);
                    this.editor.reportError = true;
                }
            }
        } else {
            System.err.println("Error: Style " + string + " declares both gss:shape and gss:icon properties which are mutually exclusive. The gss:icon property will be ignored.\n");
            this.editor.reportError = true;
        }
    }

    protected void addTextAlignAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setTextAlignment(string2);
    }

    protected CustomOrdering createAndGetSortOrdering(String string) {
        CustomOrdering customOrdering;
        if (this.orderings.containsKey(string)) {
            customOrdering = (CustomOrdering)this.orderings.get(string);
        } else {
            customOrdering = new CustomOrdering(string);
            this.orderings.put(string, customOrdering);
        }
        return customOrdering;
    }

    protected void addItemToCustomOrdering(String string, String string2, String string3) {
        this.createAndGetSortOrdering(string).addItem(string3, string2);
    }

    protected void buildCustomOrderings() {
        Enumeration enumeration = this.orderings.elements();
        while (enumeration.hasMoreElements()) {
            ((CustomOrdering)enumeration.nextElement()).buildFinalSequence();
        }
    }

    protected void buildSelectors() {
        this.id2rselector = new Hashtable();
        this.id2pselector = new Hashtable();
        this.id2lselector = new Hashtable();
        this.resourceSelectors = new Vector();
        this.literalSelectors = new Vector();
        this.propertySelectors = new Vector();
        Enumeration enumeration = this.selectorTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)this.selectorTypes.get(string);
            if (n.equals(GraphStylesheet.RES_SEL)) {
                this.buildResourceSelector(string);
                continue;
            }
            if (n.equals(GraphStylesheet.LIT_SEL)) {
                this.buildLiteralSelector(string);
                continue;
            }
            this.buildPropertySelector(string);
        }
    }

    protected void buildResourceSelector(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        Vector vector = (Vector)this.sos.get(string);
        Vector vector2 = (Vector)this.oos.get(string);
        Vector<GSSPOStatement> vector3 = null;
        Vector<GSSSPStatement> vector4 = null;
        if (vector != null && vector.size() > 0) {
            vector3 = new Vector<GSSPOStatement>();
            object = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            String string6 = null;
            int n = 0;
            while (n < vector.size()) {
                object = (String)vector.elementAt(n);
                string5 = (String)this.xosObjects.get(object);
                if (string5 != null) {
                    string4 = (String)this.classCnstrnts.get(string5);
                    string3 = (String)this.dtCnstrnts.get(string5);
                    string2 = (String)this.valueCnstrnts.get(string5);
                }
                if ((string6 = (String)this.xosPredicates.get(object)) != null || string4 != null || string3 != null || string2 != null) {
                    if (string3 != null && string4 == null) {
                        vector3.add(new GSSPOStatement(string6, string3, string2, new Boolean(true)));
                    } else if (string4 != null && string3 == null) {
                        vector3.add(new GSSPOStatement(string6, string4, string2, new Boolean(false)));
                    } else if (string4 == null && string3 == null) {
                        vector3.add(new GSSPOStatement(string6, null, string2, null));
                    } else {
                        System.err.println("EditableStylesheet.buildResourceSelector(): Error: resource class and literal datatype constraints on the same resource selector's statement's object cannot coexist :" + string + " " + string4 + " " + string3);
                        this.editor.reportError = true;
                    }
                }
                string5 = null;
                string4 = null;
                string3 = null;
                string2 = null;
                string6 = null;
                ++n;
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            vector4 = new Vector<GSSSPStatement>();
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            int n = 0;
            while (n < vector2.size()) {
                object = (String)vector2.elementAt(n);
                string5 = (String)this.xosSubjects.get(object);
                if (string5 != null) {
                    string4 = (String)this.classCnstrnts.get(string5);
                    string3 = (String)this.valueCnstrnts.get(string5);
                }
                string2 = (String)this.xosPredicates.get(object);
                if (string4 != null || string3 != null || string2 != null) {
                    vector4.add(new GSSSPStatement(string4, string3, string2));
                }
                string5 = null;
                string4 = null;
                string3 = null;
                string2 = null;
                ++n;
            }
        }
        object = new GSSResSelector((String)this.uriEQConstraints.get(string), (String)this.uriSWConstraints.get(string), vector3, vector4);
        this.id2rselector.put(string, object);
        this.resourceSelectors.add(object);
    }

    protected void buildLiteralSelector(String string) {
        Object object;
        GSSSPStatement gSSSPStatement = null;
        Vector vector = (Vector)this.oos.get(string);
        if (vector != null && vector.size() > 0) {
            object = (String)vector.firstElement();
            String string2 = (String)this.xosSubjects.get(object);
            String string3 = null;
            String string4 = null;
            if (string2 != null) {
                string3 = (String)this.classCnstrnts.get(string2);
                string4 = (String)this.valueCnstrnts.get(string2);
            }
            String string5 = (String)this.xosPredicates.get(object);
            if (string3 != null || string4 != null || string5 != null) {
                gSSSPStatement = new GSSSPStatement(string3, string4, string5);
            }
        }
        object = new GSSLitSelector((String)this.dtCnstrnts.get(string), (String)this.valueCnstrnts.get(string), gSSSPStatement);
        this.id2lselector.put(string, object);
        this.literalSelectors.add(object);
    }

    protected void buildPropertySelector(String string) {
        Object object;
        GSSSOStatement gSSSOStatement = null;
        String string2 = (String)this.pos.get(string);
        if (string2 != null) {
            object = (String)this.xosSubjects.get(string2);
            String string3 = null;
            String string4 = null;
            if (object != null) {
                string3 = (String)this.classCnstrnts.get(object);
                string4 = (String)this.valueCnstrnts.get(object);
            }
            String string5 = (String)this.xosObjects.get(string2);
            String string6 = null;
            String string7 = null;
            String string8 = null;
            if (string5 != null) {
                string6 = (String)this.classCnstrnts.get(string5);
                string7 = (String)this.dtCnstrnts.get(string5);
                string8 = (String)this.valueCnstrnts.get(string5);
            }
            if (string3 != null || string6 != null || string7 != null || string8 != null || string4 != null) {
                if (string7 != null && string6 == null) {
                    gSSSOStatement = new GSSSOStatement(string3, string4, string7, string8, new Boolean(true));
                } else if (string6 != null && string7 == null) {
                    gSSSOStatement = new GSSSOStatement(string3, string4, string6, string8, new Boolean(false));
                } else if (string6 == null && string7 == null) {
                    gSSSOStatement = new GSSSOStatement(string3, string4, null, string8, null);
                } else {
                    System.err.println("EditableStylesheet.buildPropertySelector(): Error: resource class and literal datatype constraints on the same property selector's statement's object cannot coexist :" + string + " " + string6 + " " + string7);
                    this.editor.reportError = true;
                }
            }
        }
        object = new GSSPrpSelector((String)this.uriEQConstraints.get(string), (String)this.uriSWConstraints.get(string), gSSSOStatement);
        this.id2pselector.put(string, object);
        this.propertySelectors.add(object);
    }

    protected void buildRules() {
        Object v;
        Object v2;
        Vector vector;
        Object v3;
        Object k;
        Enumeration enumeration = this.id2rselector.keys();
        while (enumeration.hasMoreElements()) {
            Object v4;
            k = enumeration.nextElement();
            v3 = this.id2rselector.get(k);
            if (this.styleStatements.containsKey(k) && (vector = (Vector)this.styleStatements.get(k)) != null && vector.size() > 0) {
                this.rStyleRules.put(v3, vector);
            }
            if (this.visibilityStatements.containsKey(k) && (v2 = this.visibilityStatements.get(k)) != null) {
                this.rVisRules.put(v3, v2);
            }
            if (this.layoutStatements.containsKey(k) && (v = this.layoutStatements.get(k)) != null) {
                this.rLayoutRules.put(v3, v);
            }
            if (!this.sortStatements.containsKey(k) || (v4 = this.sortStatements.get(k)) == null || !v4.equals(GraphStylesheet.SORT_BY_NAMESPACE) && !v4.equals(GraphStylesheet.SORT_BY_NAME) && !v4.equals(GraphStylesheet.SORT_BY_NAME_REV) && !v4.equals(GraphStylesheet.SORT_BY_NAMESPACE_REV) && (!(v4 instanceof String) || !this.orderings.containsKey(v4))) continue;
            this.sortRules.put(v3, v4);
        }
        Enumeration enumeration2 = this.id2lselector.keys();
        while (enumeration2.hasMoreElements()) {
            k = enumeration2.nextElement();
            v3 = this.id2lselector.get(k);
            if (this.styleStatements.containsKey(k) && (vector = (Vector)this.styleStatements.get(k)) != null && vector.size() > 0) {
                this.lStyleRules.put(v3, vector);
            }
            if (this.visibilityStatements.containsKey(k) && (v2 = this.visibilityStatements.get(k)) != null) {
                this.lVisRules.put(v3, v2);
            }
            if (!this.layoutStatements.containsKey(k) || (v = this.layoutStatements.get(k)) == null) continue;
            this.lLayoutRules.put(v3, v);
        }
        Enumeration enumeration3 = this.id2pselector.keys();
        while (enumeration3.hasMoreElements()) {
            k = enumeration3.nextElement();
            v3 = this.id2pselector.get(k);
            if (this.styleStatements.containsKey(k) && (vector = (Vector)this.styleStatements.get(k)) != null && vector.size() > 0) {
                this.pStyleRules.put(v3, vector);
            }
            if (this.visibilityStatements.containsKey(k) && (v2 = this.visibilityStatements.get(k)) != null) {
                this.pVisRules.put(v3, v2);
            }
            if (!this.layoutStatements.containsKey(k) || (v = this.layoutStatements.get(k)) == null) continue;
            this.pLayoutRules.put(v3, v);
        }
    }

    public void error(Exception exception) {
        System.err.println("RDFErrorHandler:Error:GraphStylehseet " + EditableStylesheet.format(exception));
        this.editor.reportError = true;
    }

    public void fatalError(Exception exception) {
        System.err.println("RDFErrorHandler:Fatal Error:GraphStylehseet " + EditableStylesheet.format(exception));
        this.editor.reportError = true;
    }

    public void warning(Exception exception) {
        System.err.println("RDFErrorHandler:Warning:GraphStylehseet " + EditableStylesheet.format(exception));
        this.editor.reportError = true;
    }

    private static String format(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        if (exception instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)exception;
            return string + "[Line = " + sAXParseException.getLineNumber() + ", Column = " + sAXParseException.getColumnNumber() + "]";
        }
        return exception.toString();
    }
}

