/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.IsaViz.DtTracker;

public class DatatypeChooser
extends JDialog
implements ActionListener {
    DtTracker dt;
    TypeMapper tm;
    JButton okBt;
    JButton cancelBt;
    JList types;

    public static RDFDatatype getDatatypeChooser(Frame frame, String string) {
        DtTracker dtTracker = new DtTracker();
        DatatypeChooser datatypeChooser = new DatatypeChooser(dtTracker, frame, string);
        datatypeChooser.addWindowListener(new Closer());
        datatypeChooser.addComponentListener(new DisposeOnClose());
        datatypeChooser.show();
        return dtTracker.getDatatype();
    }

    public static RDFDatatype getDatatypeChooser(Dialog dialog, String string) {
        DtTracker dtTracker = new DtTracker();
        DatatypeChooser datatypeChooser = new DatatypeChooser(dtTracker, dialog, string);
        datatypeChooser.addWindowListener(new Closer());
        datatypeChooser.addComponentListener(new DisposeOnClose());
        datatypeChooser.show();
        return dtTracker.getDatatype();
    }

    DatatypeChooser(DtTracker dtTracker, Frame frame, String string) {
        super(frame, "IsaViz Datatype Chooser", true);
        this.setLocation(frame.getLocation());
        this.dt = dtTracker;
        this.tm = TypeMapper.getInstance();
        this.initUI();
        this.types.setSelectedValue(string, true);
    }

    DatatypeChooser(DtTracker dtTracker, Dialog dialog, String string) {
        super(dialog, "IsaViz Datatype Chooser", true);
        this.setLocation(dialog.getLocation());
        this.dt = dtTracker;
        this.tm = TypeMapper.getInstance();
        this.initUI();
        this.types.setSelectedValue(string, true);
    }

    void initUI() {
        Container container = this.getContentPane();
        try {
            this.okBt.removeActionListener(this);
            this.cancelBt.removeActionListener(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        container.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.types = new JList(this.initTypeList());
        JScrollPane jScrollPane = new JScrollPane(this.types);
        DatatypeChooser.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        container.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        this.okBt = new JButton("OK");
        this.okBt.addActionListener(this);
        jPanel.add(this.okBt);
        this.cancelBt = new JButton("Cancel");
        this.cancelBt.addActionListener(this);
        jPanel.add(this.cancelBt);
        DatatypeChooser.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 10);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        this.pack();
        this.setResizable(false);
    }

    Vector initTypeList() {
        Iterator iterator = this.tm.listTypes();
        Vector<String> vector = new Vector<String>();
        while (iterator.hasNext()) {
            vector.add(((RDFDatatype)iterator.next()).getURI());
        }
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okBt) {
            this.dt.setDatatype(this.getSelectedDatatype());
            this.dispose();
        } else if (object == this.cancelBt) {
            this.dt.setDatatype(null);
            this.dispose();
        }
    }

    RDFDatatype getSelectedDatatype() {
        String string = (String)this.types.getSelectedValue();
        if (string != null) {
            return this.tm.getTypeByName(string);
        }
        return null;
    }

    static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    static class DisposeOnClose
    extends ComponentAdapter {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getComponent();
            window.dispose();
        }
    }

    static class Closer
    extends WindowAdapter {
        Closer() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.hide();
        }
    }
}

