/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangleNR;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRectangleST;
import com.xerox.VTM.svg.SVGWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.UIManager;
import net.claribole.zvtm.fonts.FontDialog;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.EditorEvtHdlr;
import org.w3c.IsaViz.GSSManager;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.MainCmdPanel;
import org.w3c.IsaViz.NavPanel;
import org.w3c.IsaViz.PropsPanel;
import org.w3c.IsaViz.TablePanel;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ConfigManager
implements ComponentListener {
    static Color pastelBlue = new Color(156, 154, 206);
    static Color darkerPastelBlue = new Color(125, 123, 165);
    static String ISV_MANUAL_URI = "http://www.w3.org/2001/11/IsaViz/usermanual.html";
    public static File plugInDir = new File("plugins");
    static Color resourceColorF = new Color(115, 191, 115);
    static Color resourceColorTB = new Color(66, 105, 66);
    static int defaultRFIndex = 0;
    static int defaultRTBIndex = 1;
    static float resFh;
    static float resFs;
    static float resFv;
    static float resTBh;
    static float resTBs;
    static float resTBv;
    static Color propertyColorB;
    static Color propertyColorT;
    static int defaultPBIndex;
    static int defaultPTIndex;
    static float prpBh;
    static float prpBs;
    static float prpBv;
    static float prpTh;
    static float prpTs;
    static float prpTv;
    static Color literalColorF;
    static Color literalColorTB;
    static int defaultLFIndex;
    static int defaultLTBIndex;
    static float litFh;
    static float litFs;
    static float litFv;
    static float litTBh;
    static float litTBs;
    static float litTBv;
    static Color selectionColorF;
    static float selFh;
    static float selFs;
    static float selFv;
    static float selTh;
    static float selTs;
    static float selTv;
    static Color selectionColorTB;
    static Color commentColorF;
    static float comFh;
    static float comFs;
    static float comFv;
    static float comTh;
    static float comTs;
    static float comTv;
    static Color commentColorTB;
    static Color mouseInsideColor;
    static Color bckgColor;
    static Color cursorColor;
    static Color searchColor;
    static float srhTh;
    static float srhTs;
    static float srhTv;
    static Color[] colors;
    static Hashtable strokes;
    static Hashtable dashedStrokes;
    static Hashtable fonts;
    static boolean internalFrames;
    static int cmpX;
    static int cmpY;
    static int cmpW;
    static int cmpH;
    static int mainX;
    static int mainY;
    static int mainW;
    static int mainH;
    static int rdW;
    static int rdH;
    static int prpX;
    static int prpY;
    static int prpW;
    static int prpH;
    static int tabX;
    static int tabY;
    static int tabW;
    static int tabH;
    static int navX;
    static int navY;
    static boolean showEditWindow;
    static boolean showNSWindow;
    static boolean showRadarWindow;
    static boolean showNavWindow;
    static int radarCameraIndex;
    static int ANIM_DURATION;
    static boolean ALLOW_PFX_IN_TXTFIELDS;
    static short DEFAULT_PARSING;
    static short STRICT_PARSING;
    static short LAX_PARSING;
    static short PARSING_MODE;
    static String ENCODING;
    static boolean SHOW_ANON_ID;
    Editor application;
    static Vector lastURLs;
    static int URL_LIMIT;

    static void initLookAndFeel() {
        Enumeration enumeration = UIManager.getLookAndFeelDefaults().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".font") && !string.endsWith("Font")) continue;
            UIManager.put(string, Editor.smallFont);
        }
        UIManager.put("ProgressBar.foreground", pastelBlue);
        UIManager.put("ProgressBar.background", Color.lightGray);
        UIManager.put("Label.foreground", Color.black);
    }

    ConfigManager(Editor editor) {
        this.application = editor;
        strokes = new Hashtable();
        dashedStrokes = new Hashtable();
        strokes.put(new Float(1.0f), new BasicStroke(1.0f, 0, 0, SVGWriter.DEFAULT_MITER_LIMIT));
    }

    void initWindows() {
        RectangleNR rectangleNR;
        RectangleNR rectangleNR2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        cmpX = 0;
        cmpY = 0;
        cmpW = 250;
        cmpH = 240;
        Editor.cmp = new MainCmdPanel(this.application, cmpX, cmpY, cmpW, cmpH);
        mainX = cmpW;
        mainY = 0;
        mainW = dimension.width - cmpW;
        mainH = 600;
        prpX = 0;
        prpY = cmpH;
        prpW = cmpW;
        prpH = mainH - cmpH;
        tabX = 0;
        tabY = mainH;
        tabW = dimension.width;
        tabH = dimension.height - mainH;
        Editor.propsp = new PropsPanel(this.application, prpX, prpY, prpW, prpH);
        if (Utils.osIsWindows()) {
            tabH -= 28;
        }
        Editor.tblp = new TablePanel(this.application, tabX, tabY, tabW, tabH);
        Editor.navp = new NavPanel(this.application, navX, navY);
        Editor.mSpace = Editor.vsm.addVirtualSpace("rdfSpace");
        Editor.vsm.addCamera("rdfSpace");
        Editor.vsm.addCamera("rdfSpace");
        Editor.rSpace = Editor.vsm.addVirtualSpace("radarSpace");
        Editor.vsm.addCamera("radarSpace");
        if (Utils.osIsWindows()) {
            Editor.observedRegion = new VRectangleST(0L, 0L, 0.0f, 10L, 10L, new Color(186, 135, 186));
            Editor.observedRegion.setHSVbColor(0.83519f, 0.28f, 0.45f);
            rectangleNR2 = new RectangleNR(0L, 0L, 0.0f, 0L, 500L, new Color(115, 83, 115));
            rectangleNR = new RectangleNR(0L, 0L, 0.0f, 500L, 0L, new Color(115, 83, 115));
        } else {
            Editor.observedRegion = new VRectangle(0L, 0L, 0.0f, 10L, 10L, Color.red);
            Editor.observedRegion.setHSVbColor(1.0f, 1.0f, 1.0f);
            Editor.observedRegion.setFill(false);
            rectangleNR2 = new RectangleNR(0L, 0L, 0.0f, 0L, 500L, Color.red);
            rectangleNR = new RectangleNR(0L, 0L, 0.0f, 500L, 0L, Color.red);
        }
        Editor.vsm.addGlyph((Glyph)Editor.observedRegion, "radarSpace");
        Editor.vsm.addGlyph((Glyph)rectangleNR2, "radarSpace");
        Editor.vsm.addGlyph((Glyph)rectangleNR, "radarSpace");
        Editor.vsm.stickToGlyph((Glyph)rectangleNR2, (Glyph)Editor.observedRegion);
        Editor.vsm.stickToGlyph((Glyph)rectangleNR, (Glyph)Editor.observedRegion);
        Editor.observedRegion.setSensitivity(false);
        rdW = 300;
        rdH = 200;
        Vector<Camera> vector = new Vector<Camera>();
        vector.add(Editor.vsm.getVirtualSpace("rdfSpace").getCamera(0));
        Editor.vsm.addView(vector, "Graph", mainW, mainH, true, false).setStatusBarFont(Editor.tinySwingFont);
        Editor.mView = Editor.vsm.getView("Graph");
        Editor.mView.setLocation(mainX, mainY);
        this.application.eeh = new EditorEvtHdlr(this.application);
        Editor.mView.setEventHandler((AppEventHandler)this.application.eeh);
        Editor.mView.getFrame().addComponentListener(this);
    }

    void layoutWindows() {
        Editor.cmp.setLocation(cmpX, cmpY);
        Editor.cmp.setSize(cmpW, cmpH);
        Editor.mView.setLocation(mainX, mainY);
        Editor.mView.setSize(mainW, mainH);
        Editor.propsp.setLocation(prpX, prpY);
        Editor.propsp.setSize(prpW, prpH);
        Editor.tblp.setLocation(tabX, tabY);
        Editor.navp.setLocation(navX, navY);
        Editor.tblp.setSize(tabW, tabH);
        Editor.cmp.setVisible(true);
        if (!showEditWindow) {
            Editor.cmp.showPropsMn.setSelected(false);
        } else {
            Editor.propsp.setVisible(true);
        }
        if (!showNSWindow) {
            Editor.cmp.showTablesMn.setSelected(false);
        } else {
            Editor.tblp.setVisible(true);
        }
        if (!showNavWindow) {
            Editor.cmp.showNavMn.setSelected(false);
        } else {
            Editor.navp.setVisible(true);
        }
        Editor.mView.setVisible(true);
    }

    void updateWindowVariables() {
        cmpX = Editor.cmp.getX();
        cmpY = Editor.cmp.getY();
        cmpW = Editor.cmp.getWidth();
        cmpH = Editor.cmp.getHeight();
        mainX = Editor.mView.getFrame().getX();
        mainY = Editor.mView.getFrame().getY();
        mainW = Editor.mView.getFrame().getWidth();
        mainH = Editor.mView.getFrame().getHeight();
        prpX = Editor.propsp.getX();
        prpY = Editor.propsp.getY();
        prpW = Editor.propsp.getWidth();
        prpH = Editor.propsp.getHeight();
        tabX = Editor.tblp.getX();
        tabY = Editor.tblp.getY();
        tabW = Editor.tblp.getWidth();
        tabH = Editor.tblp.getHeight();
        navX = Editor.navp.getX();
        navY = Editor.navp.getY();
    }

    void initConfig() {
        if (Editor.cfgFile.exists()) {
            try {
                Object object;
                Document document = this.application.xmlMngr.parse(Editor.cfgFile, false);
                document.normalize();
                Element element = document.getDocumentElement();
                Element element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "directories").item(0);
                try {
                    object = (Element)element2.getElementsByTagNameNS(Editor.isavizURI, "tmpDir").item(0);
                    Editor.m_TmpDir = new File(object.getFirstChild().getNodeValue());
                    Editor.dltOnExit = new Boolean(object.getAttribute("value"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.projectDir = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "projDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.rdfDir = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "rdfDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.m_GraphVizPath = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "dotExec").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Editor.m_GraphVizFontDir = new File(element2.getElementsByTagNameNS(Editor.isavizURI, "graphvizFontDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "constants").item(0);
                    try {
                        Editor.DEFAULT_BASE_URI = element2.getAttribute("defaultNamespace");
                        if (Utils.isWhiteSpaceCharsOnly(Editor.DEFAULT_BASE_URI)) {
                            Editor.DEFAULT_BASE_URI = "";
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        Editor.ANON_NODE = element2.getAttribute("anonymousNodes");
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS = new Boolean(element2.getAttribute("alwaysIncludeLang"));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        Editor.DEFAULT_LANGUAGE_IN_LITERALS = element2.getAttribute("defaultLang");
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        this.application.setAbbrevSyntax(new Boolean(element2.getAttribute("abbrevSyntax")));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        SHOW_ANON_ID = new Boolean(element2.getAttribute("showAnonIds"));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        Editor.DISP_AS_LABEL = new Boolean(element2.getAttribute("displayLabels"));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        Editor.MAX_LIT_CHAR_COUNT = new Integer(element2.getAttribute("maxLitCharCount"));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        Editor.GRAPH_ORIENTATION = element2.getAttribute("graphOrient");
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        PARSING_MODE = Short.parseShort(element2.getAttribute("parsingMode"));
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        if (element2.hasAttribute("prefixInTf")) {
                            ALLOW_PFX_IN_TXTFIELDS = new Boolean(element2.getAttribute("prefixInTf"));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        ALLOW_PFX_IN_TXTFIELDS = true;
                    }
                    try {
                        this.application.setAntialiasing(new Boolean(element2.getAttribute("antialiasing")));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        object = FontDialog.decode((String)element2.getAttribute("graphFont"));
                        if (object != null) {
                            Editor.vtmFont = object;
                            Editor.vtmFontName = ((Font)object).getFamily();
                            Editor.vtmFontSize = ((Font)object).getSize();
                            GraphStylesheet.DEFAULT_RESOURCE_FONT_FAMILY = Editor.vtmFontName;
                            GraphStylesheet.DEFAULT_LITERAL_FONT_FAMILY = Editor.vtmFontName;
                            GraphStylesheet.DEFAULT_PROPERTY_FONT_FAMILY = Editor.vtmFontName;
                            GraphStylesheet.DEFAULT_RESOURCE_FONT_SIZE = new Integer(Editor.vtmFontSize);
                            GraphStylesheet.DEFAULT_LITERAL_FONT_SIZE = new Integer(Editor.vtmFontSize);
                            GraphStylesheet.DEFAULT_PROPERTY_FONT_SIZE = new Integer(Editor.vtmFontSize);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        object = FontDialog.decode((String)element2.getAttribute("swingFont"));
                        if (object != null) {
                            Editor.swingFont = object;
                            Editor.swingFontName = ((Font)object).getFamily();
                            Editor.swingFontSize = ((Font)object).getSize();
                            Editor.tinySwingFont = ((Font)object).deriveFont(((Font)object).getStyle(), Editor.tinySwingFontSize);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        object = new Color(new Integer(element2.getAttribute("backgroundColor")));
                        if (object != null) {
                            ConfigManager.updateBckgColor((Color)object);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        GSSManager.ALLOW_INCREMENTAL_STYLING = new Boolean(element2.getAttribute("incGSSstyling"));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        Editor.SAVE_WINDOW_LAYOUT = new Boolean(element2.getAttribute("saveWindowLayout"));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (Editor.SAVE_WINDOW_LAYOUT) {
                        try {
                            element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "windows").item(0);
                            cmpX = new Integer(element2.getAttribute("cmpX"));
                            cmpY = new Integer(element2.getAttribute("cmpY"));
                            cmpW = new Integer(element2.getAttribute("cmpW"));
                            cmpH = new Integer(element2.getAttribute("cmpH"));
                            mainX = new Integer(element2.getAttribute("mainX"));
                            mainY = new Integer(element2.getAttribute("mainY"));
                            mainW = new Integer(element2.getAttribute("mainW"));
                            mainH = new Integer(element2.getAttribute("mainH"));
                            prpX = new Integer(element2.getAttribute("prpX"));
                            prpY = new Integer(element2.getAttribute("prpY"));
                            prpW = new Integer(element2.getAttribute("prpW"));
                            prpH = new Integer(element2.getAttribute("prpH"));
                            tabX = new Integer(element2.getAttribute("tabX"));
                            tabY = new Integer(element2.getAttribute("tabY"));
                            tabW = new Integer(element2.getAttribute("tabW"));
                            tabH = new Integer(element2.getAttribute("tabH"));
                            navX = new Integer(element2.getAttribute("navX"));
                            navY = new Integer(element2.getAttribute("navY"));
                            showNSWindow = new Boolean(element2.getAttribute("showNSWindow"));
                            showEditWindow = new Boolean(element2.getAttribute("showEditWindow"));
                            showNavWindow = new Boolean(element2.getAttribute("showNavWindow"));
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "webBrowser").item(0);
                    Editor.autoDetectBrowser = new Boolean(element2.getAttribute("autoDetect"));
                    Editor.browserPath = new File(element2.getAttribute("path"));
                    Editor.browserOptions = element2.getAttribute("options");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "proxy").item(0);
                    ConfigManager.updateProxy(new Boolean(element2.getAttribute("enable")), element2.getAttribute("host"), element2.getAttribute("port"));
                }
                catch (Exception exception) {
                    System.getProperties().put("proxySet", "false");
                }
                lastURLs = new Vector();
                try {
                    object = ((Element)element.getElementsByTagNameNS(Editor.isavizURI, "urls").item(0)).getElementsByTagNameNS(Editor.isavizURI, "li");
                    int n = 0;
                    while (n < object.getLength()) {
                        if (n < URL_LIMIT) {
                            lastURLs.add(object.item(n).getFirstChild().getNodeValue());
                        }
                        ++n;
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Exception exception) {
                this.application.errorMessages.append("Error while loading IsaViz configuration file (isaviz.cfg): " + exception + "\n");
                this.application.reportError = true;
            }
        }
        this.application.resetNamespaceBindings();
        this.application.initRDFMSProperties();
        this.application.initRDFSProperties();
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were errors during initialization ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        ConfigManager.updateSwingFont();
    }

    void saveConfig() {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        Document document = dOMImplementationImpl.createDocument(Editor.isavizURI, "isv:config", null);
        Element element = document.getDocumentElement();
        element.setAttribute("xmlns:isv", Editor.isavizURI);
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:directories");
        element.appendChild(element2);
        Element element3 = document.createElementNS(Editor.isavizURI, "isv:tmpDir");
        element3.appendChild(document.createTextNode(Editor.m_TmpDir.toString()));
        element3.setAttribute("value", String.valueOf(Editor.dltOnExit));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:projDir");
        element3.appendChild(document.createTextNode(Editor.projectDir.toString()));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:rdfDir");
        element3.appendChild(document.createTextNode(Editor.rdfDir.toString()));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:dotExec");
        element3.appendChild(document.createTextNode(Editor.m_GraphVizPath.toString()));
        element2.appendChild(element3);
        element3 = document.createElementNS(Editor.isavizURI, "isv:graphvizFontDir");
        element3.appendChild(document.createTextNode(Editor.m_GraphVizFontDir.toString()));
        element2.appendChild(element3);
        Element element4 = document.createElementNS(Editor.isavizURI, "isv:constants");
        element.appendChild(element4);
        element4.setAttribute("defaultNamespace", Utils.isWhiteSpaceCharsOnly(Editor.DEFAULT_BASE_URI) ? "" : Editor.DEFAULT_BASE_URI);
        element4.setAttribute("anonymousNodes", Editor.ANON_NODE);
        element4.setAttribute("alwaysIncludeLang", String.valueOf(Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS));
        element4.setAttribute("defaultLang", Editor.DEFAULT_LANGUAGE_IN_LITERALS);
        if (Editor.ABBREV_SYNTAX) {
            element4.setAttribute("abbrevSyntax", "true");
        } else {
            element4.setAttribute("abbrevSyntax", "false");
        }
        if (SHOW_ANON_ID) {
            element4.setAttribute("showAnonIds", "true");
        } else {
            element4.setAttribute("showAnonIds", "false");
        }
        if (Editor.DISP_AS_LABEL) {
            element4.setAttribute("displayLabels", "true");
        } else {
            element4.setAttribute("displayLabels", "false");
        }
        if (ALLOW_PFX_IN_TXTFIELDS) {
            element4.setAttribute("prefixInTf", "true");
        } else {
            element4.setAttribute("prefixInTf", "false");
        }
        element4.setAttribute("graphOrient", Editor.GRAPH_ORIENTATION);
        element4.setAttribute("parsingMode", String.valueOf(PARSING_MODE));
        element4.setAttribute("maxLitCharCount", String.valueOf(Editor.MAX_LIT_CHAR_COUNT));
        element4.setAttribute("antialiasing", String.valueOf(Editor.ANTIALIASING));
        element4.setAttribute("graphFont", Utils.encodeFont(Editor.vtmFont));
        element4.setAttribute("swingFont", Utils.encodeFont(Editor.swingFont));
        element4.setAttribute("backgroundColor", Integer.toString(bckgColor.getRGB()));
        element4.setAttribute("saveWindowLayout", String.valueOf(Editor.SAVE_WINDOW_LAYOUT));
        element4.setAttribute("incGSSstyling", String.valueOf(GSSManager.ALLOW_INCREMENTAL_STYLING));
        element4 = document.createElementNS(Editor.isavizURI, "isv:webBrowser");
        element4.setAttribute("autoDetect", String.valueOf(Editor.autoDetectBrowser));
        element4.setAttribute("path", Editor.browserPath.toString());
        element4.setAttribute("options", Editor.browserOptions);
        element.appendChild(element4);
        element4 = document.createElementNS(Editor.isavizURI, "isv:proxy");
        element4.setAttribute("enable", String.valueOf(Editor.useProxy));
        element4.setAttribute("host", Editor.proxyHost);
        element4.setAttribute("port", Editor.proxyPort);
        element.appendChild(element4);
        if (Editor.SAVE_WINDOW_LAYOUT) {
            this.updateWindowVariables();
            element4 = document.createElementNS(Editor.isavizURI, "isv:windows");
            element4.setAttribute("cmpX", String.valueOf(cmpX));
            element4.setAttribute("cmpY", String.valueOf(cmpY));
            element4.setAttribute("cmpW", String.valueOf(cmpW));
            element4.setAttribute("cmpH", String.valueOf(cmpH));
            element4.setAttribute("mainX", String.valueOf(mainX));
            element4.setAttribute("mainY", String.valueOf(mainY));
            element4.setAttribute("mainW", String.valueOf(mainW));
            element4.setAttribute("mainH", String.valueOf(mainH));
            element4.setAttribute("prpX", String.valueOf(prpX));
            element4.setAttribute("prpY", String.valueOf(prpY));
            element4.setAttribute("prpW", String.valueOf(prpW));
            element4.setAttribute("prpH", String.valueOf(prpH));
            element4.setAttribute("tabX", String.valueOf(tabX));
            element4.setAttribute("tabY", String.valueOf(tabY));
            element4.setAttribute("tabW", String.valueOf(tabW));
            element4.setAttribute("tabH", String.valueOf(tabH));
            element4.setAttribute("navX", String.valueOf(navX));
            element4.setAttribute("navY", String.valueOf(navY));
            element4.setAttribute("showNSWindow", String.valueOf(showNSWindow));
            element4.setAttribute("showEditWindow", String.valueOf(showEditWindow));
            element4.setAttribute("showNavWindow", String.valueOf(showNavWindow));
            element.appendChild(element4);
        }
        element4 = document.createElementNS(Editor.isavizURI, "isv:urls");
        element.appendChild(element4);
        if (lastURLs != null) {
            int n = 0;
            while (n < lastURLs.size()) {
                Element element5 = document.createElementNS(Editor.isavizURI, "isv:li");
                element5.appendChild(document.createTextNode((String)lastURLs.elementAt(n)));
                element4.appendChild(element5);
                ++n;
            }
        }
        if (Editor.cfgFile.exists()) {
            Editor.cfgFile.delete();
        }
        this.application.xmlMngr.serialize(document, Editor.cfgFile);
    }

    protected static void assignStrokeToGlyph(float f, String string, Glyph glyph) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                string2 = stringTokenizer.nextToken();
                if (string2.endsWith("px")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                fArray[n++] = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                fArray[n - 1] = 1.0f;
                System.err.println("Style: Error whie parsing a stroke dash array: " + string2 + " is not a positive float value");
            }
        }
        if (fArray.length == 0) {
            fArray = null;
        } else {
            boolean bl = false;
            int n2 = 0;
            while (n2 < fArray.length) {
                if (fArray[n2] != 0.0f) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                fArray = null;
            }
        }
        if (fArray != null) {
            ConfigManager.assignStrokeToGlyph(glyph, f, fArray);
        } else {
            ConfigManager.assignStrokeToGlyph(glyph, f);
        }
    }

    protected static void assignStrokeToGlyph(Glyph glyph, float f) {
        ConfigManager.assignStrokeToGlyph(glyph, f, null);
    }

    protected static void assignStrokeToGlyph(Glyph glyph, float f, float[] fArray) {
        float f2;
        float f3 = f2 = f > 0.0f ? f : 1.0f;
        if (fArray != null) {
            Float f4 = new Float(f2);
            BasicStroke basicStroke = new BasicStroke(f2, 0, 0, SVGWriter.DEFAULT_MITER_LIMIT, fArray, SVGWriter.DEFAULT_DASH_OFFSET);
            if (dashedStrokes.containsKey(f4)) {
                Vector vector = (Vector)dashedStrokes.get(f4);
                if (vector.contains(basicStroke)) {
                    glyph.setStroke((BasicStroke)vector.get(vector.indexOf(basicStroke)));
                } else {
                    glyph.setStroke(basicStroke);
                    vector.add(basicStroke);
                }
            } else {
                glyph.setStroke(basicStroke);
                Vector<BasicStroke> vector = new Vector<BasicStroke>();
                vector.add(basicStroke);
                dashedStrokes.put(f4, vector);
            }
        } else if (f2 == 1.0f) {
            glyph.setStroke(null);
            glyph.setStrokeWidth(f2);
        } else {
            Float f5 = new Float(f2);
            if (strokes.containsKey(f5)) {
                glyph.setStroke((BasicStroke)strokes.get(f5));
            } else {
                BasicStroke basicStroke = new BasicStroke(f2, 0, 0, SVGWriter.DEFAULT_MITER_LIMIT);
                strokes.put(f5, basicStroke);
                glyph.setStroke(basicStroke);
            }
        }
    }

    protected static void makeGlyphStrokeThicker(Glyph glyph, float f) {
        if (glyph.getStroke() != null) {
            float f2 = glyph.getStroke().getLineWidth() + f;
            if (f2 <= 0.0f) {
                f2 = 1.0f;
            }
            ConfigManager.assignStrokeToGlyph(glyph, f2, glyph.getStroke().getDashArray());
        } else {
            float f3 = 1.0f + f;
            if (f3 <= 0.0f) {
                f3 = 1.0f;
            }
            ConfigManager.assignStrokeToGlyph(glyph, f3);
        }
    }

    void addLastURL(String string) {
        boolean bl = false;
        int n = 0;
        while (n < lastURLs.size()) {
            if (((String)lastURLs.elementAt(n)).equals(string)) {
                if (n > 0) {
                    String string2 = (String)lastURLs.firstElement();
                    lastURLs.setElementAt(string, 0);
                    lastURLs.setElementAt(string2, n);
                }
                return;
            }
            ++n;
        }
        lastURLs.insertElementAt(string, 0);
        if (lastURLs.size() > URL_LIMIT) {
            lastURLs.removeElementAt(URL_LIMIT);
        }
    }

    void saveURLs() {
        try {
            Element element;
            Element element2;
            Document document;
            if (Editor.cfgFile.exists()) {
                document = this.application.xmlMngr.parse(Editor.cfgFile, false);
                document.normalize();
                element2 = document.getDocumentElement();
                if (element2.getElementsByTagNameNS(Editor.isavizURI, "urls").getLength() > 0) {
                    element2.removeChild(element2.getElementsByTagNameNS(Editor.isavizURI, "urls").item(0));
                }
                element = document.createElementNS(Editor.isavizURI, "isv:urls");
                if (lastURLs != null) {
                    int n = 0;
                    while (n < lastURLs.size()) {
                        Element element3 = document.createElementNS(Editor.isavizURI, "isv:li");
                        element3.appendChild(document.createTextNode((String)lastURLs.elementAt(n)));
                        element.appendChild(element3);
                        ++n;
                    }
                }
            } else {
                DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
                document = dOMImplementationImpl.createDocument(Editor.isavizURI, "isv:config", null);
                element2 = document.getDocumentElement();
                element = document.createElementNS(Editor.isavizURI, "isv:urls");
                if (lastURLs != null) {
                    int n = 0;
                    while (n < lastURLs.size()) {
                        Element element4 = document.createElementNS(Editor.isavizURI, "isv:li");
                        element4.appendChild(document.createTextNode((String)lastURLs.elementAt(n)));
                        element.appendChild(element4);
                        ++n;
                    }
                }
            }
            element2.appendChild(element);
            this.application.xmlMngr.serialize(document, Editor.cfgFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int addColor(Color color) {
        int n = 0;
        while (n < colors.length) {
            if (colors[n].equals(color)) {
                return n;
            }
            ++n;
        }
        Color[] colorArray = new Color[colors.length + 1];
        System.arraycopy(colors, 0, colorArray, 0, colors.length);
        colorArray[ConfigManager.colors.length] = color;
        colors = colorArray;
        return colors.length - 1;
    }

    void assignColorsToGraph() {
        Glyph glyph;
        VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
        float[] fArray = Color.RGBtoHSB(resourceColorF.getRed(), resourceColorF.getGreen(), resourceColorF.getBlue(), new float[3]);
        resFh = fArray[0];
        resFs = fArray[1];
        resFv = fArray[2];
        fArray = Color.RGBtoHSB(resourceColorTB.getRed(), resourceColorTB.getGreen(), resourceColorTB.getBlue(), new float[3]);
        resTBh = fArray[0];
        resTBs = fArray[1];
        resTBv = fArray[2];
        fArray = Color.RGBtoHSB(propertyColorB.getRed(), propertyColorB.getGreen(), propertyColorB.getBlue(), new float[3]);
        prpBh = fArray[0];
        prpBs = fArray[1];
        prpBv = fArray[2];
        fArray = Color.RGBtoHSB(propertyColorT.getRed(), propertyColorT.getGreen(), propertyColorT.getBlue(), new float[3]);
        prpTh = fArray[0];
        prpTs = fArray[1];
        prpTv = fArray[2];
        fArray = Color.RGBtoHSB(literalColorF.getRed(), literalColorF.getGreen(), literalColorF.getBlue(), new float[3]);
        litFh = fArray[0];
        litFs = fArray[1];
        litFv = fArray[2];
        fArray = Color.RGBtoHSB(literalColorTB.getRed(), literalColorTB.getGreen(), literalColorTB.getBlue(), new float[3]);
        litTBh = fArray[0];
        litTBs = fArray[1];
        litTBv = fArray[2];
        fArray = Color.RGBtoHSB(selectionColorF.getRed(), selectionColorF.getGreen(), selectionColorF.getBlue(), new float[3]);
        selFh = fArray[0];
        selFs = fArray[1];
        selFv = fArray[2];
        fArray = Color.RGBtoHSB(selectionColorTB.getRed(), selectionColorTB.getGreen(), selectionColorTB.getBlue(), new float[3]);
        selTh = fArray[0];
        selTs = fArray[1];
        selTv = fArray[2];
        fArray = Color.RGBtoHSB(commentColorF.getRed(), commentColorF.getGreen(), commentColorF.getBlue(), new float[3]);
        comFh = fArray[0];
        comFs = fArray[1];
        comFv = fArray[2];
        fArray = Color.RGBtoHSB(commentColorTB.getRed(), commentColorTB.getGreen(), commentColorTB.getBlue(), new float[3]);
        comTh = fArray[0];
        comTs = fArray[1];
        comTv = fArray[2];
        fArray = Color.RGBtoHSB(searchColor.getRed(), searchColor.getGreen(), searchColor.getBlue(), new float[3]);
        srhTh = fArray[0];
        srhTs = fArray[1];
        srhTv = fArray[2];
        Vector vector = virtualSpace.getGlyphsOfType("resG");
        int n = 0;
        while (n < vector.size()) {
            glyph = (Glyph)vector.elementAt(n);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selFh, selFs, selFv);
                glyph.setHSVbColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comFh, comFs, comFv);
                glyph.setHSVbColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(resFh, resFs, resFv);
                glyph.setHSVbColor(resTBh, resTBs, resTBv);
            }
            glyph.setMouseInsideColor(mouseInsideColor);
            ++n;
        }
        vector = virtualSpace.getGlyphsOfType("resT");
        int n2 = 0;
        while (n2 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n2);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(resTBh, resTBs, resTBv);
            }
            ++n2;
        }
        vector = virtualSpace.getGlyphsOfType("prdG");
        int n3 = 0;
        while (n3 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n3);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(prpBh, prpBs, prpBv);
            }
            ++n3;
        }
        vector = virtualSpace.getGlyphsOfType("prdH");
        int n4 = 0;
        while (n4 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n4);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(prpBh, prpBs, prpBv);
            }
            ++n4;
        }
        vector = virtualSpace.getGlyphsOfType("prdT");
        int n5 = 0;
        while (n5 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n5);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(prpTh, prpTs, prpTv);
            }
            ++n5;
        }
        vector = virtualSpace.getGlyphsOfType("litG");
        int n6 = 0;
        while (n6 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n6);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selFh, selFs, selFv);
                glyph.setHSVbColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comFh, comFs, comFv);
                glyph.setHSVbColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(litFh, litFs, litFv);
                glyph.setHSVbColor(litTBh, litTBs, litTBv);
            }
            glyph.setMouseInsideColor(mouseInsideColor);
            ++n6;
        }
        vector = virtualSpace.getGlyphsOfType("litT");
        int n7 = 0;
        while (n7 < vector.size()) {
            glyph = (Glyph)vector.elementAt(n7);
            if (((INode)glyph.getOwner()).isSelected()) {
                glyph.setHSVColor(selTh, selTs, selTv);
            } else if (((INode)glyph.getOwner()).isCommented()) {
                glyph.setHSVColor(comTh, comTs, comTv);
            } else {
                glyph.setHSVColor(litTBh, litTBs, litTBv);
            }
            ++n7;
        }
        Editor.vsm.setSelectedGlyphColor(selectionColorTB);
        Editor.vsm.setMouseInsideGlyphColor(mouseInsideColor);
        Editor.vsm.getView("Graph").setBackgroundColor(bckgColor);
        Editor.vsm.getView((String)"Graph").mouse.setColor(cursorColor);
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            IResource iResource = (IResource)enumeration.nextElement();
            iResource.fillIndex = defaultRFIndex;
            iResource.strokeIndex = defaultRTBIndex;
        }
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            ILiteral iLiteral = (ILiteral)enumeration2.nextElement();
            iLiteral.fillIndex = defaultLFIndex;
            iLiteral.strokeIndex = defaultLTBIndex;
        }
        Enumeration enumeration3 = this.application.propertiesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration3.nextElement();
            int n8 = 0;
            while (n8 < vector2.size()) {
                IProperty iProperty = (IProperty)vector2.elementAt(n8);
                iProperty.textIndex = defaultPTIndex;
                iProperty.strokeIndex = defaultPBIndex;
                ++n8;
            }
        }
    }

    static void updateProxy(boolean bl, String string, String string2) {
        Editor.useProxy = bl;
        Editor.proxyHost = string;
        Editor.proxyPort = string2;
        if (Editor.useProxy) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", Editor.proxyHost);
            System.getProperties().put("proxyPort", Editor.proxyPort);
        } else {
            System.getProperties().put("proxySet", "false");
        }
    }

    static void updateBckgColor(Color color) {
        bckgColor = color;
        if (Editor.mView != null) {
            Editor.mView.setBackgroundColor(bckgColor);
            Editor.vsm.repaintNow();
        }
    }

    static void assignFontToGraph(Frame frame) {
        Font font = FontDialog.getFontDialog((Frame)frame, (Font)Editor.vtmFont);
        if (font != null) {
            Editor.vtmFont = font;
            Editor.vtmFontName = font.getFamily();
            Editor.vtmFontSize = font.getSize();
            Editor.vsm.setMainFont(Editor.vtmFont);
            GraphStylesheet.DEFAULT_RESOURCE_FONT_FAMILY = Editor.vtmFontName;
            GraphStylesheet.DEFAULT_LITERAL_FONT_FAMILY = Editor.vtmFontName;
            GraphStylesheet.DEFAULT_PROPERTY_FONT_FAMILY = Editor.vtmFontName;
            GraphStylesheet.DEFAULT_RESOURCE_FONT_SIZE = new Integer(Editor.vtmFontSize);
            GraphStylesheet.DEFAULT_LITERAL_FONT_SIZE = new Integer(Editor.vtmFontSize);
            GraphStylesheet.DEFAULT_PROPERTY_FONT_SIZE = new Integer(Editor.vtmFontSize);
        }
    }

    static void assignFontToSwing(Frame frame) {
        Font font = FontDialog.getFontDialog((Frame)frame, (Font)Editor.swingFont);
        if (font != null) {
            Editor.swingFont = font;
            Editor.swingFontName = font.getFamily();
            Editor.swingFontSize = font.getSize();
            Editor.tinySwingFont = new Font(font.getFamily(), font.getStyle(), Editor.tinySwingFontSize);
            ConfigManager.updateSwingFont();
        }
    }

    static void updateSwingFont() {
        Editor.cmp.updateSwingFont();
        Editor.tblp.updateSwingFont();
        Editor.propsp.updateSwingFont();
        Editor.mView.setStatusBarFont(Editor.swingFont);
    }

    static Font rememberFont(Hashtable hashtable, String string, int n, short s, short s2) {
        if (string.equals(Editor.vtmFontName) && n == Editor.vtmFontSize && Utils.sameFontStyleAs(Editor.vtmFont, s, s2)) {
            return null;
        }
        boolean bl = Utils.isBold(s);
        boolean bl2 = Utils.isItalic(s2);
        Font font = null;
        if (hashtable.containsKey(string)) {
            Vector<Serializable> vector;
            Vector vector2 = (Vector)hashtable.get(string);
            int n2 = 0;
            while (n2 < vector2.size()) {
                vector = (Vector<Serializable>)vector2.elementAt(n2);
                int n3 = (Integer)vector.elementAt(0);
                int n4 = (Integer)vector.elementAt(1);
                int n5 = (Integer)vector.elementAt(2);
                if (bl) {
                    if (bl2) {
                        if (n3 == n && n4 == 1 && n5 == 1) {
                            font = (Font)vector.elementAt(3);
                            break;
                        }
                    } else if (n3 == n && n4 == 1 && n5 == 0) {
                        font = (Font)vector.elementAt(3);
                        break;
                    }
                } else if (bl2) {
                    if (n3 == n && n4 == 0 && n5 == 1) {
                        font = (Font)vector.elementAt(3);
                        break;
                    }
                } else if (n3 == n && n4 == 0 && n5 == 0) {
                    font = (Font)vector.elementAt(3);
                    break;
                }
                ++n2;
            }
            if (font == null) {
                vector = new Vector<Serializable>();
                vector.add(new Integer(n));
                vector.add(new Integer(bl ? 1 : 0));
                vector.add(new Integer(bl2 ? 1 : 0));
                int n6 = 0;
                if (bl) {
                    n6 = bl2 ? 3 : 1;
                } else if (bl2) {
                    n6 = 2;
                }
                font = new Font(string, n6, n);
                vector.add(font);
                vector2.add(vector);
            }
        } else {
            Vector vector = new Vector();
            Vector<Serializable> vector3 = new Vector<Serializable>();
            vector3.add(new Integer(n));
            vector3.add(new Integer(bl ? 1 : 0));
            vector3.add(new Integer(bl2 ? 1 : 0));
            int n7 = 0;
            if (bl) {
                n7 = bl2 ? 3 : 1;
            } else if (bl2) {
                n7 = 2;
            }
            font = new Font(string, n7, n);
            vector3.add(font);
            vector.add(vector3);
            hashtable.put(string, vector);
        }
        return font;
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == Editor.mView.getFrame()) {
            this.application.cameraMoved();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    static {
        propertyColorB = new Color(90, 89, 206);
        propertyColorT = new Color(90, 89, 206);
        defaultPBIndex = 2;
        defaultPTIndex = 3;
        literalColorF = new Color(255, 223, 123);
        literalColorTB = new Color(132, 117, 66);
        defaultLFIndex = 4;
        defaultLTBIndex = 5;
        selectionColorF = new Color(255, 150, 150);
        selectionColorTB = new Color(255, 0, 0);
        commentColorF = new Color(231, 231, 231);
        commentColorTB = new Color(180, 180, 180);
        mouseInsideColor = Color.white;
        bckgColor = new Color(231, 231, 231);
        cursorColor = Color.black;
        searchColor = new Color(255, 0, 0);
        colors = new Color[]{resourceColorF, resourceColorTB, propertyColorB, propertyColorT, literalColorF, literalColorTB};
        fonts = new Hashtable();
        internalFrames = false;
        showEditWindow = true;
        showNSWindow = true;
        showRadarWindow = false;
        showNavWindow = true;
        radarCameraIndex = 1;
        ANIM_DURATION = 300;
        ALLOW_PFX_IN_TXTFIELDS = true;
        DEFAULT_PARSING = 0;
        STRICT_PARSING = 1;
        LAX_PARSING = (short)2;
        PARSING_MODE = DEFAULT_PARSING;
        ENCODING = "UTF-8";
        SHOW_ANON_ID = false;
        URL_LIMIT = 5;
    }
}

