/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.claribole.zvtm.glyphs.GlyphFactory;
import net.claribole.zvtm.glyphs.GlyphPanel;

class VDiamPanel
extends GlyphPanel
implements MouseMotionListener,
MouseListener {
    Polygon p;

    VDiamPanel(GlyphFactory glyphFactory) {
        super(glyphFactory);
        this.xcoords = new int[4];
        this.ycoords = new int[4];
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.xcoords[0] = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle));
        this.xcoords[1] = (int)Math.round((double)this.cx - (double)this.cs * Math.sin(this.vertexAngle));
        this.xcoords[2] = (int)Math.round((double)this.cx - (double)this.cs * Math.cos(this.vertexAngle));
        this.xcoords[3] = (int)Math.round((double)this.cx + (double)this.cs * Math.sin(this.vertexAngle));
        this.ycoords[0] = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle));
        this.ycoords[1] = (int)Math.round((double)this.cy - (double)this.cs * Math.cos(this.vertexAngle));
        this.ycoords[2] = (int)Math.round((double)this.cy + (double)this.cs * Math.sin(this.vertexAngle));
        this.ycoords[3] = (int)Math.round((double)this.cy + (double)this.cs * Math.cos(this.vertexAngle));
        this.p = new Polygon(this.xcoords, this.ycoords, 4);
        if (this.alpha > 0.0) {
            if (this.alpha == 1.0) {
                this.g2d.setColor(this.fColor);
                this.g2d.fillPolygon(this.p);
            } else {
                this.g2d.setColor(this.fColor);
                this.g2d.setComposite(this.acST);
                this.g2d.fillPolygon(this.p);
                this.g2d.setComposite(GlyphPanel.acO);
            }
        }
        this.g2d.setColor(this.bColor);
        this.g2d.drawPolygon(this.p);
        this.g2d.setColor(Color.black);
        if (this.displayIndicators) {
            this.g2d.setStroke(GlyphPanel.dashed);
            this.g2d.drawOval(this.cx - this.cs, this.cy - this.cs, 2 * this.cs, 2 * this.cs);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.orientDrag(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.selectedVertex = this.gf.orientable && GlyphFactory.hasEditableAngle() && this.xorientHandle - 3 <= n && n <= this.xorientHandle + 3 && this.yorientHandle - 3 <= n2 && n2 <= this.yorientHandle + 3 ? -2 : -1;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.selectedVertex = -1;
        this.gf.setVertexVal(-1.0);
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(1));
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

