/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VShape;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;
import net.claribole.zvtm.glyphs.GlyphIcon;

class IcShape
extends GlyphIcon
implements Icon {
    VShape glyph;
    int trS;
    Polygon p;
    int[] xcoords;
    int[] ycoords;
    float vertexAngle;
    float[] vertices;

    IcShape(VShape vShape, int n, int n2) {
        this.glyph = vShape;
        this.width = n;
        this.height = n2;
    }

    public void setGlyph(Glyph glyph) {
        this.glyph = (VShape)glyph;
    }

    public Glyph getGlyph() {
        return this.glyph;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.cWidth = component.getWidth() / 2;
        this.cHeight = component.getHeight() / 2;
        this.computePolygon();
        if (this.glyph.getFillStatus()) {
            graphics.setColor(this.glyph.getColor());
            graphics.fillPolygon(this.p);
        }
        graphics.setColor(this.glyph.getColorb());
        graphics.drawPolygon(this.p);
    }

    protected void computePolygon() {
        this.trS = Math.min(this.width, this.height) / 2 - 2;
        this.vertexAngle = this.glyph.getOrient();
        this.vertices = this.glyph.getVertices();
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        int n = 0;
        while (n < this.vertices.length - 1) {
            this.xcoords[n] = (int)Math.round((double)this.cWidth + (double)this.trS * Math.cos(this.vertexAngle) * (double)this.vertices[n]);
            this.ycoords[n] = (int)Math.round((double)this.cHeight - (double)this.trS * Math.sin(this.vertexAngle) * (double)this.vertices[n]);
            this.vertexAngle = (float)((double)this.vertexAngle + Math.PI * 2 / (double)this.vertices.length);
            ++n;
        }
        this.xcoords[this.vertices.length - 1] = (int)Math.round((double)this.cWidth + (double)this.trS * Math.cos(this.vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.ycoords[this.vertices.length - 1] = (int)Math.round((double)this.cHeight - (double)this.trS * Math.sin(this.vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        this.p = new Polygon(this.xcoords, this.ycoords, this.vertices.length);
    }
}

