/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.svg;

import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class Context {
    String font_family;
    String font_size;
    String font_weight;
    String font_style;
    Color fill;
    Color stroke;
    Float fill_opacity;

    Context(String string) {
        this.processStyleInfo(string);
    }

    void add(String string) {
        this.processStyleInfo(string);
    }

    void processStyleInfo(String string) {
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(SVGReader._fill)) {
                    this.fill = SVGReader.getColor(stringArray[n].substring(SVGReader._fill.length(), stringArray[n].length()));
                } else if (stringArray[n].startsWith(SVGReader._stroke)) {
                    SVGReader.getColor(stringArray[n].substring(SVGReader._stroke.length(), stringArray[n].length()));
                } else if (stringArray[n].startsWith(SVGReader._fillopacity)) {
                    this.fill_opacity = new Float(stringArray[n].substring(SVGReader._fillopacity.length(), stringArray[n].length()));
                } else if (stringArray[n].startsWith(SVGReader._fontfamily)) {
                    this.font_family = stringArray[n].substring(SVGReader._fontfamily.length(), stringArray[n].length());
                } else if (stringArray[n].startsWith(SVGReader._fontsize)) {
                    this.font_size = stringArray[n].substring(SVGReader._fontsize.length(), stringArray[n].length());
                } else if (stringArray[n].startsWith(SVGReader._fontweight)) {
                    this.font_weight = stringArray[n].substring(SVGReader._fontweight.length(), stringArray[n].length());
                } else if (stringArray[n].startsWith(SVGReader._fontstyle)) {
                    this.font_style = stringArray[n].substring(SVGReader._fontstyle.length(), stringArray[n].length());
                }
                ++n;
            }
        }
    }

    public boolean hasTransparencyInformation() {
        return this.fill_opacity != null;
    }

    public Color getFillColor() {
        return this.fill;
    }

    public Color getBorderColor() {
        return this.stroke;
    }

    public float getAlphaTransparencyValue() {
        if (this.fill_opacity != null) {
            return this.fill_opacity.floatValue();
        }
        return 1.0f;
    }

    Font getDefinedFont() {
        if (this.font_family != null || this.font_size != null || this.font_style != null || this.font_weight != null) {
            int n;
            String string = this.font_family != null ? this.font_family : "Default";
            try {
                n = this.font_size != null ? Math.round(new Float(this.font_size).floatValue()) : 10;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Warning: Font size value not supported (using default): " + this.font_size);
                n = 10;
            }
            int n2 = this.font_style != null && this.font_style.equals("italic") ? (this.font_weight != null && this.font_weight.equals("bold") ? 3 : 2) : (this.font_weight != null && this.font_weight.equals("bold") ? 1 : 0);
            return new Font(string, n2, n);
        }
        return null;
    }
}

