/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjTriangle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VTriangle
extends Glyph
implements Cloneable {
    protected static final float halfEdgeFactor = 0.866f;
    protected static final float thirdHeightFactor = 0.5f;
    long vh;
    ProjTriangle[] pc;

    public VTriangle() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.vh = 10L;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VTriangle(long l, long l2, float f, long l3, Color color) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vh = l3;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(color);
        this.setBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjTriangle[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjTriangle();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjTriangle[] projTriangleArray = this.pc;
                this.pc = new ProjTriangle[projTriangleArray.length + 1];
                int n2 = 0;
                while (n2 < projTriangleArray.length) {
                    this.pc[n2] = projTriangleArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjTriangle();
            } else {
                System.err.println("VTriangle:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjTriangle[1];
            this.pc[0] = new ProjTriangle();
        } else {
            System.err.println("VTriangle:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vh;
    }

    public void sizeTo(float f) {
        this.size = f;
        this.vh = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void reSize(float f) {
        this.size *= f;
        this.vh = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public boolean fillsView(long l, long l2, int n) {
        return this.pc[n].p.contains(0, 0) && this.pc[n].p.contains(l, 0.0) && this.pc[n].p.contains(0.0, l2) && this.pc[n].p.contains(l, l2);
    }

    public boolean coordInside(int n, int n2, int n3) {
        return this.pc[n3].p.contains(n, n2);
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].ch = Math.round((float)this.vh * this.coef);
        this.pc[n].halfEdge = Math.round(0.866f * (float)this.pc[n].ch);
        this.pc[n].thirdHeight = Math.round(0.5f * (float)this.pc[n].ch);
        int[] nArray = new int[]{this.pc[n].cx, this.pc[n].cx - this.pc[n].halfEdge, this.pc[n].cx + this.pc[n].halfEdge};
        int[] nArray2 = new int[]{this.pc[n].cy - this.pc[n].ch, this.pc[n].cy + this.pc[n].thirdHeight, this.pc[n].cy + this.pc[n].thirdHeight};
        this.pc[n].p = new Polygon(nArray, nArray2, 3);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].ch) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].ch - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].ch + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].ch) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].ch - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].ch + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].ch > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fillPolygon(this.pc[n3].p);
            }
            graphics2D.setColor(this.borderColor);
            if (this.paintBorder) {
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.drawPolygon(this.pc[n3].p);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.drawPolygon(this.pc[n3].p);
                }
            }
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }

    public Object clone() {
        VTriangle vTriangle = new VTriangle(this.vx, this.vy, 0.0f, this.vh, this.color);
        vTriangle.borderColor = this.borderColor;
        vTriangle.selectedColor = this.selectedColor;
        vTriangle.mouseInsideColor = this.mouseInsideColor;
        vTriangle.bColor = this.bColor;
        return vTriangle;
    }
}

