/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class VShape
extends Glyph
implements Cloneable {
    long vs;
    ProjShape[] pc;
    float[] vertices;
    int[] xcoords;
    int[] ycoords;

    public VShape(float[] fArray) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.vs = 10L;
        this.vertices = fArray;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VShape(long l, long l2, float f, long l3, float[] fArray, Color color, float f2) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vs = l3;
        this.vertices = fArray;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        this.computeSize();
        this.orient = f2;
        this.setColor(color);
        this.setBorderColor(this.bColor);
    }

    public void initCams(int n) {
        this.pc = new ProjShape[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjShape();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjShape[] projShapeArray = this.pc;
                this.pc = new ProjShape[projShapeArray.length + 1];
                int n2 = 0;
                while (n2 < projShapeArray.length) {
                    this.pc[n2] = projShapeArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjShape();
            } else {
                System.err.println("VShape:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjShape[1];
            this.pc[0] = new ProjShape();
        } else {
            System.err.println("VShape:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
        this.orient = f;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vs;
    }

    public void sizeTo(float f) {
        this.size = f;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void reSize(float f) {
        this.size *= f;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public boolean fillsView(long l, long l2, int n) {
        return this.pc[n].p.contains(0, 0) && this.pc[n].p.contains(l, 0.0) && this.pc[n].p.contains(0.0, l2) && this.pc[n].p.contains(l, l2);
    }

    public boolean coordInside(int n, int n2, int n3) {
        return this.pc[n3].p.contains(n, n2);
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public String getVerticesAsText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.vertices.length - 1) {
            stringBuffer.append(this.vertices[n] + ",");
            ++n;
        }
        stringBuffer.append(this.vertices[this.vertices.length - 1]);
        return stringBuffer.toString();
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cs = Math.round((float)this.vs * this.coef);
        float f = this.orient;
        int n2 = 0;
        while (n2 < this.vertices.length - 1) {
            this.xcoords[n2] = (int)Math.round((double)this.pc[n].cx + (double)this.pc[n].cs * Math.cos(f) * (double)this.vertices[n2]);
            this.ycoords[n2] = (int)Math.round((double)this.pc[n].cy - (double)this.pc[n].cs * Math.sin(f) * (double)this.vertices[n2]);
            f = (float)((double)f + Math.PI * 2 / (double)this.vertices.length);
            ++n2;
        }
        this.xcoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[n].cx + (double)this.pc[n].cs * Math.cos(f) * (double)this.vertices[this.vertices.length - 1]);
        this.ycoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[n].cy - (double)this.pc[n].cs * Math.sin(f) * (double)this.vertices[this.vertices.length - 1]);
        this.pc[n].p = new Polygon(this.xcoords, this.ycoords, this.vertices.length);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].cs) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].cs) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cs > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fillPolygon(this.pc[n3].p);
            }
            graphics2D.setColor(this.borderColor);
            if (this.paintBorder) {
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.drawPolygon(this.pc[n3].p);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.drawPolygon(this.pc[n3].p);
                }
            }
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }

    public double getArea() {
        long[] lArray = new long[this.vertices.length];
        long[] lArray2 = new long[this.vertices.length];
        float f = this.orient;
        int n = 0;
        while (n < this.vertices.length - 1) {
            lArray[n] = Math.round((double)this.vx + (double)this.vs * Math.cos(f) * (double)this.vertices[n]);
            lArray2[n] = Math.round((double)this.vy + (double)this.vs * Math.sin(f) * (double)this.vertices[n]);
            f = (float)((double)f + Math.PI * 2 / (double)this.vertices.length);
            ++n;
        }
        lArray[this.vertices.length - 1] = Math.round((double)this.vx + (double)this.vs * Math.cos(f) * (double)this.vertices[this.vertices.length - 1]);
        lArray2[this.vertices.length - 1] = Math.round((double)this.vy + (double)this.vs * Math.sin(f) * (double)this.vertices[this.vertices.length - 1]);
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.vertices.length) {
            int n3 = (n2 + 1) % this.vertices.length;
            d += (double)(lArray[n2] * lArray2[n3] - lArray2[n2] * lArray[n3]);
            ++n2;
        }
        return (d /= 2.0) < 0.0 ? -d : d;
    }

    public Point2D.Double getPreciseCentroid() {
        int n;
        long[] lArray = new long[this.vertices.length];
        long[] lArray2 = new long[this.vertices.length];
        float f = this.orient;
        int n2 = 0;
        while (n2 < this.vertices.length - 1) {
            lArray[n2] = Math.round((double)this.vx + (double)this.vs * Math.cos(f) * (double)this.vertices[n2]);
            lArray2[n2] = Math.round((double)this.vy + (double)this.vs * Math.sin(f) * (double)this.vertices[n2]);
            f = (float)((double)f + Math.PI * 2 / (double)this.vertices.length);
            ++n2;
        }
        lArray[this.vertices.length - 1] = Math.round((double)this.vx + (double)this.vs * Math.cos(f) * (double)this.vertices[this.vertices.length - 1]);
        lArray2[this.vertices.length - 1] = Math.round((double)this.vy + (double)this.vs * Math.sin(f) * (double)this.vertices[this.vertices.length - 1]);
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.vertices.length) {
            n = (n3 + 1) % this.vertices.length;
            d += (double)(lArray[n3] * lArray2[n] - lArray2[n3] * lArray[n]);
            ++n3;
        }
        d /= 2.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        n3 = 0;
        while (n3 < this.vertices.length) {
            n = (n3 + 1) % this.vertices.length;
            d2 = lArray[n3] * lArray2[n] - lArray[n] * lArray2[n3];
            d3 += (double)(lArray[n3] + lArray[n]) * d2;
            d4 += (double)(lArray2[n3] + lArray2[n]) * d2;
            ++n3;
        }
        d2 = 1.0 / (d *= 6.0);
        Point2D.Double double_ = new Point2D.Double(d3 *= d2, d4 *= d2);
        return double_;
    }

    public LongPoint getCentroid() {
        Point2D.Double double_ = this.getPreciseCentroid();
        return new LongPoint(Math.round(double_.getX()), Math.round(double_.getY()));
    }

    public Object clone() {
        VShape vShape = new VShape(this.vx, this.vy, 0.0f, this.vs, (float[])this.vertices.clone(), this.color, this.orient);
        vShape.borderColor = this.borderColor;
        vShape.selectedColor = this.selectedColor;
        vShape.mouseInsideColor = this.mouseInsideColor;
        vShape.bColor = this.bColor;
        return vShape;
    }
}

