/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjRoundRect;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VRoundRect
extends Glyph
implements RectangularShape {
    long vw;
    long vh;
    float ar;
    ProjRoundRect[] pc;
    int arcWidth;
    int arcHeight;

    public VRoundRect() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.vw = 10L;
        this.vh = 10L;
        this.computeSize();
        this.ar = (float)this.vw / (float)this.vh;
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
        this.arcWidth = 10;
        this.arcHeight = 10;
    }

    public VRoundRect(long l, long l2, float f, long l3, long l4, Color color, int n, int n2) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vw = l3;
        this.vh = l4;
        this.computeSize();
        this.ar = this.vw == 0L && this.vh == 0L ? 1.0f : (float)this.vw / (float)this.vh;
        this.orient = 0.0f;
        this.setColor(color);
        this.setBorderColor(Color.black);
        this.arcWidth = n;
        this.arcHeight = n2;
    }

    public void initCams(int n) {
        this.pc = new ProjRoundRect[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjRoundRect();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjRoundRect[] projRoundRectArray = this.pc;
                this.pc = new ProjRoundRect[projRoundRectArray.length + 1];
                int n2 = 0;
                while (n2 < projRoundRectArray.length) {
                    this.pc[n2] = projRoundRectArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjRoundRect();
            } else {
                System.err.println("VRoundRect:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjRoundRect[1];
            this.pc[0] = new ProjRoundRect();
        } else {
            System.err.println("VRoundRect:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return 0.0f;
    }

    public void orientTo(float f) {
    }

    public float getSize() {
        return this.size;
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.vw, 2.0) + Math.pow(this.vh, 2.0));
    }

    public void sizeTo(float f) {
        this.size = f;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setWidth(long l) {
        this.vw = l;
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setHeight(long l) {
        this.vh = l;
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void reSize(float f) {
        this.size *= f;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setArcWidth(int n) {
        this.arcWidth = n >= 0 ? n : 0;
    }

    public void setArcHeight(int n) {
        this.arcHeight = n >= 0 ? n : 0;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public boolean fillsView(long l, long l2, int n) {
        return l <= (long)(this.pc[n].cx + this.pc[n].cw) && 0 >= this.pc[n].cx - this.pc[n].cw && l2 <= (long)(this.pc[n].cy + this.pc[n].ch) && 0 >= this.pc[n].cy - this.pc[n].ch;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return n >= this.pc[n3].cx - this.pc[n3].cw && n <= this.pc[n3].cx + this.pc[n3].cw && n2 >= this.pc[n3].cy - this.pc[n3].ch && n2 <= this.pc[n3].cy + this.pc[n3].ch;
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cw = Math.round((float)this.vw * this.coef);
        this.pc[n].ch = Math.round((float)this.vh * this.coef);
        this.pc[n].aw = Math.round((float)this.arcWidth * this.coef);
        this.pc[n].ah = Math.round((float)this.arcHeight * this.coef);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].cw) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].ch - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].ch + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].cw) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].ch - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].ch + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cw > 1 && this.pc[n3].ch > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fillRoundRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, 2 * this.pc[n3].cw, 2 * this.pc[n3].ch, this.pc[n3].aw, this.pc[n3].ah);
            }
            graphics2D.setColor(this.borderColor);
            if (this.paintBorder) {
                if (this.stroke != null) {
                    if (this.pc[n3].cx - this.pc[n3].cw > 0 || this.pc[n3].cy - this.pc[n3].ch > 0 || 2 * this.pc[n3].cw - 1 < n || 2 * this.pc[n3].ch - 1 < n2) {
                        graphics2D.setStroke(this.stroke);
                        graphics2D.drawRoundRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, 2 * this.pc[n3].cw - 1, 2 * this.pc[n3].ch - 1, this.pc[n3].aw, this.pc[n3].ah);
                        graphics2D.setStroke(stroke);
                    }
                } else {
                    graphics2D.drawRoundRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, 2 * this.pc[n3].cw - 1, 2 * this.pc[n3].ch - 1, this.pc[n3].aw, this.pc[n3].ah);
                }
            }
            this.textDraw(graphics2D, n3);
        } else if (this.pc[n3].cw <= 1 ^ this.pc[n3].ch <= 1) {
            graphics2D.setColor(this.color);
            if (this.pc[n3].cw <= 1) {
                graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy - this.pc[n3].ch, 1, 2 * this.pc[n3].ch);
            } else if (this.pc[n3].ch <= 1) {
                graphics2D.fillRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy, 2 * this.pc[n3].cw, 1);
            }
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }

    public Object clone() {
        VRoundRect vRoundRect = new VRoundRect(this.vx, this.vy, 0.0f, this.vw, this.vh, this.color, this.arcWidth, this.arcHeight);
        vRoundRect.borderColor = this.borderColor;
        vRoundRect.selectedColor = this.selectedColor;
        vRoundRect.mouseInsideColor = this.mouseInsideColor;
        vRoundRect.bColor = this.bColor;
        return vRoundRect;
    }
}

