/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjectedCoords;
import com.xerox.VTM.glyphs.VClippedPath;
import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class VPath
extends Glyph
implements Cloneable {
    AffineTransform at;
    ProjectedCoords[] pc;
    GeneralPath path;
    LongPoint lp;
    public LongPoint realHotSpot;
    float drawingRadius;
    float drawingFactor = 1.2f;
    boolean forcedDrawing = false;

    public static VPath duplicateVPath(VPath vPath, long l, long l2) {
        if (vPath != null) {
            VPath vPath2 = new VPath(0L, 0L, 0.0f, vPath.getColor());
            PathIterator pathIterator = vPath.getJava2DPathIterator();
            double[] dArray = new double[6];
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(dArray);
                switch (n) {
                    case 3: {
                        vPath2.addCbCurve((long)dArray[4] + l, (long)(-dArray[5]) + l2, (long)dArray[0] + l, (long)(-dArray[1]) + l2, (long)dArray[2] + l, (long)(-dArray[3]) + l2, true);
                        break;
                    }
                    case 2: {
                        vPath2.addQdCurve((long)dArray[2] + l, (long)(-dArray[3]) + l2, (long)dArray[0] + l, (long)(-dArray[1]) + l2, true);
                        break;
                    }
                    case 1: {
                        vPath2.addSegment((long)dArray[0] + l, (long)(-dArray[1]) + l2, true);
                        break;
                    }
                    case 0: {
                        vPath2.jump((long)dArray[0] + l, (long)(-dArray[1]) + l2, true);
                    }
                }
                pathIterator.next();
            }
            return vPath2;
        }
        return null;
    }

    public VPath() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.setColor(Color.black);
        this.sensit = false;
        this.resetPath();
    }

    public VPath(long l, long l2, float f, Color color) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.sensit = false;
        this.setColor(color);
        this.path = new GeneralPath();
        this.lp = new LongPoint(this.vx, this.vy);
        this.realHotSpot = new LongPoint(this.vx, this.vy);
        this.path.moveTo(this.vx, -this.vy);
        this.computeSize();
    }

    public VPath(float f, Color color, String string) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = f;
        this.sensit = false;
        this.setColor(color);
        this.setSVGPath(string);
    }

    public void setSVGPath(String string) {
        this.resetPath();
        SVGReader.createPath(string, this);
    }

    public void resetPath() {
        this.path = new GeneralPath();
        this.lp = new LongPoint(0L, 0L);
        this.realHotSpot = new LongPoint(0L, 0L);
        this.path.moveTo(0.0f, 0.0f);
        this.computeSize();
    }

    public void addSegment(long l, long l2, boolean bl) {
        if (bl) {
            this.lp.setLocation(l, l2);
        } else {
            this.lp.translate(l, l2);
        }
        this.path.lineTo(this.lp.x, -this.lp.y);
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void addQdCurve(long l, long l2, long l3, long l4, boolean bl) {
        if (bl) {
            this.path.quadTo(l3, -l4, l, -l2);
            this.lp.setLocation(l, l2);
        } else {
            this.path.quadTo(this.lp.x + l3, -(this.lp.y + l4), this.lp.x + l, -(this.lp.y + l2));
            this.lp.translate(l, l2);
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void addCbCurve(long l, long l2, long l3, long l4, long l5, long l6, boolean bl) {
        if (bl) {
            this.path.curveTo(l3, -l4, l5, -l6, l, -l2);
            this.lp.setLocation(l, l2);
        } else {
            this.path.curveTo(this.lp.x + l3, -(this.lp.y + l4), this.lp.x + l5, -(this.lp.y + l6), this.lp.x + l, -(this.lp.y + l2));
            this.lp.translate(l, l2);
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void jump(long l, long l2, boolean bl) {
        if (bl) {
            this.lp.setLocation(l, l2);
        } else {
            this.lp.translate(l, l2);
        }
        this.path.moveTo(this.lp.x, -this.lp.y);
        if (this.getPathLength() == 1) {
            this.vx = this.lp.x;
            this.vy = this.lp.y;
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    int getPathLength() {
        int n = 0;
        PathIterator pathIterator = this.path.getPathIterator(null);
        while (!pathIterator.isDone()) {
            ++n;
            pathIterator.next();
        }
        return n;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow((this.lp.x - this.vx) / 2L, 2.0) + Math.pow((this.lp.y - this.vy) / 2L, 2.0));
        this.drawingRadius = this.size * this.drawingFactor;
    }

    public void initCams(int n) {
        this.pc = new ProjectedCoords[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjectedCoords();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjectedCoords[] projectedCoordsArray = this.pc;
                this.pc = new ProjectedCoords[projectedCoordsArray.length + 1];
                int n2 = 0;
                while (n2 < projectedCoordsArray.length) {
                    this.pc[n2] = projectedCoordsArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjectedCoords();
            } else {
                System.err.println("VPath:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjectedCoords[1];
            this.pc[0] = new ProjectedCoords();
        } else {
            System.err.println("VPath:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public void sizeTo(float f) {
    }

    public void reSize(float f) {
    }

    public void orientTo(float f) {
    }

    public float getSize() {
        return this.size;
    }

    public float getOrient() {
        return this.orient;
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return false;
    }

    public int mouseInOut(int n, int n2, int n3) {
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(-camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(-camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        graphics2D.setColor(this.color);
        this.at = AffineTransform.getTranslateInstance(this.pc[n3].cx, this.pc[n3].cy);
        this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
        graphics2D.setTransform(this.at);
        if (this.stroke != null) {
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.path);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.draw(this.path);
        }
        graphics2D.setTransform(affineTransform);
    }

    public boolean drawMe(long l, long l2, long l3, long l4, int n) {
        boolean bl = this.forcedDrawing ? true : (this.realHotSpot.x >= l3 && this.realHotSpot.x <= l && this.realHotSpot.y >= l4 && this.realHotSpot.y <= l2 ? true : (float)this.realHotSpot.x - this.drawingRadius <= (float)l && (float)this.realHotSpot.x + this.drawingRadius >= (float)l3 && (float)this.realHotSpot.y - this.drawingRadius <= (float)l2 && (float)this.realHotSpot.y + this.drawingRadius >= (float)l4);
        return bl;
    }

    public void setDrawingFactor(float f) {
        this.drawingFactor = f;
    }

    public void setForcedDrawing(boolean bl) {
        this.forcedDrawing = bl;
    }

    public PathIterator getJava2DPathIterator() {
        return this.path.getPathIterator(null);
    }

    public GeneralPath getJava2DGeneralPath() {
        return this.path;
    }

    public Object clone() {
        VClippedPath vClippedPath = new VClippedPath();
        vClippedPath.borderColor = this.borderColor;
        vClippedPath.selectedColor = this.selectedColor;
        vClippedPath.mouseInsideColor = this.mouseInsideColor;
        vClippedPath.bColor = this.bColor;
        return vClippedPath;
    }
}

