/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.ClippedPathSeg;
import com.xerox.VTM.glyphs.VPath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class VClippedPath
extends VPath
implements Cloneable {
    private ClippedPathSeg[] segs;
    LongPoint firstPoint;
    LongPoint lastPoint;

    private void addSeg(LongPoint longPoint, short s) {
        if (this.firstPoint == null) {
            this.firstPoint = longPoint;
        } else if (this.segs == null) {
            this.segs = new ClippedPathSeg[1];
            this.segs[0] = new ClippedPathSeg((this.firstPoint.x + longPoint.x) / 2L, (this.firstPoint.y + longPoint.y) / 2L, (longPoint.x - this.firstPoint.x) / 2L, -(longPoint.y - this.firstPoint.y) / 2L, s, longPoint.x, -longPoint.y);
            this.lastPoint = longPoint;
        } else {
            ClippedPathSeg[] clippedPathSegArray = new ClippedPathSeg[this.segs.length + 1];
            System.arraycopy(this.segs, 0, clippedPathSegArray, 0, this.segs.length);
            this.segs = clippedPathSegArray;
            this.segs[this.segs.length - 1] = new ClippedPathSeg((this.lastPoint.x + longPoint.x) / 2L, (this.lastPoint.y + longPoint.y) / 2L, (longPoint.x - this.lastPoint.x) / 2L, -(longPoint.y - this.lastPoint.y) / 2L, s, longPoint.x, -longPoint.y);
            this.lastPoint = longPoint;
        }
    }

    public VClippedPath() {
    }

    public VClippedPath(long l, long l2, float f, Color color) {
        super(l, l2, f, color);
    }

    public VClippedPath(float f, Color color, String string) {
        super(f, color, string);
    }

    public void resetPath() {
        super.resetPath();
        this.firstPoint = null;
        this.segs = null;
    }

    public void addSegment(long l, long l2, boolean bl) {
        if (bl) {
            this.lp.setLocation(l, l2);
        } else {
            this.lp.translate(l, l2);
        }
        this.path.lineTo(this.lp.x, -this.lp.y);
        this.addSeg(new LongPoint(this.lp.x, this.lp.y), ClippedPathSeg.SEG_TYPE_SEG);
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void addQdCurve(long l, long l2, long l3, long l4, boolean bl) {
        if (bl) {
            this.path.quadTo(l3, -l4, l, -l2);
            this.addSeg(new LongPoint(l3, l4), ClippedPathSeg.SEG_TYPE_QD1);
            this.addSeg(new LongPoint(l, l2), ClippedPathSeg.SEG_TYPE_QD2);
            this.lp.setLocation(l, l2);
        } else {
            this.path.quadTo(this.lp.x + l3, -(this.lp.y + l4), this.lp.x + l, -(this.lp.y + l2));
            this.addSeg(new LongPoint(this.lp.x + l3, this.lp.y + l4), ClippedPathSeg.SEG_TYPE_QD1);
            this.addSeg(new LongPoint(this.lp.x + l, this.lp.y + l2), ClippedPathSeg.SEG_TYPE_QD2);
            this.lp.translate(l, l2);
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void addCbCurve(long l, long l2, long l3, long l4, long l5, long l6, boolean bl) {
        if (bl) {
            this.path.curveTo(l3, -l4, l5, -l6, l, -l2);
            this.addSeg(new LongPoint(l3, l4), ClippedPathSeg.SEG_TYPE_CB1);
            this.addSeg(new LongPoint(l5, l6), ClippedPathSeg.SEG_TYPE_CB2);
            this.addSeg(new LongPoint(l, l2), ClippedPathSeg.SEG_TYPE_CB3);
            this.lp.setLocation(l, l2);
        } else {
            this.path.curveTo(this.lp.x + l3, -(this.lp.y + l4), this.lp.x + l5, -(this.lp.y + l6), this.lp.x + l, -(this.lp.y + l2));
            this.addSeg(new LongPoint(this.lp.x + l3, this.lp.y + l4), ClippedPathSeg.SEG_TYPE_CB1);
            this.addSeg(new LongPoint(this.lp.x + l5, this.lp.y + l6), ClippedPathSeg.SEG_TYPE_CB2);
            this.addSeg(new LongPoint(this.lp.x + l, this.lp.y + l2), ClippedPathSeg.SEG_TYPE_CB3);
            this.lp.translate(l, l2);
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void jump(long l, long l2, boolean bl) {
        if (bl) {
            this.lp.setLocation(l, l2);
        } else {
            this.lp.translate(l, l2);
        }
        this.path.moveTo(this.lp.x, -this.lp.y);
        this.addSeg(new LongPoint(this.lp.x, this.lp.y), ClippedPathSeg.SEG_TYPE_JMP);
        if (this.getPathLength() == 1) {
            this.vx = this.lp.x;
            this.vy = this.lp.y;
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.visibilityHasChanged()) {
            this.constructVisiblePath();
        }
        graphics2D.setColor(this.color);
        this.at = AffineTransform.getTranslateInstance(this.pc[n3].cx, this.pc[n3].cy);
        this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
        graphics2D.setTransform(this.at);
        if (this.stroke != null) {
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.path);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.draw(this.path);
        }
        graphics2D.setTransform(affineTransform);
    }

    public boolean drawMe(long l, long l2, long l3, long l4, int n) {
        boolean bl = false;
        if (this.forcedDrawing) {
            return true;
        }
        if (this.realHotSpot.x >= l3 && this.realHotSpot.x <= l && this.realHotSpot.y >= l4 && this.realHotSpot.y <= l2 || (float)this.realHotSpot.x - this.drawingRadius <= (float)l && (float)this.realHotSpot.x + this.drawingRadius >= (float)l3 && (float)this.realHotSpot.y - this.drawingRadius <= (float)l2 && (float)this.realHotSpot.y + this.drawingRadius >= (float)l4) {
            try {
                int n2 = 0;
                while (n2 < this.segs.length) {
                    if (this.segs[n2].x >= l3 && this.segs[n2].x <= l && this.segs[n2].y >= l4 && this.segs[n2].y <= l2 || this.segs[n2].x - this.segs[n2].w <= l && this.segs[n2].x + this.segs[n2].w >= l3 && this.segs[n2].y - this.segs[n2].h <= l2 && this.segs[n2].y + this.segs[n2].h >= l4) {
                        this.segs[n2].setVisible(true);
                        bl = true;
                    } else {
                        this.segs[n2].setVisible(false);
                    }
                    ++n2;
                }
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return bl;
    }

    void printVis() {
        System.err.print("[");
        int n = 0;
        while (n < this.segs.length) {
            System.err.print(this.segs[n].visible + ",");
            ++n;
        }
        System.err.print("]");
        System.err.println(this.visibilityHasChanged());
    }

    private boolean visibilityHasChanged() {
        int n = 0;
        while (n < this.segs.length) {
            if (this.segs[n].wasVisible != this.segs[n].visible) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void constructVisiblePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.firstPoint.x, -this.firstPoint.y);
        int n = 0;
        while (n < this.segs.length) {
            if (this.segs[n].type == ClippedPathSeg.SEG_TYPE_CB1) {
                if (this.segs[n].visible || this.segs[n + 1].visible || this.segs[n + 2].visible) {
                    this.path.curveTo(this.segs[n].java2Dx, this.segs[n].java2Dy, this.segs[n + 1].java2Dx, this.segs[n + 1].java2Dy, this.segs[n + 2].java2Dx, this.segs[n + 2].java2Dy);
                }
                n += 3;
                continue;
            }
            if (this.segs[n].type == ClippedPathSeg.SEG_TYPE_QD1) {
                if (this.segs[n].visible || this.segs[n + 1].visible) {
                    this.path.quadTo(this.segs[n].java2Dx, this.segs[n].java2Dy, this.segs[n + 1].java2Dx, this.segs[n + 1].java2Dy);
                }
                n += 2;
                continue;
            }
            if (this.segs[n].type == ClippedPathSeg.SEG_TYPE_SEG) {
                if (this.segs[n].visible) {
                    this.path.lineTo(this.segs[n].java2Dx, this.segs[n].java2Dy);
                }
                ++n;
                continue;
            }
            if (this.segs[n].type == ClippedPathSeg.SEG_TYPE_JMP) {
                if (this.segs[n].visible) {
                    this.path.moveTo(this.segs[n].java2Dx, this.segs[n].java2Dy);
                }
                ++n;
                continue;
            }
            if (this.segs[n].type == ClippedPathSeg.SEG_TYPE_CB2) {
                n += 2;
                continue;
            }
            if (this.segs[n].type == ClippedPathSeg.SEG_TYPE_QD2) {
                ++n;
                continue;
            }
            if (this.segs[n].type != ClippedPathSeg.SEG_TYPE_CB3) continue;
            ++n;
        }
    }

    public Object clone() {
        VClippedPath vClippedPath = new VClippedPath();
        vClippedPath.borderColor = this.borderColor;
        vClippedPath.selectedColor = this.selectedColor;
        vClippedPath.mouseInsideColor = this.mouseInsideColor;
        vClippedPath.bColor = this.bColor;
        return vClippedPath;
    }
}

