/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.BooleanOps;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjBoolean;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class VBoolShape
extends Glyph
implements Cloneable {
    BooleanOps[] booleanShapes;
    long szx;
    long szy;
    int shapeType;
    ProjBoolean[] pc;

    public VBoolShape(long l, long l2, float f, long l3, long l4, int n, BooleanOps[] booleanOpsArray, Color color) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.szx = l3;
        this.szy = l4;
        this.shapeType = n;
        this.booleanShapes = booleanOpsArray;
        this.setColor(color);
        this.setBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjBoolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjBoolean();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjBoolean[] projBooleanArray = this.pc;
                this.pc = new ProjBoolean[projBooleanArray.length + 1];
                int n2 = 0;
                while (n2 < projBooleanArray.length) {
                    this.pc[n2] = projBooleanArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjBoolean();
            } else {
                System.err.println("VBoolShape:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjBoolean[1];
            this.pc[0] = new ProjBoolean();
        } else {
            System.err.println("VBoolShape:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return 0.0f;
    }

    public void orientTo(float f) {
    }

    public void orientToNS(float f) {
    }

    public float getSize() {
        return 0.0f;
    }

    public void sizeTo(float f) {
    }

    public void sizeToNS(float f) {
    }

    public long getWidth() {
        return this.szx;
    }

    public long getHeight() {
        return this.szy;
    }

    public void reSize(float f) {
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return this.pc[n3].mainArea.contains(n, n2);
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        int n2 = 0;
        while (n2 < this.booleanShapes.length) {
            this.booleanShapes[n2].project(this.coef, this.pc[n].cx, this.pc[n].cy);
            ++n2;
        }
        this.pc[n].cszx = (float)this.szx * this.coef;
        this.pc[n].cszy = (float)this.szy * this.coef;
        switch (this.shapeType) {
            case 1: {
                this.pc[n].mainArea = new Area(new Ellipse2D.Float((float)this.pc[n].cx - (float)(this.szx / 2L) * this.coef, (float)this.pc[n].cy - (float)(this.szy / 2L) * this.coef, this.pc[n].cszx, this.pc[n].cszy));
                break;
            }
            case 2: {
                this.pc[n].mainArea = new Area(new Rectangle2D.Float((float)this.pc[n].cx - (float)(this.szx / 2L) * this.coef, (float)this.pc[n].cy - (float)(this.szy / 2L) * this.coef, this.pc[n].cszx, this.pc[n].cszy));
                break;
            }
            default: {
                this.pc[n].mainArea = new Area(new Ellipse2D.Float((float)this.pc[n].cx - (float)(this.szx / 2L) * this.coef, (float)this.pc[n].cy - (float)(this.szy / 2L) * this.coef, this.pc[n].cszx, this.pc[n].cszy));
            }
        }
        int n3 = 0;
        while (n3 < this.booleanShapes.length) {
            switch (this.booleanShapes[n3].opType) {
                case 1: {
                    this.pc[n].mainArea.add(this.booleanShapes[n3].ar);
                    break;
                }
                case 2: {
                    this.pc[n].mainArea.subtract(this.booleanShapes[n3].ar);
                    break;
                }
                case 3: {
                    this.pc[n].mainArea.intersect(this.booleanShapes[n3].ar);
                    break;
                }
                case 4: {
                    this.pc[n].mainArea.exclusiveOr(this.booleanShapes[n3].ar);
                    break;
                }
                default: {
                    System.err.println("Error: VBoolShape: boolean operation not defined");
                }
            }
            ++n3;
        }
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && (float)this.textWidth < 2.0f * this.pc[n].cszx) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy - this.pc[n].cszy - 4.0f);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy + this.pc[n].cszy + (float)this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while ((float)this.textWidth > 2.0f * this.pc[n].cszx) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy - this.pc[n].cszy - 4.0f);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, (float)(this.pc[n].cx - this.textWidth / 2), (float)this.pc[n].cy + this.pc[n].cszy + (float)this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].mainArea.getBounds().width > 2 && this.pc[n3].mainArea.getBounds().height > 2) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fill(this.pc[n3].mainArea);
            }
            graphics2D.setColor(this.borderColor);
            if (this.paintBorder) {
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.draw(this.pc[n3].mainArea);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.draw(this.pc[n3].mainArea);
                }
            }
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }

    public int getMainShapeType() {
        return this.shapeType;
    }

    public BooleanOps[] getOperations() {
        return this.booleanShapes;
    }

    public Object clone() {
        return new VBoolShape(this.vx, this.vy, 0.0f, this.szx, this.szy, this.shapeType, this.booleanShapes, this.color);
    }
}

