/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AccEView;
import com.xerox.VTM.engine.AccIView;
import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.AppletView;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.EView;
import com.xerox.VTM.engine.IView;
import com.xerox.VTM.engine.IViewContainer;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VText;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import net.claribole.zvtm.engine.Location;
import net.claribole.zvtm.glyphs.CGlyph;

public class VirtualSpaceManager
implements AWTEventListener {
    static Font mainFont = new Font("Dialog", 0, 10);
    public static short VIS_AND_SENS_GLYPHS = 0;
    public static short VISIBLE_GLYPHS = 1;
    public static short SENSITIVE_GLYPHS = (short)2;
    public static short ALL_GLYPHS = (short)3;
    boolean debug = false;
    private long nextID;
    private int nextcID;
    private int nextmID;
    protected Hashtable allGlyphs;
    protected Hashtable allCameras;
    protected Hashtable allVirtualSpaces;
    protected Hashtable allViews;
    public View activeView;
    boolean generalRepaintPolicy = true;
    boolean defaultMultiFill = false;
    float textAsLineCoef = 0.5f;
    public boolean mouseSync;
    public AnimManager animator;
    protected int zoomFloor = 0;
    Color selectColor = Color.yellow;
    Color mouseInsideColor = Color.white;
    Object activeJFrame = null;

    public static Font getMainFont() {
        return mainFont;
    }

    public void setMainFont(Font font) {
        mainFont = font;
        Enumeration enumeration = this.allViews.elements();
        while (enumeration.hasMoreElements()) {
            ((View)enumeration.nextElement()).updateFont();
        }
        Enumeration enumeration2 = this.allGlyphs.elements();
        while (enumeration2.hasMoreElements()) {
            Object v = enumeration2.nextElement();
            if (!(v instanceof VText)) continue;
            ((VText)v).invalidate();
        }
        this.repaintNow();
    }

    public VirtualSpaceManager() {
        if (this.debug) {
            System.out.println("Debug mode ON");
        }
        this.nextID = 1L;
        this.nextcID = 1;
        this.nextmID = 1;
        this.allGlyphs = new Hashtable();
        this.allCameras = new Hashtable();
        this.allVirtualSpaces = new Hashtable();
        this.allViews = new Hashtable();
        this.animator = new AnimManager(this);
        this.mouseSync = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    public VirtualSpaceManager(boolean bl) {
        if (this.debug) {
            System.out.println("Debug mode ON");
        }
        this.nextID = 1L;
        this.nextcID = 1;
        this.nextmID = 1;
        this.allGlyphs = new Hashtable();
        this.allCameras = new Hashtable();
        this.allVirtualSpaces = new Hashtable();
        this.allViews = new Hashtable();
        this.animator = new AnimManager(this);
        this.mouseSync = true;
        if (!bl) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debugModeON() {
        return this.debug;
    }

    public void setRepaintPolicy(boolean bl) {
        if (bl != this.generalRepaintPolicy) {
            this.generalRepaintPolicy = bl;
            Enumeration enumeration = this.allViews.elements();
            while (enumeration.hasMoreElements()) {
                ((View)enumeration.nextElement()).setRepaintPolicy(this.generalRepaintPolicy);
            }
        }
    }

    public boolean getRepaintPolicy() {
        return this.generalRepaintPolicy;
    }

    public void setDefaultMultiFills(boolean bl) {
        this.defaultMultiFill = bl;
    }

    public boolean getDefaultMultiFills() {
        return this.defaultMultiFill;
    }

    public void setZoomLimit(int n) {
        this.zoomFloor = n;
    }

    public int getZoomLimit() {
        return this.zoomFloor;
    }

    public void setMouseSync(boolean bl) {
        this.mouseSync = bl;
        this.activeView.mouse.setSync(this.mouseSync);
    }

    public void setSelectedGlyphColor(Color color) {
        this.selectColor = color;
    }

    public void setMouseInsideGlyphColor(Color color) {
        this.mouseInsideColor = color;
    }

    public Glyph addGlyph(Glyph glyph, String string) {
        if (glyph != null) {
            if (this.allVirtualSpaces.containsKey(string)) {
                VirtualSpace virtualSpace = (VirtualSpace)this.allVirtualSpaces.get(string);
                virtualSpace.addGlyph(glyph);
                glyph.setID(new Long(this.nextID++));
                glyph.setVSM(this);
                glyph.setSelectedColor(this.selectColor);
                glyph.setMouseInsideColor(this.mouseInsideColor);
                this.allGlyphs.put(glyph.getID(), glyph);
                this.repaintNow();
                return glyph;
            }
            System.err.println("ZVTM Error:VirtualSpaceManager:addGlyph:unknown virtual space: " + string);
            return null;
        }
        System.err.println("ZVTM Error:VirtualSpaceManager:addGlyph:attempting to add a null Glyph in space: " + string);
        return null;
    }

    public CGlyph addCGlyph(CGlyph cGlyph, String string) {
        if (cGlyph != null) {
            if (this.allVirtualSpaces.containsKey(string)) {
                cGlyph.setID(new Long(this.nextID++));
                cGlyph.setVSM(this);
                this.allGlyphs.put(cGlyph.getID(), cGlyph);
                return cGlyph;
            }
            System.err.println("Error:VirtualSpaceManager:addCGlyph:unknown virtual space: " + string);
            return null;
        }
        System.err.println("Error:VirtualSpaceManager:addCGlyph:attempting to add a null composite glyph in space: " + string);
        return null;
    }

    public Glyph getGlyph(Long l) {
        return (Glyph)this.allGlyphs.get(l);
    }

    public Vector getGlyphsInRegion(long l, long l2, long l3, long l4, String string, int n) {
        Vector<Glyph> vector = new Vector<Glyph>();
        VirtualSpace virtualSpace = this.getVirtualSpace(string);
        long l5 = Math.min(l, l3);
        long l6 = Math.min(l2, l4);
        long l7 = Math.max(l, l3);
        long l8 = Math.max(l2, l4);
        if (virtualSpace != null) {
            Vector vector2 = virtualSpace.getAllGlyphs();
            int n2 = 0;
            while (n2 < vector2.size()) {
                Glyph glyph = (Glyph)vector2.elementAt(n2);
                if (glyph.vx >= l5 && glyph.vy >= l6 && glyph.vx <= l7 && glyph.vy <= l8) {
                    if (n == VIS_AND_SENS_GLYPHS && glyph.isSensitive() && glyph.isVisible()) {
                        vector.add(glyph);
                    } else if (n == VISIBLE_GLYPHS && glyph.isVisible()) {
                        vector.add(glyph);
                    } else if (n == SENSITIVE_GLYPHS && glyph.isSensitive()) {
                        vector.add(glyph);
                    } else if (n == ALL_GLYPHS) {
                        vector.add(glyph);
                    }
                }
                ++n2;
            }
        }
        if (vector.isEmpty()) {
            vector = null;
        }
        return vector;
    }

    public void destroyGlyphsInSpace(String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace(string);
        Vector vector = (Vector)virtualSpace.getAllGlyphs().clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Glyph glyph = (Glyph)enumeration.nextElement();
            virtualSpace.destroyGlyph(glyph);
            this.allGlyphs.remove(glyph);
        }
        this.repaintNow();
    }

    public Camera addCamera(String string) {
        VirtualSpace virtualSpace = (VirtualSpace)this.allVirtualSpaces.get(string);
        Camera camera = virtualSpace.createCamera();
        camera.setID(new Integer(this.nextcID++));
        this.allCameras.put(camera.getID(), camera);
        return camera;
    }

    public Camera addCamera(String string, boolean bl) {
        VirtualSpace virtualSpace = (VirtualSpace)this.allVirtualSpaces.get(string);
        Camera camera = virtualSpace.createCamera();
        camera.setLaziness(bl);
        camera.setID(new Integer(this.nextcID++));
        this.allCameras.put(camera.getID(), camera);
        return camera;
    }

    public Camera getCamera(Integer n) {
        return (Camera)this.allCameras.get(n);
    }

    public Camera getActiveCamera() {
        return this.activeView.getActiveCamera();
    }

    public View addView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2) {
        EView eView = new EView(vector, string, n, n2, bl, bl2, this);
        eView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, eView);
        eView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return eView;
    }

    public View addAccView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2) {
        AccEView accEView = new AccEView(vector, string, n, n2, bl, bl2, this);
        accEView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, accEView);
        accEView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return accEView;
    }

    public View addView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, JMenuBar jMenuBar) {
        EView eView = new EView(vector, string, n, n2, bl, bl2, this, jMenuBar);
        eView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, eView);
        eView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return eView;
    }

    public View addAccView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, JMenuBar jMenuBar) {
        AccEView accEView = new AccEView(vector, string, n, n2, bl, bl2, this, jMenuBar);
        accEView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, accEView);
        accEView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return accEView;
    }

    public EView addExternalView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2) {
        EView eView = new EView(vector, string, n, n2, bl, bl2, this);
        eView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, eView);
        eView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return eView;
    }

    public AccEView addExternalAccView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2) {
        AccEView accEView = new AccEView(vector, string, n, n2, bl, bl2, this);
        accEView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, accEView);
        accEView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return accEView;
    }

    public EView addExternalView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, JMenuBar jMenuBar) {
        EView eView = new EView(vector, string, n, n2, bl, bl2, this, jMenuBar);
        eView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, eView);
        eView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return eView;
    }

    public AccEView addExternalAccView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, JMenuBar jMenuBar) {
        AccEView accEView = new AccEView(vector, string, n, n2, bl, bl2, this, jMenuBar);
        accEView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, accEView);
        accEView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return accEView;
    }

    public IView addInternalView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, IViewContainer iViewContainer, Integer n3) {
        IView iView = new IView(vector, string, n, n2, bl, bl2, this, iViewContainer, n3);
        iView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, iView);
        iView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return iView;
    }

    public AccIView addInternalAccView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, IViewContainer iViewContainer, Integer n3) {
        AccIView accIView = new AccIView(vector, string, n, n2, bl, bl2, this, iViewContainer, n3);
        accIView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, accIView);
        accIView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return accIView;
    }

    public IView addInternalView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, JMenuBar jMenuBar, IViewContainer iViewContainer, Integer n3) {
        IView iView = new IView(vector, string, n, n2, bl, bl2, this, iViewContainer, jMenuBar, n3);
        iView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, iView);
        iView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return iView;
    }

    public AccIView addInternalAccView(Vector vector, String string, int n, int n2, boolean bl, boolean bl2, JMenuBar jMenuBar, IViewContainer iViewContainer, Integer n3) {
        AccIView accIView = new AccIView(vector, string, n, n2, bl, bl2, this, iViewContainer, jMenuBar, n3);
        accIView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, accIView);
        accIView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return accIView;
    }

    public IViewContainer createIViewContainer(String string, int n, int n2) {
        IViewContainer iViewContainer = n == 0 && n2 == 0 ? new IViewContainer(string) : new IViewContainer(string, n, n2);
        return iViewContainer;
    }

    public JPanel addAppletView(Vector vector, String string, int n, int n2) {
        AppletView appletView = new AppletView(vector, string, n, n2, this);
        appletView.mouse.setID(new Long(this.nextmID++));
        this.allViews.put(string, appletView);
        appletView.setRepaintPolicy(this.generalRepaintPolicy);
        if (!this.animator.started) {
            this.animator.start();
        }
        return appletView.panel;
    }

    public View getView(String string) {
        return (View)this.allViews.get(string);
    }

    protected void destroyView(String string) {
        this.allViews.remove(string);
        if (this.allViews.isEmpty()) {
            this.animator.stop();
        }
    }

    public void repaintNow() {
        Enumeration enumeration = this.allViews.elements();
        while (enumeration.hasMoreElements()) {
            ((View)enumeration.nextElement()).repaintNow();
        }
    }

    public VirtualSpace addVirtualSpace(String string) {
        VirtualSpace virtualSpace = new VirtualSpace(string);
        virtualSpace.setManager(this);
        this.allVirtualSpaces.put(string, virtualSpace);
        return virtualSpace;
    }

    public void destroyVirtualSpace(String string) {
        if (this.allVirtualSpaces.containsKey(string)) {
            VirtualSpace virtualSpace = (VirtualSpace)this.allVirtualSpaces.get(string);
            virtualSpace.destroy();
            this.allVirtualSpaces.remove(string);
        }
    }

    public VirtualSpace getVirtualSpace(String string) {
        return (VirtualSpace)this.allVirtualSpaces.get(string);
    }

    public VirtualSpace getActiveSpace() {
        return this.activeView.getActiveCamera().getOwningSpace();
    }

    public void setActiveView(View view) {
        this.activeView = view;
    }

    public View getActiveView() {
        return this.activeView;
    }

    public void stickToMouse(Long l) {
        this.stickToMouse(this.getGlyph(l));
    }

    public void stickToMouse(Glyph glyph) {
        this.activeView.mouse.stick(glyph);
    }

    public void unstickFromMouse() {
        this.activeView.mouse.unstick();
    }

    public void stickToGlyph(Long l, Long l2) {
        this.stickToGlyph(this.getGlyph(l), this.getGlyph(l2));
    }

    public void stickToGlyph(Glyph glyph, Glyph glyph2) {
        glyph2.stick(glyph);
    }

    public void unstickFromGlyph(Long l, Long l2) {
        this.getGlyph(l2).unstick(this.getGlyph(l));
    }

    public void unstickFromGlyph(Glyph glyph, Glyph glyph2) {
        glyph2.unstick(glyph);
    }

    public void unstickAllGlyphs(Glyph glyph) {
        Vector vector = glyph.getStickedGlyphs();
        int n = vector.size() - 1;
        while (n >= 0) {
            glyph.unstick((Glyph)vector.elementAt(n));
            --n;
        }
    }

    public Location getGlobalView(Camera camera, int n) {
        View view = null;
        try {
            view = camera.getOwningView();
            if (view != null) {
                float f;
                long[] lArray = VirtualSpaceManager.findFarmostGlyphCoords(camera.parentSpace);
                long l = (lArray[2] + lArray[0]) / 2L;
                long l2 = (lArray[1] + lArray[3]) / 2L;
                long[] lArray2 = view.getVisibleRegion(camera);
                long[] lArray3 = new long[]{lArray2[0] + l - camera.posx, lArray2[3] + l2 - camera.posy};
                float f2 = camera.getAltitude() + camera.getFocal();
                float f3 = 0.0f;
                if (lArray3[0] != 0L) {
                    f3 = (float)(l - lArray[0]) / (float)(l - lArray3[0]);
                }
                if (lArray3[1] != 0L && (f = (float)(l2 - lArray[3]) / (float)(l2 - lArray3[1])) > f3) {
                    f3 = f;
                }
                f = f2 * Math.abs(f3);
                float f4 = f - f2;
                Vector<Object> vector = new Vector<Object>();
                vector.add(new Float(f4));
                vector.add(new LongPoint(l - camera.posx, l2 - camera.posy));
                this.animator.createCameraAnimation(n, AnimManager.CA_ALT_TRANS_SIG, vector, camera.getID());
                return new Location(l, l2, f);
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Error:VirtualSpaceManager:getGlobalView: ");
            System.err.println("Camera c=" + camera);
            System.err.println("View v=" + view);
            if (this.debug) {
                nullPointerException.printStackTrace();
            } else {
                System.err.println(nullPointerException);
            }
            return null;
        }
    }

    public static long[] findFarmostGlyphCoords(VirtualSpace virtualSpace) {
        if (virtualSpace != null) {
            long[] lArray = new long[4];
            Vector vector = virtualSpace.getVisibleGlyphs();
            if (!vector.isEmpty()) {
                Glyph glyph = (Glyph)vector.firstElement();
                long l = (long)glyph.getSize();
                lArray[0] = glyph.vx - l;
                lArray[1] = glyph.vy + l;
                lArray[2] = glyph.vx + l;
                lArray[3] = glyph.vy - l;
                int n = 1;
                while (n < vector.size()) {
                    glyph = (Glyph)vector.elementAt(n);
                    l = (long)glyph.getSize();
                    long l2 = glyph.vx - l;
                    if (l2 < lArray[0]) {
                        lArray[0] = l2;
                    }
                    if ((l2 = glyph.vy + l) > lArray[1]) {
                        lArray[1] = l2;
                    }
                    if ((l2 = glyph.vx + l) > lArray[2]) {
                        lArray[2] = l2;
                    }
                    if ((l2 = glyph.vy - l) < lArray[3]) {
                        lArray[3] = l2;
                    }
                    ++n;
                }
                return lArray;
            }
            lArray[0] = 0L;
            lArray[1] = 0L;
            lArray[2] = 0L;
            lArray[3] = 0L;
            return lArray;
        }
        return null;
    }

    public Location centerOnGlyph(Glyph glyph, Camera camera, int n) {
        View view = null;
        try {
            view = camera.getOwningView();
            if (view != null) {
                float f;
                long l;
                long l2;
                Object object;
                Object object2;
                if (glyph instanceof VText) {
                    object2 = (VText)glyph;
                    object = ((VText)object2).getBounds(camera.getIndex());
                    if (((VText)object2).getTextAnchor() == VText.TEXT_ANCHOR_START) {
                        l2 = glyph.vx + ((LongPoint)object).x / 2L - camera.posx;
                        l = glyph.vy + ((LongPoint)object).y / 2L - camera.posy;
                    } else if (((VText)object2).getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
                        l2 = glyph.vx - camera.posx;
                        l = glyph.vy - camera.posy;
                    } else {
                        l2 = glyph.vx - ((LongPoint)object).x / 2L - camera.posx;
                        l = glyph.vy - ((LongPoint)object).y / 2L - camera.posy;
                    }
                } else if (glyph instanceof VPath) {
                    object2 = (VPath)glyph;
                    l2 = ((VPath)object2).realHotSpot.x - camera.posx;
                    l = ((VPath)object2).realHotSpot.y - camera.posy;
                } else {
                    l2 = glyph.vx - camera.posx;
                    l = glyph.vy - camera.posy;
                }
                object2 = view.getVisibleRegion(camera);
                object = new long[]{(long)(object2[0] + l2), (long)(object2[3] + l)};
                float f2 = camera.getAltitude() + camera.getFocal();
                float f3 = 0.0f;
                if (object[0] != 0L) {
                    f3 = glyph.getSize() / (float)(glyph.vx - object[0]);
                }
                if (object[1] != 0L && (f = glyph.getSize() / (float)(glyph.vy - object[1])) > f3) {
                    f3 = f;
                }
                f = f2 * Math.abs(f3);
                float f4 = f - f2;
                Vector<Object> vector = new Vector<Object>();
                vector.add(new Float(f4));
                vector.add(new LongPoint(l2, l));
                this.animator.createCameraAnimation(n, AnimManager.CA_ALT_TRANS_SIG, vector, camera.getID());
                return new Location(glyph.vx, glyph.vy, f);
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Error:VirtualSpaceManager:centerOnGlyph: ");
            System.err.println("Glyph g=" + glyph);
            System.err.println("Camera c=" + camera);
            System.err.println("View v=" + view);
            if (this.debug) {
                nullPointerException.printStackTrace();
            } else {
                System.err.println(nullPointerException);
            }
            return null;
        }
    }

    public Location centerOnRegion(Camera camera, int n, long l, long l2, long l3, long l4) {
        View view = null;
        try {
            view = camera.getOwningView();
            if (view != null) {
                float f;
                long[] lArray = new long[]{l, l2, l3, l4};
                long l5 = (lArray[2] + lArray[0]) / 2L;
                long l6 = (lArray[1] + lArray[3]) / 2L;
                long[] lArray2 = view.getVisibleRegion(camera);
                long[] lArray3 = new long[]{lArray2[0] + l5 - camera.posx, lArray2[3] + l6 - camera.posy};
                float f2 = camera.getAltitude() + camera.getFocal();
                float f3 = 0.0f;
                if (lArray3[0] != 0L) {
                    f3 = (float)(l5 - lArray[0]) / (float)(l5 - lArray3[0]);
                }
                if (lArray3[1] != 0L && (f = (float)(l6 - lArray[3]) / (float)(l6 - lArray3[1])) > f3) {
                    f3 = f;
                }
                f = f2 * Math.abs(f3);
                float f4 = f - f2;
                Vector<Object> vector = new Vector<Object>();
                vector.add(new Float(f4));
                vector.add(new LongPoint(l5 - camera.posx, l6 - camera.posy));
                this.animator.createCameraAnimation(n, AnimManager.CA_ALT_TRANS_SIG, vector, camera.getID());
                return new Location(l5, l6, f);
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Error:VirtualSpaceManager:centerOnRegion: ");
            System.err.println("Camera c=" + camera);
            System.err.println("View v=" + view);
            if (this.debug) {
                nullPointerException.printStackTrace();
            } else {
                System.err.println(nullPointerException);
            }
            return null;
        }
    }

    public void setTextDisplayedAsSegCoef(float f) {
        this.textAsLineCoef = f;
    }

    public float getTextDisplayedAsSegCoef() {
        return this.textAsLineCoef;
    }

    public void removeGlyphFromUnderMouseLists(Glyph glyph) {
        VirtualSpace virtualSpace = null;
        try {
            Enumeration enumeration = this.allVirtualSpaces.elements();
            while (enumeration.hasMoreElements()) {
                virtualSpace = (VirtualSpace)enumeration.nextElement();
                if (virtualSpace.getAllGlyphs().contains(glyph)) break;
            }
            Enumeration enumeration2 = virtualSpace.getCameraList().elements();
            while (enumeration2.hasMoreElements()) {
                ((Camera)enumeration2.nextElement()).getOwningView().mouse.removeGlyphFromList(glyph);
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 205) {
            this.activeJFrame = aWTEvent.getSource();
        }
    }
}

