/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.CameraManager;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.util.Enumeration;
import java.util.Vector;

public class VirtualSpace {
    public String spaceName;
    VirtualSpaceManager vsm;
    CameraManager cm = new CameraManager(this);
    Vector visualEnts = new Vector();
    Vector drawingList;
    Vector[] camera2drawnList = new Vector[0];

    public static LongPoint getGlyphSetGeometricalCenter(Glyph[] glyphArray) {
        if (glyphArray != null && glyphArray.length > 0) {
            long[] lArray = new long[4];
            long l = (long)glyphArray[0].getSize();
            lArray[0] = glyphArray[0].vx - l;
            lArray[1] = glyphArray[0].vy + l;
            lArray[2] = glyphArray[0].vx + l;
            lArray[3] = glyphArray[0].vy - l;
            int n = 1;
            while (n < glyphArray.length) {
                l = (long)glyphArray[n].getSize();
                long l2 = glyphArray[n].vx - l;
                if (l2 < lArray[0]) {
                    lArray[0] = l2;
                }
                if ((l2 = glyphArray[n].vy + l) > lArray[1]) {
                    lArray[1] = l2;
                }
                if ((l2 = glyphArray[n].vx + l) > lArray[2]) {
                    lArray[2] = l2;
                }
                if ((l2 = glyphArray[n].vy - l) < lArray[3]) {
                    lArray[3] = l2;
                }
                ++n;
            }
            return new LongPoint((lArray[2] + lArray[0]) / 2L, (lArray[1] + lArray[3]) / 2L);
        }
        return new LongPoint(0L, 0L);
    }

    VirtualSpace(String string) {
        this.drawingList = new Vector();
        this.spaceName = string;
    }

    public String getName() {
        return this.spaceName;
    }

    public Camera getCamera(int n) {
        return this.cm.getCamera(n);
    }

    public Vector getCameraList() {
        Vector<Camera> vector = new Vector<Camera>();
        int n = 0;
        while (n < this.cm.cameraList.length) {
            vector.add(this.cm.cameraList[n]);
            ++n;
        }
        return vector;
    }

    public Camera[] getCameraListAsArray() {
        return this.cm.cameraList;
    }

    Camera createCamera() {
        Camera camera = this.cm.addCamera();
        Vector[] vectorArray = new Vector[this.camera2drawnList.length + 1];
        System.arraycopy(this.camera2drawnList, 0, vectorArray, 0, this.camera2drawnList.length);
        vectorArray[this.camera2drawnList.length] = new Vector();
        this.camera2drawnList = vectorArray;
        camera.setOwningSpace(this);
        Enumeration enumeration = this.visualEnts.elements();
        while (enumeration.hasMoreElements()) {
            Glyph glyph = (Glyph)enumeration.nextElement();
            glyph.addCamera(camera.getIndex());
        }
        return camera;
    }

    public void removeCamera(int n) {
        if (this.cm.cameraList.length > n) {
            Object object;
            Enumeration enumeration = this.vsm.allViews.elements();
            while (enumeration.hasMoreElements()) {
                object = (View)enumeration.nextElement();
                if (!((View)object).cameras.contains(this.cm.getCamera(n))) continue;
                ((View)object).destroyCamera(this.cm.getCamera(n));
            }
            object = this.visualEnts.elements();
            while (object.hasMoreElements()) {
                Glyph glyph = (Glyph)object.nextElement();
                glyph.removeCamera(n);
            }
            this.cm.removeCamera(n);
            this.camera2drawnList[n] = null;
        }
    }

    protected void destroy() {
        int n = 0;
        while (n < this.cm.cameraList.length) {
            this.removeCamera(n);
            ++n;
        }
        Enumeration enumeration = this.visualEnts.elements();
        while (enumeration.hasMoreElements()) {
            this.destroyGlyph((Glyph)enumeration.nextElement());
        }
    }

    void addGlyph(Glyph glyph) {
        glyph.initCams(this.cm.cameraList.length);
        this.visualEnts.add(glyph);
        this.drawingList.add(glyph);
    }

    public Vector getAllGlyphs() {
        return this.visualEnts;
    }

    public Vector getVisibleGlyphs() {
        return this.drawingList;
    }

    public Vector getDrawnGlyphs() {
        if (this.camera2drawnList.length > 0) {
            return this.camera2drawnList[0];
        }
        return null;
    }

    public Vector getDrawnGlyphs(int n) {
        if (n < this.camera2drawnList.length) {
            return this.camera2drawnList[n];
        }
        return null;
    }

    protected void drewGlyph(Glyph glyph, int n) {
        if (n < this.camera2drawnList.length && this.camera2drawnList[n] != null) {
            this.camera2drawnList[n].add(glyph);
        }
    }

    public Vector getSelectedGlyphs() {
        Vector<Glyph> vector = new Vector<Glyph>();
        Enumeration enumeration = this.visualEnts.elements();
        while (enumeration.hasMoreElements()) {
            Glyph glyph = (Glyph)enumeration.nextElement();
            if (!glyph.isSelected()) continue;
            vector.add(glyph);
        }
        return vector;
    }

    public void selectAllGlyphs() {
        Enumeration enumeration = this.visualEnts.elements();
        while (enumeration.hasMoreElements()) {
            ((Glyph)enumeration.nextElement()).select(true);
        }
    }

    public void unselectAllGlyphs() {
        Enumeration enumeration = this.visualEnts.elements();
        while (enumeration.hasMoreElements()) {
            ((Glyph)enumeration.nextElement()).select(false);
        }
    }

    public Vector getGlyphsOfType(String string) {
        Vector<Glyph> vector = new Vector<Glyph>();
        Enumeration enumeration = this.visualEnts.elements();
        while (enumeration.hasMoreElements()) {
            Glyph glyph = (Glyph)enumeration.nextElement();
            if (!string.equals("") && !glyph.getType().equals(string)) continue;
            vector.add(glyph);
        }
        return vector;
    }

    public void destroyGlyph(Glyph glyph) {
        try {
            if (glyph.stickedTo != null) {
                if (glyph.stickedTo instanceof Glyph) {
                    ((Glyph)glyph.stickedTo).unstick(glyph);
                } else {
                    ((VCursor)glyph.stickedTo).unstickSpecificGlyph(glyph);
                }
            }
            if (glyph.getCGlyph() != null) {
                glyph.getCGlyph().removeSecondaryGlyph(glyph);
            }
            int n = 0;
            while (n < this.camera2drawnList.length) {
                if (this.camera2drawnList[n] != null) {
                    this.camera2drawnList[n].remove(glyph);
                }
                ++n;
            }
            Enumeration enumeration = this.vsm.allViews.elements();
            while (enumeration.hasMoreElements()) {
                View view = (View)enumeration.nextElement();
                view.mouse.removeGlyphFromList(glyph);
            }
            this.visualEnts.remove(glyph);
            this.drawingList.remove(glyph);
            this.vsm.allGlyphs.remove(glyph);
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("ZVTM Error: VirtualSpace.destroyGlyph(): the glyph you are trying to delete might not be a member of this virtual space (" + this.spaceName + ") or might be null");
            nullPointerException.printStackTrace();
        }
    }

    public void show(Glyph glyph) {
        if (this.visualEnts.contains(glyph) && !this.drawingList.contains(glyph)) {
            this.drawingList.add(glyph);
        }
        this.vsm.repaintNow();
    }

    public void hide(Glyph glyph) {
        boolean bl = this.drawingList.removeElement(glyph);
        this.vsm.repaintNow();
    }

    public void onTop(Glyph glyph) {
        if (this.drawingList.contains(glyph)) {
            this.drawingList.removeElement(glyph);
            this.drawingList.add(glyph);
        }
    }

    public void atBottom(Glyph glyph) {
        if (this.drawingList.contains(glyph)) {
            this.drawingList.removeElement(glyph);
            this.drawingList.insertElementAt(glyph, 0);
        }
    }

    public void above(Glyph glyph, Glyph glyph2) {
        if (this.drawingList.contains(glyph) && this.drawingList.contains(glyph2)) {
            this.drawingList.remove(glyph);
            int n = this.drawingList.indexOf(glyph2);
            this.drawingList.insertElementAt(glyph, n + 1);
        }
    }

    public void below(Glyph glyph, Glyph glyph2) {
        if (this.drawingList.contains(glyph) && this.drawingList.contains(glyph2)) {
            this.drawingList.remove(glyph);
            int n = this.drawingList.indexOf(glyph2);
            this.drawingList.insertElementAt(glyph, n);
        }
    }

    void setManager(VirtualSpaceManager virtualSpaceManager) {
        this.vsm = virtualSpaceManager;
    }
}

