/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class AppletViewPanel
extends ViewPanel
implements Runnable {
    BufferedImage buffImg;

    protected BufferedImage getImage() {
        return this.buffImg;
    }

    public AppletViewPanel(Vector vector, View view) {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (AppletViewPanel.this.isShowing()) {
                    AppletViewPanel.this.start();
                } else {
                    AppletViewPanel.this.stop();
                }
            }
        });
        this.parent = view;
        this.cams = new Camera[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.cams[n] = (Camera)vector.get(n);
            ++n;
        }
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.start();
        this.setAWTCursor(-1);
        if (this.parent.parent.debug) {
            System.out.println("View refresh time set to " + this.frameTime + "ms");
        }
    }

    public void start() {
        Dimension dimension = this.getSize();
        this.runView = new Thread(this);
        this.runView.setPriority(5);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.getSize().width <= 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep " + interruptedException);
                }
                return;
            }
        }
        Graphics graphics = null;
        Graphics graphics2 = null;
        Dimension dimension = this.getSize();
        while (this.runView == thread) {
            Serializable serializable;
            if (this.notBlank) {
                if (this.active) {
                    if (this.repaintNow) {
                        block89: {
                            try {
                                this.repaintNow = false;
                                this.updateMouseOnly = false;
                                this.d1 = System.currentTimeMillis();
                                serializable = this.getSize();
                                if (serializable.width != dimension.width || serializable.height != dimension.height) {
                                    this.buffImg = null;
                                    if (graphics2 != null) {
                                        graphics2.dispose();
                                        graphics2 = null;
                                    }
                                    if (this.parent.parent.debug) {
                                        System.out.println("Resizing JPanel: (" + dimension.width + "x" + dimension.height + ") -> (" + serializable.width + "x" + serializable.height + ")");
                                    }
                                    dimension = serializable;
                                    this.updateAntialias = true;
                                    this.updateFont = true;
                                }
                                if (this.buffImg == null) {
                                    this.buffImg = (BufferedImage)this.createImage(serializable.width, serializable.height);
                                    this.updateAntialias = true;
                                    this.updateFont = true;
                                }
                                if (graphics2 == null) {
                                    graphics2 = this.buffImg.createGraphics();
                                    this.updateAntialias = true;
                                    this.updateFont = true;
                                }
                                if (this.updateFont) {
                                    graphics2.setFont(VirtualSpaceManager.mainFont);
                                    this.updateFont = false;
                                }
                                if (this.updateAntialias) {
                                    if (this.antialias) {
                                        ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                    } else {
                                        ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                                    }
                                    this.updateAntialias = false;
                                }
                                graphics = graphics2;
                                this.standardStroke = ((Graphics2D)graphics).getStroke();
                                this.standardTransform = ((Graphics2D)graphics).getTransform();
                                AppletViewPanel appletViewPanel = this;
                                synchronized (appletViewPanel) {
                                    Serializable serializable2;
                                    graphics.setPaintMode();
                                    ((Graphics2D)graphics).setBackground(this.backColor);
                                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                                    int n = 0;
                                    while (n < this.cams.length) {
                                        if (this.cams[n] != null && this.cams[n].enabled && (this.cams[n].eager || this.cams[n].shouldRepaint())) {
                                            this.camIndex = this.cams[n].getIndex();
                                            this.drawnGlyphs = this.cams[n].parentSpace.getDrawnGlyphs(this.camIndex);
                                            serializable2 = this.drawnGlyphs;
                                            synchronized (serializable2) {
                                                Enumeration enumeration;
                                                this.drawnGlyphs.removeAllElements();
                                                this.uncoef = (this.cams[n].focal + this.cams[n].altitude) / this.cams[n].focal;
                                                this.viewW = this.getSize().width;
                                                this.viewH = this.getSize().height;
                                                this.viewWHu = (long)((float)this.cams[n].posx + (float)(this.getSize().width / 2) * this.uncoef);
                                                this.viewHHu = (long)((float)this.cams[n].posy + (float)(this.getSize().height / 2) * this.uncoef);
                                                this.viewWLu = (long)((float)this.cams[n].posx - (float)(this.getSize().width / 2) * this.uncoef);
                                                this.viewHLu = (long)((float)this.cams[n].posy - (float)(this.getSize().height / 2) * this.uncoef);
                                                if (this.parent.detectMultipleFullFills) {
                                                    enumeration = this.cams[n].parentSpace.getVisibleGlyphs().elements();
                                                    while (enumeration.hasMoreElements()) {
                                                        this.gl = (Glyph)enumeration.nextElement();
                                                        if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                                        this.cams[n].parentSpace.drewGlyph(this.gl, this.camIndex);
                                                        this.gl.project(this.cams[n], this);
                                                    }
                                                    this.beginAt = 0;
                                                    int n2 = this.drawnGlyphs.size() - 1;
                                                    while (n2 >= 0) {
                                                        if (((Glyph)this.drawnGlyphs.elementAt(n2)).fillsView(this.viewW, this.viewH, this.cams[n].getIndex())) {
                                                            this.beginAt = n2;
                                                            break;
                                                        }
                                                        --n2;
                                                    }
                                                    int n3 = this.beginAt;
                                                    while (n3 < this.drawnGlyphs.size()) {
                                                        this.gl = (Glyph)this.drawnGlyphs.elementAt(n3);
                                                        if (this.gl.isVisible()) {
                                                            this.gl.draw((Graphics2D)graphics, serializable.width, serializable.height, this.cams[n].getIndex(), this.standardStroke, this.standardTransform);
                                                        }
                                                        ++n3;
                                                    }
                                                } else {
                                                    enumeration = this.cams[n].parentSpace.getVisibleGlyphs().elements();
                                                    while (enumeration.hasMoreElements()) {
                                                        this.gl = (Glyph)enumeration.nextElement();
                                                        if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                                        Glyph glyph = this.gl;
                                                        synchronized (glyph) {
                                                            this.gl.project(this.cams[n], this);
                                                            if (this.gl.isVisible()) {
                                                                this.gl.draw((Graphics2D)graphics, serializable.width, serializable.height, this.cams[n].getIndex(), this.standardStroke, this.standardTransform);
                                                            }
                                                        }
                                                        this.cams[n].parentSpace.drewGlyph(this.gl, this.camIndex);
                                                    }
                                                }
                                            }
                                        }
                                        ++n;
                                    }
                                    if (this.inside) {
                                        block88: {
                                            try {
                                                this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                                if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                                    this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                                                }
                                            }
                                            catch (NullPointerException nullPointerException) {
                                                if (!this.parent.parent.debug) break block88;
                                                System.err.println("viewpanel.run.drawdrag " + nullPointerException);
                                            }
                                        }
                                        graphics.setColor(this.parent.mouse.color);
                                        if (this.drawDrag) {
                                            graphics.drawLine(this.origDragx, this.origDragy, this.parent.mouse.mx, this.parent.mouse.my);
                                        }
                                        if (this.drawRect) {
                                            graphics.drawRect(Math.min(this.origDragx, this.parent.mouse.mx), Math.min(this.origDragy, this.parent.mouse.my), Math.max(this.origDragx, this.parent.mouse.mx) - Math.min(this.origDragx, this.parent.mouse.mx), Math.max(this.origDragy, this.parent.mouse.my) - Math.min(this.origDragy, this.parent.mouse.my));
                                        }
                                        if (this.drawOval) {
                                            if (this.circleOnly) {
                                                graphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragx - this.parent.mouse.mx));
                                            } else {
                                                graphics.drawOval(this.origDragx - Math.abs(this.origDragx - this.parent.mouse.mx), this.origDragy - Math.abs(this.origDragy - this.parent.mouse.my), 2 * Math.abs(this.origDragx - this.parent.mouse.mx), 2 * Math.abs(this.origDragy - this.parent.mouse.my));
                                            }
                                        }
                                        if (this.drawVTMcursor) {
                                            serializable2 = this;
                                            synchronized (serializable2) {
                                                graphics.setXORMode(this.backColor);
                                                this.parent.mouse.draw((Graphics2D)graphics);
                                                this.oldX = this.parent.mouse.mx;
                                                this.oldY = this.parent.mouse.my;
                                            }
                                        }
                                    }
                                    if (graphics == graphics2) {
                                        this.repaint();
                                    }
                                    this.d2 = System.currentTimeMillis();
                                    this.timeToSleep = (long)this.frameTime - this.d2 + this.d1;
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (!this.parent.parent.debug) break block89;
                                System.err.println("viewpanel.run (probably due to buffImg.createGraphics()) " + nullPointerException);
                            }
                        }
                        try {
                            Thread.sleep(this.timeToSleep > 10L ? this.timeToSleep : 10L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.parent.parent.debug) {
                                System.err.println("viewpanel.run.runview.sleep2 " + interruptedException);
                            }
                            return;
                        }
                    }
                    if (this.updateMouseOnly) {
                        block90: {
                            this.updateMouseOnly = false;
                            this.d1 = System.currentTimeMillis();
                            try {
                                this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                    this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (!this.parent.parent.debug) break block90;
                                System.err.println("viewpanel.run.drawdrag " + nullPointerException);
                            }
                        }
                        if (this.drawVTMcursor) {
                            serializable = this;
                            synchronized (serializable) {
                                block91: {
                                    try {
                                        graphics.setXORMode(this.backColor);
                                        graphics.setColor(this.parent.mouse.color);
                                        graphics.drawLine(this.oldX - 10, this.oldY, this.oldX + 10, this.oldY);
                                        graphics.drawLine(this.oldX, this.oldY - 10, this.oldX, this.oldY + 10);
                                        graphics.drawLine(this.parent.mouse.mx - 10, this.parent.mouse.my, this.parent.mouse.mx + 10, this.parent.mouse.my);
                                        graphics.drawLine(this.parent.mouse.mx, this.parent.mouse.my - 10, this.parent.mouse.mx, this.parent.mouse.my + 10);
                                        this.oldX = this.parent.mouse.mx;
                                        this.oldY = this.parent.mouse.my;
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        if (!this.parent.parent.debug) break block91;
                                        System.err.println("viewpanel.run.runview.drawVTMcursor " + nullPointerException);
                                    }
                                }
                            }
                        }
                        this.repaint();
                        this.d2 = System.currentTimeMillis();
                        this.timeToSleep = (long)this.frameTime - this.d2 + this.d1;
                        try {
                            Thread.sleep(this.timeToSleep > 10L ? this.timeToSleep : 10L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.parent.parent.debug) {
                                System.err.println("viewpanel.run.runview.sleep3 " + interruptedException);
                            }
                            return;
                        }
                    }
                    try {
                        Thread.sleep(this.frameTime + 20);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.parent.parent.debug) {
                            System.err.println("viewpanel.run.runview.sleep4 " + interruptedException);
                        }
                        return;
                    }
                }
                try {
                    Thread.sleep(this.deactiveTime);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (this.parent.parent.debug) {
                        System.err.println("viewpanel.run.runview.sleep5 " + interruptedException);
                    }
                    return;
                }
            }
            serializable = this.getSize();
            if (serializable.width != dimension.width || serializable.height != dimension.height) {
                this.buffImg = null;
                if (graphics2 != null) {
                    graphics2.dispose();
                    graphics2 = null;
                }
                if (this.parent.parent.debug) {
                    System.out.println("Resizing JPanel in blank mode: (" + dimension.width + "x" + dimension.height + ") -> (" + serializable.width + "x" + serializable.height + ")");
                }
                dimension = serializable;
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (this.buffImg == null) {
                this.buffImg = (BufferedImage)this.createImage(serializable.width, serializable.height);
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (graphics2 == null) {
                graphics2 = this.buffImg.createGraphics();
                this.updateAntialias = true;
                this.updateFont = true;
            }
            if (this.updateFont) {
                graphics2.setFont(VirtualSpaceManager.mainFont);
                this.updateFont = false;
            }
            if (this.updateAntialias) {
                if (this.antialias) {
                    ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                this.updateAntialias = false;
            }
            graphics = graphics2;
            this.standardStroke = ((Graphics2D)graphics).getStroke();
            this.standardTransform = ((Graphics2D)graphics).getTransform();
            graphics.setPaintMode();
            graphics.setColor(this.blankColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.repaint();
            try {
                Thread.sleep(this.deactiveTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep5 " + interruptedException);
                }
                return;
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        AppletViewPanel appletViewPanel = this;
        synchronized (appletViewPanel) {
            this.g2 = (Graphics2D)graphics;
            if (this.buffImg != null) {
                this.g2.drawImage(this.buffImg, null, 0, 0);
            }
        }
    }
}

