/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.xml;

import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.Transparent;
import com.xerox.VTM.glyphs.VCirImage;
import com.xerox.VTM.glyphs.VCirShape;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VCircleST;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VDiamondOr;
import com.xerox.VTM.glyphs.VDiamondOrST;
import com.xerox.VTM.glyphs.VDiamondST;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VEllipseST;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VImageOr;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VOctagonOr;
import com.xerox.VTM.glyphs.VOctagonOrST;
import com.xerox.VTM.glyphs.VOctagonST;
import com.xerox.VTM.glyphs.VPoint;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VRectangleOrST;
import com.xerox.VTM.glyphs.VRectangleST;
import com.xerox.VTM.glyphs.VSegment;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VShapeST;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTextOr;
import com.xerox.VTM.glyphs.VTriangle;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.glyphs.VTriangleOrST;
import com.xerox.VTM.glyphs.VTriangleST;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ZvtmIO {
    public static String zvtmURI = "http://www.claribole.net/zvtm";
    public static String prefix = "zvtm";
    private static File imageIconDir = new File(".");
    public static String _alpha = "alpha";
    public static String _orient = "or";
    public static String _vertices = "vtx";
    public static String _x = "vx";
    public static String _y = "vy";
    public static String _id = "id";
    public static String _sz = "sz";
    public static String _width = "width";
    public static String _height = "height";
    public static String _color = "color";
    public static String _filled = "filled";
    public static String _bcolor = "bcolor";
    public static String _border = "border";
    public static String _selected = "selected";
    public static String _sensitive = "sensitive";
    public static String _visible = "visible";
    public static String _label = "text";
    public static String _type = "type";
    public static String _cid = "cid";
    public static String _zoom = "zoom";
    public static String _font = "font";
    public static String _path = "path";
    public static String _shpcolor = "shpcolor";
    public static String _shpfilled = "shpfilled";
    public static String _shpbcolor = "shpbcolor";
    public static String _shape = "shape";
    public static String _rectangle = "rectangle";
    public static String _circle = "circle";
    public static String _ellipse = "ellipse";
    public static String _triangle = "triangle";
    public static String _text = "text";
    public static String _segment = "segment";
    public static String _diamond = "diamond";
    public static String _octagon = "octagon";
    public static String _point = "point";
    public static String _image = "image";
    public static String _cirimage = "cirimage";
    public static String _cirshape = "cirshape";

    public static void setImageIconDirectory(File file) {
        if (file != null && file.isDirectory()) {
            imageIconDir = file;
        }
    }

    public static Document parse(String string, boolean bl) {
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature("http://xml.org/sax/features/validation", bl);
            dOMParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
            dOMParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            try {
                dOMParser.parse(string);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Document document = dOMParser.getDocument();
            document.normalize();
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void serialize(Document document, File file) {
        if (file != null && document != null) {
            XMLSerializer xMLSerializer = new XMLSerializer();
            try {
                xMLSerializer.setOutputCharStream((Writer)new FileWriter(file.toString()));
                xMLSerializer.setOutputFormat(new OutputFormat(document, "UTF-8", true));
                xMLSerializer.serialize(document);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void load(File file, VirtualSpaceManager virtualSpaceManager) {
    }

    public static void save(File file, VirtualSpaceManager virtualSpaceManager) {
    }

    public static String verticesAsString(float[] fArray) {
        String string = "";
        if (fArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < fArray.length - 1) {
                stringBuffer.append(fArray[n]);
                stringBuffer.append(",");
                ++n;
            }
            stringBuffer.append(fArray[fArray.length - 1]);
            string = stringBuffer.toString();
        }
        return string;
    }

    public static Element getGlyphAsDOMElement(Glyph glyph, Document document) {
        Element element = null;
        if (glyph instanceof VShape) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _shape);
            element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            element.setAttribute(_vertices, ZvtmIO.verticesAsString(((VShape)glyph).getVertices()));
        } else if (glyph instanceof VRectangle) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _rectangle);
            if (glyph instanceof VRectangleOr) {
                element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            }
        } else if (glyph instanceof VCircle) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _circle);
        } else if (glyph instanceof VEllipse) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _ellipse);
        } else if (glyph instanceof VTriangle) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _triangle);
            if (glyph instanceof VTriangleOr) {
                element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            }
        } else if (glyph instanceof VText) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _text);
            if (glyph instanceof VTextOr) {
                element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            }
            element.setAttribute(_zoom, Boolean.toString(((VText)glyph).isZoomSensitive()));
        } else if (glyph instanceof VSegment) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _segment);
        } else if (glyph instanceof VDiamond) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _diamond);
            if (glyph instanceof VDiamondOr) {
                element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            }
        } else if (glyph instanceof VOctagon) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _octagon);
            if (glyph instanceof VOctagonOr) {
                element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            }
        } else if (glyph instanceof VPoint) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _point);
        } else if (glyph instanceof VImage) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _image);
            if (glyph instanceof VImageOr) {
                element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            }
            element.setAttribute(_zoom, Boolean.toString(((VImage)glyph).isZoomSensitive()));
            Image image = ((VImage)glyph).getImage();
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
            File file = null;
            try {
                file = File.createTempFile("zvtm", ".png", imageIconDir);
                imageWriter.setOutput(ImageIO.createImageOutputStream(file));
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                bufferedImage.createGraphics().drawImage(image, null, null);
                imageWriter.write(bufferedImage);
                element.setAttribute(_path, file.getAbsolutePath());
            }
            catch (Exception exception) {
                System.err.println("ZVTM-I/O: An error occured while exporting " + glyph.toString() + "to PNG format.\n" + exception);
            }
        } else if (glyph instanceof VCirImage) {
            element = document.createElementNS(zvtmURI, prefix + ":" + _cirimage);
            element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            Image image = ((VCirImage)glyph).getImage();
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
            File file = null;
            try {
                file = File.createTempFile("zvtm", ".png", imageIconDir);
                imageWriter.setOutput(ImageIO.createImageOutputStream(file));
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                bufferedImage.createGraphics().drawImage(image, null, null);
                imageWriter.write(bufferedImage);
                element.setAttribute(_path, file.getAbsolutePath());
            }
            catch (Exception exception) {
                System.err.println("ZVTM-I/O: An error occured while exporting " + glyph.toString() + "to PNG format.\n" + exception);
            }
        } else if (glyph instanceof VCirShape) {
            VCirShape vCirShape = (VCirShape)glyph;
            element = document.createElementNS(zvtmURI, prefix + ":" + _cirshape);
            element.setAttribute(_orient, Float.toString(glyph.getOrient()));
            element.setAttribute(_vertices, ZvtmIO.verticesAsString(vCirShape.getVertices()));
            element.setAttribute(_shpcolor, Integer.toString(vCirShape.getShapeColor().getRGB()));
            element.setAttribute(_shpfilled, Boolean.toString(vCirShape.getShapeFillStatus()));
            element.setAttribute(_shpbcolor, Integer.toString(vCirShape.getShapebColor().getRGB()));
        } else {
            System.err.println("ZVTM-I/O: unsupported glyph type (no DOM representation defined): " + glyph.toString());
            return element;
        }
        element.setAttribute(_id, glyph.getID().toString());
        element.setAttribute(_x, Long.toString(glyph.vx));
        element.setAttribute(_y, Long.toString(glyph.vy));
        element.setAttribute(_sz, Float.toString(glyph.getSize()));
        if (glyph instanceof RectangularShape) {
            element.setAttribute(_width, Long.toString(((RectangularShape)((Object)glyph)).getWidth()));
            element.setAttribute(_height, Long.toString(((RectangularShape)((Object)glyph)).getHeight()));
        }
        element.setAttribute(_color, Integer.toString(glyph.getColor().getRGB()));
        element.setAttribute(_filled, Boolean.toString(glyph.getFillStatus()));
        element.setAttribute(_bcolor, Integer.toString(glyph.getColorb().getRGB()));
        element.setAttribute(_border, Boolean.toString(glyph.getPaintBorderStatus()));
        element.setAttribute(_selected, Boolean.toString(glyph.isSelected()));
        element.setAttribute(_sensitive, Boolean.toString(glyph.isSensitive()));
        element.setAttribute(_visible, Boolean.toString(glyph.isVisible()));
        if (glyph.getText() != null && glyph.getText().length() > 0) {
            element.setAttribute(_label, glyph.getText());
        }
        if (glyph.getType() != null && glyph.getType().length() > 0) {
            element.setAttribute(_type, glyph.getType());
        }
        if (glyph instanceof Transparent) {
            element.setAttribute(_alpha, Float.toString(((Transparent)((Object)glyph)).getTransparencyValue()));
        }
        if (glyph.getCGlyph() != null) {
            element.setAttribute(_cid, glyph.getCGlyph().getID().toString());
        }
        if (glyph.usesSpecialFont()) {
            element.setAttribute(_font, glyph.getFont().toString());
        }
        return element;
    }

    public static Glyph getGlyphFromDOMElement(Element element) {
        Glyph glyph = null;
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(zvtmURI)) {
            try {
                String string = element.getLocalName();
                long l = new Long(element.getAttribute(_x));
                long l2 = new Long(element.getAttribute(_y));
                float f = new Float(element.getAttribute(_sz)).floatValue();
                Color color = new Color(new Integer(element.getAttribute(_color)));
                if (string.equals(_shape)) {
                    if (element.hasAttribute(_alpha)) {
                        glyph = new VShapeST(l, l2, 0.0f, (long)f, ZvtmIO.floatTokenizer(element.getAttribute(_vertices)), color, new Float(element.getAttribute(_orient)).floatValue());
                        ((Transparent)((Object)glyph)).setTransparencyValue(new Float(element.getAttribute(_alpha)).floatValue());
                    } else {
                        glyph = new VShape(l, l2, 0.0f, (long)f, ZvtmIO.floatTokenizer(element.getAttribute(_vertices)), color, new Float(element.getAttribute(_orient)).floatValue());
                    }
                } else if (string.equals(_rectangle)) {
                    if (element.hasAttribute(_alpha)) {
                        glyph = element.hasAttribute(_orient) ? new VRectangleOrST(l, l2, 0.0f, new Long(element.getAttribute(_width)), new Long(element.getAttribute(_height)), color, new Float(element.getAttribute(_orient)).floatValue()) : new VRectangleST(l, l2, 0.0f, new Long(element.getAttribute(_width)), new Long(element.getAttribute(_height)), color);
                        ((Transparent)((Object)glyph)).setTransparencyValue(new Float(element.getAttribute(_alpha)).floatValue());
                    } else {
                        glyph = element.hasAttribute(_orient) ? new VRectangleOr(l, l2, 0.0f, new Long(element.getAttribute(_width)), new Long(element.getAttribute(_height)), color, new Float(element.getAttribute(_orient)).floatValue()) : new VRectangle(l, l2, 0.0f, new Long(element.getAttribute(_width)), new Long(element.getAttribute(_height)), color);
                    }
                } else if (string.equals(_circle)) {
                    if (element.hasAttribute(_alpha)) {
                        glyph = new VCircleST(l, l2, 0.0f, (long)f, color);
                        ((Transparent)((Object)glyph)).setTransparencyValue(new Float(element.getAttribute(_alpha)).floatValue());
                    } else {
                        glyph = new VCircle(l, l2, 0.0f, (long)f, color);
                    }
                } else if (string.equals(_ellipse)) {
                    if (element.hasAttribute(_alpha)) {
                        glyph = new VEllipseST(l, l2, 0.0f, new Long(element.getAttribute(_width)), new Long(element.getAttribute(_height)), color);
                        ((Transparent)((Object)glyph)).setTransparencyValue(new Float(element.getAttribute(_alpha)).floatValue());
                    } else {
                        glyph = new VEllipse(l, l2, 0.0f, new Long(element.getAttribute(_width)), new Long(element.getAttribute(_height)), color);
                    }
                } else if (string.equals(_triangle)) {
                    if (element.hasAttribute(_alpha)) {
                        glyph = element.hasAttribute(_orient) ? new VTriangleOrST(l, l2, 0.0f, (long)f, color, new Float(element.getAttribute(_orient)).floatValue()) : new VTriangleST(l, l2, 0.0f, (long)f, color);
                        ((Transparent)((Object)glyph)).setTransparencyValue(new Float(element.getAttribute(_alpha)).floatValue());
                    } else {
                        glyph = element.hasAttribute(_orient) ? new VTriangleOr(l, l2, 0.0f, (long)f, color, new Float(element.getAttribute(_orient)).floatValue()) : new VTriangle(l, l2, 0.0f, (long)f, color);
                    }
                } else if (string.equals(_text)) {
                    glyph = element.hasAttribute(_orient) ? new VTextOr(l, l2, 0.0f, color, element.getAttribute(_label), new Float(element.getAttribute(_orient)).floatValue()) : new VText(l, l2, 0.0f, color, element.getAttribute(_label));
                    ((VText)glyph).setZoomSensitive(new Boolean(element.getAttribute(_zoom)));
                } else if (string.equals(_segment)) {
                    glyph = new VSegment(l, l2, 0.0f, new Long(element.getAttribute(_width)), new Long(element.getAttribute(_height)), color);
                } else if (string.equals(_diamond)) {
                    if (element.hasAttribute(_alpha)) {
                        glyph = element.hasAttribute(_orient) ? new VDiamondOrST(l, l2, 0.0f, (long)f, color, new Float(element.getAttribute(_orient)).floatValue()) : new VDiamondST(l, l2, 0.0f, (long)f, color);
                        ((Transparent)((Object)glyph)).setTransparencyValue(new Float(element.getAttribute(_alpha)).floatValue());
                    } else {
                        glyph = element.hasAttribute(_orient) ? new VDiamondOr(l, l2, 0.0f, (long)f, color, new Float(element.getAttribute(_orient)).floatValue()) : new VDiamond(l, l2, 0.0f, (long)f, color);
                    }
                } else if (string.equals(_octagon)) {
                    if (element.hasAttribute(_alpha)) {
                        glyph = element.hasAttribute(_orient) ? new VOctagonOrST(l, l2, 0.0f, (long)f, color, new Float(element.getAttribute(_orient)).floatValue()) : new VOctagonST(l, l2, 0.0f, (long)f, color);
                        ((Transparent)((Object)glyph)).setTransparencyValue(new Float(element.getAttribute(_alpha)).floatValue());
                    } else {
                        glyph = element.hasAttribute(_orient) ? new VOctagonOr(l, l2, 0.0f, (long)f, color, new Float(element.getAttribute(_orient)).floatValue()) : new VOctagon(l, l2, 0.0f, (long)f, color);
                    }
                } else if (string.equals(_point)) {
                    glyph = new VPoint(l, l2, color);
                } else if (string.equals(_image) || string.equals(_cirimage) || string.equals(_cirshape)) {
                    // empty if block
                }
                glyph.setFill(new Boolean(element.getAttribute(_filled)));
                float[] fArray = new float[3];
                Color color2 = new Color(new Integer(element.getAttribute(_bcolor)));
                Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), fArray);
                glyph.setHSVbColor(fArray[0], fArray[1], fArray[2]);
                glyph.setPaintBorder(new Boolean(element.getAttribute(_border)));
                glyph.select(new Boolean(element.getAttribute(_selected)));
                glyph.setSensitivity(new Boolean(element.getAttribute(_sensitive)));
                glyph.setVisible(new Boolean(element.getAttribute(_visible)));
                if (element.hasAttribute(_type)) {
                    glyph.setType(element.getAttribute(_type));
                }
                if (element.hasAttribute(_label) && !(glyph instanceof VText)) {
                    glyph.setType(element.getAttribute(_label));
                }
                if (element.hasAttribute(_font)) {
                    glyph.setSpecialFont(Font.decode(element.getAttribute(_font)));
                }
            }
            catch (Exception exception) {
                System.err.println("ZVTM_I/O : Error: getGlyphFromDOMElement: unknown type of glyph (or bad delcaration) " + element.toString() + " " + exception);
            }
        } else {
            System.err.println("ZVTM_I/O : Error: getGlyphFromDOMElement: provided element does not belong to the zvtm namespace and does not describe a Glyph " + element.toString());
        }
        return glyph;
    }

    public static float[] floatTokenizer(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = new Float(stringTokenizer.nextToken()).floatValue();
            ++n;
        }
        return fArray;
    }
}

