/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.claribole.zvtm.glyphs.GlyphFactory;
import net.claribole.zvtm.glyphs.GlyphPanel;

class VShapePanel
extends GlyphPanel
implements MouseMotionListener,
MouseListener {
    Polygon p;
    int x2;
    int y2;
    double tmpD;

    VShapePanel(GlyphFactory glyphFactory) {
        super(glyphFactory);
        this.vertices = this.gf.vertices;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = 0;
        while (n < this.vertices.length - 1) {
            this.xcoords[n] = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle) * this.vertices[n]);
            this.ycoords[n] = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle) * this.vertices[n]);
            this.vertexAngle += Math.PI * 2 / (double)this.vertices.length;
            ++n;
        }
        this.xcoords[this.vertices.length - 1] = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle) * this.vertices[this.vertices.length - 1]);
        this.ycoords[this.vertices.length - 1] = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle) * this.vertices[this.vertices.length - 1]);
        this.p = new Polygon(this.xcoords, this.ycoords, this.xcoords.length);
        if (this.alpha > 0.0) {
            if (this.alpha == 1.0) {
                this.g2d.setColor(this.fColor);
                this.g2d.fillPolygon(this.p);
            } else {
                this.g2d.setColor(this.fColor);
                this.g2d.setComposite(this.acST);
                this.g2d.fillPolygon(this.p);
                this.g2d.setComposite(GlyphPanel.acO);
            }
        }
        this.g2d.setColor(this.bColor);
        this.g2d.drawPolygon(this.p);
        this.g2d.setColor(Color.black);
        if (this.displayIndicators) {
            this.g2d.setStroke(GlyphPanel.dashed);
            this.g2d.drawOval(this.cx - this.cs, this.cy - this.cs, 2 * this.cs, 2 * this.cs);
            this.vertexAngle = this.gf.angle;
            int n2 = 0;
            while (n2 < this.xcoords.length) {
                this.x2 = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle));
                this.y2 = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle));
                this.g2d.drawLine(this.cx, this.cy, this.x2, this.y2);
                if (n2 == this.selectedVertex) {
                    this.g2d.setColor(Color.red);
                    this.g2d.fillRect(this.xcoords[n2] - 3, this.ycoords[n2] - 3, 6, 6);
                    this.g2d.setColor(Color.black);
                } else {
                    this.g2d.fillRect(this.xcoords[n2] - 3, this.ycoords[n2] - 3, 6, 6);
                }
                this.vertexAngle += Math.PI * 2 / (double)this.vertices.length;
                ++n2;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedVertex >= 0) {
            this.tmpD = Math.sqrt(Math.pow(mouseEvent.getX() - this.cx, 2.0) + Math.pow(mouseEvent.getY() - this.cy, 2.0)) / (double)this.cs;
            if (this.tmpD < 0.0) {
                this.tmpD = 0.0;
            } else if (this.tmpD > 1.0) {
                this.tmpD = 1.0;
            }
            this.vertices[this.selectedVertex] = this.tmpD;
            this.gf.setVertexVal(this.tmpD);
            this.repaint();
        } else {
            this.orientDrag(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        if (GlyphFactory.hasEditableVertexValues()) {
            int n3 = 0;
            while (n3 < this.xcoords.length) {
                if (this.xcoords[n3] - 3 <= n && n <= this.xcoords[n3] + 3 && this.ycoords[n3] - 3 <= n2 && n2 <= this.ycoords[n3] + 3) {
                    this.selectedVertex = n3;
                    bl = true;
                    break;
                }
                ++n3;
            }
        }
        if (!bl) {
            this.selectedVertex = this.gf.orientable && GlyphFactory.hasEditableAngle() && this.xorientHandle - 3 <= n && n <= this.xorientHandle + 3 && this.yorientHandle - 3 <= n2 && n2 <= this.yorientHandle + 3 ? -2 : -1;
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        if (GlyphFactory.hasEditableVertexValues()) {
            int n3 = 0;
            while (n3 < this.xcoords.length) {
                if (this.xcoords[n3] - 3 <= n && n <= this.xcoords[n3] + 3 && this.ycoords[n3] - 3 <= n2 && n2 <= this.ycoords[n3] + 3) {
                    bl = true;
                    this.selectedVertex = n3;
                    this.gf.setVertexVal(this.vertices[n3]);
                    break;
                }
                ++n3;
            }
        }
        if (!bl) {
            this.selectedVertex = -1;
            this.gf.setVertexVal(-1.0);
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(1));
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.gf.vertices = this.vertices;
    }
}

