/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.Transparent;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VCircleST;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VDiamondOr;
import com.xerox.VTM.glyphs.VDiamondOrST;
import com.xerox.VTM.glyphs.VDiamondST;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VEllipseST;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VOctagonOr;
import com.xerox.VTM.glyphs.VOctagonOrST;
import com.xerox.VTM.glyphs.VOctagonST;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VRectangleOrST;
import com.xerox.VTM.glyphs.VRectangleST;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VShapeST;
import com.xerox.VTM.glyphs.VTriangle;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.glyphs.VTriangleOrST;
import com.xerox.VTM.glyphs.VTriangleST;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.claribole.zvtm.glyphs.ColorIndicator;
import net.claribole.zvtm.glyphs.GlyphPanel;
import net.claribole.zvtm.glyphs.GlyphTracker;
import net.claribole.zvtm.glyphs.VCirPanel;
import net.claribole.zvtm.glyphs.VDiamPanel;
import net.claribole.zvtm.glyphs.VEllPanel;
import net.claribole.zvtm.glyphs.VOctPanel;
import net.claribole.zvtm.glyphs.VRectPanel;
import net.claribole.zvtm.glyphs.VShapePanel;
import net.claribole.zvtm.glyphs.VTrgPanel;

public class GlyphFactory
extends JDialog
implements ActionListener,
MouseListener,
ChangeListener {
    public static String V_Shape = "VShape";
    public static String V_Rectangle = "VRectangle";
    public static String V_Ellipse = "VEllipse";
    public static String V_Circle = "VCircle";
    public static String V_Triangle = "VTriangle";
    public static String V_Diamond = "VDiamond";
    public static String V_Octagon = "VOctagon";
    private static Vector allowedShapeTypes = GlyphFactory.initShapeTypes();
    private static String defaultShapeType = V_Shape;
    private static boolean changeableShapeType = true;
    private static Color defaultFillColor = Color.white;
    private static boolean editableFillColor = true;
    private static Color defaultBorderColor = Color.white;
    private static boolean editableBorderColor = true;
    private static boolean defaultTransparencyOnOff = true;
    private static boolean editableTransparencyOnOff = true;
    private static double defaultAlphaValue = 1.0;
    private static boolean editableAlphaValue = true;
    private static boolean defaultOrientationOnOff = true;
    private static boolean editableOrientationOnOff = true;
    private static double defaultAngleValue = 0.0;
    private static boolean editableAngleValue = true;
    private static long defaultSizeValue = 10L;
    private static boolean editableSizeValue = true;
    private static int defaultVertexCount = 8;
    private static boolean editableVertexCount = true;
    private static double[] defaultVertexValues = new double[]{1.0, 0.5, 1.0, 0.5, 1.0, 0.5, 1.0, 0.5};
    private static boolean editableVertexValues = true;
    private static int GLYPH_PANEL_WIDTH = 301;
    GlyphTracker gt;
    GlyphPanel glyphPanel;
    JComboBox glList;
    ColorIndicator ci1;
    ColorIndicator ci2;
    JCheckBox transpChk;
    JCheckBox angleChk;
    JCheckBox aliasChk;
    JCheckBox gridChk;
    JCheckBox geomChk;
    JSpinner transpSpin;
    JSpinner angleSpin;
    JSpinner sizeSpin;
    JSpinner vxSpin;
    JLabel vxVal;
    JLabel vxValLb;
    JLabel vxLb;
    JButton okBt;
    JButton cancelBt;
    JButton resetBt;
    double angle = defaultAngleValue;
    long size = defaultSizeValue;
    boolean orientable = defaultOrientationOnOff;
    double aspectRatio = 1.0;
    double alpha = defaultAlphaValue;
    Color fillColor = defaultFillColor;
    Color borderColor = defaultBorderColor;
    double[] vertices = defaultVertexValues;

    private static Vector initShapeTypes() {
        Vector<String> vector = new Vector<String>();
        vector.add(V_Shape);
        vector.add(V_Rectangle);
        vector.add(V_Ellipse);
        vector.add(V_Circle);
        vector.add(V_Triangle);
        vector.add(V_Diamond);
        vector.add(V_Octagon);
        return vector;
    }

    public static boolean hasEditableAngle() {
        return editableAngleValue;
    }

    public static boolean hasEditableVertexValues() {
        return editableVertexValues;
    }

    public static Glyph getGlyphFactoryDialog(Frame frame) {
        GlyphTracker glyphTracker = new GlyphTracker();
        GlyphFactory glyphFactory = new GlyphFactory(glyphTracker, frame);
        glyphFactory.addWindowListener(new Closer());
        glyphFactory.addComponentListener(new DisposeOnClose());
        glyphFactory.show();
        return glyphTracker.getGlyph();
    }

    public static Glyph getGlyphFactoryDialog(Frame frame, long l) {
        if (l != -1L) {
            defaultSizeValue = l;
        }
        GlyphTracker glyphTracker = new GlyphTracker();
        GlyphFactory glyphFactory = new GlyphFactory(glyphTracker, frame);
        glyphFactory.addWindowListener(new Closer());
        glyphFactory.addComponentListener(new DisposeOnClose());
        glyphFactory.show();
        return glyphTracker.getGlyph();
    }

    public static Glyph getGlyphFactoryDialog(Frame frame, Vector vector, String string, boolean bl, Color color, boolean bl2, Color color2, boolean bl3, boolean bl4, boolean bl5, double d, boolean bl6, boolean bl7, boolean bl8, double d2, boolean bl9, long l, boolean bl10, int n, boolean bl11, double[] dArray, boolean bl12) {
        if (vector != null) {
            allowedShapeTypes = vector;
        }
        if (allowedShapeTypes.contains(string)) {
            defaultShapeType = string;
        }
        changeableShapeType = bl;
        if (color != null) {
            defaultFillColor = color;
        }
        editableFillColor = bl2;
        if (color2 != null) {
            defaultBorderColor = color2;
        }
        editableBorderColor = bl3;
        defaultTransparencyOnOff = bl4;
        editableTransparencyOnOff = bl5;
        if (d != -1.0) {
            defaultAlphaValue = d;
        }
        editableAlphaValue = bl6;
        defaultOrientationOnOff = bl7;
        editableOrientationOnOff = bl8;
        if (d2 != -10.0) {
            defaultAngleValue = d2;
        }
        editableAngleValue = bl9;
        if (l != -1L) {
            defaultSizeValue = l;
        }
        editableSizeValue = bl10;
        if (n > 0) {
            defaultVertexCount = n;
        }
        editableVertexCount = bl11;
        if (dArray != null) {
            defaultVertexValues = dArray;
        }
        editableVertexValues = bl12;
        if (defaultVertexValues.length != defaultVertexCount) {
            defaultVertexCount = defaultVertexValues.length;
        }
        return GlyphFactory.getGlyphFactoryDialog(frame);
    }

    static float[] doubleToFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            fArray[n] = (float)dArray[n];
            ++n;
        }
        return fArray;
    }

    GlyphFactory(GlyphTracker glyphTracker, Frame frame) {
        super(frame, "ZVTM Glyph Factory", true);
        this.gt = glyphTracker;
        this.initUI(defaultShapeType, true, false, true);
    }

    void initUI(String string, boolean bl, boolean bl2, boolean bl3) {
        Container container = this.getContentPane();
        try {
            this.glList.removeActionListener(this);
            this.ci1.removeMouseListener(this);
            this.ci2.removeMouseListener(this);
            this.transpChk.removeActionListener(this);
            this.transpSpin.removeChangeListener(this);
            this.angleChk.removeActionListener(this);
            this.angleSpin.removeChangeListener(this);
            this.sizeSpin.removeChangeListener(this);
            this.vxSpin.removeChangeListener(this);
            this.gridChk.removeActionListener(this);
            this.aliasChk.removeActionListener(this);
            this.geomChk.removeActionListener(this);
            this.glyphPanel.removeMouseListener((MouseListener)((Object)this.glyphPanel));
            this.glyphPanel.removeMouseMotionListener((MouseMotionListener)((Object)this.glyphPanel));
            this.okBt.removeActionListener(this);
            this.cancelBt.removeActionListener(this);
            this.resetBt.removeActionListener(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        container.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Parameters"));
        jPanel.setLayout(new GridLayout(1, 2));
        this.glyphPanel = this.setGlyphPanel(string);
        this.glyphPanel.setPreferredSize(new Dimension(GLYPH_PANEL_WIDTH, GLYPH_PANEL_WIDTH));
        this.glyphPanel.setMinimumSize(new Dimension(GLYPH_PANEL_WIDTH, GLYPH_PANEL_WIDTH));
        this.glyphPanel.setMaximumSize(new Dimension(GLYPH_PANEL_WIDTH, GLYPH_PANEL_WIDTH));
        jPanel.add(this.glyphPanel);
        this.glyphPanel.addMouseListener((MouseListener)((Object)this.glyphPanel));
        this.glyphPanel.addMouseMotionListener((MouseMotionListener)((Object)this.glyphPanel));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        Vector vector = (Vector)allowedShapeTypes.clone();
        this.glList = new JComboBox(vector);
        this.glList.setMaximumRowCount(5);
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 100, 14);
        gridBagLayout.setConstraints(this.glList, gridBagConstraints);
        jPanel2.add(this.glList);
        this.glList.setSelectedItem(string);
        this.glList.addActionListener(this);
        this.glList.setEnabled(changeableShapeType);
        this.ci1 = new ColorIndicator("Fill Color", this.fillColor);
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.ci1, gridBagConstraints);
        jPanel2.add(this.ci1);
        this.ci2 = new ColorIndicator("Border Color", this.borderColor);
        GlyphFactory.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.ci2, gridBagConstraints);
        jPanel2.add(this.ci2);
        this.ci1.addMouseListener(this);
        this.ci2.addMouseListener(this);
        this.transpChk = new JCheckBox("Translucent", defaultTransparencyOnOff);
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.transpChk, gridBagConstraints);
        jPanel2.add(this.transpChk);
        this.transpChk.addActionListener(this);
        this.transpChk.setEnabled(editableTransparencyOnOff);
        this.transpSpin = new JSpinner(new SpinnerNumberModel(defaultAlphaValue, 0.0, 1.0, 0.05));
        GlyphFactory.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.transpSpin, gridBagConstraints);
        jPanel2.add(this.transpSpin);
        this.transpSpin.setEnabled(this.transpChk.isSelected() ? editableAlphaValue : false);
        this.transpSpin.addChangeListener(this);
        this.angleChk = new JCheckBox("Orientation", defaultOrientationOnOff);
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.angleChk, gridBagConstraints);
        jPanel2.add(this.angleChk);
        this.angleChk.addActionListener(this);
        this.angleChk.setEnabled(editableOrientationOnOff);
        this.angleSpin = new JSpinner(new SpinnerNumberModel(defaultAngleValue, 0.0, Math.PI * 2, 0.02));
        GlyphFactory.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.angleSpin, gridBagConstraints);
        jPanel2.add(this.angleSpin);
        this.angleSpin.setEnabled(this.angleChk.isSelected() ? editableAngleValue : false);
        this.angleSpin.addChangeListener(this);
        JLabel jLabel = new JLabel("Size");
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 50, 14);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.sizeSpin = new JSpinner(new SpinnerNumberModel((int)defaultSizeValue, 0, Integer.MAX_VALUE, 10));
        GlyphFactory.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.sizeSpin, gridBagConstraints);
        jPanel2.add(this.sizeSpin);
        this.sizeSpin.setEnabled(editableSizeValue);
        this.sizeSpin.addChangeListener(this);
        this.vxLb = new JLabel("Vertex count");
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.vxLb, gridBagConstraints);
        jPanel2.add(this.vxLb);
        this.vxSpin = new JSpinner(new SpinnerNumberModel(defaultVertexCount, 3, Integer.MAX_VALUE, 1));
        GlyphFactory.buildConstraints(gridBagConstraints, 1, 5, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.vxSpin, gridBagConstraints);
        jPanel2.add(this.vxSpin);
        this.vxSpin.setEnabled(editableVertexCount);
        this.vxSpin.addChangeListener(this);
        this.vxValLb = new JLabel("Selected vertex value");
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 6, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.vxValLb, gridBagConstraints);
        jPanel2.add(this.vxValLb);
        this.vxVal = new JLabel(" ");
        GlyphFactory.buildConstraints(gridBagConstraints, 1, 6, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.vxVal, gridBagConstraints);
        jPanel2.add(this.vxVal);
        this.gridChk = new JCheckBox("Grid", bl);
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 7, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.gridChk, gridBagConstraints);
        jPanel2.add(this.gridChk);
        this.gridChk.addActionListener(this);
        this.aliasChk = new JCheckBox("Antialiasing", bl2);
        GlyphFactory.buildConstraints(gridBagConstraints, 1, 7, 1, 1, 50, 14);
        gridBagLayout.setConstraints(this.aliasChk, gridBagConstraints);
        jPanel2.add(this.aliasChk);
        this.aliasChk.addActionListener(this);
        this.geomChk = new JCheckBox("Indicators", bl3);
        GlyphFactory.buildConstraints(gridBagConstraints, 0, 8, 2, 1, 100, 14);
        gridBagLayout.setConstraints(this.geomChk, gridBagConstraints);
        jPanel2.add(this.geomChk);
        this.geomChk.setSelected(true);
        this.geomChk.addActionListener(this);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        this.okBt = new JButton("OK");
        this.okBt.addActionListener(this);
        jPanel3.add(this.okBt);
        this.cancelBt = new JButton("Cancel");
        this.cancelBt.addActionListener(this);
        jPanel3.add(this.cancelBt);
        this.resetBt = new JButton("Reset");
        this.resetBt.addActionListener(this);
        jPanel3.add(this.resetBt);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        container.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        GlyphFactory.buildConstraints(gridBagConstraints2, 0, 0, 1, 1, 100, 99);
        gridBagLayout2.setConstraints(jPanel, gridBagConstraints2);
        container.add(jPanel);
        GlyphFactory.buildConstraints(gridBagConstraints2, 0, 1, 1, 1, 100, 1);
        gridBagLayout2.setConstraints(jPanel3, gridBagConstraints2);
        container.add(jPanel3);
        this.pack();
        this.setResizable(false);
        if (string.equals(V_Shape)) {
            this.vxSpin.setEnabled(true);
            this.vxLb.setEnabled(true);
            this.vxVal.setEnabled(true);
            this.vxValLb.setEnabled(true);
        } else {
            this.vxSpin.setEnabled(false);
            this.vxLb.setEnabled(false);
            this.vxVal.setEnabled(false);
            this.vxValLb.setEnabled(false);
            if (string.equals(V_Ellipse) || string.equals(V_Circle)) {
                this.angleSpin.setValue(new Double(0.0));
                this.orientable = false;
                this.angleSpin.setEnabled(false);
                this.angleChk.setSelected(false);
                this.angleChk.setEnabled(false);
                if (this.glyphPanel.selectedVertex == -2) {
                    this.glyphPanel.selectedVertex = -1;
                }
            }
        }
        if (this.aliasChk.isSelected()) {
            this.glyphPanel.setAntialiasing(true);
        } else {
            this.glyphPanel.setAntialiasing(false);
        }
        if (this.gridChk.isSelected()) {
            this.glyphPanel.setGrid(true);
        } else {
            this.glyphPanel.setGrid(false);
        }
        if (this.geomChk.isSelected()) {
            this.glyphPanel.setGeom(true);
        } else {
            this.glyphPanel.setGeom(false);
        }
    }

    GlyphPanel setGlyphPanel(String string) {
        if (string.equals(V_Shape)) {
            return new VShapePanel(this);
        }
        if (string.equals(V_Rectangle)) {
            return new VRectPanel(this);
        }
        if (string.equals(V_Circle)) {
            return new VCirPanel(this);
        }
        if (string.equals(V_Ellipse)) {
            return new VEllPanel(this);
        }
        if (string.equals(V_Triangle)) {
            return new VTrgPanel(this);
        }
        if (string.equals(V_Diamond)) {
            return new VDiamPanel(this);
        }
        if (string.equals(V_Octagon)) {
            return new VOctPanel(this);
        }
        return new VShapePanel(this);
    }

    void changeFillColor(Color color) {
        this.fillColor = color;
        this.ci1.setColor(this.fillColor);
        this.glyphPanel.setColor(this.fillColor, this.borderColor);
    }

    void changeBorderColor(Color color) {
        this.borderColor = color;
        this.ci2.setColor(this.borderColor);
        this.glyphPanel.setColor(this.fillColor, this.borderColor);
    }

    void changeOrient(double d) {
        this.angle = d;
        this.glyphPanel.setAngle(this.angle);
    }

    void changeSize(int n) {
        this.size = n;
    }

    void updateAngleSpin(double d) {
        this.angle = d;
        this.angleSpin.setValue(new Double(d));
    }

    void changeTransp(double d) {
        this.alpha = d;
        this.glyphPanel.setTransparency(this.alpha);
    }

    void changeVertices(int n) {
        if (n > this.vertices.length) {
            double[] dArray = new double[this.vertices.length + 1];
            System.arraycopy(this.vertices, 0, dArray, 0, this.vertices.length);
            dArray[dArray.length - 1] = 1.0;
            this.vertices = dArray;
            this.glyphPanel.setVertices(this.vertices);
        } else if (n < this.vertices.length) {
            double[] dArray = new double[this.vertices.length - 1];
            System.arraycopy(this.vertices, 0, dArray, 0, this.vertices.length - 1);
            this.vertices = dArray;
            this.glyphPanel.setVertices(this.vertices);
        }
    }

    void setVertexVal(double d) {
        if (d >= 0.0) {
            String string = Double.toString(d);
            this.vxVal.setText(string.length() > 6 ? string.substring(0, 6) : string);
        } else {
            this.vxVal.setText("");
        }
    }

    Glyph instantiateGlyph(String string) {
        float[] fArray;
        Glyph glyph = null;
        if (string.equals(V_Shape)) {
            if (this.transpChk.isSelected()) {
                glyph = new VShapeST(0L, 0L, 0.0f, this.size, GlyphFactory.doubleToFloatArray(this.vertices), this.fillColor, (float)this.angle);
                ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
            } else {
                glyph = new VShape(0L, 0L, 0.0f, this.size, GlyphFactory.doubleToFloatArray(this.vertices), this.fillColor, (float)this.angle);
                fArray = new float[3];
                Color.RGBtoHSB(this.borderColor.getRed(), this.borderColor.getGreen(), this.borderColor.getBlue(), fArray);
                glyph.setHSVbColor(fArray[0], fArray[1], fArray[2]);
            }
        } else if (string.equals(V_Rectangle)) {
            long l;
            long l2;
            if (this.aspectRatio >= 1.0) {
                l2 = this.size;
                l = Math.round((double)this.size / this.aspectRatio);
            } else {
                l = this.size;
                l2 = Math.round((double)this.size * this.aspectRatio);
            }
            if (this.angleChk.isSelected()) {
                if (this.transpChk.isSelected()) {
                    glyph = new VRectangleOrST(0L, 0L, 0.0f, l2, l, this.fillColor, (float)this.angle);
                    ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
                } else {
                    glyph = new VRectangleOr(0L, 0L, 0.0f, l2, l, this.fillColor, (float)this.angle);
                }
            } else if (this.transpChk.isSelected()) {
                glyph = new VRectangleST(0L, 0L, 0.0f, l2, l, this.fillColor);
                ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
            } else {
                glyph = new VRectangle(0L, 0L, 0.0f, l2, l, this.fillColor);
            }
        } else if (string.equals(V_Ellipse)) {
            long l;
            long l3;
            if (this.aspectRatio >= 1.0) {
                l3 = this.size;
                l = Math.round((double)this.size / this.aspectRatio);
            } else {
                l = this.size;
                l3 = Math.round((double)this.size * this.aspectRatio);
            }
            if (this.transpChk.isSelected()) {
                glyph = new VEllipseST(0L, 0L, 0.0f, l3, l, this.fillColor);
                ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
            } else {
                glyph = new VEllipse(0L, 0L, 0.0f, l3, l, this.fillColor);
            }
        } else if (string.equals(V_Circle)) {
            if (this.transpChk.isSelected()) {
                glyph = new VCircleST(0L, 0L, 0.0f, this.size, this.fillColor);
                ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
            } else {
                glyph = new VCircle(0L, 0L, 0.0f, this.size, this.fillColor);
            }
        } else if (string.equals(V_Triangle)) {
            if (this.angleChk.isSelected()) {
                if (this.transpChk.isSelected()) {
                    glyph = new VTriangleOrST(0L, 0L, 0.0f, this.size, this.fillColor, (float)this.angle);
                    ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
                } else {
                    glyph = new VTriangleOr(0L, 0L, 0.0f, this.size, this.fillColor, (float)this.angle);
                }
            } else if (this.transpChk.isSelected()) {
                glyph = new VTriangleST(0L, 0L, 0.0f, this.size, this.fillColor);
                ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
            } else {
                glyph = new VTriangle(0L, 0L, 0.0f, this.size, this.fillColor);
            }
        } else if (string.equals(V_Diamond)) {
            if (this.angleChk.isSelected()) {
                if (this.transpChk.isSelected()) {
                    glyph = new VDiamondOrST(0L, 0L, 0.0f, this.size, this.fillColor, (float)this.angle);
                    ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
                } else {
                    glyph = new VDiamondOr(0L, 0L, 0.0f, this.size, this.fillColor, (float)this.angle);
                }
            } else if (this.transpChk.isSelected()) {
                glyph = new VDiamondST(0L, 0L, 0.0f, this.size, this.fillColor);
                ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
            } else {
                glyph = new VDiamond(0L, 0L, 0.0f, this.size, this.fillColor);
            }
        } else if (string.equals(V_Octagon)) {
            if (this.angleChk.isSelected()) {
                if (this.transpChk.isSelected()) {
                    glyph = new VOctagonOrST(0L, 0L, 0.0f, this.size, this.fillColor, (float)this.angle);
                    ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
                } else {
                    glyph = new VOctagonOr(0L, 0L, 0.0f, this.size, this.fillColor, (float)this.angle);
                }
            } else if (this.transpChk.isSelected()) {
                glyph = new VOctagonST(0L, 0L, 0.0f, this.size, this.fillColor);
                ((Transparent)((Object)glyph)).setTransparencyValue((float)this.alpha);
            } else {
                glyph = new VOctagon(0L, 0L, 0.0f, this.size, this.fillColor);
            }
        }
        fArray = new float[3];
        Color.RGBtoHSB(this.borderColor.getRed(), this.borderColor.getGreen(), this.borderColor.getBlue(), fArray);
        glyph.setHSVbColor(fArray[0], fArray[1], fArray[2]);
        return glyph;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.transpChk) {
            if (this.transpChk.isSelected()) {
                this.transpSpin.setEnabled(editableAlphaValue);
            } else {
                this.transpSpin.setValue(new Double(1.0));
                this.transpSpin.setEnabled(false);
            }
        } else if (object == this.angleChk) {
            if (this.angleChk.isSelected()) {
                this.orientable = true;
                this.angleSpin.setEnabled(editableAngleValue);
                if (this.glyphPanel.selectedVertex == -2) {
                    this.glyphPanel.selectedVertex = -1;
                }
                this.glyphPanel.repaint();
            } else {
                this.angleSpin.setValue(new Double(0.0));
                this.orientable = false;
                this.angleSpin.setEnabled(false);
                if (this.glyphPanel.selectedVertex == -2) {
                    this.glyphPanel.selectedVertex = -1;
                }
                this.glyphPanel.repaint();
            }
        } else if (object == this.aliasChk) {
            if (this.aliasChk.isSelected()) {
                this.glyphPanel.setAntialiasing(true);
            } else {
                this.glyphPanel.setAntialiasing(false);
            }
        } else if (object == this.gridChk) {
            if (this.gridChk.isSelected()) {
                this.glyphPanel.setGrid(true);
            } else {
                this.glyphPanel.setGrid(false);
            }
        } else if (object == this.geomChk) {
            if (this.geomChk.isSelected()) {
                this.glyphPanel.setGeom(true);
            } else {
                this.glyphPanel.setGeom(false);
            }
        } else if (object == this.okBt) {
            Glyph glyph = this.instantiateGlyph((String)this.glList.getSelectedItem());
            this.gt.setGlyph(glyph);
            this.dispose();
        } else if (object == this.cancelBt) {
            this.gt.setGlyph(null);
            this.dispose();
        } else if (object == this.resetBt) {
            this.angle = defaultAngleValue;
            this.angleSpin.setValue(new Double(this.angle));
            this.size = defaultSizeValue;
            this.sizeSpin.setValue(new Integer((int)this.size));
            this.alpha = defaultAlphaValue;
            this.transpSpin.setValue(new Double(this.alpha));
            this.fillColor = defaultFillColor;
            this.ci1.setColor(this.fillColor);
            this.borderColor = defaultBorderColor;
            this.ci2.setColor(this.borderColor);
            this.vertices = defaultVertexValues;
            this.vxSpin.setValue(new Integer(this.vertices.length));
            this.glyphPanel.setColor(this.fillColor, this.borderColor);
            this.glyphPanel.setAngle(this.angle);
            this.glyphPanel.setTransparency(this.alpha);
            this.glyphPanel.setVertices(this.vertices);
        } else if (object == this.glList) {
            this.initUI((String)this.glList.getSelectedItem(), this.gridChk.isSelected(), this.aliasChk.isSelected(), this.geomChk.isSelected());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.transpSpin) {
            this.changeTransp((Double)this.transpSpin.getValue());
        } else if (object == this.vxSpin) {
            this.changeVertices((Integer)this.vxSpin.getValue());
        } else if (object == this.angleSpin) {
            this.changeOrient((Double)this.angleSpin.getValue());
        } else if (object == this.sizeSpin) {
            this.changeSize((Integer)this.sizeSpin.getValue());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.ci1 && editableFillColor) {
            this.changeFillColor(JColorChooser.showDialog(this, "Choose a New Fill Color", this.fillColor));
        } else if (object == this.ci2 && editableBorderColor) {
            this.changeBorderColor(JColorChooser.showDialog(this, "Choose a New Border Color", this.borderColor));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    static class DisposeOnClose
    extends ComponentAdapter {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getComponent();
            window.dispose();
        }
    }

    static class Closer
    extends WindowAdapter {
        Closer() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.hide();
        }
    }
}

