/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.SGlyph;

public class CGlyph
extends Glyph {
    public static short PRIMARY_GLYPH_ONLY = 0;
    public static short ALL_GLYPHS = 1;
    short compSensit = ALL_GLYPHS;
    Glyph pGlyph;
    SGlyph[] sGlyphs;

    public CGlyph(Glyph glyph, SGlyph[] sGlyphArray) {
        this.setPrimaryGlyph(glyph);
        if (sGlyphArray != null && sGlyphArray.length > 0) {
            this.sGlyphs = sGlyphArray;
            int n = 0;
            while (n < this.sGlyphs.length) {
                this.sGlyphs[n].g.moveTo(this.pGlyph.vx + this.sGlyphs[n].xoffset, this.pGlyph.vy + this.sGlyphs[n].yoffset);
                this.sGlyphs[n].g.setCGlyph(this);
                ++n;
            }
        }
    }

    public void initCams(int n) {
    }

    public void addCamera(int n) {
    }

    public void removeCamera(int n) {
    }

    public void resetMouseIn(int n) {
    }

    public void move(long l, long l2) {
        this.vx += l;
        this.vy += l2;
        this.pGlyph.move(l, l2);
        if (this.sGlyphs != null) {
            int n = 0;
            while (n < this.sGlyphs.length) {
                this.sGlyphs[n].g.move(l, l2);
                ++n;
            }
        }
        this.propagateMove(l, l2);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void moveTo(long l, long l2) {
        this.propagateMove(l - this.vx, l2 - this.vy);
        this.pGlyph.moveTo(l, l2);
        if (this.sGlyphs != null) {
            double d = -this.getOrient();
            int n = 0;
            while (n < this.sGlyphs.length) {
                if (this.sGlyphs[n].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[n].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                    long l3 = Math.round((double)this.sGlyphs[n].xoffset * Math.cos(d) + (double)this.sGlyphs[n].yoffset * Math.sin(d));
                    long l4 = Math.round((double)this.sGlyphs[n].yoffset * Math.cos(d) - (double)this.sGlyphs[n].xoffset * Math.sin(d));
                    this.sGlyphs[n].g.moveTo(this.pGlyph.vx + l3, this.pGlyph.vy + l4);
                } else {
                    this.sGlyphs[n].g.moveTo(l + this.sGlyphs[n].xoffset, l2 + this.sGlyphs[n].yoffset);
                }
                ++n;
            }
        }
        this.vx = this.pGlyph.vx;
        this.vy = this.pGlyph.vy;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getOrient() {
        if (this.pGlyph != null) {
            return this.pGlyph.getOrient();
        }
        return 0.0f;
    }

    public void orientTo(float f) {
        try {
            this.pGlyph.orientTo(f);
            if (this.sGlyphs != null) {
                double d = -f;
                int n = 0;
                while (n < this.sGlyphs.length) {
                    if (this.sGlyphs[n].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[n].rotationPolicy == SGlyph.ROTATION_ANGLE_ONLY) {
                        this.sGlyphs[n].g.orientTo(f + this.sGlyphs[n].aoffset);
                    }
                    if (this.sGlyphs[n].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[n].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                        long l = Math.round((double)this.sGlyphs[n].xoffset * Math.cos(d) + (double)this.sGlyphs[n].yoffset * Math.sin(d));
                        long l2 = Math.round((double)this.sGlyphs[n].yoffset * Math.cos(d) - (double)this.sGlyphs[n].xoffset * Math.sin(d));
                        this.sGlyphs[n].g.moveTo(this.pGlyph.vx + l, this.pGlyph.vy + l2);
                    }
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        if (this.pGlyph != null) {
            return this.pGlyph.getSize();
        }
        return 0.0f;
    }

    public void sizeTo(float f) {
        if (this.sGlyphs != null) {
            float f2 = f / this.getSize();
            double d = -this.getOrient();
            int n = 0;
            while (n < this.sGlyphs.length) {
                this.sGlyphs[n].xoffset = Math.round((float)this.sGlyphs[n].xoffset * f2);
                this.sGlyphs[n].yoffset = Math.round((float)this.sGlyphs[n].yoffset * f2);
                if (this.sGlyphs[n].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[n].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                    long l = Math.round((double)this.sGlyphs[n].xoffset * Math.cos(d) + (double)this.sGlyphs[n].yoffset * Math.sin(d));
                    long l2 = Math.round((double)this.sGlyphs[n].yoffset * Math.cos(d) - (double)this.sGlyphs[n].xoffset * Math.sin(d));
                    this.sGlyphs[n].g.moveTo(this.pGlyph.vx + l, this.pGlyph.vy + l2);
                } else {
                    this.sGlyphs[n].g.moveTo(this.pGlyph.vx + this.sGlyphs[n].xoffset, this.pGlyph.vy + this.sGlyphs[n].yoffset);
                }
                if (this.sGlyphs[n].sizePolicy == SGlyph.RESIZE) {
                    this.sGlyphs[n].g.reSize(f2);
                }
                ++n;
            }
        }
        this.pGlyph.sizeTo(f);
    }

    public void reSize(float f) {
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return false;
    }

    public int mouseInOut(int n, int n2, int n3) {
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
    }

    void textDraw(Graphics2D graphics2D, int n) {
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
    }

    public void setSensitivity(short s) {
        if (s != this.compSensit) {
            if (s == PRIMARY_GLYPH_ONLY && this.sGlyphs != null) {
                int n = 0;
                while (n < this.sGlyphs.length) {
                    this.sGlyphs[n].g.setSensitivity(false);
                    ++n;
                }
            } else if (s == ALL_GLYPHS && this.sGlyphs != null) {
                int n = 0;
                while (n < this.sGlyphs.length) {
                    this.sGlyphs[n].g.setSensitivity(true);
                    ++n;
                }
            }
            this.compSensit = s;
        }
    }

    public void setPrimaryGlyph(Glyph glyph) {
        this.pGlyph = glyph;
        glyph.setCGlyph(this);
        this.vx = this.pGlyph.vx;
        this.vy = this.pGlyph.vy;
    }

    public void addSecondaryGlyph(Glyph glyph, long l, long l2) {
        if (this.sGlyphs == null) {
            this.sGlyphs = new SGlyph[1];
            this.sGlyphs[0] = new SGlyph(glyph, l, l2);
            this.sGlyphs[0].g.moveTo(this.pGlyph.vx + this.sGlyphs[0].xoffset, this.pGlyph.vy + this.sGlyphs[0].yoffset);
        } else {
            SGlyph[] sGlyphArray = new SGlyph[this.sGlyphs.length + 1];
            System.arraycopy(this.sGlyphs, 0, sGlyphArray, 0, this.sGlyphs.length);
            sGlyphArray[sGlyphArray.length - 1] = new SGlyph(glyph, l, l2);
            this.sGlyphs = sGlyphArray;
            this.sGlyphs[this.sGlyphs.length - 1].g.moveTo(this.pGlyph.vx + this.sGlyphs[this.sGlyphs.length - 1].xoffset, this.pGlyph.vy + this.sGlyphs[this.sGlyphs.length - 1].yoffset);
        }
        glyph.setCGlyph(this);
    }

    public void addSecondaryGlyph(SGlyph sGlyph) {
        if (this.sGlyphs == null) {
            this.sGlyphs = new SGlyph[1];
            this.sGlyphs[0] = sGlyph;
            this.sGlyphs[0].g.moveTo(this.pGlyph.vx + this.sGlyphs[0].xoffset, this.pGlyph.vy + this.sGlyphs[0].yoffset);
            this.sGlyphs[0].g.setCGlyph(this);
        } else {
            SGlyph[] sGlyphArray = new SGlyph[this.sGlyphs.length + 1];
            System.arraycopy(this.sGlyphs, 0, sGlyphArray, 0, this.sGlyphs.length);
            sGlyphArray[sGlyphArray.length - 1] = sGlyph;
            this.sGlyphs = sGlyphArray;
            this.sGlyphs[this.sGlyphs.length - 1].g.moveTo(this.pGlyph.vx + this.sGlyphs[this.sGlyphs.length - 1].xoffset, this.pGlyph.vy + this.sGlyphs[this.sGlyphs.length - 1].yoffset);
            this.sGlyphs[this.sGlyphs.length - 1].g.setCGlyph(this);
        }
    }

    public void removeSecondaryGlyph(Glyph glyph) {
        if (this.sGlyphs != null) {
            int n = 0;
            while (n < this.sGlyphs.length) {
                if (this.sGlyphs[n].g == glyph) {
                    glyph.setCGlyph(null);
                    SGlyph[] sGlyphArray = new SGlyph[this.sGlyphs.length - 1];
                    System.arraycopy(this.sGlyphs, 0, sGlyphArray, 0, n);
                    System.arraycopy(this.sGlyphs, n + 1, sGlyphArray, n, this.sGlyphs.length - n - 1);
                    this.sGlyphs = sGlyphArray;
                    break;
                }
                ++n;
            }
            if (this.sGlyphs.length == 0) {
                this.sGlyphs = null;
            }
        }
    }

    public SGlyph getSGlyph(Glyph glyph) {
        SGlyph sGlyph = null;
        if (this.sGlyphs != null) {
            int n = 0;
            while (n < this.sGlyphs.length) {
                if (this.sGlyphs[n].g == glyph) {
                    sGlyph = this.sGlyphs[n];
                    break;
                }
                ++n;
            }
        }
        return sGlyph;
    }

    public SGlyph[] getSecondaryGlyphs() {
        return this.sGlyphs;
    }
}

