/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.fonts;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.claribole.zvtm.fonts.FontTracker;

public class FontDialog
extends JDialog
implements ActionListener {
    static String DEFAULT_FAMILY = "Dialog";
    static int DEFAULT_STYLE = 0;
    static int DEFAULT_SIZE = 10;
    FontTracker ft;
    JButton okBt;
    JButton cancelBt;
    JList familyList;
    JList styleList;
    JList sizeList;
    String[] allFontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    String[] allFontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    String[] allFontSizes = new String[]{"4", "6", "8", "10", "12", "14", "16", "18", "20", "24"};

    public static Font getFontDialog(Frame frame) {
        FontTracker fontTracker = new FontTracker();
        FontDialog fontDialog = new FontDialog(fontTracker, frame);
        fontDialog.addWindowListener(new Closer());
        fontDialog.addComponentListener(new DisposeOnClose());
        fontDialog.show();
        return fontTracker.getFont();
    }

    public static Font getFontDialog(Frame frame, Font font) {
        if (font != null) {
            DEFAULT_FAMILY = font.getFamily();
            DEFAULT_STYLE = font.getStyle();
            DEFAULT_SIZE = font.getSize();
        }
        FontTracker fontTracker = new FontTracker();
        FontDialog fontDialog = new FontDialog(fontTracker, frame);
        fontDialog.addWindowListener(new Closer());
        fontDialog.addComponentListener(new DisposeOnClose());
        fontDialog.show();
        return fontTracker.getFont();
    }

    public static Font decode(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            if (stringArray.length >= 3) {
                int n;
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
                String string2 = "";
                int n3 = 0;
                while (n3 < stringArray.length - 3) {
                    string2 = string2 + stringArray[n3] + " ";
                    ++n3;
                }
                String string3 = string2 = string2 + stringArray[stringArray.length - 3];
                if (string3 == null) {
                    string3 = DEFAULT_FAMILY;
                }
                String string4 = stringArray[stringArray.length - 2];
                String string5 = stringArray[stringArray.length - 1];
                int n4 = string4.equals("Bold") ? 1 : (string4.equals("Italic") ? 2 : (string4.equals("BoldItalic") ? 3 : 0));
                try {
                    n = Integer.parseInt(string5);
                    if (n <= 0) {
                        n = DEFAULT_SIZE;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n = DEFAULT_SIZE;
                }
                return new Font(string3, n4, n);
            }
            return new Font(DEFAULT_FAMILY, DEFAULT_STYLE, DEFAULT_SIZE);
        }
        return new Font(DEFAULT_FAMILY, DEFAULT_STYLE, DEFAULT_SIZE);
    }

    FontDialog(FontTracker fontTracker, Frame frame) {
        super(frame, "ZVTM Font Chooser", true);
        this.setLocation(frame.getLocation());
        this.ft = fontTracker;
        this.initUI();
    }

    void initUI() {
        Container container = this.getContentPane();
        try {
            this.okBt.removeActionListener(this);
            this.cancelBt.removeActionListener(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        container.removeAll();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.familyList = new JList<String>(this.allFontFamilies);
        JScrollPane jScrollPane = new JScrollPane(this.familyList);
        FontDialog.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 100);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this.styleList = new JList<String>(this.allFontStyles);
        JScrollPane jScrollPane2 = new JScrollPane(this.styleList);
        FontDialog.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 30, 0);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel.add(jScrollPane2);
        this.sizeList = new JList<String>(this.allFontSizes);
        JScrollPane jScrollPane3 = new JScrollPane(this.sizeList);
        FontDialog.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 25, 0);
        gridBagLayout.setConstraints(jScrollPane3, gridBagConstraints);
        jPanel.add(jScrollPane3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.okBt = new JButton("OK");
        this.okBt.addActionListener(this);
        jPanel2.add(this.okBt);
        this.cancelBt = new JButton("Cancel");
        this.cancelBt.addActionListener(this);
        jPanel2.add(this.cancelBt);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        container.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        FontDialog.buildConstraints(gridBagConstraints2, 0, 0, 1, 1, 100, 99);
        gridBagLayout2.setConstraints(jPanel, gridBagConstraints2);
        container.add(jPanel);
        FontDialog.buildConstraints(gridBagConstraints2, 0, 1, 1, 1, 100, 1);
        gridBagLayout2.setConstraints(jPanel2, gridBagConstraints2);
        container.add(jPanel2);
        this.setSize(350, 200);
        this.setResizable(false);
        this.familyList.setSelectedValue(DEFAULT_FAMILY, true);
        if (DEFAULT_STYLE == 0) {
            this.styleList.setSelectedValue("Plain", true);
        } else if (DEFAULT_STYLE == 1) {
            this.styleList.setSelectedValue("Bold", true);
        } else if (DEFAULT_STYLE == 2) {
            this.styleList.setSelectedValue("Italic", true);
        } else if (DEFAULT_STYLE == 3) {
            this.styleList.setSelectedValue("BoldItalic", true);
        }
        this.sizeList.setSelectedValue(new Integer(DEFAULT_SIZE).toString(), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okBt) {
            this.ft.setFont(this.getSelectedFont());
            this.dispose();
        } else if (object == this.cancelBt) {
            this.ft.setFont(null);
            this.dispose();
        }
    }

    Font getSelectedFont() {
        int n;
        String string;
        String string2 = (String)this.familyList.getSelectedValue();
        if (string2 == null) {
            string2 = DEFAULT_FAMILY;
        }
        int n2 = (string = (String)this.styleList.getSelectedValue()).equals("Bold") ? 1 : (string.equals("Italic") ? 2 : (string.equals("BoldItalic") ? 3 : 0));
        try {
            String string3 = (String)this.sizeList.getSelectedValue();
            n = Integer.parseInt(string3);
            if (n <= 0) {
                n = DEFAULT_SIZE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = DEFAULT_SIZE;
        }
        return new Font(string2, n2, n);
    }

    static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public static String getFontStyleName(int n) {
        if (n == 1) {
            return "Bold";
        }
        if (n == 2) {
            return "Italic";
        }
        if (n == 3) {
            return "BoldItalic";
        }
        return "Plain";
    }

    static class DisposeOnClose
    extends ComponentAdapter {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getComponent();
            window.dispose();
        }
    }

    static class Closer
    extends WindowAdapter {
        Closer() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.hide();
        }
    }
}

