/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjPolygon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class VPolygon
extends Glyph {
    long vs;
    ProjPolygon[] pc;
    long[] xcoords;
    long[] ycoords;

    public VPolygon(LongPoint[] longPointArray, Color color) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.xcoords = new long[longPointArray.length];
        this.ycoords = new long[longPointArray.length];
        int n = 0;
        while (n < longPointArray.length) {
            this.xcoords[n] = longPointArray[n].x;
            this.ycoords[n] = longPointArray[n].y;
            ++n;
        }
        this.orient = 0.0f;
        LongPoint longPoint = this.getCentroid();
        this.vx = longPoint.x;
        this.vy = longPoint.y;
        int n2 = 0;
        while (n2 < this.xcoords.length) {
            int n3 = n2;
            this.xcoords[n3] = this.xcoords[n3] - this.vx;
            int n4 = n2++;
            this.ycoords[n4] = this.ycoords[n4] - this.vy;
        }
        this.computeSize();
        this.setRGBColor(color);
        this.setRGBBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjPolygon[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjPolygon(this.xcoords.length);
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjPolygon[] projPolygonArray = this.pc;
                this.pc = new ProjPolygon[projPolygonArray.length + 1];
                int n2 = 0;
                while (n2 < projPolygonArray.length) {
                    this.pc[n2] = projPolygonArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjPolygon(this.xcoords.length);
            } else {
                System.err.println("VPolygon:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjPolygon[1];
            this.pc[0] = new ProjPolygon(this.xcoords.length);
        } else {
            System.err.println("VPolygon:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = 0.0f;
        int n = 0;
        while (n < this.xcoords.length) {
            double d = Math.sqrt(Math.pow(this.xcoords[n], 2.0) + Math.pow(this.ycoords[n], 2.0));
            if (d > (double)this.size) {
                this.size = (float)d;
            }
            ++n;
        }
        this.vs = Math.round(this.size);
    }

    public void sizeTo(float f) {
    }

    public void reSize(float f) {
    }

    public boolean fillsView(long l, long l2, int n) {
        return this.pc[n].p.contains(0, 0) && this.pc[n].p.contains(l, 0.0) && this.pc[n].p.contains(0.0, l2) && this.pc[n].p.contains(l, l2);
    }

    public boolean coordInside(int n, int n2, int n3) {
        return this.pc[n3].p.contains(n, n2);
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public LongPoint[] getVertices() {
        LongPoint[] longPointArray = new LongPoint[this.xcoords.length];
        int n = 0;
        while (n < this.xcoords.length) {
            longPointArray[n] = new LongPoint(this.xcoords[n], this.ycoords[n]);
            ++n;
        }
        return longPointArray;
    }

    public String getVerticesAsText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.xcoords.length) {
            stringBuffer.append(this.xcoords[n] + "," + this.ycoords[n] + " ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cs = Math.round((float)this.vs * this.coef);
        int n2 = 0;
        while (n2 < this.xcoords.length) {
            this.pc[n].xpcoords[n2] = Math.round((float)this.pc[n].cx + (float)this.xcoords[n2] * this.coef);
            this.pc[n].ypcoords[n2] = Math.round((float)this.pc[n].cy - (float)this.ycoords[n2] * this.coef);
            ++n2;
        }
        this.pc[n].p = new Polygon(this.pc[n].xpcoords, this.pc[n].ypcoords, this.xcoords.length);
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].cs) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].cs) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cs > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fillPolygon(this.pc[n3].p);
            }
            graphics2D.setColor(this.borderColor);
            if (this.paintBorder) {
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.drawPolygon(this.pc[n3].p);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.drawPolygon(this.pc[n3].p);
                }
            }
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }

    public double getArea() {
        long[] lArray = new long[this.xcoords.length];
        long[] lArray2 = new long[this.ycoords.length];
        int n = 0;
        while (n < this.xcoords.length) {
            lArray[n] = this.vx + this.xcoords[n];
            lArray2[n] = this.vy + this.ycoords[n];
            ++n;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.xcoords.length) {
            int n3 = (n2 + 1) % this.xcoords.length;
            d += (double)(lArray[n2] * lArray2[n3] - lArray2[n2] * lArray[n3]);
            ++n2;
        }
        return (d /= 2.0) < 0.0 ? -d : d;
    }

    public Point2D.Double getPreciseCentroid() {
        int n;
        long[] lArray = new long[this.xcoords.length];
        long[] lArray2 = new long[this.ycoords.length];
        int n2 = 0;
        while (n2 < this.xcoords.length) {
            lArray[n2] = this.vx + this.xcoords[n2];
            lArray2[n2] = this.vy + this.ycoords[n2];
            ++n2;
        }
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.xcoords.length) {
            n = (n3 + 1) % this.xcoords.length;
            d += (double)(lArray[n3] * lArray2[n] - lArray2[n3] * lArray[n]);
            ++n3;
        }
        d /= 2.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        n3 = 0;
        while (n3 < this.xcoords.length) {
            n = (n3 + 1) % this.xcoords.length;
            d2 = lArray[n3] * lArray2[n] - lArray[n] * lArray2[n3];
            d3 += (double)(lArray[n3] + lArray[n]) * d2;
            d4 += (double)(lArray2[n3] + lArray2[n]) * d2;
            ++n3;
        }
        d2 = 1.0 / (d *= 6.0);
        Point2D.Double double_ = new Point2D.Double(d3 *= d2, d4 *= d2);
        return double_;
    }

    public LongPoint getCentroid() {
        Point2D.Double double_ = this.getPreciseCentroid();
        return new LongPoint(Math.round(double_.getX()), Math.round(double_.getY()));
    }
}

