/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjImage;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VImage
extends Glyph
implements RectangularShape {
    long vw;
    long vh;
    float ar;
    AffineTransform at;
    int drawBorder = 0;
    ProjImage[] pc;
    Image image;
    boolean zoomSensitive = true;
    float scaleFactor = 1.0f;
    float trueCoef = 1.0f;

    public VImage(Image image) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0.0f;
        this.image = image;
        this.vw = this.image.getWidth(null) / 2;
        this.vh = this.image.getHeight(null) / 2;
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        this.orient = 0.0f;
        this.setRGBColor(Color.black);
        this.setRGBBorderColor(Color.black);
    }

    public VImage(long l, long l2, float f, Image image) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.image = image;
        this.vw = Math.round((double)this.image.getWidth(null) / 2.0);
        this.vh = Math.round((double)this.image.getHeight(null) / 2.0);
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        this.orient = 0.0f;
        this.setRGBColor(Color.black);
        this.setRGBBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjImage[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjImage();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjImage[] projImageArray = this.pc;
                this.pc = new ProjImage[projImageArray.length + 1];
                int n2 = 0;
                while (n2 < projImageArray.length) {
                    this.pc[n2] = projImageArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjImage();
            } else {
                System.err.println("VImage:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjImage[1];
            this.pc[0] = new ProjImage();
        } else {
            System.err.println("VImage:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.vw, 2.0) + Math.pow(this.vh, 2.0));
    }

    public void setWidth(long l) {
    }

    public void setHeight(long l) {
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    public void sizeTo(float f) {
        this.size = f;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float f) {
        this.size *= f;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.vw = Math.round((double)this.image.getWidth(null) / 2.0);
        this.vh = Math.round((double)this.image.getHeight(null) / 2.0);
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setZoomSensitive(boolean bl) {
        if (this.zoomSensitive != bl) {
            this.zoomSensitive = bl;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean isZoomSensitive() {
        return this.zoomSensitive;
    }

    public void setDrawBorderPolicy(int n) {
        if (this.drawBorder != n) {
            this.drawBorder = n;
            try {
                this.vsm.repaintNow();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return n >= this.pc[n3].cx - this.pc[n3].cw && n <= this.pc[n3].cx + this.pc[n3].cw && n2 >= this.pc[n3].cy - this.pc[n3].ch && n2 <= this.pc[n3].cy + this.pc[n3].ch;
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        if (this.zoomSensitive) {
            this.pc[n].cw = Math.round((float)this.vw * this.coef);
            this.pc[n].ch = Math.round((float)this.vh * this.coef);
        } else {
            this.pc[n].cw = (int)this.vw;
            this.pc[n].ch = (int)this.vh;
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cw > 1 && this.pc[n3].ch > 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                graphics2D.setTransform(AffineTransform.getTranslateInstance(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch));
                graphics2D.drawImage(this.image, AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef), null);
                graphics2D.setTransform(affineTransform);
                if (this.drawBorder == 1) {
                    if (this.pc[n3].prevMouseIn) {
                        graphics2D.setColor(this.borderColor);
                        graphics2D.drawRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, 2 * this.pc[n3].cw - 1, 2 * this.pc[n3].ch - 1);
                    }
                } else if (this.drawBorder == 2) {
                    graphics2D.setColor(this.borderColor);
                    graphics2D.drawRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, 2 * this.pc[n3].cw - 1, 2 * this.pc[n3].ch - 1);
                }
            } else {
                graphics2D.drawImage(this.image, this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, null);
                if (this.drawBorder == 1) {
                    if (this.pc[n3].prevMouseIn) {
                        graphics2D.setColor(this.borderColor);
                        graphics2D.drawRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, 2 * this.pc[n3].cw - 1, 2 * this.pc[n3].ch - 1);
                    }
                } else if (this.drawBorder == 2) {
                    graphics2D.setColor(this.borderColor);
                    graphics2D.drawRect(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, 2 * this.pc[n3].cw - 1, 2 * this.pc[n3].ch - 1);
                }
            }
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }
}

