/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjCbCurve;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VCbCurve
extends Glyph {
    long vs;
    long vrad1;
    float ang1;
    long vrad2;
    float ang2;
    ProjCbCurve[] pc;

    public VCbCurve(long l, long l2, float f, long l3, Color color, float f2, long l4, float f3, long l5, float f4) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vs = l3;
        this.sensit = false;
        this.orient = f2;
        this.vrad1 = l4;
        this.ang1 = f3;
        this.vrad2 = l5;
        this.ang2 = f4;
        this.computeSize();
        this.filled = false;
        this.setRGBColor(color);
        this.setRGBBorderColor(this.bColor);
    }

    public void setCtrlPoint1(long l, float f) {
        this.vrad1 = l;
        this.ang1 = f;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setCtrlPoint2(long l, float f) {
        this.vrad2 = l;
        this.ang2 = f;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long getCtrlPointRadius1() {
        return this.vrad1;
    }

    public float getCtrlPointAngle1() {
        return this.ang1;
    }

    public long getCtrlPointRadius2() {
        return this.vrad2;
    }

    public float getCtrlPointAngle2() {
        return this.ang2;
    }

    public void initCams(int n) {
        this.pc = new ProjCbCurve[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjCbCurve();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjCbCurve[] projCbCurveArray = this.pc;
                this.pc = new ProjCbCurve[projCbCurveArray.length + 1];
                int n2 = 0;
                while (n2 < projCbCurveArray.length) {
                    this.pc[n2] = projCbCurveArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjCbCurve();
            } else {
                System.err.println("VCbCurve:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjCbCurve[1];
            this.pc[0] = new ProjCbCurve();
        } else {
            System.err.println("VCbCurve:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
        this.orient = f;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vs;
    }

    public void sizeTo(float f) {
        this.vrad1 = Math.round((float)this.vrad1 * f / this.size);
        this.vrad2 = Math.round((float)this.vrad2 * f / this.size);
        this.size = f;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float f) {
        this.size *= f;
        this.vs = Math.round(this.size);
        this.vrad1 = Math.round((float)this.vrad1 * f);
        this.vrad2 = Math.round((float)this.vrad2 * f);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long l, long l2, int n) {
        return false;
    }

    public boolean coordInside(int n, int n2, int n3) {
        return false;
    }

    public int mouseInOut(int n, int n2, int n3) {
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cs = Math.round((float)this.vs * this.coef);
        if (this.pc[n].cs > 1) {
            this.pc[n].start.setLocation((double)this.pc[n].cx + (double)this.pc[n].cs * Math.cos(this.orient), (double)this.pc[n].cy + (double)this.pc[n].cs * Math.sin(this.orient));
            this.pc[n].end.setLocation((double)this.pc[n].cx - (double)this.pc[n].cs * Math.cos(this.orient), (double)this.pc[n].cy - (double)this.pc[n].cs * Math.sin(this.orient));
            this.pc[n].ctrlStart.setLocation(this.pc[n].start.x + (double)((int)Math.round((double)(this.coef * (float)this.vrad1) * Math.cos(this.orient - this.ang1))), this.pc[n].start.y + (double)((int)Math.round((double)(this.coef * (float)this.vrad1) * Math.sin(this.orient - this.ang1))));
            this.pc[n].ctrlEnd.setLocation(this.pc[n].end.x + (double)((int)Math.round((double)(this.coef * (float)this.vrad2) * Math.cos(this.orient - this.ang2))), this.pc[n].end.y + (double)((int)Math.round((double)(this.coef * (float)this.vrad2) * Math.sin(this.orient - this.ang2))));
            this.pc[n].quad.setCurve(this.pc[n].start, this.pc[n].ctrlStart, this.pc[n].ctrlEnd, this.pc[n].end);
        }
    }

    void textDraw(Graphics2D graphics2D, int n) {
        if (this.fontSizePolicy >= 0 && this.text != null && !this.text.equals("")) {
            this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
            if (this.fontSizePolicy == 1 || this.fontSizePolicy == 0 && this.textWidth < 2 * this.pc[n].cs) {
                if (this.textPos == 1) {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                } else if (this.textPos == -1) {
                    this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                } else {
                    graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                }
            } else if (this.fontSizePolicy == 2) {
                Font font = new Font(graphics2D.getFont().getName(), graphics2D.getFont().getStyle(), graphics2D.getFont().getSize());
                int n2 = 1;
                while (this.textWidth > 2 * this.pc[n].cs) {
                    n2 = graphics2D.getFont().getSize() - 2;
                    if (n2 < 0) {
                        n2 = 0;
                        break;
                    }
                    graphics2D.setFont(new Font(font.getName(), font.getStyle(), n2));
                    this.textWidth = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getWidth();
                }
                if (n2 > 0) {
                    if (this.textPos == 1) {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy - this.pc[n].cs - 4);
                    } else if (this.textPos == -1) {
                        this.textHeight = (int)graphics2D.getFontMetrics().getStringBounds(this.text, graphics2D).getHeight();
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy + this.pc[n].cs + this.textHeight);
                    } else {
                        graphics2D.drawString(this.text, this.pc[n].cx - this.textWidth / 2, this.pc[n].cy);
                    }
                }
                graphics2D.setFont(font);
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cs > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fill(this.pc[n3].quad);
                graphics2D.setColor(this.borderColor);
                graphics2D.drawLine((int)this.pc[n3].start.x, (int)this.pc[n3].start.y, (int)this.pc[n3].end.x, (int)this.pc[n3].end.y);
            } else {
                graphics2D.setColor(this.color);
            }
            if (this.stroke != null) {
                graphics2D.setStroke(this.stroke);
                graphics2D.draw(this.pc[n3].quad);
                graphics2D.setStroke(stroke);
            } else {
                graphics2D.draw(this.pc[n3].quad);
            }
            this.textDraw(graphics2D, n3);
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }
}

