/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AppEventHandler;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VText;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class VCursor {
    Long ID;
    Color color;
    boolean isVisible = true;
    boolean sensit = true;
    boolean sync;
    int cx;
    int cy;
    public long vx;
    public long vy;
    long pvx;
    long pvy;
    int mx;
    int my;
    Glyph tmpGlyph;
    int tmpRes;
    Long tmpID;
    int maxIndex = -1;
    public Glyph[] glyphsUnderMouse = new Glyph[50];
    public Glyph lastGlyphEntered = null;
    Vector stickedGlyphs;
    View owningView;

    VCursor(View view) {
        this.owningView = view;
        this.vx = 0L;
        this.pvx = 0L;
        this.vy = 0L;
        this.pvy = 0L;
        this.cx = 0;
        this.cy = 0;
        this.mx = 0;
        this.my = 0;
        this.color = Color.black;
        this.stickedGlyphs = new Vector();
        this.sync = true;
    }

    public Long getID() {
        return this.ID;
    }

    public void setID(Long l) {
        this.ID = l;
    }

    public LongPoint getLocation() {
        return new LongPoint(this.vx, this.vy);
    }

    public View getOwningView() {
        return this.owningView;
    }

    public void setSync(boolean bl) {
        this.sync = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void moveTo(int n, int n2) {
        if (this.sync) {
            this.mx = n;
            this.my = n2;
        }
    }

    public void propagateMove() {
        Enumeration enumeration = this.stickedGlyphs.elements();
        while (enumeration.hasMoreElements()) {
            ((Glyph)enumeration.nextElement()).move(this.vx - this.pvx, this.vy - this.pvy);
        }
    }

    void stick(Glyph glyph) {
        if (glyph != null) {
            glyph.setSensitivity(false);
            this.stickedGlyphs.add(glyph);
            glyph.stickedTo = this;
        }
    }

    void unstick() {
        if (this.stickedGlyphs.size() > 0) {
            Glyph glyph = (Glyph)this.stickedGlyphs.lastElement();
            glyph.setSensitivity(true);
            glyph.stickedTo = null;
            this.stickedGlyphs.removeElementAt(this.stickedGlyphs.size() - 1);
        }
    }

    public int getStickedGlyphsNumber() {
        return this.stickedGlyphs.size();
    }

    void unstickSpecificGlyph(Glyph glyph) {
        if (this.stickedGlyphs.size() > 0) {
            glyph.stickedTo = null;
            this.stickedGlyphs.remove(glyph);
        }
    }

    public Vector getStickedGlyphs() {
        return this.stickedGlyphs;
    }

    public void setVisibility(boolean bl) {
        this.isVisible = bl;
    }

    public void setSensitivity(boolean bl) {
        this.sensit = bl;
    }

    public boolean isSensitive() {
        return this.sensit;
    }

    public Vector getIntersectingPaths(Camera camera) {
        Vector<Glyph> vector = new Vector<Glyph>();
        Enumeration enumeration = camera.getOwningSpace().getDrawnGlyphs().elements();
        while (enumeration.hasMoreElements()) {
            Glyph glyph = (Glyph)enumeration.nextElement();
            if (!(glyph instanceof VPath) || !this.intersectsVPath((VPath)glyph)) continue;
            vector.add(glyph);
        }
        if (vector.isEmpty()) {
            vector = null;
        }
        return vector;
    }

    public boolean intersectsVPath(VPath vPath) {
        boolean bl = vPath.getJava2DGeneralPath().intersects(this.vx - 10L, -this.vy - 10L, 10.0, 10.0);
        if (vPath.getJava2DGeneralPath().contains(this.vx - 5L, -this.vy - 5L, 5.0, 5.0)) {
            bl = false;
        }
        return bl;
    }

    public Vector getIntersectingTexts(Camera camera) {
        Vector<Glyph> vector = new Vector<Glyph>();
        int n = camera.getIndex();
        Enumeration enumeration = camera.getOwningSpace().getDrawnGlyphs().elements();
        while (enumeration.hasMoreElements()) {
            Glyph glyph = (Glyph)enumeration.nextElement();
            if (!(glyph instanceof VText) || !this.intersectsVText((VText)glyph, n)) continue;
            vector.add(glyph);
        }
        if (vector.isEmpty()) {
            vector = null;
        }
        return vector;
    }

    public boolean intersectsVText(VText vText, int n) {
        boolean bl = false;
        LongPoint longPoint = vText.getBounds(n);
        if (vText.getTextAnchor() == VText.TEXT_ANCHOR_START) {
            if (this.vx >= vText.vx && this.vy >= vText.vy && this.vx <= vText.vx + longPoint.x && this.vy <= vText.vy + longPoint.y) {
                bl = true;
            }
        } else if (vText.getTextAnchor() == VText.TEXT_ANCHOR_MIDDLE) {
            if (this.vx >= vText.vx - longPoint.x / 2L && this.vy >= vText.vy && this.vx <= vText.vx + longPoint.x / 2L && this.vy <= vText.vy + longPoint.y) {
                bl = true;
            }
        } else if (this.vx <= vText.vx && this.vy >= vText.vy && this.vx >= vText.vx - longPoint.x && this.vy <= vText.vy + longPoint.y) {
            bl = true;
        }
        return bl;
    }

    void doubleCapacity() {
        Glyph[] glyphArray = new Glyph[this.glyphsUnderMouse.length * 2];
        System.arraycopy(this.glyphsUnderMouse, 0, glyphArray, 0, this.glyphsUnderMouse.length);
        this.glyphsUnderMouse = glyphArray;
    }

    void resetGlyphsUnderMouseList(VirtualSpace virtualSpace, int n) {
        int n2 = 0;
        while (n2 < this.glyphsUnderMouse.length) {
            this.glyphsUnderMouse[n2] = null;
            this.maxIndex = -1;
            ++n2;
        }
        this.lastGlyphEntered = null;
        Vector vector = virtualSpace.getVisibleGlyphs();
        int n3 = 0;
        while (n3 < vector.size()) {
            Glyph glyph = (Glyph)vector.elementAt(n3);
            glyph.resetMouseIn(n);
            glyph.borderColor = glyph.bColor;
            ++n3;
        }
    }

    public Vector getGlyphsUnderMouse() {
        Vector<Glyph> vector = new Vector<Glyph>();
        int n = 0;
        while (n <= this.maxIndex) {
            vector.add(this.glyphsUnderMouse[n]);
            ++n;
        }
        return vector;
    }

    void removeGlyphFromList(Glyph glyph) {
        int n = 0;
        boolean bl = false;
        while (n <= this.maxIndex) {
            if (this.glyphsUnderMouse[n++] != glyph) continue;
            bl = true;
            break;
        }
        while (n <= this.maxIndex) {
            this.glyphsUnderMouse[n - 1] = this.glyphsUnderMouse[n];
            ++n;
        }
        if (bl) {
            --this.maxIndex;
            if (this.maxIndex < 0) {
                this.lastGlyphEntered = null;
                this.maxIndex = -1;
            } else {
                this.lastGlyphEntered = this.glyphsUnderMouse[this.maxIndex];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean computeMouseOverList(AppEventHandler appEventHandler, Camera camera) {
        boolean bl = false;
        Vector vector = camera.getOwningSpace().getDrawnGlyphs();
        synchronized (vector) {
            block14: {
                try {
                    Enumeration enumeration = camera.getOwningSpace().getDrawnGlyphs().elements();
                    while (enumeration.hasMoreElements()) {
                        this.tmpGlyph = (Glyph)enumeration.nextElement();
                        if (!this.tmpGlyph.isSensitive()) continue;
                        this.tmpRes = this.tmpGlyph.mouseInOut(this.mx, this.my, camera.getIndex());
                        if (this.tmpRes == 1) {
                            this.tmpID = this.tmpGlyph.getID();
                            ++this.maxIndex;
                            if (this.maxIndex >= this.glyphsUnderMouse.length) {
                                this.doubleCapacity();
                            }
                            this.glyphsUnderMouse[this.maxIndex] = this.tmpGlyph;
                            this.lastGlyphEntered = this.tmpGlyph;
                            appEventHandler.enterGlyph(this.tmpGlyph);
                            bl = true;
                            continue;
                        }
                        if (this.tmpRes != -1) continue;
                        this.tmpID = this.tmpGlyph.getID();
                        int n = 0;
                        while (n <= this.maxIndex) {
                            if (this.glyphsUnderMouse[n++] == this.tmpGlyph) break;
                        }
                        while (n <= this.maxIndex) {
                            this.glyphsUnderMouse[n - 1] = this.glyphsUnderMouse[n];
                            ++n;
                        }
                        --this.maxIndex;
                        if (this.maxIndex < 0) {
                            this.lastGlyphEntered = null;
                            this.maxIndex = -1;
                        } else {
                            this.lastGlyphEntered = this.glyphsUnderMouse[this.maxIndex];
                        }
                        appEventHandler.exitGlyph(this.tmpGlyph);
                        bl = true;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (this.owningView.parent.debug) {
                        System.err.println("vcursor.computemouseoverlist " + noSuchElementException);
                        noSuchElementException.printStackTrace();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (!this.owningView.parent.debug) break block14;
                    System.err.println("vcursor.computemouseoverlist null " + nullPointerException + " (This might be caused by an error in enterGlyph/exitGlyph in your event handler)");
                    nullPointerException.printStackTrace();
                }
            }
        }
        return bl;
    }

    public void printList() {
        System.err.print("[");
        int n = 0;
        while (n <= this.maxIndex) {
            System.err.print(this.glyphsUnderMouse[n].getID().toString() + ",");
            ++n;
        }
        System.err.println("]");
    }

    void unProject(Camera camera, ViewPanel viewPanel) {
        if (this.sync) {
            this.cx = this.mx - viewPanel.getSize().width / 2;
            this.cy = -this.my + viewPanel.getSize().height / 2;
            float f = (camera.focal + camera.altitude) / camera.focal;
            this.pvx = this.vx;
            this.pvy = this.vy;
            this.vx = Math.round((float)this.cx * f + (float)camera.posx);
            this.vy = Math.round((float)this.cy * f + (float)camera.posy);
        }
    }

    public void draw(Graphics2D graphics2D) {
        if (this.isVisible) {
            graphics2D.setColor(this.color);
            graphics2D.drawLine(this.mx - 10, this.my, this.mx + 10, this.my);
            graphics2D.drawLine(this.mx, this.my - 10, this.mx, this.my + 10);
        }
    }
}

