/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.GAnimation;
import com.xerox.VTM.glyphs.Glyph;
import java.util.Date;

class GColoration
extends GAnimation {
    float[][] steps;
    boolean border;

    GColoration(Glyph glyph, AnimManager animManager, long l, boolean bl) {
        this.started = false;
        this.target = glyph;
        this.parent = animManager;
        this.duration = l;
        this.border = bl;
        this.type = AnimManager.GL_COLOR;
    }

    void start() {
        this.now = new Date();
        this.startTime = this.now.getTime();
        this.started = true;
    }

    boolean animate() {
        if (this.started) {
            this.now = new Date();
            this.progression = (double)(this.now.getTime() - this.startTime) / (double)this.duration;
            this.step = (int)Math.round((double)this.steps.length * this.progression);
            if (this.step < this.steps.length) {
                if (this.border) {
                    this.target.setHSVbColor(this.steps[this.step][0], this.steps[this.step][1], this.steps[this.step][2]);
                } else {
                    this.target.setHSVColor(this.steps[this.step][0], this.steps[this.step][1], this.steps[this.step][2]);
                }
            } else {
                if (this.border) {
                    this.target.setHSVbColor(this.steps[this.steps.length - 1][0], this.steps[this.steps.length - 1][1], this.steps[this.steps.length - 1][2]);
                } else {
                    this.target.setHSVColor(this.steps[this.steps.length - 1][0], this.steps[this.steps.length - 1][1], this.steps[this.steps.length - 1][2]);
                }
                this.parent.killGAnim(this, this.type);
            }
            return true;
        }
        return false;
    }

    protected void conclude() {
        if (this.border) {
            this.target.setHSVbColor(this.steps[this.steps.length - 1][0], this.steps[this.steps.length - 1][1], this.steps[this.steps.length - 1][2]);
        } else {
            this.target.setHSVColor(this.steps[this.steps.length - 1][0], this.steps[this.steps.length - 1][1], this.steps[this.steps.length - 1][2]);
        }
    }
}

