/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.UCharacterIterator;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import java.util.Locale;

class UppercaseTransliterator
extends Transliterator {
    static final String _ID = "Any-Upper";
    private Locale loc;
    private char[] buffer = new char[10];
    private static final UCharacterProperty m_charppty_ = UCharacterProperty.getInstance();

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return new UppercaseTransliterator(Locale.US);
            }
        });
    }

    public UppercaseTransliterator(Locale loc) {
        super(_ID, null);
        this.loc = loc;
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        int textPos = offsets.start;
        if (textPos >= offsets.limit) {
            return;
        }
        UCharacterIterator original = new UCharacterIterator(text);
        int limit = offsets.limit;
        while (textPos < limit) {
            original.setIndex(textPos);
            int cp = original.currentCodePoint();
            int oldLen = UTF16.getCharCount(cp);
            int newLen = m_charppty_.toUpperOrTitleCase(this.loc, cp, original, true, this.buffer);
            if (newLen >= 0) {
                text.replace(textPos, textPos + oldLen, this.buffer, 0, newLen);
                if (newLen != oldLen) {
                    textPos += newLen;
                    offsets.limit += newLen - oldLen;
                    offsets.contextLimit += newLen - oldLen;
                    continue;
                }
            }
            textPos += oldLen;
        }
        offsets.start = offsets.limit;
    }
}

