/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.UnicodeSet;
import java.util.Iterator;

public final class UnicodeSetIterator {
    public static int IS_STRING = -1;
    public int codepoint;
    public int codepointEnd;
    public String string;
    private UnicodeSet set;
    private int endRange = 0;
    private int range = 0;
    private int startElement = 0;
    private int endElement;
    private int nextElement;
    private boolean abbreviated = false;
    private Iterator stringIterator = null;

    public UnicodeSetIterator(UnicodeSet set) {
        this.reset(set);
    }

    public UnicodeSetIterator() {
        this.reset(new UnicodeSet());
    }

    public boolean next() {
        if (this.nextElement <= this.endElement) {
            this.codepointEnd = this.nextElement++;
            this.codepoint = this.codepointEnd;
            return true;
        }
        if (this.range < this.endRange) {
            ++this.range;
            this.nextElement = this.startElement = this.set.getRangeStart(this.range);
            this.endElement = this.set.getRangeEnd(this.range);
            if (this.abbreviated && this.endElement > this.startElement + 50) {
                this.endElement = this.startElement + 50;
            }
            this.codepointEnd = this.nextElement++;
            this.codepoint = this.codepointEnd;
            return true;
        }
        if (this.stringIterator == null) {
            return false;
        }
        this.codepoint = IS_STRING;
        this.string = (String)this.stringIterator.next();
        if (!this.stringIterator.hasNext()) {
            this.stringIterator = null;
        }
        return true;
    }

    public boolean nextRange() {
        if (this.nextElement <= this.endElement) {
            this.codepointEnd = this.endElement;
            this.codepoint = this.nextElement;
            this.nextElement = this.endElement + 1;
            return true;
        }
        if (this.range < this.endRange) {
            ++this.range;
            this.nextElement = this.startElement = this.set.getRangeStart(this.range);
            this.endElement = this.set.getRangeEnd(this.range);
            if (this.abbreviated && this.endElement > this.startElement + 50) {
                this.endElement = this.startElement + 50;
            }
            this.codepointEnd = this.endElement;
            this.codepoint = this.nextElement;
            this.nextElement = this.endElement + 1;
            return true;
        }
        if (this.stringIterator == null) {
            return false;
        }
        this.codepoint = IS_STRING;
        this.string = (String)this.stringIterator.next();
        if (!this.stringIterator.hasNext()) {
            this.stringIterator = null;
        }
        return true;
    }

    public void reset(UnicodeSet set) {
        this.set = set;
        this.endRange = set.getRangeCount() - 1;
        this.resetInternal();
    }

    public void reset() {
        this.endRange = this.set.getRangeCount() - 1;
        this.resetInternal();
    }

    public void setAbbreviated(boolean abbr) {
        this.abbreviated = abbr;
    }

    public boolean getAbbreviated() {
        return this.abbreviated;
    }

    private void resetInternal() {
        this.range = 0;
        this.endElement = -1;
        this.nextElement = 0;
        if (this.endRange >= 0) {
            this.nextElement = this.startElement = this.set.getRangeStart(this.range);
            this.endElement = this.set.getRangeEnd(this.range);
            if (this.abbreviated && this.endElement > this.startElement + 50) {
                this.endElement = this.startElement + 50;
            }
        }
        this.stringIterator = null;
        if (this.set.strings != null) {
            this.stringIterator = this.set.strings.iterator();
            if (!this.stringIterator.hasNext()) {
                this.stringIterator = null;
            }
        }
    }
}

