/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.UnicodeFilter;

public final class UnicodeFilterLogic {
    public static UnicodeFilter not(final UnicodeFilter f) {
        return new UnicodeFilter(){

            public boolean contains(int c) {
                return !f.contains(c);
            }
        };
    }

    public static UnicodeFilter and(final UnicodeFilter f, final UnicodeFilter g) {
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        return new UnicodeFilter(){

            public boolean contains(int c) {
                return f.contains(c) && g.contains(c);
            }
        };
    }

    public static UnicodeFilter and(final UnicodeFilter[] f) {
        return new UnicodeFilter(){

            public boolean contains(int c) {
                int i = 0;
                while (i < f.length) {
                    if (!f[i].contains(c)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
    }

    public static UnicodeFilter or(final UnicodeFilter f, final UnicodeFilter g) {
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        return new UnicodeFilter(){

            public boolean contains(int c) {
                return f.contains(c) || g.contains(c);
            }
        };
    }

    public static UnicodeFilter or(final UnicodeFilter[] f) {
        return new UnicodeFilter(){

            public boolean contains(int c) {
                int i = 0;
                while (i < f.length) {
                    if (f[i].contains(c)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
    }
}

