/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;

public abstract class SearchIterator {
    public static final int DONE = -1;
    private static final int BEFORE = -2;
    private int index;
    private int length;
    private boolean overlap = true;
    private CharacterIterator target;
    private BreakIterator breaker;

    public final int first() {
        this.setIndex(-2);
        return this.next();
    }

    public final int following(int pos) {
        this.setIndex(pos);
        return this.next();
    }

    public final int last() {
        this.setIndex(-1);
        return this.previous();
    }

    public final int preceding(int pos) {
        this.setIndex(pos);
        return this.previous();
    }

    public int next() {
        if (this.index == -2) {
            this.index = this.target.getBeginIndex();
        } else if (this.length > 0) {
            this.index += this.overlap ? 1 : this.length;
        }
        --this.index;
        do {
            this.length = 0;
            this.index = this.handleNext(this.index + 1);
        } while (this.index != -1 && !this.isBreakUnit(this.index, this.index + this.length));
        return this.index;
    }

    public int previous() {
        if (this.index == -1) {
            this.index = this.target.getEndIndex();
        } else if (this.length > 0) {
            this.index = this.overlap ? this.index + this.length - 1 : this.index;
        }
        ++this.index;
        do {
            this.length = 0;
            this.index = this.handlePrev(this.index - 1);
        } while (this.index != -1 && !this.isBreakUnit(this.index, this.index + this.length));
        if (this.index == -1) {
            this.index = -2;
        }
        return this.getIndex();
    }

    public int getIndex() {
        return this.index == -2 ? -1 : this.index;
    }

    public void setOverlapping(boolean allowOverlap) {
        this.overlap = allowOverlap;
    }

    public boolean isOverlapping() {
        return this.overlap;
    }

    public int getMatchLength() {
        return this.length;
    }

    public void setBreakIterator(BreakIterator iterator) {
        this.breaker = iterator;
        if (this.breaker != null) {
            this.breaker.setText(this.target);
        }
    }

    public BreakIterator getBreakIterator() {
        return this.breaker;
    }

    public void setTarget(CharacterIterator iterator) {
        this.target = iterator;
        if (this.breaker != null) {
            this.breaker.setText(this.target);
        }
        this.setIndex(-2);
    }

    public CharacterIterator getTarget() {
        return this.target;
    }

    public String getMatchedText() {
        StringBuffer buffer = new StringBuffer();
        if (this.length > 0) {
            int i = 0;
            char c = this.target.setIndex(this.index);
            while (i < this.length) {
                buffer.append(c);
                c = this.target.next();
                ++i;
            }
        }
        return buffer.toString();
    }

    protected SearchIterator(CharacterIterator target, BreakIterator breaker) {
        this.target = target;
        if (breaker != null) {
            this.breaker = (BreakIterator)breaker.clone();
            this.breaker.setText(target);
        }
        this.index = target.getBeginIndex();
        this.length = 0;
    }

    protected abstract int handleNext(int var1);

    protected abstract int handlePrev(int var1);

    protected void setMatchLength(int length) {
        this.length = length;
    }

    private void setIndex(int pos) {
        this.index = pos;
        this.length = 0;
    }

    private boolean isBreakUnit(int start, int end) {
        if (this.breaker == null) {
            return true;
        }
        boolean startBound = this.breaker.isBoundary(start);
        boolean endBound = end == this.target.getEndIndex() || this.breaker.isBoundary(end);
        return startBound && endBound;
    }
}

